/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.version;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.ApplicationServices;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.ConnectionServices;
import com.limegroup.gnutella.DownloadManager;
import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.NetworkUpdateSanityChecker;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.SaveLocationException;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.UrnSet;
import com.limegroup.gnutella.connection.RoutedConnection;
import com.limegroup.gnutella.downloader.InNetworkDownloader;
import com.limegroup.gnutella.downloader.ManagedDownloader;
import com.limegroup.gnutella.downloader.RemoteFileDescFactory;
import com.limegroup.gnutella.http.HTTPHeaderName;
import com.limegroup.gnutella.http.HttpClientListener;
import com.limegroup.gnutella.http.HttpExecutor;
import com.limegroup.gnutella.library.SharingUtils;
import com.limegroup.gnutella.messages.vendor.CapabilitiesVMFactory;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.settings.UpdateSettings;
import com.limegroup.gnutella.util.LimeWireUtils;
import com.limegroup.gnutella.version.DownloadInformation;
import com.limegroup.gnutella.version.UpdateCollection;
import com.limegroup.gnutella.version.UpdateCollectionFactory;
import com.limegroup.gnutella.version.UpdateData;
import com.limegroup.gnutella.version.UpdateHandler;
import com.limegroup.gnutella.version.UpdateInformation;
import com.limegroup.gnutella.version.UpdateMessageVerifier;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.params.AbstractHttpParams;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.DefaultedHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.limewire.io.Connectable;
import org.limewire.io.IOUtils;
import org.limewire.io.IpPort;
import org.limewire.util.Clock;
import org.limewire.util.CommonUtils;
import org.limewire.util.FileUtils;
import org.limewire.util.StringUtils;
import org.limewire.util.Version;
import org.limewire.util.VersionFormatException;
import org.limewire.util.VersionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class UpdateHandlerImpl
implements UpdateHandler {
    private static final Log LOG = LogFactory.getLog(UpdateHandlerImpl.class);
    private static final long THREE_DAYS = 259200000L;
    private static final long ONE_MONTH = 2592000000L;
    private static final String FILENAME = "version.xml";
    private static final int IGNORE_ID = Integer.MAX_VALUE;
    private static final Random RANDOM = new Random();
    private final Clock clock;
    private volatile UpdateInformation _updateInfo;
    private volatile List<DownloadInformation> _updatesToDownload;
    private volatile int _lastId;
    private volatile byte[] _lastBytes;
    private long _lastTimestamp;
    private long _nextDownloadTime;
    private boolean _killingObsoleteNecessary;
    private final HttpRequestControl httpRequestControl = new HttpRequestControl();
    private final ScheduledExecutorService backgroundExecutor;
    private final Provider<ActivityCallback> activityCallback;
    private final ConnectionServices connectionServices;
    private final Provider<HttpExecutor> httpExecutor;
    private final Provider<HttpParams> defaultParams;
    private final Provider<NetworkUpdateSanityChecker> networkUpdateSanityChecker;
    private final CapabilitiesVMFactory capabilitiesVMFactory;
    private final Provider<ConnectionManager> connectionManager;
    private final Provider<DownloadManager> downloadManager;
    private final Provider<FileManager> fileManager;
    private final ApplicationServices applicationServices;
    private final UpdateCollectionFactory updateCollectionFactory;
    private final UpdateMessageVerifier updateMessageVerifier;
    private final RemoteFileDescFactory remoteFileDescFactory;
    private volatile String timeoutUpdateLocation = "http://update0.limewire.com/update.def";
    private volatile List<String> maxedUpdateList = Arrays.asList("http://update1.limewire.com/update.def", "http://update2.limewire.com/update.def", "http://update3.limewire.com/update.def", "http://update4.limewire.com/update.def", "http://update5.limewire.com/update.def", "http://update6.limewire.com/update.def", "http://update7.limewire.com/update.def", "http://update8.limewire.com/update.def", "http://update9.limewire.com/update.def", "http://update10.limewire.com/update.def");
    private volatile int minMaxHttpRequestDelay = 60000;
    private volatile int maxMaxHttpRequestDelay = 1800000;
    private volatile int silentPeriodForMaxHttpRequest = 300000;

    @Inject
    UpdateHandlerImpl(@Named(value="backgroundExecutor") ScheduledExecutorService scheduledExecutorService, Provider<ActivityCallback> provider, ConnectionServices connectionServices, Provider<HttpExecutor> provider2, @Named(value="defaults") Provider<HttpParams> provider3, Provider<NetworkUpdateSanityChecker> provider4, CapabilitiesVMFactory capabilitiesVMFactory, Provider<ConnectionManager> provider5, Provider<DownloadManager> provider6, Provider<FileManager> provider7, ApplicationServices applicationServices, UpdateCollectionFactory updateCollectionFactory, Clock clock, UpdateMessageVerifier updateMessageVerifier, RemoteFileDescFactory remoteFileDescFactory) {
        this.backgroundExecutor = scheduledExecutorService;
        this.activityCallback = provider;
        this.connectionServices = connectionServices;
        this.httpExecutor = provider2;
        this.defaultParams = provider3;
        this.networkUpdateSanityChecker = provider4;
        this.capabilitiesVMFactory = capabilitiesVMFactory;
        this.connectionManager = provider5;
        this.downloadManager = provider6;
        this.fileManager = provider7;
        this.applicationServices = applicationServices;
        this.updateCollectionFactory = updateCollectionFactory;
        this.clock = clock;
        this.updateMessageVerifier = updateMessageVerifier;
        this.remoteFileDescFactory = remoteFileDescFactory;
    }

    String getTimeoutUrl() {
        return this.timeoutUpdateLocation;
    }

    void setTimeoutUrl(String string) {
        this.timeoutUpdateLocation = string;
    }

    List<String> getMaxUrls() {
        return this.maxedUpdateList;
    }

    void setMaxUrls(List<String> list) {
        this.maxedUpdateList = list;
    }

    int getMinHttpRequestUpdateDelayForMaxFailover() {
        return this.minMaxHttpRequestDelay;
    }

    int getMaxHttpRequestUpdateDelayForMaxFailover() {
        return this.maxMaxHttpRequestDelay;
    }

    void setMinHttpRequestUpdateDelayForMaxFailover(int n) {
        this.minMaxHttpRequestDelay = n;
    }

    void setMaxHttpRequestUpdateDelayForMaxFailover(int n) {
        this.maxMaxHttpRequestDelay = n;
    }

    int getSilentPeriodForMaxHttpRequest() {
        return this.silentPeriodForMaxHttpRequest;
    }

    void setSilentPeriodForMaxHttpRequest(int n) {
        this.silentPeriodForMaxHttpRequest = n;
    }

    @Override
    public void initialize() {
        LOG.trace("Initializing UpdateHandler");
        this.backgroundExecutor.execute(new Runnable(){

            public void run() {
                UpdateHandlerImpl.this.handleDataInternal(FileUtils.readFileFully(UpdateHandlerImpl.this.getStoredFile()), UpdateType.FROM_DISK, null);
            }
        });
        this.backgroundExecutor.schedule(new Poller(), UpdateSettings.UPDATE_RETRY_DELAY.getValue(), TimeUnit.MILLISECONDS);
    }

    @Override
    public void tryToDownloadUpdates() {
    }

    @Override
    public void handleUpdateAvailable(final ReplyHandler replyHandler, final int n) {
        if (n == this._lastId) {
            this.backgroundExecutor.execute(new Runnable(){

                public void run() {
                    UpdateHandlerImpl.this.addSourceIfIdMatches(replyHandler, n);
                }
            });
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Another version from rh: " + replyHandler + ", them: " + n + ", me: " + this._lastId);
        }
    }

    @Override
    public void handleNewData(final byte[] byArray, final ReplyHandler replyHandler) {
        if (byArray != null) {
            this.backgroundExecutor.execute(new Runnable(){

                public void run() {
                    LOG.trace("Parsing new data...");
                    UpdateHandlerImpl.this.handleDataInternal(byArray, UpdateType.FROM_NETWORK, replyHandler);
                }
            });
        }
    }

    @Override
    public int getLatestId() {
        return this._lastId;
    }

    @Override
    public byte[] getLatestBytes() {
        return this._lastBytes;
    }

    private void handleDataInternal(byte[] byArray, UpdateType updateType, ReplyHandler replyHandler) {
        if (byArray == null) {
            if (updateType == UpdateType.FROM_NETWORK && replyHandler != null) {
                this.networkUpdateSanityChecker.get().handleInvalidResponse(replyHandler, NetworkUpdateSanityChecker.RequestType.VERSION);
            }
            LOG.warn("No data to handle.");
            return;
        }
        String string = this.updateMessageVerifier.getVerifiedData(byArray);
        if (string == null) {
            if (updateType == UpdateType.FROM_NETWORK && replyHandler != null) {
                this.networkUpdateSanityChecker.get().handleInvalidResponse(replyHandler, NetworkUpdateSanityChecker.RequestType.VERSION);
            }
            LOG.warn("Couldn't verify signature on data.");
            return;
        }
        if (updateType == UpdateType.FROM_NETWORK && replyHandler != null) {
            this.networkUpdateSanityChecker.get().handleValidResponse(replyHandler, NetworkUpdateSanityChecker.RequestType.VERSION);
        }
        UpdateCollection updateCollection = this.updateCollectionFactory.createUpdateCollection(string);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Got a collection with id: " + updateCollection.getId() + ", from " + (Object)((Object)updateType) + ".  Current id is: " + this._lastId);
        }
        switch (updateType) {
            case FROM_NETWORK: {
                if (updateCollection.getId() == Integer.MAX_VALUE) {
                    if (this._lastId == Integer.MAX_VALUE) break;
                    this.doHttpMaxFailover(updateCollection);
                    break;
                }
                if (updateCollection.getId() <= this._lastId) {
                    this.checkForStaleUpdateAndMaybeDoHttpFailover(updateCollection);
                    this.addSourceIfIdMatches(replyHandler, updateCollection.getId());
                    break;
                }
                this.storeAndUpdate(byArray, updateCollection, updateType);
                break;
            }
            case FROM_DISK: {
                this.checkForStaleUpdateAndMaybeDoHttpFailover(updateCollection);
                if (updateCollection.getId() <= this._lastId) break;
                this.storeAndUpdate(byArray, updateCollection, updateType);
                break;
            }
            case FROM_HTTP: {
                if (updateCollection.getId() < this._lastId) break;
                this.storeAndUpdate(byArray, updateCollection, updateType);
            }
        }
    }

    private void storeAndUpdate(byte[] byArray, UpdateCollection updateCollection, UpdateType updateType) {
        Version version;
        if (LOG.isTraceEnabled()) {
            LOG.trace("Retrieved new data from: " + (Object)((Object)updateType) + ", storing & updating.");
        }
        if (updateCollection.getId() == Integer.MAX_VALUE && updateType == UpdateType.FROM_NETWORK) {
            throw new IllegalStateException("shouldn't be here!");
        }
        if (updateType == UpdateType.FROM_NETWORK && this.httpRequestControl.isRequestPending() && this.httpRequestControl.getRequestReason() == HttpRequestControl.RequestReason.MAX) {
            return;
        }
        this._lastId = updateCollection.getId();
        this._lastTimestamp = updateCollection.getTimestamp();
        UpdateSettings.LAST_UPDATE_TIMESTAMP.setValue(this._lastTimestamp);
        long l = UpdateSettings.UPDATE_DOWNLOAD_DELAY.getValue();
        long l2 = Math.abs(RANDOM.nextLong() % l);
        this._nextDownloadTime = this._lastTimestamp + l2;
        this._lastBytes = byArray;
        if (updateType != UpdateType.FROM_DISK) {
            if (this.httpRequestControl.getRequestReason() == HttpRequestControl.RequestReason.TIMEOUT) {
                this.httpRequestControl.cancelRequest();
            }
            UpdateSettings.LAST_HTTP_FAILOVER.setValue(this.clock.now());
            FileUtils.verySafeSave(CommonUtils.getUserSettingsDir(), FILENAME, byArray);
            this.capabilitiesVMFactory.updateCapabilities();
            this.connectionManager.get().sendUpdatedCapabilities();
        }
        try {
            version = new Version(LimeWireUtils.getLimeWireVersion());
        }
        catch (VersionFormatException versionFormatException) {
            LOG.warn("Invalid LimeWire version", versionFormatException);
            return;
        }
        Version version2 = null;
        try {
            version2 = new Version(VersionUtils.getJavaVersion());
        }
        catch (VersionFormatException versionFormatException) {
            LOG.warn("Invalid java version", versionFormatException);
        }
        int n = Math.min(2, UpdateSettings.UPDATE_STYLE.getValue());
        UpdateData updateData = updateCollection.getUpdateDataFor(version, ApplicationSettings.getLanguage(), LimeWireUtils.isPro(), n, version2);
        List<DownloadInformation> list = updateCollection.getUpdatesWithDownloadInformation();
        this._killingObsoleteNecessary = true;
        if (updateData != null && updateData.getUpdateURN() != null) {
            UpdateHandlerImpl.prepareUpdateCommand(updateData);
            list = new LinkedList<DownloadInformation>(list);
            list.add(0, updateData);
        }
        this._updateInfo = updateData;
        this._updatesToDownload = list;
        this.downloadUpdates(list, null);
        if (updateData == null) {
            LOG.warn("No relevant update info to notify about.");
            return;
        }
        if (updateData.getUpdateURN() == null || UpdateHandlerImpl.isHopeless(updateData)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("we have an update, but it doesn't need a download.  or all our updates are hopeles. Scheduling URL notification...");
            }
            updateData.setUpdateCommand(null);
            this.backgroundExecutor.schedule(new NotificationFailover(this._lastId), UpdateHandlerImpl.delay(this.clock.now(), updateCollection.getTimestamp()), TimeUnit.MILLISECONDS);
        } else if (this.isMyUpdateDownloaded(updateData)) {
            LOG.debug("there is an update for me, but I happen to have it on disk");
            this.activityCallback.get().updateAvailable(updateData);
        } else {
            LOG.debug("we have an update, it needs a download.  Rely on callbacks");
        }
    }

    private void checkForStaleUpdateAndMaybeDoHttpFailover(UpdateCollection updateCollection) {
        LOG.debug("checking for timeout http failover");
        long l = this.clock.now() - 2592000000L;
        if (UpdateSettings.LAST_UPDATE_TIMESTAMP.getValue() < l && UpdateSettings.LAST_HTTP_FAILOVER.getValue() < l && !this.httpRequestControl.requestQueued(HttpRequestControl.RequestReason.TIMEOUT)) {
            long l2 = (this.connectionServices.isConnected() ? 1 : 5) * 60 * 1000;
            if (LOG.isDebugEnabled()) {
                LOG.debug("scheduling http failover in " + l2);
            }
            this.backgroundExecutor.schedule(new Runnable(){

                public void run() {
                    try {
                        UpdateHandlerImpl.this.launchHTTPUpdate(UpdateHandlerImpl.this.timeoutUpdateLocation);
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        UpdateHandlerImpl.this.httpRequestControl.requestFinished();
                        UpdateHandlerImpl.this.httpRequestControl.cancelRequest();
                        LOG.warn(uRISyntaxException.toString(), uRISyntaxException);
                    }
                }
            }, l2, TimeUnit.MILLISECONDS);
        }
    }

    private void doHttpMaxFailover(UpdateCollection updateCollection) {
        long l = this.clock.now() - (long)this.silentPeriodForMaxHttpRequest;
        if (!this.httpRequestControl.requestQueued(HttpRequestControl.RequestReason.MAX) && UpdateSettings.LAST_HTTP_FAILOVER.getValue() < l) {
            LOG.debug("Scheduling http max failover...");
            this.backgroundExecutor.schedule(new Runnable(){

                public void run() {
                    String string = (String)UpdateHandlerImpl.this.maxedUpdateList.get(RANDOM.nextInt(UpdateHandlerImpl.this.maxedUpdateList.size()));
                    try {
                        UpdateHandlerImpl.this.launchHTTPUpdate(string);
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        UpdateHandlerImpl.this.httpRequestControl.requestFinished();
                        UpdateHandlerImpl.this.httpRequestControl.cancelRequest();
                        LOG.warn(uRISyntaxException.toString(), uRISyntaxException);
                    }
                }
            }, (long)(RANDOM.nextInt(this.maxMaxHttpRequestDelay) + this.minMaxHttpRequestDelay), TimeUnit.MILLISECONDS);
        } else {
            LOG.debug("Ignoring http max failover.");
        }
    }

    private void launchHTTPUpdate(String string) throws URISyntaxException {
        if (!this.httpRequestControl.isRequestPending()) {
            return;
        }
        LOG.debug("about to issue http request method");
        HttpGet httpGet = new HttpGet(LimeWireUtils.addLWInfoToUrl(string, this.applicationServices.getMyGUID()));
        httpGet.addHeader("User-Agent", LimeWireUtils.getHttpServer());
        httpGet.addHeader(HTTPHeaderName.CONNECTION.httpStringValue(), "close");
        this.httpRequestControl.requestActive();
        AbstractHttpParams abstractHttpParams = new BasicHttpParams();
        HttpConnectionParams.setConnectionTimeout(abstractHttpParams, 10000);
        HttpConnectionParams.setSoTimeout(abstractHttpParams, 10000);
        abstractHttpParams = new DefaultedHttpParams(abstractHttpParams, this.defaultParams.get());
        this.httpExecutor.get().execute(httpGet, abstractHttpParams, new RequestHandler());
    }

    private static void prepareUpdateCommand(UpdateData updateData) {
        if (updateData == null || updateData.getUpdateCommand() == null) {
            return;
        }
        File file = SharingUtils.PREFERENCE_SHARE.getAbsoluteFile();
        String string = updateData.getUpdateFileName();
        try {
            file = FileUtils.getCanonicalFile(file);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String string2 = updateData.getUpdateCommand();
        string2 = StringUtils.replace(string2, "$", file.getPath() + File.separator);
        string2 = StringUtils.replace(string2, "%", string);
        updateData.setUpdateCommand(string2);
    }

    private static boolean isHopeless(DownloadInformation downloadInformation) {
        return UpdateSettings.FAILED_UPDATES.contains(downloadInformation.getUpdateURN().httpStringValue());
    }

    private void addSourceIfIdMatches(ReplyHandler replyHandler, int n) {
        if (n == this._lastId) {
            this.downloadUpdates(this._updatesToDownload, replyHandler);
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Another version? Me: " + n + ", here: " + this._lastId);
        }
    }

    private void downloadUpdates(List<? extends DownloadInformation> list, ReplyHandler replyHandler) {
        if (list == null) {
            list = Collections.emptyList();
        }
        this.killObsoleteUpdates(list);
        for (DownloadInformation downloadInformation : list) {
            if (UpdateHandlerImpl.isHopeless(downloadInformation) || !this.downloadManager.get().isSavedDownloadsLoaded() || !this.fileManager.get().isLoadFinished()) continue;
            FileDesc fileDesc = this.fileManager.get().getFileDescForUrn(downloadInformation.getUpdateURN());
            ManagedDownloader managedDownloader = (ManagedDownloader)this.downloadManager.get().getDownloaderForURN(downloadInformation.getUpdateURN());
            if (LOG.isDebugEnabled()) {
                LOG.debug("Looking for: " + downloadInformation + ", got: " + fileDesc);
            }
            if (fileDesc != null && fileDesc.getClass() == FileDesc.class) {
                if (managedDownloader == null) continue;
                managedDownloader.stop();
                continue;
            }
            if (managedDownloader == null && !this.downloadManager.get().hasInNetworkDownload() && this.canStartDownload()) {
                LOG.debug("Starting a new InNetwork Download");
                try {
                    managedDownloader = (ManagedDownloader)this.downloadManager.get().download(downloadInformation, this.clock.now());
                }
                catch (SaveLocationException saveLocationException) {
                    LOG.error("Unable to construct download", saveLocationException);
                }
            }
            if (managedDownloader == null) continue;
            if (replyHandler != null) {
                managedDownloader.addDownload(this.rfd(replyHandler, downloadInformation), false);
                continue;
            }
            this.addCurrentDownloadSources(managedDownloader, downloadInformation);
        }
    }

    private void killObsoleteUpdates(List<? extends DownloadInformation> list) {
        if (!this.downloadManager.get().isSavedDownloadsLoaded() || !this.fileManager.get().isLoadFinished()) {
            return;
        }
        if (this._killingObsoleteNecessary) {
            this._killingObsoleteNecessary = false;
            this.downloadManager.get().killDownloadersNotListed(list);
            HashSet<URN> hashSet = new HashSet<URN>(list.size());
            for (DownloadInformation object2 : list) {
                hashSet.add(object2.getUpdateURN());
            }
            List<FileDesc> list2 = this.fileManager.get().getSharedFilesInDirectory(SharingUtils.PREFERENCE_SHARE);
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                FileDesc fileDesc = (FileDesc)iterator.next();
                if (fileDesc.getSHA1Urn() == null || hashSet.contains(fileDesc.getSHA1Urn())) continue;
                this.fileManager.get().removeFileIfShared(fileDesc.getFile());
                fileDesc.getFile().delete();
            }
        }
    }

    private void addCurrentDownloadSources(ManagedDownloader managedDownloader, DownloadInformation downloadInformation) {
        for (RoutedConnection routedConnection : this.connectionManager.get().getConnections()) {
            if (routedConnection.getConnectionCapabilities().getRemoteHostUpdateVersion() == this._lastId) {
                LOG.debug("Adding source: " + routedConnection);
                managedDownloader.addDownload(this.rfd(routedConnection, downloadInformation), false);
                continue;
            }
            LOG.debug("Not adding source because bad id: " + routedConnection.getConnectionCapabilities().getRemoteHostUpdateVersion() + ", us: " + this._lastId);
        }
    }

    private RemoteFileDesc rfd(ReplyHandler replyHandler, DownloadInformation downloadInformation) {
        UrnSet urnSet = new UrnSet(downloadInformation.getUpdateURN());
        return this.remoteFileDescFactory.createRemoteFileDesc(replyHandler.getAddress(), replyHandler.getPort(), Integer.MAX_VALUE, downloadInformation.getUpdateFileName(), (int)downloadInformation.getSize(), replyHandler.getClientGUID(), 0, false, 2, false, null, urnSet, false, false, "LIME", IpPort.EMPTY_SET, 0L, 0, replyHandler instanceof Connectable ? ((Connectable)((Object)replyHandler)).isTLSCapable() : false);
    }

    private boolean canStartDownload() {
        long l = this.clock.now();
        if (LOG.isDebugEnabled()) {
            LOG.debug("now is " + l + " next time is " + this._nextDownloadTime);
        }
        return l > this._nextDownloadTime;
    }

    private void notifyAboutInfo(int n) {
        if (n != this._lastId) {
            return;
        }
        UpdateInformation updateInformation = this._updateInfo;
        assert (updateInformation != null);
        this.activityCallback.get().updateAvailable(updateInformation);
    }

    private static long delay(long l, long l2) {
        if (l2 - l > 259200000L) {
            return 0L;
        }
        long l3 = UpdateSettings.UPDATE_DELAY.getValue();
        long l4 = Math.abs(new Random().nextLong() % l3);
        long l5 = l2 + l4;
        if (LOG.isInfoEnabled()) {
            LOG.info("Delaying Update.\nNow    : " + l + "\nStamp  : " + l2 + "\nDelay  : " + l3 + "\nRandom : " + l4 + "\nThen   : " + l5 + "\nDiff   : " + (l5 - l));
        }
        return Math.max(0L, l5 - l);
    }

    @Override
    public void inNetworkDownloadFinished(final URN uRN, final boolean bl) {
        Runnable runnable = new Runnable(){

            public void run() {
                UpdateData updateData;
                if (!bl) {
                    UpdateSettings.FAILED_UPDATES.add(uRN.httpStringValue());
                }
                if ((updateData = (UpdateData)UpdateHandlerImpl.this._updateInfo) != null && updateData.getUpdateURN() != null && updateData.getUpdateURN().equals(uRN)) {
                    if (!bl) {
                        updateData.setUpdateCommand(null);
                        long l = UpdateHandlerImpl.delay(UpdateHandlerImpl.this.clock.now(), UpdateHandlerImpl.this._lastTimestamp);
                        UpdateHandlerImpl.this.backgroundExecutor.schedule(new NotificationFailover(UpdateHandlerImpl.this._lastId), l, TimeUnit.MILLISECONDS);
                    } else {
                        ((ActivityCallback)UpdateHandlerImpl.this.activityCallback.get()).updateAvailable(updateData);
                        ((ConnectionManager)UpdateHandlerImpl.this.connectionManager.get()).sendUpdatedCapabilities();
                    }
                }
            }
        };
        this.backgroundExecutor.execute(runnable);
    }

    private void killHopelessUpdates(List<? extends DownloadInformation> list) {
        if (list == null) {
            return;
        }
        if (!this.downloadManager.get().hasInNetworkDownload()) {
            return;
        }
        long l = this.clock.now();
        for (DownloadInformation downloadInformation : list) {
            InNetworkDownloader inNetworkDownloader;
            Downloader downloader = this.downloadManager.get().getDownloaderForURN(downloadInformation.getUpdateURN());
            if (downloader == null || !(downloader instanceof InNetworkDownloader) || !this.isHopeless(inNetworkDownloader = (InNetworkDownloader)downloader, l)) continue;
            inNetworkDownloader.stop();
        }
    }

    private boolean isHopeless(InNetworkDownloader inNetworkDownloader, long l) {
        if (l - inNetworkDownloader.getStartTime() < (long)UpdateSettings.UPDATE_GIVEUP_FACTOR.getValue() * UpdateSettings.UPDATE_DOWNLOAD_DELAY.getValue()) {
            return false;
        }
        return inNetworkDownloader.getDownloadAttempts() >= UpdateSettings.UPDATE_MIN_ATTEMPTS.getValue();
    }

    private boolean isMyUpdateDownloaded(UpdateInformation updateInformation) {
        if (!this.fileManager.get().isLoadFinished()) {
            return false;
        }
        URN uRN = updateInformation.getUpdateURN();
        if (uRN == null) {
            return true;
        }
        FileDesc fileDesc = this.fileManager.get().getFileDescForUrn(uRN);
        if (fileDesc == null) {
            return false;
        }
        return fileDesc.getClass() == FileDesc.class;
    }

    private File getStoredFile() {
        return new File(CommonUtils.getUserSettingsDir(), FILENAME);
    }

    static /* synthetic */ boolean access$500(UpdateHandlerImpl updateHandlerImpl, UpdateInformation updateInformation) {
        return updateHandlerImpl.isMyUpdateDownloaded(updateInformation);
    }

    private static class HttpRequestControl {
        private final AtomicBoolean requestQueued = new AtomicBoolean(false);
        private final AtomicBoolean requestActive = new AtomicBoolean(false);
        private volatile RequestReason requestReason;

        private HttpRequestControl() {
        }

        boolean isRequestPending() {
            return this.requestActive.get() || this.requestQueued.get();
        }

        boolean requestQueued(RequestReason requestReason) {
            boolean bl = this.requestQueued.getAndSet(true);
            if (!bl || requestReason == RequestReason.MAX) {
                this.requestReason = requestReason;
            }
            return bl || this.requestActive.get();
        }

        void requestActive() {
            this.requestActive.set(true);
            this.requestQueued.set(false);
        }

        RequestReason getRequestReason() {
            return this.requestReason;
        }

        void cancelRequest() {
            this.requestQueued.set(false);
        }

        void requestFinished() {
            this.requestActive.set(false);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static enum RequestReason {
            TIMEOUT,
            MAX;

        }
    }

    private class RequestHandler
    implements HttpClientListener {
        private RequestHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean requestComplete(HttpUriRequest httpUriRequest, HttpResponse httpResponse) {
            byte[] byArray;
            LOG.debug("http request method succeeded");
            UpdateSettings.LAST_HTTP_FAILOVER.setValue(UpdateHandlerImpl.this.clock.now());
            try {
                if (httpResponse.getStatusLine().getStatusCode() < 200 || httpResponse.getStatusLine().getStatusCode() >= 300) {
                    throw new IOException("bad code " + httpResponse.getStatusLine().getStatusCode());
                }
                byte[] byArray2 = null;
                if (httpResponse.getEntity() != null) {
                    byArray2 = IOUtils.readFully(httpResponse.getEntity().getContent());
                }
                if (byArray2 == null || byArray2.length == 0) {
                    throw new IOException("bad body");
                }
                byArray = UpdateHandlerImpl.this.updateMessageVerifier.inflateNetworkData(byArray2);
            }
            catch (IOException iOException) {
                UpdateHandlerImpl.this.httpRequestControl.requestFinished();
                LOG.warn("couldn't fetch data ", iOException);
                boolean bl = false;
                return bl;
            }
            finally {
                ((HttpExecutor)UpdateHandlerImpl.this.httpExecutor.get()).releaseResources(httpResponse);
            }
            UpdateHandlerImpl.this.backgroundExecutor.execute(new Runnable(){

                public void run() {
                    UpdateHandlerImpl.this.httpRequestControl.requestFinished();
                    LOG.trace("Parsing new data...");
                    UpdateHandlerImpl.this.handleDataInternal(byArray, UpdateType.FROM_HTTP, null);
                }
            });
            return false;
        }

        public boolean requestFailed(HttpUriRequest httpUriRequest, HttpResponse httpResponse, IOException iOException) {
            LOG.warn("http failover failed", iOException);
            UpdateHandlerImpl.this.httpRequestControl.requestFinished();
            UpdateSettings.LAST_HTTP_FAILOVER.setValue(UpdateHandlerImpl.this.clock.now());
            ((HttpExecutor)UpdateHandlerImpl.this.httpExecutor.get()).releaseResources(httpResponse);
            return false;
        }
    }

    private class NotificationFailover
    implements Runnable {
        private final int id;
        private boolean shown;

        NotificationFailover(int n) {
            this.id = n;
        }

        public void run() {
            if (this.shown) {
                return;
            }
            this.shown = true;
            UpdateHandlerImpl.this.notifyAboutInfo(this.id);
        }
    }

    private class Poller
    implements Runnable {
        private Poller() {
        }

        public void run() {
            UpdateHandlerImpl.this.downloadUpdates(UpdateHandlerImpl.this._updatesToDownload, null);
            UpdateHandlerImpl.this.killHopelessUpdates(UpdateHandlerImpl.this._updatesToDownload);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum UpdateType {
        FROM_NETWORK,
        FROM_DISK,
        FROM_HTTP;

    }
}

