/*
 * Decompiled with CFR 0.152.
 */
package irc;

import irc.DispatchThread;
import irc.EventItem;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;

public class EventDispatcher {
    private static final int USER = 0;
    private static final int SECURITY = 1;
    private static final String[] _names = new String[]{"User", "Security"};
    private static Hashtable _cache = new Hashtable();
    private static DispatchThread[] _thread = new DispatchThread[2];
    private static boolean _warning = true;

    private static void ensureAlive(int n) {
        if (_thread[n] == null || !_thread[n].isAlive()) {
            EventDispatcher._thread[n] = new DispatchThread(_names[n]);
        }
    }

    private static boolean match(Class[] classArray, Class[] classArray2) {
        if (classArray.length != classArray2.length) {
            return false;
        }
        for (int i = 0; i < classArray.length; ++i) {
            if (classArray2[i] == null || classArray[i].isAssignableFrom(classArray2[i])) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCache() {
        Hashtable hashtable = _cache;
        synchronized (hashtable) {
            _cache.clear();
        }
    }

    public static void disableBadThreadWarning() {
        _warning = false;
    }

    public static void enableBadThreadWarning() {
        _warning = true;
    }

    public static Object dispatchEventSync(Object object, String string, Object[] objectArray) {
        try {
            return EventDispatcher.dispatchEventSyncEx(object, string, objectArray);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object dispatchEventSyncEx(Object object, String string, Object[] objectArray) throws Throwable {
        EventDispatcher.ensureAlive(0);
        if (string.startsWith("AWTSource")) {
            EventDispatcher.disableBadThreadWarning();
        }
        if (_warning && !EventDispatcher.isEventThread()) {
            System.err.println("Event dispatch in wrong thread for IRC method: " + string);
            System.err.println("expected thread was " + _thread);
            System.err.println("current thread is " + Thread.currentThread());
            System.err.println("please submit a bug report to bugs@frostwire.com with the following information :");
            Thread.dumpStack();
        }
        try {
            Class<?> clazz = object.getClass();
            Class[] classArray = _cache;
            synchronized (_cache) {
                int n;
                Method[] methodArray = (Method[])_cache.get(clazz);
                if (methodArray == null) {
                    methodArray = clazz.getMethods();
                    _cache.put(clazz, methodArray);
                }
                // ** MonitorExit[var5_6] (shouldn't be in output)
                classArray = new Class[objectArray.length];
                for (n = 0; n < objectArray.length; ++n) {
                    classArray[n] = objectArray[n] != null ? objectArray[n].getClass() : null;
                }
                for (n = 0; n < methodArray.length; ++n) {
                    if (!methodArray[n].getName().equals(string) || !EventDispatcher.match(methodArray[n].getParameterTypes(), classArray)) continue;
                    return methodArray[n].invoke(object, objectArray);
                }
                throw new NoSuchMethodException(string);
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getTargetException();
        }
        catch (Throwable throwable) {
            System.err.println("internal error");
            System.err.println("please submit a bug report to bugs@frostwire.com with the following information :");
            throwable.printStackTrace();
            return null;
        }
    }

    public static void dispatchEventAsync(Object object, String string, Object[] objectArray) {
        EventDispatcher.ensureAlive(0);
        _thread[0].addEvent(object, string, objectArray);
    }

    private static void checkStack() {
    }

    private static void checkDeadLock(int n) {
        EventDispatcher.ensureAlive(n);
        if (Thread.currentThread() == _thread[n]) {
            try {
                throw new RuntimeException("Deadlock protection");
            }
            catch (RuntimeException runtimeException) {
                runtimeException.printStackTrace();
                throw runtimeException;
            }
        }
    }

    public static void dispatchEventAsyncSecurity(Object object, String string, Object[] objectArray) {
        EventDispatcher.checkStack();
        EventDispatcher.ensureAlive(1);
        _thread[1].addEvent(object, string, objectArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object dispatchEventAsyncAndWaitExImp(Object object, String string, Object[] objectArray, int n) throws InterruptedException, Throwable {
        EventDispatcher.checkDeadLock(n);
        EventDispatcher.ensureAlive(n);
        EventItem eventItem = _thread[n].addEvent(object, string, objectArray);
        Object object2 = eventItem.endLock;
        synchronized (object2) {
            if (eventItem.resultAvailable) {
                if (eventItem.resultException != null) {
                    throw eventItem.resultException;
                }
                return eventItem.result;
            }
            eventItem.endLock.wait();
            if (eventItem.resultException != null) {
                throw eventItem.resultException;
            }
            return eventItem.result;
        }
    }

    public static Object dispatchEventAsyncAndWaitEx(Object object, String string, Object[] objectArray) throws InterruptedException, Throwable {
        return EventDispatcher.dispatchEventAsyncAndWaitExImp(object, string, objectArray, 0);
    }

    public static Object dispatchEventAsyncAndWaitExSecurity(Object object, String string, Object[] objectArray) throws InterruptedException, Throwable {
        EventDispatcher.checkStack();
        return EventDispatcher.dispatchEventAsyncAndWaitExImp(object, string, objectArray, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object dispatchEventAsyncAndWait(Object object, String string, Object[] objectArray) throws InterruptedException {
        EventDispatcher.checkDeadLock(0);
        EventDispatcher.ensureAlive(0);
        EventItem eventItem = _thread[0].addEvent(object, string, objectArray);
        Object object2 = eventItem.endLock;
        synchronized (object2) {
            if (eventItem.resultAvailable) {
                return eventItem.result;
            }
            eventItem.endLock.wait();
            return eventItem.result;
        }
    }

    public static boolean isEventThread() {
        EventDispatcher.ensureAlive(0);
        return Thread.currentThread() == _thread[0] || Thread.currentThread() == _thread[1];
    }
}

