/*
 * Decompiled with CFR 0.152.
 */
package irc.gui.common;

import irc.EventDispatcher;
import irc.ListenerGroup;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.Vector;

public class AWTIrcTextField
extends Container
implements ActionListener,
KeyListener,
FocusListener {
    private int _index;
    private int _tabCount;
    private String _completing;
    private String[] _completeList;
    private Vector _historic;
    private ListenerGroup _listeners;
    private TextField _field;
    private boolean _useEnterTextHere = false;
    private String _enterTextHere;

    public AWTIrcTextField() {
        this.setLayout(new GridLayout(1, 1));
        this._field = new TextField();
        this.add(this._field);
        this._completeList = new String[0];
        this._field.setFont(new Font("SanSerif", 0, 13));
        this._tabCount = 0;
        this._completing = "";
        this._index = 0;
        this._listeners = new ListenerGroup();
        this._historic = new Vector();
        this._field.addActionListener(this);
        this._field.addKeyListener(this);
        try {
            Class<?> clazz = this._field.getClass();
            Method method = clazz.getMethod("setFocusTraversalKeysEnabled", Boolean.TYPE);
            method.invoke((Object)this._field, new Boolean(false));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.addFocusListener(this);
    }

    public void release() {
        this.removeFocusListener(this);
        this._field.removeActionListener(this);
        this._field.removeKeyListener(this);
        this._historic = new Vector();
        this._field = null;
        this.removeAll();
    }

    public void setEnterTextHere(boolean bl, String string) {
        this._useEnterTextHere = bl;
        this._enterTextHere = string;
        if (this._useEnterTextHere) {
            this._field.setText(this._enterTextHere);
            this._field.setSelectionStart(0);
            this._field.setSelectionEnd(this._field.getText().length() + 1);
        }
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this._field.setBackground(color);
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this._field.setForeground(color);
    }

    public void focusGained(FocusEvent focusEvent) {
        this._field.requestFocus();
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    public void addActionListener(ActionListener actionListener) {
        this._listeners.addListener(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this._listeners.removeListener(actionListener);
    }

    public void setCompleteList(String[] stringArray) {
        this._completeList = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            this._completeList[i] = stringArray[i];
        }
    }

    public void setText(String string) {
        this._field.setText(string);
    }

    public String getText() {
        return this._field.getText();
    }

    public int getCaretPosition() {
        return this._field.getCaretPosition();
    }

    public void setCaretPosition(int n) {
        this._field.setCaretPosition(n);
    }

    private void type(int n) {
        int n2 = this._field.getSelectionStart();
        int n3 = this._field.getSelectionEnd();
        String string = this._field.getText();
        if (n2 != n3) {
            string = string.substring(0, n2) + string.substring(n3);
            this._field.setCaretPosition(n2);
        }
        int n4 = this._field.getCaretPosition();
        String string2 = string.substring(0, n4);
        String string3 = string.substring(n4);
        this._field.setText(string2 + (char)n + string3);
        this._field.setCaretPosition(n4 + 1);
    }

    private void getCompleting() {
        this._completing = "";
        String string = this._field.getText();
        if (this._field.getCaretPosition() == string.length() || string.charAt(this._field.getCaretPosition()) == ' ') {
            for (int i = this._field.getCaretPosition() - 1; i >= 0 && string.charAt(i) != ' '; --i) {
                this._completing = string.charAt(i) + this._completing;
            }
        }
    }

    private void complete() {
        if (this._completing.length() == 0) {
            return;
        }
        String string = this._completing.toLowerCase(Locale.ENGLISH);
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < this._completeList.length; ++i) {
            if (!this._completeList[i].toLowerCase(Locale.ENGLISH).startsWith(string)) continue;
            vector.insertElementAt(this._completeList[i], vector.size());
        }
        if (vector.size() > 0) {
            String string2 = (String)vector.elementAt(this._tabCount % vector.size());
            int n = this._field.getCaretPosition();
            String string3 = this._field.getText();
            String string4 = string3.substring(0, n);
            String string5 = string3.substring(n);
            int n2 = string4.lastIndexOf(32);
            string4 = n2 == -1 ? "" : string4.substring(0, n2 + 1);
            string4 = string4 + string2;
            this._field.setText(string4 + string5);
            this._field.setCaretPosition(string4.length());
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 9 || keyEvent.getKeyCode() == 34) {
            if (this._tabCount == 0) {
                this.getCompleting();
            }
            this.complete();
            ++this._tabCount;
            keyEvent.consume();
        } else {
            this._tabCount = 0;
        }
        if (keyEvent.getKeyCode() == 38) {
            if (this._historic.size() > 0) {
                --this._index;
                if (this._index == -1) {
                    this._index = 0;
                }
                this._field.setText((String)this._historic.elementAt(this._index));
                this.setCaretPosition(this.getText().length());
            }
            keyEvent.consume();
        } else if (keyEvent.getKeyCode() == 40) {
            if (this._historic.size() > 0) {
                ++this._index;
                if (this._index > this._historic.size()) {
                    this._index = this._historic.size();
                }
                if (this._index < this._historic.size()) {
                    this._field.setText((String)this._historic.elementAt(this._index));
                } else {
                    this._field.setText("");
                }
                this.setCaretPosition(this.getText().length());
            }
            keyEvent.consume();
        } else if (keyEvent.getKeyCode() == 75 && keyEvent.isControlDown()) {
            this.type(3);
            keyEvent.consume();
        } else if (keyEvent.getKeyCode() == 66 && keyEvent.isControlDown()) {
            this.type(2);
            keyEvent.consume();
        } else if (keyEvent.getKeyCode() == 85 && keyEvent.isControlDown()) {
            this.type(31);
            keyEvent.consume();
        } else if (keyEvent.getKeyCode() == 82 && keyEvent.isControlDown()) {
            this.type(22);
            keyEvent.consume();
        } else if (keyEvent.getKeyCode() == 79 && keyEvent.isControlDown()) {
            this.type(15);
            keyEvent.consume();
        } else if (keyEvent.getKeyCode() == 87 && keyEvent.isControlDown()) {
            this.type(30);
            keyEvent.consume();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void validateText() {
        if (this.getText().length() > 0) {
            this._historic.insertElementAt(this.getText(), this._historic.size());
            this._index = this._historic.size();
        }
        this._listeners.sendEvent("actionPerformed", new Object[]{new ActionEvent(this, 0, "validate")});
    }

    public void actionPerformed(ActionEvent actionEvent) {
        EventDispatcher.dispatchEventAsync(this, "validateText", new Object[0]);
    }
}

