/*
 * Decompiled with CFR 0.152.
 */
package irc.gui.pixx;

import irc.EventDispatcher;
import irc.ListenerGroup;
import irc.StyleContext;
import irc.gui.pixx.AWTStyleSelector;
import irc.gui.pixx.AWTStyleSelectorExListener;
import irc.gui.pixx.FontSelector;
import irc.gui.pixx.FontSelectorListener;
import irc.gui.pixx.NonFocusableButton;
import irc.gui.pixx.PixxConfiguration;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Font;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class AWTStyleSelectorEx
extends Panel
implements ActionListener,
FontSelectorListener {
    private ListenerGroup _lis;
    private AWTStyleSelector _selector;
    private FontSelector _fs;
    private Button _b;

    public AWTStyleSelectorEx(PixxConfiguration pixxConfiguration) {
        this._fs = new FontSelector(pixxConfiguration);
        this._selector = new AWTStyleSelector(pixxConfiguration);
        this.setLayout(new BorderLayout());
        this.add((Component)this._selector, "Center");
        this._b = new NonFocusableButton("Font");
        this._b.setForeground(pixxConfiguration.getColor(1));
        this._b.setBackground(pixxConfiguration.getColor(5));
        this._b.addActionListener(this);
        if (pixxConfiguration.getB("setfontonstyle")) {
            this.add((Component)this._b, "East");
        }
        this._lis = new ListenerGroup();
    }

    public void release() {
        this.removeAll();
        this._b.removeActionListener(this);
        this._selector.release();
        this._fs.release();
        this._selector = null;
        this._fs = null;
    }

    public void setStyleContext(StyleContext styleContext) {
        this._selector.setStyleContext(styleContext);
    }

    public String getPrefix() {
        return this._selector.getPrefix();
    }

    public AWTStyleSelector getStyleSelector() {
        return this._selector;
    }

    public void addAWTStyleSelectorExListener(AWTStyleSelectorExListener aWTStyleSelectorExListener) {
        this._lis.addListener(aWTStyleSelectorExListener);
    }

    public void removeAWTStyleSelectorExListener(AWTStyleSelectorExListener aWTStyleSelectorExListener) {
        this._lis.removeListener(aWTStyleSelectorExListener);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        EventDispatcher.dispatchEventAsync(this._fs, "selectFont", new Object[]{this});
    }

    public void fontSelected(Font font) {
        if (font != null) {
            this._lis.sendEvent("fontSelected", font);
        }
    }
}

