/*
 * Decompiled with CFR 0.152.
 */
package irc.plugin.buttons;

import irc.IRCApplication;
import irc.IRCConfiguration;
import irc.SmileyTable;
import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;

public class SmileyButtons
extends WindowAdapter
implements ActionListener,
Runnable {
    private Thread _thread = null;
    private Frame _frame;
    private Panel _panel;
    private IRCApplication _appl;
    private IRCConfiguration _config;
    private SmileyTable _smileyTable;
    private static int _width = 18;
    private static int _height = 22;

    public static int getHeight() {
        return _height;
    }

    public static int getWidth() {
        return _width;
    }

    public SmileyButtons(IRCConfiguration iRCConfiguration, IRCApplication iRCApplication) {
        this._appl = iRCApplication;
        this._config = iRCConfiguration;
        this._smileyTable = this._config.getSmileyTable();
        this._frame = new Frame();
        this._frame.setVisible(false);
        this._frame.setTitle("Smileys Available");
        this._frame.setLayout(new BorderLayout());
        this._frame.addWindowListener(this);
        if (this._thread == null) {
            this._thread = new Thread((Runnable)this, "Smiley_Picker");
            this._thread.start();
        }
    }

    public void run() {
        Thread thread = Thread.currentThread();
        this._panel = new Panel();
        int n = 5;
        int n2 = this._smileyTable.getSize() / n + 1;
        this._panel.setLayout(new GridLayout(n2, n));
        int n3 = this._smileyTable.getSize();
        for (int i = 0; i < n3; ++i) {
            String string = this._smileyTable.getMatch(i);
            Image image = this._smileyTable.getImage(i);
            JSmileyButton jSmileyButton = new JSmileyButton(image, string);
            jSmileyButton.setSize(_width, _height);
            jSmileyButton.addActionListener(this);
            this._panel.add(jSmileyButton);
        }
        this.addPaneltoFrame(this._panel);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = ((JSmileyButton)actionEvent.getSource()).getMatch();
        this._appl.setFieldText(this._appl.getFieldText() + string);
    }

    public void addPaneltoFrame(Panel panel) {
        int n = this._smileyTable.getSize();
        this._panel = panel;
        this._frame.add(this._panel);
        this._frame.pack();
    }

    public void show() {
        this._frame.setVisible(true);
        this._frame.toFront();
    }

    public void windowDeactivated(WindowEvent windowEvent) {
        this._frame.setVisible(false);
    }

    public void windowClosing(WindowEvent windowEvent) {
        this._frame.setVisible(false);
    }

    class JSmileyButton
    extends JButton {
        private static final long serialVersionUID = 1424L;
        private String _match;

        public void setMatch(String string) {
            this._match = string;
        }

        public String getMatch() {
            return this._match;
        }

        public JSmileyButton(Image image, String string) {
            super(new ImageIcon(image));
            this.setMatch(string);
            this.setSize(SmileyButtons.getWidth(), SmileyButtons.getHeight());
        }
    }
}

