/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.rudp.messages.impl;

import com.google.inject.Singleton;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.limewire.io.ByteBufferInputStream;
import org.limewire.rudp.messages.AckMessage;
import org.limewire.rudp.messages.DataMessage;
import org.limewire.rudp.messages.FinMessage;
import org.limewire.rudp.messages.KeepAliveMessage;
import org.limewire.rudp.messages.MessageFormatException;
import org.limewire.rudp.messages.RUDPMessage;
import org.limewire.rudp.messages.RUDPMessageFactory;
import org.limewire.rudp.messages.SynMessage;
import org.limewire.rudp.messages.impl.AckMessageImpl;
import org.limewire.rudp.messages.impl.DataMessageImpl;
import org.limewire.rudp.messages.impl.FinMessageImpl;
import org.limewire.rudp.messages.impl.KeepAliveMessageImpl;
import org.limewire.rudp.messages.impl.SynMessageImpl;
import org.limewire.service.ErrorService;
import org.limewire.util.ByteOrder;

@Singleton
public class DefaultMessageFactory
implements RUDPMessageFactory {
    private static final MessageFormatException NO_MATCH = new MessageFormatException("No matching RUDPMessage");

    public RUDPMessage createMessage(ByteBuffer ... byteBufferArray) throws MessageFormatException {
        ByteBufferInputStream byteBufferInputStream = new ByteBufferInputStream(byteBufferArray);
        if (byteBufferInputStream.available() < 23) {
            throw new MessageFormatException("not enough data for header!");
        }
        byte by = (byte)byteBufferInputStream.read();
        byte by2 = (byte)byteBufferInputStream.read();
        RUDPMessage.OpCode opCode = RUDPMessage.OpCode.valueOf((by2 & 0xF0) >> 4);
        long l = ((long)byteBufferInputStream.read() & 0xFFL) << 8 | (long)byteBufferInputStream.read() & 0xFFL;
        int n = by2 & 0xF;
        if (n > 12) {
            throw new MessageFormatException("data1Length too big: " + n);
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(12);
        byteBufferInputStream.read(byteBuffer);
        byteBuffer.flip();
        if (opCode == RUDPMessage.OpCode.OP_DATA) {
            byteBuffer.limit(n);
        }
        byteBufferInputStream.skip(3L);
        int n2 = -1;
        try {
            n2 = ByteOrder.leb2int((InputStream)byteBufferInputStream);
        }
        catch (IOException iOException) {
            ErrorService.error((Throwable)iOException);
        }
        if (n2 != byteBufferInputStream.available()) {
            throw new MessageFormatException("inconsistent message size.  expected: " + n2 + ", was: " + byteBufferInputStream.available());
        }
        ByteBuffer byteBuffer2 = byteBufferInputStream.bufferFor(n2);
        assert (byteBufferInputStream.available() == 0);
        switch (opCode) {
            case OP_SYN: {
                return new SynMessageImpl(by, l, byteBuffer, byteBuffer2);
            }
            case OP_ACK: {
                return new AckMessageImpl(by, l, byteBuffer, byteBuffer2);
            }
            case OP_KEEPALIVE: {
                return new KeepAliveMessageImpl(by, l, byteBuffer, byteBuffer2);
            }
            case OP_DATA: {
                return new DataMessageImpl(by, l, byteBuffer, byteBuffer2);
            }
            case OP_FIN: {
                return new FinMessageImpl(by, l, byteBuffer, byteBuffer2);
            }
        }
        throw NO_MATCH;
    }

    public DataMessage createDataMessage(byte by, long l, ByteBuffer byteBuffer) {
        return new DataMessageImpl(by, l, byteBuffer);
    }

    public AckMessage createAckMessage(byte by, long l, long l2, int n) {
        return new AckMessageImpl(by, l, l2, n);
    }

    public FinMessage createFinMessage(byte by, long l, byte by2) {
        return new FinMessageImpl(by, l, by2);
    }

    public KeepAliveMessage createKeepAliveMessage(byte by, long l, int n) {
        return new KeepAliveMessageImpl(by, l, n);
    }

    public SynMessage createSynMessage(byte by) {
        return new SynMessageImpl(by);
    }

    public SynMessage createSynMessage(byte by, byte by2) {
        return new SynMessageImpl(by, by2);
    }
}

