/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.security;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import org.limewire.security.InvalidSecurityTokenException;
import org.limewire.security.MACCalculatorRepositoryManager;
import org.limewire.security.SecurityToken;

public abstract class AbstractSecurityToken
implements SecurityToken {
    private final MACCalculatorRepositoryManager mgr;
    private final byte[] _securityToken;

    protected AbstractSecurityToken(SecurityToken.TokenData tokenData, MACCalculatorRepositoryManager mACCalculatorRepositoryManager) {
        this.mgr = mACCalculatorRepositoryManager;
        this._securityToken = this.getFromMAC(mACCalculatorRepositoryManager.getMACBytes(tokenData), tokenData);
    }

    protected AbstractSecurityToken(byte[] byArray, MACCalculatorRepositoryManager mACCalculatorRepositoryManager) throws InvalidSecurityTokenException {
        this.mgr = mACCalculatorRepositoryManager;
        if (!this.isValidBytes(byArray)) {
            throw new InvalidSecurityTokenException("invalid data: " + Arrays.toString(byArray));
        }
        this._securityToken = byArray;
    }

    public final boolean isFor(SecurityToken.TokenData tokenData) {
        if (!this.isValidTokenData(tokenData)) {
            return false;
        }
        Iterable<byte[]> iterable = this.mgr.getAllBytes(tokenData);
        for (byte[] byArray : iterable) {
            if (!Arrays.equals(this._securityToken, this.getFromMAC(byArray, tokenData))) continue;
            return true;
        }
        return false;
    }

    protected boolean isValidTokenData(SecurityToken.TokenData tokenData) {
        return true;
    }

    public final void write(OutputStream outputStream) throws IOException {
        outputStream.write(this._securityToken);
    }

    public final byte[] getBytes() {
        byte[] byArray = new byte[this._securityToken.length];
        System.arraycopy(this._securityToken, 0, byArray, 0, this._securityToken.length);
        return byArray;
    }

    protected abstract byte[] getFromMAC(byte[] var1, SecurityToken.TokenData var2);

    protected boolean isValidBytes(byte[] byArray) {
        return byArray != null && byArray.length > 0;
    }

    public boolean equals(Object object) {
        if (object instanceof SecurityToken) {
            SecurityToken securityToken = (SecurityToken)object;
            return Arrays.equals(this._securityToken, securityToken.getBytes());
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this._securityToken);
    }
}

