/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.security;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.util.ArrayList;
import java.util.concurrent.ScheduledExecutorService;
import org.limewire.security.MACCalculator;
import org.limewire.security.MACCalculatorFactory;
import org.limewire.security.MACCalculatorRepository;
import org.limewire.security.MACCalculatorRotator;
import org.limewire.security.SecurityToken;
import org.limewire.security.SettingsProvider;
import org.limewire.security.SimpleMACCalculatorRepository;
import org.limewire.security.TEAMACCalculatorFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class MACCalculatorRepositoryManager {
    private final MACCalculatorRepository repository;

    @Inject
    public MACCalculatorRepositoryManager(@Named(value="backgroundExecutor") ScheduledExecutorService scheduledExecutorService, SettingsProvider settingsProvider) {
        this.repository = new MACCalculatorRotator(scheduledExecutorService, new TEAMACCalculatorFactory(), settingsProvider);
    }

    public MACCalculatorRepositoryManager() {
        this.repository = new SimpleMACCalculatorRepository(new TEAMACCalculatorFactory());
    }

    public byte[] getMACBytes(SecurityToken.TokenData tokenData) {
        return this.repository.getCurrentMACCalculator().getMACBytes(tokenData);
    }

    public Iterable<byte[]> getAllBytes(SecurityToken.TokenData tokenData) {
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>(2);
        for (MACCalculator mACCalculator : this.repository.getValidMACCalculators()) {
            arrayList.add(mACCalculator.getMACBytes(tokenData));
        }
        return arrayList;
    }

    public static MACCalculatorFactory createDefaultCalculatorFactory() {
        return new TEAMACCalculatorFactory();
    }
}

