/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.security;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.io.OutputStream;
import java.net.SocketAddress;
import org.limewire.security.AddressSecurityToken;
import org.limewire.security.MACCalculatorRepositoryManager;

public interface SecurityToken {
    public byte[] getBytes();

    public void write(OutputStream var1) throws IOException;

    public boolean isFor(TokenData var1);

    @Singleton
    public static class AddressSecurityTokenProvider
    implements TokenProvider {
        private final MACCalculatorRepositoryManager manager;

        @Inject
        public AddressSecurityTokenProvider(MACCalculatorRepositoryManager mACCalculatorRepositoryManager) {
            this.manager = mACCalculatorRepositoryManager;
        }

        public SecurityToken getSecurityToken(SocketAddress socketAddress) {
            return new AddressSecurityToken(socketAddress, this.manager);
        }

        public TokenData getTokenData(SocketAddress socketAddress) {
            return new AddressSecurityToken.AddressTokenData(socketAddress);
        }
    }

    public static interface TokenData {
        public byte[] getData();
    }

    public static interface TokenProvider {
        public SecurityToken getSecurityToken(SocketAddress var1);

        public TokenData getTokenData(SocketAddress var1);
    }
}

