/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.security;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.security.SecureMessage;
import org.limewire.security.SecureMessageCallback;

public abstract class Verifier
implements Runnable {
    private static final Log LOG = LogFactory.getLog(Verifier.class);
    private SecureMessage message;
    private SecureMessageCallback callback;

    public Verifier(SecureMessage secureMessage, SecureMessageCallback secureMessageCallback) {
        this.message = secureMessage;
        this.callback = secureMessageCallback;
    }

    public abstract PublicKey getPublicKey();

    public abstract String getAlgorithm();

    public SecureMessage getSecureMessage() {
        return this.message;
    }

    public SecureMessageCallback getSecureMessageCallback() {
        return this.callback;
    }

    public void run() {
        SecureMessage secureMessage = this.getSecureMessage();
        SecureMessageCallback secureMessageCallback = this.getSecureMessageCallback();
        PublicKey publicKey = this.getPublicKey();
        String string = this.getAlgorithm();
        if (publicKey == null) {
            LOG.warn((Object)"Cannot verify message without a public key.");
            secureMessage.setSecureStatus(0);
            secureMessageCallback.handleSecureMessage(secureMessage, false);
            return;
        }
        byte[] byArray = secureMessage.getSecureSignature();
        if (byArray == null) {
            LOG.warn((Object)"Cannot verify message without a signature.");
            secureMessage.setSecureStatus(0);
            secureMessageCallback.handleSecureMessage(secureMessage, false);
            return;
        }
        try {
            Signature signature = Signature.getInstance(string);
            signature.initVerify(publicKey);
            secureMessage.updateSignatureWithSecuredBytes(signature);
            if (signature.verify(byArray)) {
                secureMessage.setSecureStatus(2);
                secureMessageCallback.handleSecureMessage(secureMessage, true);
                return;
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            LOG.error((Object)"No alg.", (Throwable)noSuchAlgorithmException);
        }
        catch (InvalidKeyException invalidKeyException) {
            LOG.error((Object)"Invalid key", (Throwable)invalidKeyException);
        }
        catch (SignatureException signatureException) {
            LOG.error((Object)"Bad sig", (Throwable)signatureException);
        }
        catch (ClassCastException classCastException) {
            LOG.error((Object)"bad cast", (Throwable)classCastException);
        }
        secureMessage.setSecureStatus(1);
        secureMessageCallback.handleSecureMessage(secureMessage, false);
    }
}

