/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.activities;

import com.aelitis.azureus.activities.VuzeActivitiesManager;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.cnetwork.ContentNetwork;
import com.aelitis.azureus.core.cnetwork.ContentNetworkManagerFactory;
import com.aelitis.azureus.core.torrent.PlatformTorrentUtils;
import com.aelitis.azureus.ui.selectedcontent.SelectedContentV3;
import com.aelitis.azureus.ui.utils.ImageBytesDownloader;
import com.aelitis.azureus.util.ConstantsVuze;
import com.aelitis.azureus.util.DataSourceUtils;
import com.aelitis.azureus.util.MapUtils;
import com.aelitis.azureus.util.PlayUtils;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.torrent.TOTorrentFactory;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TorrentUtils;

public class VuzeActivitiesEntry {
    private String text;
    private String iconID;
    private String id;
    private long timestamp;
    private String typeID;
    private String assetHash;
    private String assetImageURL;
    private DownloadManager dm;
    public Object urlInfo;
    private byte[] imageBytes;
    private boolean showThumb = true;
    private String torrentName;
    private TOTorrent torrent;
    private boolean isDRM;
    private boolean isPlatformContent;
    private boolean playable;
    private long readOn;
    private GlobalManager gm = null;
    private long contentNetworkID = 1L;

    public VuzeActivitiesEntry(long l, String string, String string2) {
        this.setText(string);
        this.timestamp = l;
        this.setTypeID(string2, true);
    }

    public VuzeActivitiesEntry(long l, String string, String string2, String string3, String string4, String string5) {
        this.timestamp = l;
        this.setText(string);
        this.setIconID(string2);
        this.setID(string3);
        this.setTypeID(string4, true);
        this.setAssetHash(string5);
    }

    public VuzeActivitiesEntry() {
        this.timestamp = SystemTime.getCurrentTime();
    }

    public void loadFromExternalMap(Map map) {
        this.timestamp = SystemTime.getCurrentTime() - MapUtils.getMapLong(map, "age-ms", 0L);
        this.setIconID(MapUtils.getMapString(map, "icon-url", MapUtils.getMapString(map, "icon-id", null)));
        this.setTypeID(MapUtils.getMapString(map, "type-id", null), true);
        this.setAssetHash(MapUtils.getMapString(map, "related-asset-hash", null));
        this.setAssetImageURL(MapUtils.getMapString(map, "related-image-url", null));
        this.setDRM(MapUtils.getMapBoolean(map, "no-play", false));
        this.setTorrentName(MapUtils.getMapString(map, "related-asset-name", null));
        this.setReadOn(MapUtils.getMapLong(map, "readOn", 0L));
        this.loadCommonFromMap(map);
    }

    public void loadFromInternalMap(Map map) {
        this.timestamp = MapUtils.getMapLong(map, "timestamp", 0L);
        if (this.timestamp == 0L) {
            this.timestamp = SystemTime.getCurrentTime();
        }
        this.setAssetHash(MapUtils.getMapString(map, "assetHash", null));
        this.setIconID(MapUtils.getMapString(map, "icon", null));
        this.setTypeID(MapUtils.getMapString(map, "typeID", null), true);
        this.setShowThumb(MapUtils.getMapLong(map, "showThumb", 1L) == 1L);
        this.setAssetImageURL(MapUtils.getMapString(map, "assetImageURL", null));
        this.setImageBytes(MapUtils.getMapByteArray(map, "imageBytes", null));
        this.setDRM(MapUtils.getMapBoolean(map, "isDRM", false));
        this.setReadOn(MapUtils.getMapLong(map, "readOn", SystemTime.getCurrentTime()));
        this.loadCommonFromMap(map);
    }

    public void loadCommonFromMap(Map map) {
        if (!this.isPlatformContent) {
            this.setIsPlatformContent(MapUtils.getMapBoolean(map, "is-platform", this.isPlatformContent));
        }
        if (!this.playable) {
            this.setPlayable(MapUtils.getMapBoolean(map, "playable", false));
        }
        this.setID(MapUtils.getMapString(map, "id", null));
        this.setText(MapUtils.getMapString(map, "text", null));
        Map map2 = MapUtils.getMapMap(map, "torrent", null);
        if (map2 != null) {
            TOTorrent tOTorrent = null;
            try {
                tOTorrent = TOTorrentFactory.deserialiseFromMap(map2);
                this.setTorrent(tOTorrent);
            }
            catch (TOTorrentException tOTorrentException) {
                // empty catch block
            }
        }
        if (this.dm == null && this.torrentName == null) {
            this.setTorrentName(MapUtils.getMapString(map, "torrent-name", null));
        }
        this.setContentNetworkID(MapUtils.getMapLong(map, "contentNetworkID", this.contentNetworkID));
    }

    public boolean equals(Object object) {
        if (object instanceof VuzeActivitiesEntry && this.id != null) {
            return this.id.equals(((VuzeActivitiesEntry)object).id);
        }
        return super.equals(object);
    }

    public int compareTo(Object object) {
        if (object instanceof VuzeActivitiesEntry) {
            VuzeActivitiesEntry vuzeActivitiesEntry = (VuzeActivitiesEntry)object;
            long l = this.timestamp - vuzeActivitiesEntry.timestamp;
            return l == 0L ? 0 : (l > 0L ? 1 : -1);
        }
        return 1;
    }

    public void setAssetImageURL(String string) {
        if (string == null && this.assetImageURL == null) {
            return;
        }
        if (string == null || string.length() == 0) {
            this.assetImageURL = null;
            VuzeActivitiesManager.triggerEntryChanged(this);
            return;
        }
        if (string.equals(this.assetImageURL)) {
            return;
        }
        this.assetImageURL = string;
        ImageBytesDownloader.loadImage(string, new ImageBytesDownloader.ImageDownloaderListener(){

            public void imageDownloaded(byte[] byArray) {
                VuzeActivitiesEntry.this.setImageBytes(byArray);
                VuzeActivitiesManager.triggerEntryChanged(VuzeActivitiesEntry.this);
            }
        });
    }

    public String getAssetImageURL() {
        return this.assetImageURL;
    }

    public Map toDeletedMap() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("timestamp", new Long(this.timestamp));
        hashMap.put("id", this.id);
        return hashMap;
    }

    public Map toMap() {
        Object object;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("timestamp", new Long(this.timestamp));
        if (this.assetHash != null) {
            hashMap.put("assetHash", this.assetHash);
        }
        hashMap.put("icon", this.getIconID());
        hashMap.put("id", this.id);
        hashMap.put("text", this.getText());
        hashMap.put("typeID", this.getTypeID());
        hashMap.put("assetImageURL", this.assetImageURL);
        hashMap.put("showThumb", new Long(this.getShowThumb() ? 1L : 0L));
        if (this.imageBytes != null) {
            hashMap.put("imageBytes", this.imageBytes);
        } else if (this.dm != null && (object = PlatformTorrentUtils.getContentThumbnail(this.dm.getTorrent())) != null) {
            hashMap.put("imageBytes", object);
        }
        if (this.torrent != null && (this.dm == null || this.assetHash == null)) {
            try {
                object = this.torrent.serialiseToMap();
                TOTorrent tOTorrent = TOTorrentFactory.deserialiseFromMap((Map)object);
                Map map = (Map)object.get("vuze");
                tOTorrent.removeAdditionalProperties();
                object = tOTorrent.serialiseToMap();
                if (map != null) {
                    object.put("vuze", map);
                }
                hashMap.put("torrent", object);
            }
            catch (TOTorrentException tOTorrentException) {
                Debug.outNoStack("VuzeActivityEntry.toMap: " + tOTorrentException.toString());
            }
        }
        hashMap.put("isDRM", new Long(this.isDRM() ? 1L : 0L));
        if (this.torrentName != null) {
            hashMap.put("torrent-name", this.torrentName);
        }
        hashMap.put("is-platform", new Long(this.isPlatformContent ? 1L : 0L));
        if (this.playable) {
            hashMap.put("playable", new Long(this.playable ? 1L : 0L));
        }
        hashMap.put("readOn", new Long(this.readOn));
        hashMap.put("contentNetworkID", new Long(this.contentNetworkID));
        return hashMap;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long l) {
        if (this.timestamp == l) {
            return;
        }
        this.timestamp = l;
    }

    public void setTypeID(String string, boolean bl) {
        this.typeID = string;
        if (this.getIconID() == null && string != null) {
            this.setIconID("image.vuze-entry." + string.toLowerCase());
        }
        if ("CONTENT_PROMO".equals(string)) {
            this.setIsPlatformContent(true);
            this.setPlayable(true);
        }
    }

    public String getTypeID() {
        return this.typeID;
    }

    public void setIconID(String string) {
        if (string != null && string.indexOf("image.") < 0 && !string.startsWith("http")) {
            string = "image.vuze-entry." + string;
        }
        this.iconID = string;
    }

    public String getIconID() {
        return this.iconID;
    }

    public void setText(String string) {
        this.text = string;
    }

    public String getText() {
        return this.text;
    }

    public void setID(String string) {
        this.id = string;
    }

    public String getID() {
        return this.id;
    }

    public void setAssetHash(String string) {
        this.assetHash = string;
        if (string != null) {
            try {
                if (this.gm == null) {
                    this.gm = AzureusCoreFactory.getSingleton().getGlobalManager();
                }
                this.setDownloadManager(this.gm.getDownloadManager(new HashWrapper(Base32.decode(string))));
            }
            catch (Exception exception) {
                this.setDownloadManager(null);
                Debug.out("Core not ready", exception);
            }
        } else {
            this.setDownloadManager(null);
        }
    }

    public String getAssetHash() {
        return this.assetHash;
    }

    public void setDownloadManager(DownloadManager downloadManager) {
        if (this.dm == downloadManager) {
            return;
        }
        if (this.gm == null) {
            try {
                this.gm = AzureusCoreFactory.getSingleton().getGlobalManager();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.dm = downloadManager;
        if (downloadManager != null) {
            this.setTorrent(downloadManager.getTorrent());
        }
    }

    public DownloadManager getDownloadManger() {
        if (this.gm != null && !this.gm.contains(this.dm)) {
            this.setDownloadManager(null);
            return null;
        }
        return this.dm;
    }

    public void setImageBytes(byte[] byArray) {
        this.imageBytes = byArray;
    }

    public byte[] getImageBytes() {
        return this.imageBytes;
    }

    public void setShowThumb(boolean bl) {
        this.showThumb = bl;
    }

    public boolean getShowThumb() {
        return this.showThumb;
    }

    public TOTorrent getTorrent() {
        return this.torrent;
    }

    public void setTorrent(TOTorrent tOTorrent) {
        this.torrent = tOTorrent;
        try {
            this.assetHash = tOTorrent.getHashWrapper().toBase32String();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setContentNetworkID(PlatformTorrentUtils.getContentNetworkID(tOTorrent));
        this.setDRM(tOTorrent == null ? false : PlatformTorrentUtils.isContentDRM(tOTorrent));
        this.setIsPlatformContent(tOTorrent == null ? false : PlatformTorrentUtils.isContent(tOTorrent, true));
    }

    public boolean isDRM() {
        return this.isDRM;
    }

    public void setDRM(boolean bl) {
        this.isDRM = bl;
    }

    public String getTorrentName() {
        if (this.torrentName == null) {
            if (this.dm != null) {
                return PlatformTorrentUtils.getContentTitle2(this.dm);
            }
            if (this.torrent != null) {
                return TorrentUtils.getLocalisedName(this.torrent);
            }
        }
        return this.torrentName;
    }

    public void setTorrentName(String string) {
        this.torrentName = string;
    }

    public SelectedContentV3 createSelectedContentObject() throws Exception {
        TOTorrent tOTorrent;
        boolean bl = DataSourceUtils.isPlatformContent(this);
        SelectedContentV3 selectedContentV3 = new SelectedContentV3();
        if (this.assetHash == null) {
            return selectedContentV3;
        }
        this.dm = this.getDownloadManger();
        if (this.dm != null) {
            selectedContentV3.setDisplayName(PlatformTorrentUtils.getContentTitle2(this.dm));
            selectedContentV3.setDownloadManager(this.dm);
            return selectedContentV3;
        }
        if (this.torrent != null) {
            selectedContentV3.setTorrent(this.torrent);
        }
        selectedContentV3.setDisplayName(this.getTorrentName());
        if (selectedContentV3.getDisplayName() == null && (tOTorrent = this.getTorrent()) != null) {
            selectedContentV3.setDisplayName(TorrentUtils.getLocalisedName(tOTorrent));
            selectedContentV3.setHash(tOTorrent.getHashWrapper().toBase32String(), bl);
        }
        if (selectedContentV3.getHash() == null && this.assetHash != null) {
            selectedContentV3.setHash(this.assetHash, true);
        }
        selectedContentV3.setThumbURL(this.assetImageURL);
        selectedContentV3.setImageBytes(this.imageBytes);
        return selectedContentV3;
    }

    public boolean isPlatformContent() {
        return this.isPlatformContent;
    }

    public void setIsPlatformContent(boolean bl) {
        this.isPlatformContent = bl;
    }

    public boolean isPlayable() {
        if (this.playable) {
            return true;
        }
        return PlayUtils.canPlayDS(DataSourceUtils.getTorrent(this));
    }

    public void setPlayable(boolean bl) {
        this.playable = bl;
    }

    public long getReadOn() {
        return this.readOn;
    }

    public void setReadOn(long l) {
        if (this.readOn == l) {
            return;
        }
        this.readOn = l;
        VuzeActivitiesManager.triggerEntryChanged(this);
    }

    public void setRead(boolean bl) {
        long l = SystemTime.getCurrentTime();
        if (bl) {
            this.setReadOn(l);
        } else {
            this.setReadOn(l * -1L);
        }
    }

    public boolean isRead() {
        return this.readOn > 0L;
    }

    public boolean canFlipRead() {
        long l = SystemTime.getOffsetTime(-300L);
        if (this.readOn > 0L) {
            return l > this.readOn;
        }
        return l > -1L * this.readOn;
    }

    public long getContentNetworkID() {
        return this.contentNetworkID;
    }

    public ContentNetwork getContentNetwork() {
        ContentNetwork contentNetwork = ContentNetworkManagerFactory.getSingleton().getContentNetwork(this.contentNetworkID);
        if (contentNetwork == null) {
            contentNetwork = ConstantsVuze.getDefaultContentNetwork();
        }
        return contentNetwork;
    }

    public void setContentNetworkID(long l) {
        this.contentNetworkID = l;
    }
}

