/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.content;

import com.aelitis.azureus.core.content.AzureusContent;
import com.aelitis.azureus.core.content.AzureusContentDirectory;
import com.aelitis.azureus.core.content.AzureusContentDirectoryListener;
import com.aelitis.azureus.core.content.AzureusContentDirectoryManager;
import com.aelitis.azureus.core.content.AzureusContentDownload;
import com.aelitis.azureus.core.content.AzureusContentFile;
import com.aelitis.azureus.core.torrent.PlatformTorrentUtils;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.util.ConstantsVuze;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentFactory;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.plugins.disk.DiskManagerFileInfo;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadAttributeListener;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.torrent.TorrentAttribute;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderFactory;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader.ResourceDownloaderFactoryImpl;

public class AzureusPlatformContentDirectory
implements AzureusContentDirectory {
    private static boolean registered = false;
    private static TorrentAttribute ta_category;
    private static CopyOnWriteList<AzureusContentDirectoryListener> listeners;

    public static synchronized void register() {
        if (!registered) {
            registered = true;
            ta_category = PluginInitializer.getDefaultInterface().getTorrentManager().getAttribute("Category");
            AzureusContentDirectoryManager.registerDirectory(new AzureusPlatformContentDirectory());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AzureusContent lookupContent(Map map) {
        AzureusPlatformContent azureusPlatformContent;
        byte[] byArray = (byte[])map.get("btih");
        if (byArray == null) {
            return null;
        }
        String string = ConstantsVuze.getDefaultContentNetwork().getTorrentDownloadService(Base32.encode(byArray), null);
        ResourceDownloaderFactory resourceDownloaderFactory = ResourceDownloaderFactoryImpl.getSingleton();
        ResourceDownloader resourceDownloader = resourceDownloaderFactory.create(new URL(string));
        InputStream inputStream = resourceDownloader.download();
        try {
            TOTorrent tOTorrent = TOTorrentFactory.deserialiseFromBEncodedInputStream(inputStream);
            azureusPlatformContent = new AzureusPlatformContent(new TorrentImpl(tOTorrent));
        }
        catch (Throwable throwable) {
            try {
                inputStream.close();
                throw throwable;
            }
            catch (Throwable throwable2) {
                throwable2.printStackTrace();
                return null;
            }
        }
        inputStream.close();
        return azureusPlatformContent;
    }

    public AzureusContentDownload lookupContentDownload(Map map) {
        byte[] byArray = (byte[])map.get("btih");
        try {
            final Download download = PluginInitializer.getDefaultInterface().getDownloadManager().getDownload(byArray);
            if (download == null) {
                return null;
            }
            return new AzureusContentDownload(){

                public Download getDownload() {
                    return download;
                }

                public Object getProperty(String string) {
                    return null;
                }
            };
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public AzureusContentFile lookupContentFile(Map map) {
        byte[] byArray = (byte[])map.get("btih");
        int n = (Integer)map.get("file_index");
        try {
            Download download = PluginInitializer.getDefaultInterface().getDownloadManager().getDownload(byArray);
            if (download == null) {
                return null;
            }
            Torrent torrent = download.getTorrent();
            if (torrent == null) {
                return null;
            }
            String string = "AzureusPlatformContentDirectory:" + n;
            AzureusContentFile azureusContentFile = (AzureusContentFile)download.getUserData(string);
            if (azureusContentFile != null) {
                return azureusContentFile;
            }
            final TOTorrent tOTorrent = ((TorrentImpl)torrent).getTorrent();
            final DiskManagerFileInfo diskManagerFileInfo = download.getDiskManagerFileInfo()[n];
            azureusContentFile = PlatformTorrentUtils.isContent(tOTorrent, false) ? new AzureusContentFile(){

                public DiskManagerFileInfo getFile() {
                    return diskManagerFileInfo;
                }

                public Object getProperty(String string) {
                    block15: {
                        try {
                            if (string.equals("duration")) {
                                long l = PlatformTorrentUtils.getContentVideoRunningTime(tOTorrent);
                                if (l > 0L) {
                                    return new Long(l * 1000L);
                                }
                                break block15;
                            }
                            if (string.equals("video_width")) {
                                int[] nArray = PlatformTorrentUtils.getContentVideoResolution(tOTorrent);
                                if (nArray != null) {
                                    return new Long(nArray[0]);
                                }
                                break block15;
                            }
                            if (string.equals("video_height")) {
                                int[] nArray = PlatformTorrentUtils.getContentVideoResolution(tOTorrent);
                                if (nArray != null) {
                                    return new Long(nArray[1]);
                                }
                                break block15;
                            }
                            if (string.equals("date")) {
                                return new Long(diskManagerFileInfo.getDownload().getCreationTime());
                            }
                            if (string.equals("cats")) {
                                try {
                                    String string2 = diskManagerFileInfo.getDownload().getCategoryName();
                                    if (string2 != null && string2.length() > 0 && !string2.equalsIgnoreCase("Categories.uncategorized")) {
                                        return new String[]{string2};
                                    }
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                                return new String[0];
                            }
                            if (string.equals("percent")) {
                                long l = diskManagerFileInfo.getLength();
                                return new Long(l == 0L ? 100L : 1000L * diskManagerFileInfo.getDownloaded() / l);
                            }
                            if (string.equals("eta")) {
                                return AzureusPlatformContentDirectory.this.getETA(diskManagerFileInfo);
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    return null;
                }
            } : new AzureusContentFile(){

                public DiskManagerFileInfo getFile() {
                    return diskManagerFileInfo;
                }

                public Object getProperty(String string) {
                    try {
                        if (string.equals("date")) {
                            return new Long(diskManagerFileInfo.getDownload().getCreationTime());
                        }
                        if (string.equals("cats")) {
                            try {
                                String string2 = diskManagerFileInfo.getDownload().getCategoryName();
                                if (string2 != null && string2.length() > 0 && !string2.equalsIgnoreCase("Categories.uncategorized")) {
                                    return new String[]{string2};
                                }
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            return new String[0];
                        }
                        if (string.equals("percent")) {
                            long l = diskManagerFileInfo.getLength();
                            return new Long(l == 0L ? 100L : 1000L * diskManagerFileInfo.getDownloaded() / l);
                        }
                        if (string.equals("eta")) {
                            return AzureusPlatformContentDirectory.this.getETA(diskManagerFileInfo);
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    return null;
                }
            };
            download.setUserData(string, azureusContentFile);
            final AzureusContentFile azureusContentFile2 = azureusContentFile;
            download.addAttributeListener(new DownloadAttributeListener(){

                public void attributeEventOccurred(Download download, TorrentAttribute torrentAttribute, int n) {
                    AzureusPlatformContentDirectory.fireChanged(azureusContentFile2);
                }
            }, ta_category, 1);
            return azureusContentFile;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    protected long getETA(DiskManagerFileInfo diskManagerFileInfo) {
        try {
            if (diskManagerFileInfo.getDownloaded() == diskManagerFileInfo.getLength()) {
                return 0L;
            }
            if (diskManagerFileInfo.isDeleted() || diskManagerFileInfo.isSkipped()) {
                return Long.MAX_VALUE;
            }
            long l = diskManagerFileInfo.getDownload().getStats().getETASecs();
            if (l < 0L) {
                return Long.MAX_VALUE;
            }
            return l;
        }
        catch (Throwable throwable) {
            return Long.MAX_VALUE;
        }
    }

    public static void fireChanged(AzureusContentFile azureusContentFile) {
        for (AzureusContentDirectoryListener azureusContentDirectoryListener : listeners) {
            azureusContentDirectoryListener.contentChanged(azureusContentFile, "cats");
        }
    }

    public void addListener(AzureusContentDirectoryListener azureusContentDirectoryListener) {
        listeners.add(azureusContentDirectoryListener);
    }

    public void removeListener(AzureusContentDirectoryListener azureusContentDirectoryListener) {
        listeners.remove(azureusContentDirectoryListener);
    }

    static {
        listeners = new CopyOnWriteList();
    }

    protected class AzureusPlatformContent
    implements AzureusContent {
        private Torrent torrent;

        protected AzureusPlatformContent(Torrent torrent) {
            this.torrent = torrent;
        }

        public Torrent getTorrent() {
            return this.torrent;
        }
    }
}

