/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.dht.impl;

import com.aelitis.azureus.core.dht.DHT;
import com.aelitis.azureus.core.dht.DHTLogger;
import com.aelitis.azureus.core.dht.DHTOperationListener;
import com.aelitis.azureus.core.dht.DHTStorageAdapter;
import com.aelitis.azureus.core.dht.control.DHTControl;
import com.aelitis.azureus.core.dht.control.DHTControlAdapter;
import com.aelitis.azureus.core.dht.control.DHTControlFactory;
import com.aelitis.azureus.core.dht.db.DHTDB;
import com.aelitis.azureus.core.dht.impl.DHTLog;
import com.aelitis.azureus.core.dht.nat.DHTNATPuncher;
import com.aelitis.azureus.core.dht.nat.DHTNATPuncherAdapter;
import com.aelitis.azureus.core.dht.nat.DHTNATPuncherFactory;
import com.aelitis.azureus.core.dht.netcoords.DHTNetworkPositionManager;
import com.aelitis.azureus.core.dht.router.DHTRouter;
import com.aelitis.azureus.core.dht.speed.DHTSpeedTester;
import com.aelitis.azureus.core.dht.speed.DHTSpeedTesterFactory;
import com.aelitis.azureus.core.dht.transport.DHTTransport;
import com.aelitis.azureus.core.dht.transport.DHTTransportContact;
import com.aelitis.azureus.core.dht.transport.DHTTransportValue;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.gudy.azureus2.core3.util.Debug;

public class DHTImpl
implements DHT {
    private DHTStorageAdapter storage_adapter;
    private DHTNATPuncherAdapter nat_adapter;
    private DHTControl control;
    private DHTNATPuncher nat_puncher;
    private DHTSpeedTester speed_tester;
    private Properties properties;
    private DHTLogger logger;

    public DHTImpl(DHTTransport dHTTransport, Properties properties, DHTStorageAdapter dHTStorageAdapter, DHTNATPuncherAdapter dHTNATPuncherAdapter, DHTLogger dHTLogger) {
        this.properties = properties;
        this.storage_adapter = dHTStorageAdapter;
        this.nat_adapter = dHTNATPuncherAdapter;
        this.logger = dHTLogger;
        DHTNetworkPositionManager.initialise(this.storage_adapter);
        DHTLog.setLogger(this.logger);
        int n = this.getProp("EntriesPerNode", 20);
        int n2 = this.getProp("NodeSplitFactor", 4);
        int n3 = this.getProp("ReplacementsPerNode", 5);
        int n4 = this.getProp("SearchConcurrency", 5);
        int n5 = this.getProp("LookupConcurrency", 10);
        int n6 = this.getProp("OriginalRepublishInterval", 28800000);
        int n7 = this.getProp("CacheRepublishInterval", 1800000);
        int n8 = this.getProp("CacheClosestN", 1);
        this.control = DHTControlFactory.create(new DHTControlAdapter(){

            public DHTStorageAdapter getStorageAdapter() {
                return DHTImpl.this.storage_adapter;
            }

            public boolean isDiversified(byte[] byArray) {
                if (DHTImpl.this.storage_adapter == null) {
                    return false;
                }
                return DHTImpl.this.storage_adapter.isDiversified(byArray);
            }

            public byte[][] diversify(String string, DHTTransportContact dHTTransportContact, boolean bl, boolean bl2, byte[] byArray, byte by, boolean bl3, int n) {
                boolean bl4;
                if (bl2) {
                    bl4 = by == 2 || by == 3 || by == 1;
                } else {
                    boolean bl5 = bl4 = by == 2 || by == 3;
                }
                if (DHTImpl.this.storage_adapter != null && bl4) {
                    if (bl2) {
                        return DHTImpl.this.storage_adapter.getExistingDiversification(byArray, bl, bl3, n);
                    }
                    return DHTImpl.this.storage_adapter.createNewDiversification(string, dHTTransportContact, byArray, bl, by, bl3, n);
                }
                if (!bl4) {
                    Debug.out("Invalid diversification received: type = " + by);
                }
                if (bl2) {
                    return new byte[][]{byArray};
                }
                return new byte[0][];
            }
        }, dHTTransport, n, n2, n3, n4, n5, n6, n7, n8, this.logger);
        if (this.nat_adapter != null) {
            this.nat_puncher = DHTNATPuncherFactory.create(this.nat_adapter, this);
        }
        this.speed_tester = DHTSpeedTesterFactory.create(this);
    }

    protected int getProp(String string, int n) {
        Integer n2 = (Integer)this.properties.get(string);
        if (n2 == null) {
            this.properties.put(string, new Integer(n));
            return n;
        }
        return n2;
    }

    public int getIntProperty(String string) {
        return (Integer)this.properties.get(string);
    }

    public boolean isDiversified(byte[] byArray) {
        return this.control.isDiversified(byArray);
    }

    public void put(byte[] byArray, String string, byte[] byArray2, byte by, DHTOperationListener dHTOperationListener) {
        this.control.put(byArray, string, byArray2, by, (byte)0, (byte)-1, true, dHTOperationListener);
    }

    public void put(byte[] byArray, String string, byte[] byArray2, byte by, boolean bl, DHTOperationListener dHTOperationListener) {
        this.control.put(byArray, string, byArray2, by, (byte)0, (byte)-1, bl, dHTOperationListener);
    }

    public void put(byte[] byArray, String string, byte[] byArray2, byte by, byte by2, boolean bl, DHTOperationListener dHTOperationListener) {
        this.control.put(byArray, string, byArray2, by, by2, (byte)-1, bl, dHTOperationListener);
    }

    public void put(byte[] byArray, String string, byte[] byArray2, byte by, byte by2, byte by3, boolean bl, DHTOperationListener dHTOperationListener) {
        this.control.put(byArray, string, byArray2, by, by2, by3, bl, dHTOperationListener);
    }

    public DHTTransportValue getLocalValue(byte[] byArray) {
        return this.control.getLocalValue(byArray);
    }

    public void get(byte[] byArray, String string, byte by, int n, long l, boolean bl, boolean bl2, DHTOperationListener dHTOperationListener) {
        this.control.get(byArray, string, by, n, l, bl, bl2, dHTOperationListener);
    }

    public byte[] remove(byte[] byArray, String string, DHTOperationListener dHTOperationListener) {
        return this.control.remove(byArray, string, dHTOperationListener);
    }

    public byte[] remove(DHTTransportContact[] dHTTransportContactArray, byte[] byArray, String string, DHTOperationListener dHTOperationListener) {
        return this.control.remove(dHTTransportContactArray, byArray, string, dHTOperationListener);
    }

    public DHTTransport getTransport() {
        return this.control.getTransport();
    }

    public DHTRouter getRouter() {
        return this.control.getRouter();
    }

    public DHTControl getControl() {
        return this.control;
    }

    public DHTDB getDataBase() {
        return this.control.getDataBase();
    }

    public DHTNATPuncher getNATPuncher() {
        return this.nat_puncher;
    }

    public DHTSpeedTester getSpeedTester() {
        return this.speed_tester;
    }

    public DHTStorageAdapter getStorageAdapter() {
        return this.storage_adapter;
    }

    public void integrate(boolean bl) {
        this.control.seed(bl);
        if (this.nat_puncher != null) {
            this.nat_puncher.start();
        }
    }

    public void destroy() {
        if (this.nat_puncher != null) {
            this.nat_puncher.destroy();
        }
        DHTNetworkPositionManager.destroy(this.storage_adapter);
    }

    public void exportState(DataOutputStream dataOutputStream, int n) throws IOException {
        this.control.exportState(dataOutputStream, n);
    }

    public void importState(DataInputStream dataInputStream) throws IOException {
        this.control.importState(dataInputStream);
    }

    public void setLogging(boolean bl) {
        DHTLog.setLogging(bl);
    }

    public DHTLogger getLogger() {
        return this.logger;
    }

    public void print(boolean bl) {
        this.control.print(bl);
    }
}

