/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.dht.impl;

import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.dht.DHT;
import com.aelitis.azureus.core.dht.DHTFactory;
import com.aelitis.azureus.core.dht.DHTLogger;
import com.aelitis.azureus.core.dht.DHTOperationAdapter;
import com.aelitis.azureus.core.dht.DHTOperationListener;
import com.aelitis.azureus.core.dht.DHTStorageAdapter;
import com.aelitis.azureus.core.dht.DHTStorageKeyStats;
import com.aelitis.azureus.core.dht.control.DHTControlContact;
import com.aelitis.azureus.core.dht.impl.DHTLog;
import com.aelitis.azureus.core.dht.nat.DHTNATPuncherAdapter;
import com.aelitis.azureus.core.dht.nat.impl.DHTNATPuncherImpl;
import com.aelitis.azureus.core.dht.transport.DHTTransport;
import com.aelitis.azureus.core.dht.transport.DHTTransportContact;
import com.aelitis.azureus.core.dht.transport.DHTTransportException;
import com.aelitis.azureus.core.dht.transport.DHTTransportFactory;
import com.aelitis.azureus.core.dht.transport.DHTTransportFullStats;
import com.aelitis.azureus.core.dht.transport.DHTTransportProgressListener;
import com.aelitis.azureus.core.dht.transport.DHTTransportReplyHandlerAdapter;
import com.aelitis.azureus.core.dht.transport.DHTTransportStats;
import com.aelitis.azureus.core.dht.transport.DHTTransportTransferHandler;
import com.aelitis.azureus.core.dht.transport.DHTTransportValue;
import com.aelitis.azureus.core.dht.transport.loopback.DHTTransportLoopbackImpl;
import com.aelitis.azureus.core.dht.transport.udp.DHTTransportUDP;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTTransportUDPImpl;
import com.aelitis.azureus.plugins.dht.impl.DHTPluginStorageManager;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.InetSocketAddress;
import java.security.KeyFactory;
import java.security.Signature;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.RSAPrivateKeySpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.SHA1Simple;
import org.gudy.azureus2.core3.util.Timer;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.logging.LoggerChannel;
import org.gudy.azureus2.plugins.logging.LoggerChannelListener;

public class Test
implements DHTNATPuncherAdapter {
    static boolean AELITIS_TEST = false;
    static InetSocketAddress AELITIS_ADDRESS = new InetSocketAddress("213.186.46.164", 6881);
    static int DEFAULT_NETWORK = 1;
    int num_dhts = 6;
    int num_stores = 0;
    static int MAX_VALUES;
    boolean udp_protocol = true;
    int udp_timeout = 1000;
    static int K;
    static int B;
    static int ID_BYTES;
    int fail_percentage = 0;
    static Properties dht_props;
    static byte[] th_key;
    static Map check;
    static DHTLogger logger;
    Map port_map = new HashMap();

    public static DHTLogger getLogger() {
        return logger;
    }

    public static void main(String[] stringArray) {
        new Test();
    }

    protected Test() {
        try {
            Object object;
            OutputStream outputStream;
            int n;
            DHTLog.setLogging(true);
            DHT[] dHTArray = new DHT[this.num_dhts * 2 + 30];
            DHTTransport[] dHTTransportArray = new DHTTransport[this.num_dhts * 2 + 30];
            for (n = 0; n < this.num_dhts; ++n) {
                this.createDHT(dHTArray, dHTTransportArray, DEFAULT_NETWORK, n);
            }
            for (n = 0; n < this.num_dhts - 1; ++n) {
                if (AELITIS_TEST) {
                    ((DHTTransportUDP)dHTTransportArray[n]).importContact(AELITIS_ADDRESS, (byte)26);
                } else {
                    outputStream = new ByteArrayOutputStream();
                    DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
                    dHTTransportArray[n].getLocalContact().exportContact(dataOutputStream);
                    dataOutputStream.close();
                    dHTTransportArray[n + 1].importContact(new DataInputStream(new ByteArrayInputStream(((ByteArrayOutputStream)outputStream).toByteArray())));
                }
                dHTArray[n].integrate(true);
                if (n <= 0 || n % 10 != 0) continue;
                System.out.println("Integrated " + n + " DHTs");
            }
            if (AELITIS_TEST) {
                ((DHTTransportUDP)dHTTransportArray[this.num_dhts - 1]).importContact(AELITIS_ADDRESS, (byte)26);
            } else {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                outputStream = new DataOutputStream(byteArrayOutputStream);
                dHTTransportArray[0].getLocalContact().exportContact((DataOutputStream)outputStream);
                ((FilterOutputStream)outputStream).close();
                dHTTransportArray[this.num_dhts - 1].importContact(new DataInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray())));
            }
            dHTArray[this.num_dhts - 1].integrate(true);
            DHTTransportLoopbackImpl.setFailPercentage(this.fail_percentage);
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            for (int i = 0; i < this.num_stores; ++i) {
                int n2 = (int)(Math.random() * (double)this.num_dhts);
                object = dHTArray[n2];
                object.put(("" + i).getBytes(), "", new byte[4], (byte)0, new DHTOperationAdapter());
                hashMap.put("" + i, object);
                if (i == 0 || i % 100 != 0) continue;
                System.out.println("Stored " + i + " values");
            }
            Timer timer = new Timer("");
            timer.addPeriodicEvent(10000L, new TimerEventPerformer(){

                public void perform(TimerEvent timerEvent2) {
                    if (!Test.this.udp_protocol) {
                        DHTTransportStats dHTTransportStats = DHTTransportLoopbackImpl.getOverallStats();
                        System.out.println("Overall stats: " + dHTTransportStats.getString());
                    }
                }
            });
            LineNumberReader lineNumberReader = new LineNumberReader(new InputStreamReader(System.in));
            while (true) {
                System.out.print("> ");
                try {
                    Object object4;
                    Object object5;
                    object = lineNumberReader.readLine().trim();
                    if (object == null) break;
                    int n3 = ((String)object).indexOf(32);
                    if (n3 == -1 || n3 == 0) {
                        Test.usage();
                        continue;
                    }
                    int n4 = (int)(Math.random() * (double)this.num_dhts);
                    DHT dHT = dHTArray[n4];
                    String string = ((String)object).substring(0, n3).trim();
                    String string2 = ((String)object).substring(n3 + 1).trim();
                    DHTTransportStats dHTTransportStats = null;
                    char c = string.toLowerCase().charAt(0);
                    if (c == 'p') {
                        n3 = string2.indexOf(61);
                        if (n3 == -1) {
                            Test.usage();
                        } else {
                            System.out.println("Using dht " + n4);
                            dHTTransportStats = dHT.getTransport().getStats().snapshot();
                            String string3 = string2.substring(0, n3);
                            object5 = string2.substring(n3 + 1);
                            n3 = ((String)object5).indexOf(32);
                            byte by = 0;
                            byte by2 = 0;
                            byte by3 = -1;
                            if (n3 != -1) {
                                String[] stringArray;
                                object4 = ((String)object5).substring(n3 + 1);
                                for (Object object2 : stringArray = ((String)object4).split(",")) {
                                    String[] stringArray2 = ((String)object2).split("=");
                                    String string4 = stringArray2[0];
                                    if (string4.equals("f")) {
                                        by = (byte)Integer.parseInt(stringArray2[1], 16);
                                        continue;
                                    }
                                    if (string4.equals("l")) {
                                        by2 = (byte)Integer.parseInt(stringArray2[1]);
                                        continue;
                                    }
                                    if (!string4.equals("r")) continue;
                                    by3 = (byte)Integer.parseInt(stringArray2[1]);
                                }
                                object5 = ((String)object5).substring(0, n3);
                            }
                            dHT.put(string3.getBytes(), "", ((String)object5).getBytes(), by, by2, by3, false, new DHTOperationAdapter());
                        }
                    } else if (c == 'x') {
                        dHT = (DHT)hashMap.get(string2);
                        if (dHT == null) {
                            System.out.println("DHT not found");
                        } else {
                            dHTTransportStats = dHT.getTransport().getStats().snapshot();
                            byte[] byArray = dHT.remove(string2.getBytes(), "", new DHTOperationAdapter());
                            if (byArray != null) {
                                hashMap.remove(string2);
                            }
                            System.out.println("-> " + (byArray == null ? "null" : new String(byArray)));
                        }
                    } else if (c == 'e') {
                        dHT = (DHT)hashMap.get(string2);
                        if (dHT == null) {
                            System.out.println("DHT not found");
                        } else {
                            DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream("C:\\temp\\dht.state"));
                            dHT.exportState(dataOutputStream, 0);
                            dataOutputStream.close();
                        }
                    } else if (c == 'g') {
                        System.out.println("Using dht " + n4);
                        dHTTransportStats = dHT.getTransport().getStats().snapshot();
                        n3 = string2.indexOf(32);
                        byte by = 0;
                        if (n3 != -1) {
                            String[] stringArray;
                            object5 = string2.substring(n3 + 1);
                            for (String string5 : stringArray = ((String)object5).split(",")) {
                                String[] stringArray3 = string5.split("=");
                                String string6 = stringArray3[0];
                                if (!string6.equals("f")) continue;
                                by = (byte)Integer.parseInt(stringArray3[1]);
                            }
                            string2 = string2.substring(0, n3);
                        }
                        dHT.get(string2.getBytes(), "", by, 32, 0L, false, false, new DHTOperationAdapter(){

                            public void read(DHTTransportContact dHTTransportContact, DHTTransportValue dHTTransportValue) {
                                System.out.println("-> " + Test.this.getString(dHTTransportValue));
                            }

                            public void complete(boolean bl) {
                                System.out.println("-> complete");
                            }
                        });
                    } else if (c == '?') {
                        System.out.println("Using dht " + n4);
                        dHTTransportStats = dHT.getTransport().getStats().snapshot();
                        final DHT dHT2 = dHT;
                        dHT.get(string2.getBytes(), "", (byte)8, 32, 0L, false, false, new DHTOperationAdapter(){

                            public void read(DHTTransportContact dHTTransportContact, DHTTransportValue dHTTransportValue) {
                                System.out.println("-> " + Test.this.getString(dHTTransportValue));
                                try {
                                    DHTStorageKeyStats dHTStorageKeyStats = dHT2.getStorageAdapter().deserialiseStats(new DataInputStream(new ByteArrayInputStream(dHTTransportValue.getValue())));
                                    System.out.println("    stats: size = " + dHTStorageKeyStats.getSize() + ", entries=" + dHTStorageKeyStats.getEntryCount() + ", rpm=" + dHTStorageKeyStats.getReadsPerMinute());
                                }
                                catch (Throwable throwable) {
                                    throwable.printStackTrace();
                                }
                            }

                            public void complete(boolean bl) {
                                System.out.println("-> complete");
                            }
                        });
                    } else if (c == 'd') {
                        System.out.println("Using dht " + n4);
                        dHTTransportStats = dHT.getTransport().getStats().snapshot();
                        byte[] byArray = dHT.remove(string2.getBytes(), "", new DHTOperationAdapter());
                        System.out.println("-> " + (byArray == null ? "null" : new String(byArray)));
                    } else if (c == 'z') {
                        System.out.println("Using dht " + n4);
                        dHTTransportStats = dHT.getTransport().getStats().snapshot();
                        dHT.get(string2.getBytes(), "", (byte)0, 10, 0L, false, false, new DHTOperationListener(){

                            public void searching(DHTTransportContact dHTTransportContact, int n, int n2) {
                            }

                            public void diversified(String string) {
                            }

                            public void found(DHTTransportContact dHTTransportContact, boolean bl) {
                            }

                            public void read(final DHTTransportContact dHTTransportContact, DHTTransportValue dHTTransportValue) {
                                System.out.println("-> " + dHTTransportValue.getString());
                                new AEThread("blah"){

                                    public void runSupport() {
                                        DHTTransportFullStats dHTTransportFullStats = dHTTransportContact.getStats();
                                        System.out.println("    stats = " + dHTTransportFullStats.getString());
                                    }
                                }.start();
                            }

                            public void wrote(DHTTransportContact dHTTransportContact, DHTTransportValue dHTTransportValue) {
                            }

                            public void complete(boolean bl) {
                                System.out.println("complete");
                            }
                        });
                    } else if (c == 'v') {
                        try {
                            int n5 = Integer.parseInt(string2);
                            dHT = dHTArray[n5];
                            dHTTransportStats = dHT.getTransport().getStats().snapshot();
                            dHT.print(true);
                            object5 = dHT.getControl().getContacts();
                            for (int i = 0; i < object5.size(); ++i) {
                                DHTControlContact dHTControlContact = (DHTControlContact)object5.get(i);
                                System.out.println("  contact:" + dHTControlContact.getRouterContact().getString() + "/" + dHTControlContact.getTransportContact().getString());
                            }
                        }
                        catch (Throwable throwable) {
                            throwable.printStackTrace();
                        }
                    } else if (c == 'q') {
                        try {
                            int n6 = Integer.parseInt(string2);
                            dHT = dHTArray[n6];
                            dHT.destroy();
                        }
                        catch (Throwable throwable) {
                            throwable.printStackTrace();
                        }
                    } else if (c == 't') {
                        try {
                            int n7 = Integer.parseInt(string2);
                            dHT = dHTArray[n7];
                            dHTTransportStats = dHT.getTransport().getStats().snapshot();
                            ((DHTTransportUDPImpl)dHTTransportArray[n7]).testInstanceIDChange();
                            dHT.integrate(true);
                        }
                        catch (Throwable throwable) {
                            throwable.printStackTrace();
                        }
                    } else if (c == 's') {
                        try {
                            int n8 = Integer.parseInt(string2);
                            dHT = dHTArray[n8];
                            dHTTransportStats = dHT.getTransport().getStats().snapshot();
                            ((DHTTransportUDPImpl)dHTTransportArray[n8]).testTransportIDChange();
                        }
                        catch (Throwable throwable) {
                            throwable.printStackTrace();
                        }
                    } else if (c == 'a') {
                        int n9 = DEFAULT_NETWORK;
                        try {
                            n9 = Integer.parseInt(string2);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        this.createDHT(dHTArray, dHTTransportArray, n9, this.num_dhts++);
                        dHT = dHTArray[this.num_dhts - 1];
                        dHTTransportStats = dHTTransportArray[this.num_dhts - 1].getStats().snapshot();
                        object5 = new ByteArrayOutputStream();
                        DataOutputStream dataOutputStream = new DataOutputStream((OutputStream)object5);
                        ArrayList<Object> arrayList = new ArrayList<Object>();
                        for (int i = 0; i < this.num_dhts - 1; ++i) {
                            object4 = dHTTransportArray[i];
                            if (object4.getNetwork() != n9) continue;
                            arrayList.add(object4);
                        }
                        if (arrayList.size() > 0) {
                            DHTTransport dHTTransport = (DHTTransport)arrayList.get((int)(Math.random() * (double)(arrayList.size() - 1)));
                            dHTTransport.getLocalContact().exportContact(dataOutputStream);
                            dataOutputStream.close();
                            dHTTransportArray[this.num_dhts - 1].importContact(new DataInputStream(new ByteArrayInputStream(((ByteArrayOutputStream)object5).toByteArray())));
                        } else {
                            System.out.println("No comaptible networks found");
                        }
                        dHT.integrate(true);
                        dHT.print(true);
                    } else if (c == 'r') {
                        System.out.println("read - dht0 -> dht1");
                        byte[] byArray = dHTArray[0].getTransport().readTransfer(new DHTTransportProgressListener(){

                            public void reportSize(long l) {
                                System.out.println("   read size: " + l);
                            }

                            public void reportActivity(String string) {
                                System.out.println("   read act: " + string);
                            }

                            public void reportCompleteness(int n) {
                                System.out.println("   read %: " + n);
                            }
                        }, dHTArray[1].getTransport().getLocalContact(), th_key, new byte[]{1, 2, 3, 4}, 30000L);
                        System.out.println("res = " + byArray);
                    } else if (c == 'w') {
                        System.out.println("write - dht0 -> dht1");
                        dHTArray[0].getTransport().writeTransfer(new DHTTransportProgressListener(){

                            public void reportSize(long l) {
                                System.out.println("   write size: " + l);
                            }

                            public void reportActivity(String string) {
                                System.out.println("   write act: " + string);
                            }

                            public void reportCompleteness(int n) {
                                System.out.println("   write %: " + n);
                            }
                        }, dHTArray[1].getTransport().getLocalContact(), th_key, new byte[]{1, 2, 3, 4}, new byte[1000], 60000L);
                    } else if (c == 'c') {
                        System.out.println("call - dht0 <-> dht1");
                        byte[] byArray = dHTArray[0].getTransport().writeReadTransfer(new DHTTransportProgressListener(){

                            public void reportSize(long l) {
                                System.out.println("   readWrite size: " + l);
                            }

                            public void reportActivity(String string) {
                                System.out.println("   readWrite act: " + string);
                            }

                            public void reportCompleteness(int n) {
                                System.out.println("   readWrite %: " + n);
                            }
                        }, dHTArray[1].getTransport().getLocalContact(), th_key, new byte[1000], 60000L);
                        System.out.println("    reply: len = " + byArray.length);
                    } else if (c == 'b') {
                        if (string2.equals("1")) {
                            System.out.println("rendezvous bind: dht2 -> rdv dht1");
                            DHTNATPuncherImpl dHTNATPuncherImpl = (DHTNATPuncherImpl)dHTArray[2].getNATPuncher();
                            dHTNATPuncherImpl.setRendezvous(dHTArray[2].getTransport().getLocalContact(), dHTArray[1].getTransport().getLocalContact());
                        } else if (string2.equals("2")) {
                            System.out.println("rendezvous punch: dht0 -> rdv dht2");
                            DHTNATPuncherImpl dHTNATPuncherImpl = (DHTNATPuncherImpl)dHTArray[0].getNATPuncher();
                            object5 = new HashMap<String, String>();
                            object5.put("hello", "mum");
                            Map map = dHTNATPuncherImpl.punch("Test", dHTArray[2].getTransport().getLocalContact(), null, (Map)object5);
                            System.out.println("   punch client data: " + map);
                        }
                    } else if (c == 'k') {
                        boolean bl;
                        Object object2;
                        int n10 = string2.indexOf(32);
                        if (n10 == -1) {
                            object5 = string2;
                            bl = true;
                        } else {
                            object5 = string2.substring(0, n10);
                            bl = false;
                        }
                        String string6 = "123";
                        String string7 = "567";
                        object4 = KeyFactory.getInstance("RSA");
                        RSAPrivateKeySpec rSAPrivateKeySpec = new RSAPrivateKeySpec(new BigInteger(string6, 16), new BigInteger(string7, 16));
                        RSAPrivateKey rSAPrivateKey = (RSAPrivateKey)((KeyFactory)object4).generatePrivate(rSAPrivateKeySpec);
                        byte[] byArray = new byte[28];
                        byArray[0] = (byte)(bl ? 1 : 0);
                        int n2 = (int)(System.currentTimeMillis() / 1000L);
                        byArray[4] = (byte)(n2 >> 24);
                        byArray[5] = (byte)(n2 >> 16);
                        byArray[6] = (byte)(n2 >> 8);
                        byArray[7] = (byte)n2;
                        System.arraycopy(new SHA1Simple().calculateHash(((String)object5).getBytes()), 0, byArray, 8, 20);
                        object2 = Signature.getInstance("MD5withRSA");
                        ((Signature)object2).initSign(rSAPrivateKey);
                        ((Signature)object2).update(byArray);
                        dHTArray[1].getTransport().getLocalContact().sendKeyBlock(new DHTTransportReplyHandlerAdapter(){

                            public void keyBlockReply(DHTTransportContact dHTTransportContact) {
                                System.out.println("key block sent ok");
                            }

                            public void failed(DHTTransportContact dHTTransportContact, Throwable throwable) {
                                System.out.println("key block failed");
                                throwable.printStackTrace();
                            }
                        }, byArray, ((Signature)object2).sign());
                    } else {
                        Test.usage();
                    }
                    if (dHTTransportStats == null) continue;
                    DHTTransportStats dHTTransportStats2 = dHT.getTransport().getStats().snapshot();
                    System.out.println("before:" + dHTTransportStats.getString());
                    System.out.println("after:" + dHTTransportStats2.getString());
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    protected String getString(DHTTransportValue dHTTransportValue) {
        return new String(dHTTransportValue.getValue()) + "; flags=" + Integer.toHexString(dHTTransportValue.getFlags()) + "; life=" + dHTTransportValue.getLifeTimeHours() + "; rep=" + Integer.toHexString(dHTTransportValue.getReplicationControl()) + ", orig=" + dHTTransportValue.getOriginator().getAddress();
    }

    protected void createDHT(DHT[] dHTArray, DHTTransport[] dHTTransportArray, int n, int n2) throws DHTTransportException {
        DHT dHT;
        DHTTransport dHTTransport;
        Object object;
        if (this.udp_protocol) {
            object = (Integer)this.port_map.get(new Integer(n));
            object = object == null ? new Integer(0) : new Integer((Integer)object + 1);
            this.port_map.put(new Integer(n), object);
            byte by = n == 0 ? (byte)26 : 36;
            dHTTransport = DHTTransportFactory.createUDP(by, n, false, null, null, 6890 + (Integer)object, 5, 3, this.udp_timeout, 50, 25, false, false, logger);
        } else {
            dHTTransport = DHTTransportFactory.createLoopback(ID_BYTES);
        }
        dHTTransport.registerTransferHandler(th_key, new DHTTransportTransferHandler(){

            public String getName() {
                return "test";
            }

            public byte[] handleRead(DHTTransportContact dHTTransportContact, byte[] byArray) {
                byte[] byArray2 = new byte[1000];
                System.out.println("handle read -> length = " + byArray2.length);
                return byArray2;
            }

            public byte[] handleWrite(DHTTransportContact dHTTransportContact, byte[] byArray, byte[] byArray2) {
                byte[] byArray3 = null;
                if (byArray2.length == 1000) {
                    byArray3 = new byte[4];
                }
                System.out.println("handle write -> length = " + byArray2.length + ", reply = " + byArray3);
                return byArray3;
            }
        });
        object = new DHTPluginStorageManager(n, logger, new File("C:\\temp\\dht\\" + n2));
        dHTArray[n2] = dHT = DHTFactory.create(dHTTransport, dht_props, (DHTStorageAdapter)object, this, logger);
        dHTTransportArray[n2] = dHTTransport;
    }

    public Map getClientData(InetSocketAddress inetSocketAddress, Map map) {
        System.out.println("getClientData - " + map + "/" + inetSocketAddress);
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        hashMap.put("udp_data_port", new Long(1234L));
        hashMap.put("tcp_data_port", new Long(5678L));
        return hashMap;
    }

    protected static void usage() {
        System.out.println("syntax: [p g] <key>[=<value>]");
    }

    static {
        DHTTransportUDPImpl.TEST_EXTERNAL_IP = true;
        MAX_VALUES = 10000;
        K = 20;
        B = 5;
        ID_BYTES = 20;
        dht_props = new Properties();
        dht_props.put("EntriesPerNode", new Integer(K));
        dht_props.put("NodeSplitFactor", new Integer(B));
        dht_props.put("CacheRepublishInterval", new Integer(30000));
        dht_props.put("OriginalRepublishInterval", new Integer(60000));
        th_key = new byte[]{1, 1, 1, 1};
        check = new HashMap();
        final LoggerChannel loggerChannel = AzureusCoreFactory.create().getPluginManager().getDefaultPluginInterface().getLogger().getNullChannel("test");
        loggerChannel.addListener(new LoggerChannelListener(){

            public void messageLogged(int n, String string) {
                System.out.println(string);
            }

            public void messageLogged(String string, Throwable throwable) {
                System.out.println(string);
                throwable.printStackTrace();
            }
        });
        logger = new DHTLogger(){

            public void log(String string) {
                loggerChannel.log(string);
            }

            public void log(Throwable throwable) {
                loggerChannel.log(throwable);
            }

            public void log(int n, String string) {
                if (this.isEnabled(n)) {
                    loggerChannel.log(string);
                }
            }

            public boolean isEnabled(int n) {
                return true;
            }

            public PluginInterface getPluginInterface() {
                return loggerChannel.getLogger().getPluginInterface();
            }
        };
    }
}

