/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.dht.netcoords;

import com.aelitis.azureus.core.dht.DHTStorageAdapter;
import com.aelitis.azureus.core.dht.impl.DHTLog;
import com.aelitis.azureus.core.dht.netcoords.DHTNetworkPosition;
import com.aelitis.azureus.core.dht.netcoords.DHTNetworkPositionListener;
import com.aelitis.azureus.core.dht.netcoords.DHTNetworkPositionProvider;
import com.aelitis.azureus.core.dht.netcoords.DHTNetworkPositionProviderInstance;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Iterator;
import org.gudy.azureus2.core3.util.Debug;

public class DHTNetworkPositionManager {
    private static DHTNetworkPositionProvider[] providers = new DHTNetworkPositionProvider[0];
    private static DHTStorageAdapter storage_adapter = null;
    private static CopyOnWriteList position_listeners;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialise(DHTStorageAdapter dHTStorageAdapter) {
        DHTNetworkPositionProvider[] dHTNetworkPositionProviderArray = providers;
        synchronized (providers) {
            if (storage_adapter == null) {
                storage_adapter = dHTStorageAdapter;
                for (int i = 0; i < providers.length; ++i) {
                    DHTNetworkPositionProvider dHTNetworkPositionProvider = providers[i];
                    try {
                        DHTNetworkPositionManager.startUp(dHTNetworkPositionProvider);
                        continue;
                    }
                    catch (Throwable throwable) {
                        Debug.printStackTrace(throwable);
                    }
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private static void startUp(DHTNetworkPositionProvider dHTNetworkPositionProvider) {
        byte[] byArray = null;
        if (storage_adapter != null) {
            byArray = storage_adapter.getStorageForKey("NPP:" + dHTNetworkPositionProvider.getPositionType());
        }
        if (byArray == null) {
            byArray = new byte[]{};
        }
        try {
            dHTNetworkPositionProvider.startUp(new DataInputStream(new ByteArrayInputStream(byArray)));
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destroy(DHTStorageAdapter dHTStorageAdapter) {
        DHTNetworkPositionProvider[] dHTNetworkPositionProviderArray = providers;
        synchronized (providers) {
            if (storage_adapter == dHTStorageAdapter) {
                for (int i = 0; i < providers.length; ++i) {
                    try {
                        DHTNetworkPositionProvider dHTNetworkPositionProvider = providers[i];
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                        dHTNetworkPositionProvider.shutDown(dataOutputStream);
                        dataOutputStream.flush();
                        byte[] byArray = byteArrayOutputStream.toByteArray();
                        storage_adapter.setStorageForKey("NPP:" + dHTNetworkPositionProvider.getPositionType(), byArray);
                        continue;
                    }
                    catch (Throwable throwable) {
                        Debug.printStackTrace(throwable);
                    }
                }
                storage_adapter = null;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DHTNetworkPositionProviderInstance registerProvider(final DHTNetworkPositionProvider dHTNetworkPositionProvider) {
        DHTNetworkPositionProvider[] dHTNetworkPositionProviderArray = providers;
        synchronized (providers) {
            DHTNetworkPositionProvider[] dHTNetworkPositionProviderArray2 = new DHTNetworkPositionProvider[providers.length + 1];
            System.arraycopy(providers, 0, dHTNetworkPositionProviderArray2, 0, providers.length);
            dHTNetworkPositionProviderArray2[DHTNetworkPositionManager.providers.length] = dHTNetworkPositionProvider;
            providers = dHTNetworkPositionProviderArray2;
            if (storage_adapter != null) {
                DHTNetworkPositionManager.startUp(dHTNetworkPositionProvider);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return new DHTNetworkPositionProviderInstance(){

                public void log(String string) {
                    DHTLog.log("NetPos " + dHTNetworkPositionProvider.getPositionType() + ": " + string);
                }
            };
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DHTNetworkPositionProvider getProvider(byte by) {
        DHTNetworkPositionProvider[] dHTNetworkPositionProviderArray = providers;
        synchronized (providers) {
            for (int i = 0; i < providers.length; ++i) {
                if (providers[i].getPositionType() != by) continue;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return providers[i];
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return null;
        }
    }

    public static DHTNetworkPosition[] getLocalPositions() {
        DHTNetworkPositionProvider[] dHTNetworkPositionProviderArray = providers;
        ArrayList<DHTNetworkPosition> arrayList = new ArrayList<DHTNetworkPosition>();
        for (int i = 0; i < dHTNetworkPositionProviderArray.length; ++i) {
            try {
                DHTNetworkPosition dHTNetworkPosition = dHTNetworkPositionProviderArray[i].getLocalPosition();
                if (dHTNetworkPosition == null) continue;
                arrayList.add(dHTNetworkPosition);
                continue;
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
        return arrayList.toArray(new DHTNetworkPosition[arrayList.size()]);
    }

    public static DHTNetworkPosition getBestLocalPosition() {
        DHTNetworkPosition dHTNetworkPosition = null;
        DHTNetworkPosition[] dHTNetworkPositionArray = DHTNetworkPositionManager.getLocalPositions();
        byte by = 0;
        for (int i = 0; i < dHTNetworkPositionArray.length; ++i) {
            DHTNetworkPosition dHTNetworkPosition2 = dHTNetworkPositionArray[i];
            byte by2 = dHTNetworkPosition2.getPositionType();
            if (by2 <= by) continue;
            dHTNetworkPosition = dHTNetworkPosition2;
        }
        return dHTNetworkPosition;
    }

    public static DHTNetworkPosition[] createPositions(byte[] byArray, boolean bl) {
        DHTNetworkPositionProvider[] dHTNetworkPositionProviderArray = providers;
        DHTNetworkPosition[] dHTNetworkPositionArray = new DHTNetworkPosition[dHTNetworkPositionProviderArray.length];
        int n = 0;
        for (int i = 0; i < dHTNetworkPositionArray.length; ++i) {
            try {
                dHTNetworkPositionArray[i] = dHTNetworkPositionProviderArray[i].create(byArray, bl);
                continue;
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
                ++n;
            }
        }
        if (n > 0) {
            DHTNetworkPosition[] dHTNetworkPositionArray2 = new DHTNetworkPosition[dHTNetworkPositionArray.length - n];
            int n2 = 0;
            for (int i = 0; i < dHTNetworkPositionArray.length; ++i) {
                if (dHTNetworkPositionArray[i] == null) continue;
                dHTNetworkPositionArray2[n2++] = dHTNetworkPositionArray[i];
            }
            dHTNetworkPositionArray = dHTNetworkPositionArray2;
            if (dHTNetworkPositionArray.length == 0) {
                Debug.out("hmm");
            }
        }
        return dHTNetworkPositionArray;
    }

    public static float estimateRTT(DHTNetworkPosition[] dHTNetworkPositionArray, DHTNetworkPosition[] dHTNetworkPositionArray2) {
        byte by = 0;
        float f = Float.NaN;
        block2: for (int i = 0; i < dHTNetworkPositionArray.length; ++i) {
            DHTNetworkPosition dHTNetworkPosition = dHTNetworkPositionArray[i];
            byte by2 = dHTNetworkPosition.getPositionType();
            for (int j = 0; j < dHTNetworkPositionArray2.length; ++j) {
                DHTNetworkPosition dHTNetworkPosition2 = dHTNetworkPositionArray2[j];
                if (by2 != dHTNetworkPosition2.getPositionType()) continue;
                try {
                    float f2 = dHTNetworkPosition.estimateRTT(dHTNetworkPosition2);
                    if (Float.isNaN(f2) || by2 <= by) continue block2;
                    f = f2;
                    by = by2;
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                }
                continue block2;
            }
        }
        return f;
    }

    public static void update(DHTNetworkPosition[] dHTNetworkPositionArray, byte[] byArray, DHTNetworkPosition[] dHTNetworkPositionArray2, float f) {
        block2: for (int i = 0; i < dHTNetworkPositionArray.length; ++i) {
            DHTNetworkPosition dHTNetworkPosition = dHTNetworkPositionArray[i];
            for (int j = 0; j < dHTNetworkPositionArray2.length; ++j) {
                DHTNetworkPosition dHTNetworkPosition2 = dHTNetworkPositionArray2[j];
                if (dHTNetworkPosition.getPositionType() != dHTNetworkPosition2.getPositionType()) continue;
                try {
                    dHTNetworkPosition.update(byArray, dHTNetworkPosition2, f);
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                }
                continue block2;
            }
        }
    }

    public static byte[] serialisePosition(DHTNetworkPosition dHTNetworkPosition) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeByte(1);
        dataOutputStream.writeByte(dHTNetworkPosition.getPositionType());
        dHTNetworkPosition.serialise(dataOutputStream);
        dataOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public static DHTNetworkPosition deserialisePosition(InetAddress inetAddress, byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        dataInputStream.readByte();
        byte by = dataInputStream.readByte();
        return DHTNetworkPositionManager.deserialise(inetAddress, by, dataInputStream);
    }

    public static DHTNetworkPosition deserialise(InetAddress inetAddress, byte by, DataInputStream dataInputStream) throws IOException {
        DHTNetworkPositionProvider[] dHTNetworkPositionProviderArray = providers;
        dataInputStream.mark(512);
        for (int i = 0; i < dHTNetworkPositionProviderArray.length; ++i) {
            if (dHTNetworkPositionProviderArray[i].getPositionType() != by) continue;
            DHTNetworkPositionProvider dHTNetworkPositionProvider = dHTNetworkPositionProviderArray[i];
            try {
                DHTNetworkPosition dHTNetworkPosition = dHTNetworkPositionProvider.deserialisePosition(dataInputStream);
                CopyOnWriteList copyOnWriteList = position_listeners;
                if (copyOnWriteList != null) {
                    Iterator iterator = copyOnWriteList.iterator();
                    while (iterator.hasNext()) {
                        try {
                            ((DHTNetworkPositionListener)iterator.next()).positionFound(dHTNetworkPositionProvider, inetAddress, dHTNetworkPosition);
                        }
                        catch (Throwable throwable) {
                            Debug.printStackTrace(throwable);
                        }
                    }
                }
                return dHTNetworkPosition;
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
                dataInputStream.reset();
                break;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addPositionListener(DHTNetworkPositionListener dHTNetworkPositionListener) {
        Class<DHTNetworkPositionManager> clazz = DHTNetworkPositionManager.class;
        synchronized (DHTNetworkPositionManager.class) {
            if (position_listeners == null) {
                position_listeners = new CopyOnWriteList();
            }
            position_listeners.add(dHTNetworkPositionListener);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }
}

