/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.dht.router.impl;

import com.aelitis.azureus.core.dht.DHTLogger;
import com.aelitis.azureus.core.dht.impl.DHTLog;
import com.aelitis.azureus.core.dht.router.DHTRouter;
import com.aelitis.azureus.core.dht.router.DHTRouterAdapter;
import com.aelitis.azureus.core.dht.router.DHTRouterContact;
import com.aelitis.azureus.core.dht.router.DHTRouterContactAttachment;
import com.aelitis.azureus.core.dht.router.DHTRouterObserver;
import com.aelitis.azureus.core.dht.router.DHTRouterStats;
import com.aelitis.azureus.core.dht.router.impl.DHTRouterContactImpl;
import com.aelitis.azureus.core.dht.router.impl.DHTRouterNodeImpl;
import com.aelitis.azureus.core.dht.router.impl.DHTRouterStatsImpl;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.core.util.bloom.BloomFilter;
import com.aelitis.azureus.core.util.bloom.BloomFilterFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TimerEventPeriodic;

public class DHTRouterImpl
implements DHTRouter {
    private static final int SMALLEST_SUBTREE_MAX_EXCESS = 10240;
    private int K;
    private int B;
    private int max_rep_per_node;
    private DHTLogger logger;
    private int smallest_subtree_max;
    private DHTRouterAdapter adapter;
    private DHTRouterContactImpl local_contact;
    private byte[] router_node_id;
    private DHTRouterNodeImpl root;
    private DHTRouterNodeImpl smallest_subtree;
    private int consecutive_dead;
    private static long random_seed = SystemTime.getCurrentTime();
    private Random random;
    private List outstanding_pings = new ArrayList();
    private List outstanding_adds = new ArrayList();
    private DHTRouterStatsImpl stats = new DHTRouterStatsImpl(this);
    private AEMonitor this_mon = new AEMonitor("DHTRouter");
    private static AEMonitor class_mon = new AEMonitor("DHTRouter:class");
    private final CopyOnWriteList observers = new CopyOnWriteList();
    private BloomFilter recent_contact_bloom = BloomFilterFactory.createRotating(BloomFilterFactory.createAddOnly(10240), 2);
    private TimerEventPeriodic timer_event;
    private volatile int seed_in_ticks;
    private static final int TICK_PERIOD = 10000;
    private static final int SEED_DELAY_PERIOD = 60000;
    private static final int SEED_DELAY_TICKS = 6;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DHTRouterImpl(int n, int n2, int n3, byte[] byArray, DHTRouterContactAttachment dHTRouterContactAttachment, DHTLogger dHTLogger) {
        try {
            class_mon.enter();
            this.random = new Random(random_seed++);
        }
        finally {
            class_mon.exit();
        }
        this.K = n;
        this.B = n2;
        this.max_rep_per_node = n3;
        this.logger = dHTLogger;
        this.smallest_subtree_max = 1;
        for (int i = 0; i < this.B; ++i) {
            this.smallest_subtree_max *= 2;
        }
        this.smallest_subtree_max += 10240;
        this.router_node_id = byArray;
        ArrayList<DHTRouterContactImpl> arrayList = new ArrayList<DHTRouterContactImpl>();
        this.local_contact = new DHTRouterContactImpl(this.router_node_id, dHTRouterContactAttachment, true);
        arrayList.add(this.local_contact);
        this.root = new DHTRouterNodeImpl(this, 0, true, arrayList);
        this.timer_event = SimpleTimer.addPeriodicEvent("DHTRouter:pinger", 10000L, new TimerEventPerformer(){

            public void perform(TimerEvent timerEvent2) {
                DHTRouterImpl.this.pingeroonies();
                if (DHTRouterImpl.this.seed_in_ticks > 0) {
                    DHTRouterImpl.this.seed_in_ticks--;
                    if (DHTRouterImpl.this.seed_in_ticks == 0) {
                        DHTRouterImpl.this.seedSupport();
                    }
                }
            }
        });
    }

    protected void notifyAdded(DHTRouterContact dHTRouterContact) {
        for (DHTRouterObserver dHTRouterObserver : this.observers) {
            try {
                dHTRouterObserver.added(dHTRouterContact);
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
    }

    protected void notifyRemoved(DHTRouterContact dHTRouterContact) {
        for (DHTRouterObserver dHTRouterObserver : this.observers) {
            try {
                dHTRouterObserver.removed(dHTRouterContact);
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
    }

    protected void notifyLocationChanged(DHTRouterContact dHTRouterContact) {
        for (DHTRouterObserver dHTRouterObserver : this.observers) {
            try {
                dHTRouterObserver.locationChanged(dHTRouterContact);
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
    }

    protected void notifyNowAlive(DHTRouterContact dHTRouterContact) {
        for (DHTRouterObserver dHTRouterObserver : this.observers) {
            try {
                dHTRouterObserver.nowAlive(dHTRouterContact);
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
    }

    protected void notifyNowFailing(DHTRouterContact dHTRouterContact) {
        for (DHTRouterObserver dHTRouterObserver : this.observers) {
            try {
                dHTRouterObserver.nowFailing(dHTRouterContact);
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
    }

    protected void notifyDead() {
        for (DHTRouterObserver dHTRouterObserver : this.observers) {
            try {
                dHTRouterObserver.destroyed(this);
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
    }

    public boolean addObserver(DHTRouterObserver dHTRouterObserver) {
        if (dHTRouterObserver != null && !this.observers.contains(dHTRouterObserver)) {
            this.observers.add(dHTRouterObserver);
            return true;
        }
        return false;
    }

    public boolean containsObserver(DHTRouterObserver dHTRouterObserver) {
        return dHTRouterObserver != null && this.observers.contains(dHTRouterObserver);
    }

    public boolean removeObserver(DHTRouterObserver dHTRouterObserver) {
        return dHTRouterObserver != null && this.observers.remove(dHTRouterObserver);
    }

    public DHTRouterStats getStats() {
        return this.stats;
    }

    public int getK() {
        return this.K;
    }

    public byte[] getID() {
        return this.router_node_id;
    }

    public boolean isID(byte[] byArray) {
        return Arrays.equals(byArray, this.router_node_id);
    }

    public DHTRouterContact getLocalContact() {
        return this.local_contact;
    }

    public void setAdapter(DHTRouterAdapter dHTRouterAdapter) {
        this.adapter = dHTRouterAdapter;
    }

    public void contactKnown(byte[] byArray, DHTRouterContactAttachment dHTRouterContactAttachment) {
        if (this.recent_contact_bloom.contains(byArray)) {
            return;
        }
        this.recent_contact_bloom.add(byArray);
        this.addContact(byArray, dHTRouterContactAttachment, false);
    }

    public DHTRouterContact contactAlive(byte[] byArray, DHTRouterContactAttachment dHTRouterContactAttachment) {
        return this.addContact(byArray, dHTRouterContactAttachment, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DHTRouterContact contactDead(byte[] byArray, boolean bl) {
        if (Arrays.equals(this.router_node_id, byArray)) {
            Debug.out("DHTRouter: contactDead called on router node!");
            return this.local_contact;
        }
        try {
            try {
                this.this_mon.enter();
                ++this.consecutive_dead;
                Object[] objectArray = this.findContactSupport(byArray);
                DHTRouterNodeImpl dHTRouterNodeImpl = (DHTRouterNodeImpl)objectArray[0];
                DHTRouterContactImpl dHTRouterContactImpl = (DHTRouterContactImpl)objectArray[1];
                if (dHTRouterContactImpl != null && (this.consecutive_dead < 100 || bl)) {
                    dHTRouterNodeImpl.dead(dHTRouterContactImpl, bl);
                }
                DHTRouterContactImpl dHTRouterContactImpl2 = dHTRouterContactImpl;
                this.this_mon.exit();
                return dHTRouterContactImpl2;
            }
            catch (Throwable throwable) {
                this.this_mon.exit();
                throw throwable;
            }
        }
        finally {
            this.dispatchPings();
            this.dispatchNodeAdds();
        }
    }

    public void contactRemoved(byte[] byArray) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DHTRouterContact addContact(byte[] byArray, DHTRouterContactAttachment dHTRouterContactAttachment, boolean bl) {
        try {
            try {
                this.this_mon.enter();
                if (bl) {
                    this.consecutive_dead = 0;
                }
                DHTRouterContact dHTRouterContact = this.addContactSupport(byArray, dHTRouterContactAttachment, bl);
                this.this_mon.exit();
                return dHTRouterContact;
            }
            catch (Throwable throwable) {
                this.this_mon.exit();
                throw throwable;
            }
        }
        finally {
            this.dispatchPings();
            this.dispatchNodeAdds();
        }
    }

    protected DHTRouterContact addContactSupport(byte[] byArray, DHTRouterContactAttachment dHTRouterContactAttachment, boolean bl) {
        DHTRouterNodeImpl dHTRouterNodeImpl = this.root;
        boolean bl2 = false;
        for (int i = 0; i < byArray.length; ++i) {
            byte by = byArray[i];
            int n = 7;
            while (n >= 0) {
                boolean bl3;
                DHTRouterNodeImpl dHTRouterNodeImpl2;
                if (dHTRouterNodeImpl == this.smallest_subtree) {
                    bl2 = true;
                }
                if ((dHTRouterNodeImpl2 = (bl3 = (by >> n & 1) == 1) ? dHTRouterNodeImpl.getLeft() : dHTRouterNodeImpl.getRight()) == null) {
                    DHTRouterContactImpl dHTRouterContactImpl = dHTRouterNodeImpl.updateExistingNode(byArray, dHTRouterContactAttachment, bl);
                    if (dHTRouterContactImpl != null) {
                        return dHTRouterContactImpl;
                    }
                    List list = dHTRouterNodeImpl.getBuckets();
                    if (list.size() == this.K) {
                        Object object;
                        boolean bl4;
                        boolean bl5 = dHTRouterNodeImpl.containsRouterNodeID();
                        int n2 = dHTRouterNodeImpl.getDepth();
                        boolean bl6 = bl4 = n2 % this.B == 0;
                        if (bl5 || !bl4 || bl2) {
                            Object object2;
                            int n3;
                            if (bl2 && bl4 && !bl5 && this.getContactCount(this.smallest_subtree) > (long)this.smallest_subtree_max) {
                                Debug.out("DHTRouter: smallest subtree max size violation");
                                return null;
                            }
                            object = new ArrayList();
                            ArrayList<DHTRouterContactImpl> arrayList = new ArrayList<DHTRouterContactImpl>();
                            for (n3 = 0; n3 < list.size(); ++n3) {
                                DHTRouterContactImpl dHTRouterContactImpl2 = (DHTRouterContactImpl)list.get(n3);
                                object2 = dHTRouterContactImpl2.getID();
                                if ((object2[n2 / 8] >> 7 - n2 % 8 & 1) == 0) {
                                    arrayList.add(dHTRouterContactImpl2);
                                    continue;
                                }
                                object.add(dHTRouterContactImpl2);
                            }
                            n3 = 0;
                            boolean bl7 = false;
                            if (bl5) {
                                n3 = (this.router_node_id[n2 / 8] >> 7 - n2 % 8 & 1) == 0 ? 1 : 0;
                                bl7 = n3 == 0;
                            }
                            object2 = new DHTRouterNodeImpl(this, n2 + 1, bl7, (List)object);
                            DHTRouterNodeImpl dHTRouterNodeImpl3 = new DHTRouterNodeImpl(this, n2 + 1, n3 != 0, arrayList);
                            dHTRouterNodeImpl.split((DHTRouterNodeImpl)object2, dHTRouterNodeImpl3);
                            if (n3 != 0) {
                                this.smallest_subtree = object2;
                                continue;
                            }
                            if (!bl7) continue;
                            this.smallest_subtree = dHTRouterNodeImpl3;
                            continue;
                        }
                        object = new DHTRouterContactImpl(byArray, dHTRouterContactAttachment, bl);
                        return dHTRouterNodeImpl.addReplacement((DHTRouterContactImpl)object, this.max_rep_per_node);
                    }
                    DHTRouterContactImpl dHTRouterContactImpl3 = new DHTRouterContactImpl(byArray, dHTRouterContactAttachment, bl);
                    dHTRouterNodeImpl.addNode(dHTRouterContactImpl3);
                    return dHTRouterContactImpl3;
                }
                dHTRouterNodeImpl = dHTRouterNodeImpl2;
                --n;
            }
        }
        Debug.out("DHTRouter inconsistency");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List findClosestContacts(byte[] byArray, int n, boolean bl) {
        try {
            this.this_mon.enter();
            ArrayList arrayList = new ArrayList();
            this.findClosestContacts(byArray, n, 0, this.root, bl, arrayList);
            ArrayList arrayList2 = arrayList;
            return arrayList2;
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected void findClosestContacts(byte[] byArray, int n, int n2, DHTRouterNodeImpl dHTRouterNodeImpl, boolean bl, List list) {
        List list2 = dHTRouterNodeImpl.getBuckets();
        if (list2 != null) {
            for (int i = 0; i < list2.size(); ++i) {
                DHTRouterContactImpl dHTRouterContactImpl = (DHTRouterContactImpl)list2.get(i);
                if (bl && dHTRouterContactImpl.isFailing()) continue;
                list.add(dHTRouterContactImpl);
            }
        } else {
            DHTRouterNodeImpl dHTRouterNodeImpl2;
            DHTRouterNodeImpl dHTRouterNodeImpl3;
            boolean bl2;
            boolean bl3 = bl2 = (byArray[n2 / 8] >> 7 - n2 % 8 & 1) == 1;
            if (bl2) {
                dHTRouterNodeImpl3 = dHTRouterNodeImpl.getLeft();
                dHTRouterNodeImpl2 = dHTRouterNodeImpl.getRight();
            } else {
                dHTRouterNodeImpl3 = dHTRouterNodeImpl.getRight();
                dHTRouterNodeImpl2 = dHTRouterNodeImpl.getLeft();
            }
            this.findClosestContacts(byArray, n, n2 + 1, dHTRouterNodeImpl3, bl, list);
            if (list.size() < n) {
                this.findClosestContacts(byArray, n, n2 + 1, dHTRouterNodeImpl2, bl, list);
            }
        }
    }

    public DHTRouterContact findContact(byte[] byArray) {
        Object[] objectArray = this.findContactSupport(byArray);
        return (DHTRouterContact)objectArray[1];
    }

    protected DHTRouterNodeImpl findNode(byte[] byArray) {
        Object[] objectArray = this.findContactSupport(byArray);
        return (DHTRouterNodeImpl)objectArray[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object[] findContactSupport(byte[] byArray) {
        try {
            int n;
            this.this_mon.enter();
            DHTRouterNodeImpl dHTRouterNodeImpl = this.root;
            block4: for (int i = 0; i < byArray.length && dHTRouterNodeImpl.getBuckets() == null; ++i) {
                n = byArray[i];
                for (int j = 7; j >= 0; --j) {
                    boolean bl;
                    boolean bl2 = bl = (n >> j & 1) == 1;
                    if (dHTRouterNodeImpl.getBuckets() != null) continue block4;
                    dHTRouterNodeImpl = bl ? dHTRouterNodeImpl.getLeft() : dHTRouterNodeImpl.getRight();
                }
            }
            List list = dHTRouterNodeImpl.getBuckets();
            for (n = 0; n < list.size(); ++n) {
                DHTRouterContactImpl dHTRouterContactImpl = (DHTRouterContactImpl)list.get(n);
                if (!Arrays.equals(byArray, dHTRouterContactImpl.getID())) continue;
                Object[] objectArray = new Object[]{dHTRouterNodeImpl, dHTRouterContactImpl};
                return objectArray;
            }
            Object[] objectArray = new Object[]{dHTRouterNodeImpl, null};
            return objectArray;
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected long getNodeCount() {
        return this.getNodeCount(this.root);
    }

    protected long getNodeCount(DHTRouterNodeImpl dHTRouterNodeImpl) {
        if (dHTRouterNodeImpl.getBuckets() != null) {
            return 1L;
        }
        return 1L + this.getNodeCount(dHTRouterNodeImpl.getLeft()) + this.getNodeCount(dHTRouterNodeImpl.getRight());
    }

    protected long getContactCount() {
        return this.getContactCount(this.root);
    }

    protected long getContactCount(DHTRouterNodeImpl dHTRouterNodeImpl) {
        if (dHTRouterNodeImpl.getBuckets() != null) {
            return dHTRouterNodeImpl.getBuckets().size();
        }
        return this.getContactCount(dHTRouterNodeImpl.getLeft()) + this.getContactCount(dHTRouterNodeImpl.getRight());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List findBestContacts(int n) {
        TreeSet treeSet = new TreeSet(new Comparator(){

            public int compare(Object object, Object object2) {
                DHTRouterContactImpl dHTRouterContactImpl = (DHTRouterContactImpl)object;
                DHTRouterContactImpl dHTRouterContactImpl2 = (DHTRouterContactImpl)object2;
                return (int)(dHTRouterContactImpl2.getTimeAlive() - dHTRouterContactImpl.getTimeAlive());
            }
        });
        try {
            this.this_mon.enter();
            this.findAllContacts(treeSet, this.root);
        }
        finally {
            this.this_mon.exit();
        }
        ArrayList arrayList = new ArrayList(n);
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext() && (n <= 0 || arrayList.size() < n)) {
            arrayList.add(iterator.next());
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getAllContacts() {
        try {
            this.this_mon.enter();
            ArrayList arrayList = new ArrayList();
            this.findAllContacts(arrayList, this.root);
            ArrayList arrayList2 = arrayList;
            return arrayList2;
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected void findAllContacts(Set set, DHTRouterNodeImpl dHTRouterNodeImpl) {
        List list = dHTRouterNodeImpl.getBuckets();
        if (list == null) {
            this.findAllContacts(set, dHTRouterNodeImpl.getLeft());
            this.findAllContacts(set, dHTRouterNodeImpl.getRight());
        } else {
            for (int i = 0; i < list.size(); ++i) {
                DHTRouterContactImpl dHTRouterContactImpl = (DHTRouterContactImpl)list.get(i);
                set.add(dHTRouterContactImpl);
            }
        }
    }

    protected void findAllContacts(List list, DHTRouterNodeImpl dHTRouterNodeImpl) {
        List list2 = dHTRouterNodeImpl.getBuckets();
        if (list2 == null) {
            this.findAllContacts(list, dHTRouterNodeImpl.getLeft());
            this.findAllContacts(list, dHTRouterNodeImpl.getRight());
        } else {
            for (int i = 0; i < list2.size(); ++i) {
                DHTRouterContactImpl dHTRouterContactImpl = (DHTRouterContactImpl)list2.get(i);
                list.add(dHTRouterContactImpl);
            }
        }
    }

    public void seed() {
        this.seed_in_ticks = 6;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void seedSupport() {
        byte[] byArray = new byte[this.router_node_id.length];
        ArrayList arrayList = new ArrayList();
        try {
            this.this_mon.enter();
            this.refreshNodes(arrayList, this.root, byArray, true, 120000L);
        }
        finally {
            this.this_mon.exit();
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            this.requestLookup((byte[])arrayList.get(i), "Seeding DHT");
        }
    }

    protected void refreshNodes(List list, DHTRouterNodeImpl dHTRouterNodeImpl, byte[] byArray, boolean bl, long l) {
        if (bl && dHTRouterNodeImpl == this.smallest_subtree) {
            return;
        }
        if (l != 0L && dHTRouterNodeImpl.getTimeSinceLastLookup() <= l) {
            return;
        }
        if (dHTRouterNodeImpl.getBuckets() != null) {
            if (bl && dHTRouterNodeImpl.containsRouterNodeID()) {
                return;
            }
            this.refreshNode(list, dHTRouterNodeImpl, byArray);
        }
        if (dHTRouterNodeImpl.getBuckets() == null) {
            int n = dHTRouterNodeImpl.getDepth();
            byte by = (byte)(1 << 7 - n % 8);
            byArray[n / 8] = (byte)(byArray[n / 8] | by);
            this.refreshNodes(list, dHTRouterNodeImpl.getLeft(), byArray, bl, l);
            byArray[n / 8] = (byte)(byArray[n / 8] & ~by);
            this.refreshNodes(list, dHTRouterNodeImpl.getRight(), byArray, bl, l);
        }
    }

    protected void refreshNode(List list, DHTRouterNodeImpl dHTRouterNodeImpl, byte[] byArray) {
        byte[] byArray2 = new byte[this.router_node_id.length];
        this.random.nextBytes(byArray2);
        int n = dHTRouterNodeImpl.getDepth();
        for (int i = 0; i < n; ++i) {
            byte by = (byte)(1 << 7 - i % 8);
            boolean bl = (byArray[i / 8] >> 7 - i % 8 & 1) == 1;
            byArray2[i / 8] = bl ? (byte)(byArray2[i / 8] | by) : (byte)(byArray2[i / 8] & ~by);
        }
        list.add(byArray2);
    }

    protected DHTRouterNodeImpl getSmallestSubtree() {
        return this.smallest_subtree;
    }

    public void recordLookup(byte[] byArray) {
        this.findNode(byArray).setLastLookupTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshIdleLeaves(long l) {
        byte[] byArray = new byte[this.router_node_id.length];
        ArrayList arrayList = new ArrayList();
        try {
            this.this_mon.enter();
            this.refreshNodes(arrayList, this.root, byArray, false, l);
        }
        finally {
            this.this_mon.exit();
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            this.requestLookup((byte[])arrayList.get(i), "Idle leaf refresh");
        }
    }

    public boolean requestPing(byte[] byArray) {
        Object[] objectArray = this.findContactSupport(byArray);
        DHTRouterContactImpl dHTRouterContactImpl = (DHTRouterContactImpl)objectArray[1];
        if (dHTRouterContactImpl != null) {
            this.adapter.requestPing(dHTRouterContactImpl);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void requestPing(DHTRouterContactImpl dHTRouterContactImpl) {
        DHTLog.log("DHTRouter: requestPing:" + DHTLog.getString(dHTRouterContactImpl.getID()));
        if (dHTRouterContactImpl == this.local_contact) {
            Debug.out("pinging local contact");
        }
        try {
            this.this_mon.enter();
            if (!this.outstanding_pings.contains(dHTRouterContactImpl)) {
                this.outstanding_pings.add(dHTRouterContactImpl);
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispatchPings() {
        List list;
        if (this.outstanding_pings.size() == 0) {
            return;
        }
        try {
            this.this_mon.enter();
            list = this.outstanding_pings;
            this.outstanding_pings = new ArrayList();
        }
        finally {
            this.this_mon.exit();
        }
        for (int i = 0; i < list.size(); ++i) {
            this.adapter.requestPing((DHTRouterContactImpl)list.get(i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pingeroonies() {
        try {
            this.this_mon.enter();
            DHTRouterNodeImpl dHTRouterNodeImpl = this.root;
            LinkedList<DHTRouterNodeImpl> linkedList = new LinkedList<DHTRouterNodeImpl>();
            while (true) {
                List list;
                if ((list = dHTRouterNodeImpl.getBuckets()) == null) {
                    if (this.random.nextBoolean()) {
                        linkedList.add(dHTRouterNodeImpl.getRight());
                        dHTRouterNodeImpl = dHTRouterNodeImpl.getLeft();
                        continue;
                    }
                    linkedList.add(dHTRouterNodeImpl.getLeft());
                    dHTRouterNodeImpl = dHTRouterNodeImpl.getRight();
                    continue;
                }
                int n = 0;
                DHTRouterContactImpl dHTRouterContactImpl = null;
                for (int i = 0; i < list.size(); ++i) {
                    int n2;
                    DHTRouterContactImpl dHTRouterContactImpl2 = (DHTRouterContactImpl)list.get(i);
                    if (dHTRouterContactImpl2.getPingOutstanding() || (n2 = dHTRouterContactImpl2.getFailCount()) <= n) continue;
                    n = n2;
                    dHTRouterContactImpl = dHTRouterContactImpl2;
                }
                if (dHTRouterContactImpl != null) {
                    this.requestPing(dHTRouterContactImpl);
                    return;
                }
                if (linkedList.size() == 0) {
                    break;
                }
                dHTRouterNodeImpl = (DHTRouterNodeImpl)linkedList.removeLast();
            }
        }
        finally {
            this.this_mon.exit();
            this.dispatchPings();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void requestNodeAdd(DHTRouterContactImpl dHTRouterContactImpl) {
        DHTLog.log("DHTRouter: requestNodeAdd:" + DHTLog.getString(dHTRouterContactImpl.getID()));
        if (dHTRouterContactImpl == this.local_contact) {
            Debug.out("adding local contact");
        }
        try {
            this.this_mon.enter();
            if (!this.outstanding_adds.contains(dHTRouterContactImpl)) {
                this.outstanding_adds.add(dHTRouterContactImpl);
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispatchNodeAdds() {
        List list;
        if (this.outstanding_adds.size() == 0) {
            return;
        }
        try {
            this.this_mon.enter();
            list = this.outstanding_adds;
            this.outstanding_adds = new ArrayList();
        }
        finally {
            this.this_mon.exit();
        }
        for (int i = 0; i < list.size(); ++i) {
            this.adapter.requestAdd((DHTRouterContactImpl)list.get(i));
        }
    }

    public byte[] refreshRandom() {
        byte[] byArray = new byte[this.router_node_id.length];
        this.random.nextBytes(byArray);
        this.requestLookup(byArray, "Random Refresh");
        return byArray;
    }

    protected void requestLookup(byte[] byArray, String string) {
        DHTLog.log("DHTRouter: requestLookup:" + DHTLog.getString(byArray));
        this.adapter.requestLookup(byArray, string);
    }

    protected void getStatsSupport(long[] lArray, DHTRouterNodeImpl dHTRouterNodeImpl) {
        lArray[0] = lArray[0] + 1L;
        List list = dHTRouterNodeImpl.getBuckets();
        if (list == null) {
            this.getStatsSupport(lArray, dHTRouterNodeImpl.getLeft());
            this.getStatsSupport(lArray, dHTRouterNodeImpl.getRight());
        } else {
            lArray[1] = lArray[1] + 1L;
            lArray[2] = lArray[2] + (long)list.size();
            for (int i = 0; i < list.size(); ++i) {
                DHTRouterContactImpl dHTRouterContactImpl = (DHTRouterContactImpl)list.get(i);
                if (dHTRouterContactImpl.getFirstFailTime() > 0L) {
                    lArray[6] = lArray[6] + 1L;
                    continue;
                }
                if (dHTRouterContactImpl.hasBeenAlive()) {
                    lArray[4] = lArray[4] + 1L;
                    continue;
                }
                lArray[5] = lArray[5] + 1L;
            }
            List list2 = dHTRouterNodeImpl.getReplacements();
            if (list2 != null) {
                lArray[3] = lArray[3] + (long)list2.size();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long[] getStatsSupport() {
        try {
            this.this_mon.enter();
            long[] lArray = new long[7];
            this.getStatsSupport(lArray, this.root);
            long[] lArray2 = lArray;
            return lArray2;
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected void log(String string) {
        this.logger.log(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print() {
        try {
            this.this_mon.enter();
            this.log("DHT: " + DHTLog.getString2(this.router_node_id) + ", node count = " + this.getNodeCount() + ", contacts =" + this.getContactCount());
            this.root.print("", "");
        }
        finally {
            this.this_mon.exit();
        }
    }

    public void destroy() {
        this.timer_event.cancel();
        this.notifyDead();
    }
}

