/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.dht.transport.udp.impl;

import com.aelitis.azureus.core.dht.transport.DHTTransportContact;
import com.aelitis.azureus.core.dht.transport.DHTTransportException;
import com.aelitis.azureus.core.dht.transport.DHTTransportValue;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTTransportUDPImpl;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketReply;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPUtils;
import com.aelitis.azureus.core.dht.transport.udp.impl.packethandler.DHTUDPPacketNetworkHandler;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;

public class DHTUDPPacketReplyFindValue
extends DHTUDPPacketReply {
    public static final int DHT_FIND_VALUE_HEADER_SIZE = 26;
    public static final int DHT_FIND_VALUE_TV_HEADER_SIZE = 26;
    private DHTTransportContact[] contacts;
    private DHTTransportValue[] values;
    private boolean has_continuation;
    private byte diversification_type = 1;

    public DHTUDPPacketReplyFindValue(DHTTransportUDPImpl dHTTransportUDPImpl, int n, long l, DHTTransportContact dHTTransportContact, DHTTransportContact dHTTransportContact2) {
        super(dHTTransportUDPImpl, 1031, n, l, dHTTransportContact, dHTTransportContact2);
    }

    protected DHTUDPPacketReplyFindValue(DHTUDPPacketNetworkHandler dHTUDPPacketNetworkHandler, InetSocketAddress inetSocketAddress, DataInputStream dataInputStream, int n) throws IOException {
        super(dHTUDPPacketNetworkHandler, inetSocketAddress, dataInputStream, 1031, n);
        boolean bl;
        if (this.getProtocolVersion() >= 6) {
            this.has_continuation = dataInputStream.readBoolean();
        }
        if (bl = dataInputStream.readBoolean()) {
            if (this.getProtocolVersion() >= 6) {
                this.diversification_type = dataInputStream.readByte();
            }
            this.values = DHTUDPUtils.deserialiseTransportValues(this, dataInputStream, 0L);
        } else {
            this.contacts = DHTUDPUtils.deserialiseContacts(this.getTransport(), dataInputStream);
            if (this.getProtocolVersion() >= 16) {
                DHTUDPUtils.deserialiseVivaldi(this, dataInputStream);
            }
        }
    }

    public void serialise(DataOutputStream dataOutputStream) throws IOException {
        super.serialise(dataOutputStream);
        if (this.getProtocolVersion() >= 6) {
            dataOutputStream.writeBoolean(this.has_continuation);
        }
        dataOutputStream.writeBoolean(this.values != null);
        if (this.values == null) {
            DHTUDPUtils.serialiseContacts(dataOutputStream, this.contacts);
            if (this.getProtocolVersion() >= 16) {
                DHTUDPUtils.serialiseVivaldi(this, dataOutputStream);
            }
        } else {
            if (this.getProtocolVersion() >= 6) {
                dataOutputStream.writeByte(this.diversification_type);
            }
            try {
                DHTUDPUtils.serialiseTransportValues(this, dataOutputStream, this.values, -this.getClockSkew());
            }
            catch (DHTTransportException dHTTransportException) {
                throw new IOException(dHTTransportException.getMessage());
            }
        }
    }

    public boolean hasContinuation() {
        return this.has_continuation;
    }

    protected void setValues(DHTTransportValue[] dHTTransportValueArray, byte by, boolean bl) {
        this.has_continuation = bl;
        this.diversification_type = by;
        this.values = dHTTransportValueArray;
    }

    protected DHTTransportValue[] getValues() {
        return this.values;
    }

    protected byte getDiversificationType() {
        return this.diversification_type;
    }

    protected void setContacts(DHTTransportContact[] dHTTransportContactArray) {
        this.contacts = dHTTransportContactArray;
    }

    protected DHTTransportContact[] getContacts() {
        return this.contacts;
    }

    public String getString() {
        return super.getString() + ",contacts=" + (this.contacts == null ? "null" : "" + this.contacts.length);
    }
}

