/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.dht.transport.udp.impl;

import com.aelitis.azureus.core.dht.transport.DHTTransportContact;
import com.aelitis.azureus.core.dht.transport.DHTTransportFullStats;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTTransportUDPImpl;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketReply;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPUtils;
import com.aelitis.azureus.core.dht.transport.udp.impl.packethandler.DHTUDPPacketNetworkHandler;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;

public class DHTUDPPacketReplyStats
extends DHTUDPPacketReply {
    private int stats_type = 1;
    private DHTTransportFullStats original_stats;
    private byte[] new_stats;

    public DHTUDPPacketReplyStats(DHTTransportUDPImpl dHTTransportUDPImpl, int n, long l, DHTTransportContact dHTTransportContact, DHTTransportContact dHTTransportContact2) {
        super(dHTTransportUDPImpl, 1033, n, l, dHTTransportContact, dHTTransportContact2);
    }

    protected DHTUDPPacketReplyStats(DHTUDPPacketNetworkHandler dHTUDPPacketNetworkHandler, InetSocketAddress inetSocketAddress, DataInputStream dataInputStream, int n) throws IOException {
        super(dHTUDPPacketNetworkHandler, inetSocketAddress, dataInputStream, 1033, n);
        if (this.getProtocolVersion() >= 15) {
            this.stats_type = dataInputStream.readInt();
            if (this.stats_type == 1) {
                this.original_stats = DHTUDPUtils.deserialiseStats(this.getProtocolVersion(), dataInputStream);
            } else {
                this.new_stats = DHTUDPUtils.deserialiseByteArray(dataInputStream, 65535);
            }
        } else {
            this.original_stats = DHTUDPUtils.deserialiseStats(this.getProtocolVersion(), dataInputStream);
        }
    }

    public int getStatsType() {
        return this.stats_type;
    }

    public DHTTransportFullStats getOriginalStats() {
        return this.original_stats;
    }

    public void setOriginalStats(DHTTransportFullStats dHTTransportFullStats) {
        this.stats_type = 1;
        this.original_stats = dHTTransportFullStats;
    }

    public byte[] getNewStats() {
        return this.new_stats;
    }

    public void setNewStats(byte[] byArray, int n) {
        this.stats_type = n;
        this.new_stats = byArray;
    }

    public void serialise(DataOutputStream dataOutputStream) throws IOException {
        super.serialise(dataOutputStream);
        if (this.getProtocolVersion() >= 15) {
            dataOutputStream.writeInt(this.stats_type);
            if (this.stats_type == 1) {
                DHTUDPUtils.serialiseStats(this.getProtocolVersion(), dataOutputStream, this.original_stats);
            } else {
                DHTUDPUtils.serialiseByteArray(dataOutputStream, this.new_stats, 65535);
            }
        } else {
            DHTUDPUtils.serialiseStats(this.getProtocolVersion(), dataOutputStream, this.original_stats);
        }
    }
}

