/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.diskmanager.cache.impl;

import com.aelitis.azureus.core.diskmanager.cache.CacheFile;
import com.aelitis.azureus.core.diskmanager.cache.CacheFileManagerException;
import com.aelitis.azureus.core.diskmanager.cache.impl.CacheEntry;
import com.aelitis.azureus.core.diskmanager.cache.impl.CacheFileManagerImpl;
import com.aelitis.azureus.core.diskmanager.file.FMFile;
import com.aelitis.azureus.core.diskmanager.file.FMFileManagerException;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentFile;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Average;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.DirectByteBufferPool;

public class CacheFileWithCache
implements CacheFile {
    private static final byte SS_CACHE = 3;
    private static final LogIDs LOGID = LogIDs.CACHE;
    protected static Comparator comparator = new Comparator(){

        public int compare(Object object, Object object2) {
            CacheEntry cacheEntry = (CacheEntry)object;
            CacheEntry cacheEntry2 = (CacheEntry)object2;
            long l = cacheEntry.getFilePosition();
            int n = cacheEntry.getLength();
            long l2 = cacheEntry2.getFilePosition();
            int n2 = cacheEntry2.getLength();
            if (l + (long)n > l2 && l2 + (long)n2 > l && n != 0 && n2 != 0) {
                Debug.out("Overlapping cache entries - " + cacheEntry.getString() + "/" + cacheEntry2.getString());
            }
            return l - l2 < 0L ? -1 : 1;
        }
    };
    protected static boolean TRACE = false;
    protected static final boolean TRACE_CACHE_CONTENTS = false;
    protected static final int READAHEAD_LOW_LIMIT = 65536;
    protected static final int READAHEAD_HIGH_LIMIT = 262144;
    protected static final int READAHEAD_HISTORY = 32;
    protected CacheFileManagerImpl manager;
    protected FMFile file;
    protected int access_mode = 1;
    protected TOTorrentFile torrent_file;
    protected TOTorrent torrent;
    protected long file_offset_in_torrent;
    protected long[] read_history;
    protected int read_history_next = 0;
    protected TreeSet cache = new TreeSet(comparator);
    protected int current_read_ahead_size = 0;
    protected static final int READ_AHEAD_STATS_WAIT_TICKS = 10;
    protected int read_ahead_stats_wait = 10;
    protected Average read_ahead_made_average = Average.getInstance(1000, 5);
    protected Average read_ahead_used_average = Average.getInstance(1000, 5);
    protected long read_ahead_bytes_made;
    protected long last_read_ahead_bytes_made;
    protected long read_ahead_bytes_used;
    protected long last_read_ahead_bytes_used;
    protected int piece_size = 0;
    protected int piece_offset = 0;
    protected AEMonitor this_mon = new AEMonitor("CacheFile");
    protected volatile CacheFileManagerException pending_exception;

    protected CacheFileWithCache(CacheFileManagerImpl cacheFileManagerImpl, FMFile fMFile, TOTorrentFile tOTorrentFile) {
        this.manager = cacheFileManagerImpl;
        this.file = fMFile;
        if (tOTorrentFile != null) {
            TOTorrentFile tOTorrentFile2;
            this.torrent_file = tOTorrentFile;
            this.torrent = this.torrent_file.getTorrent();
            this.piece_size = (int)this.torrent.getPieceLength();
            for (int i = 0; i < this.torrent.getFiles().length && (tOTorrentFile2 = this.torrent.getFiles()[i]) != this.torrent_file; ++i) {
                this.file_offset_in_torrent += tOTorrentFile2.getLength();
            }
            this.piece_offset = this.piece_size - (int)(this.file_offset_in_torrent % (long)this.piece_size);
            if (this.piece_offset == this.piece_size) {
                this.piece_offset = 0;
            }
            this.current_read_ahead_size = Math.min(65536, this.piece_size);
        }
    }

    public TOTorrentFile getTorrentFile() {
        return this.torrent_file;
    }

    protected void updateStats() {
        long l = this.read_ahead_bytes_made;
        long l2 = this.read_ahead_bytes_used;
        long l3 = l - this.last_read_ahead_bytes_made;
        long l4 = l2 - this.last_read_ahead_bytes_used;
        this.read_ahead_made_average.addValue(l3);
        this.read_ahead_used_average.addValue(l4);
        this.last_read_ahead_bytes_made = l;
        this.last_read_ahead_bytes_used = l2;
        if (--this.read_ahead_stats_wait == 0) {
            this.read_ahead_stats_wait = 10;
            double d = this.read_ahead_made_average.getAverage();
            double d2 = this.read_ahead_used_average.getAverage();
            double d3 = d2 * 100.0 / d;
            if (d3 > 0.75) {
                this.current_read_ahead_size += 16384;
                this.current_read_ahead_size = Math.min(this.current_read_ahead_size, this.piece_size);
                this.current_read_ahead_size = Math.min(this.current_read_ahead_size, 262144);
                this.current_read_ahead_size = Math.min(this.current_read_ahead_size, (int)(this.manager.getCacheSize() / 16L));
            } else if (d3 < 0.5) {
                this.current_read_ahead_size -= 16384;
                this.current_read_ahead_size = Math.max(this.current_read_ahead_size, 65536);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readCache(DirectByteBuffer directByteBuffer, long l, boolean bl, boolean bl2) throws CacheFileManagerException {
        block48: {
            this.checkPendingException();
            int n = directByteBuffer.position((byte)3);
            int n2 = directByteBuffer.limit((byte)3);
            int n3 = n2 - n;
            if (this.manager.isCacheEnabled()) {
                int n4;
                if (TRACE) {
                    Logger.log(new LogEvent(this.torrent, LOGID, "readCache: " + this.getName() + ", " + l + " - " + (l + (long)n3 - 1L) + ":" + n + "/" + n2));
                }
                if (n3 == 0) {
                    return;
                }
                long l2 = l;
                int n5 = n3;
                boolean bl3 = true;
                int n6 = 0;
                long l3 = 0L;
                try {
                    this.this_mon.enter();
                    if (this.read_history == null) {
                        this.read_history = new long[32];
                        Arrays.fill(this.read_history, -1L);
                    }
                    this.read_history[this.read_history_next++] = l + (long)n3;
                    if (this.read_history_next == 32) {
                        this.read_history_next = 0;
                    }
                    Iterator iterator = this.cache.iterator();
                    while (bl3 && n5 > 0 && iterator.hasNext()) {
                        CacheEntry cacheEntry = (CacheEntry)iterator.next();
                        long l4 = cacheEntry.getFilePosition();
                        n4 = cacheEntry.getLength();
                        if (l4 > l2) {
                            bl3 = false;
                            break;
                        }
                        if (l4 + (long)n4 <= l2) continue;
                        int n7 = (int)(l2 - l4);
                        int n8 = n4 - n7;
                        if (n8 > n5) {
                            n8 = n5;
                        }
                        DirectByteBuffer directByteBuffer2 = cacheEntry.getBuffer();
                        int n9 = directByteBuffer2.position((byte)3);
                        int n10 = directByteBuffer2.limit((byte)3);
                        try {
                            directByteBuffer2.limit((byte)3, n9 + n7 + n8);
                            directByteBuffer2.position((byte)3, n9 + n7);
                            if (TRACE) {
                                Logger.log(new LogEvent(this.torrent, LOGID, "cacheRead: using " + cacheEntry.getString() + "[" + directByteBuffer2.position((byte)3) + "/" + directByteBuffer2.limit((byte)3) + "]" + "to write to [" + directByteBuffer.position((byte)3) + "/" + directByteBuffer.limit((byte)3) + "]"));
                            }
                            ++n6;
                            directByteBuffer.put((byte)3, directByteBuffer2);
                            this.manager.cacheEntryUsed(cacheEntry);
                        }
                        finally {
                            directByteBuffer2.limit((byte)3, n10);
                            directByteBuffer2.position((byte)3, n9);
                        }
                        l2 += (long)n8;
                        n5 -= n8;
                        if (cacheEntry.getType() != 1) continue;
                        l3 += (long)n8;
                    }
                }
                finally {
                    if (bl3) {
                        this.read_ahead_bytes_used += l3;
                    }
                    this.this_mon.exit();
                }
                if (bl3 && n5 == 0) {
                    if (!bl) {
                        this.manager.cacheBytesRead(n3);
                    }
                    if (TRACE) {
                        Logger.log(new LogEvent(this.torrent, LOGID, "cacheRead: cache use ok [entries = " + n6 + "]"));
                    }
                    break block48;
                }
                if (TRACE) {
                    Logger.log(new LogEvent(this.torrent, LOGID, "cacheRead: cache use fails, reverting to plain read"));
                }
                directByteBuffer.position((byte)3, n);
                for (int i = 0; i < 2; ++i) {
                    try {
                        boolean bl4;
                        boolean bl5 = bl4 = i == 0 && !bl && !bl2 && this.read_history != null && this.manager.isReadCacheEnabled() && n3 < this.current_read_ahead_size && l + (long)this.current_read_ahead_size <= this.file.getLength();
                        if (bl4) {
                            bl4 = false;
                            for (int j = 0; j < 32; ++j) {
                                if (this.read_history[j] != l) continue;
                                bl4 = true;
                                break;
                            }
                        }
                        int n11 = this.current_read_ahead_size;
                        if (bl4) {
                            int n12 = (int)((l - (long)this.piece_offset) % (long)this.piece_size);
                            if (n12 < 0) {
                                n12 += this.piece_size;
                            }
                            if ((n4 = this.piece_size - n12) < n11 && (n11 = n4) <= n3) {
                                bl4 = false;
                            }
                        }
                        if (bl4) {
                            if (TRACE) {
                                Logger.log(new LogEvent(this.torrent, LOGID, "\tperforming read-ahead"));
                            }
                            DirectByteBuffer directByteBuffer3 = DirectByteBufferPool.getBuffer((byte)5, n11);
                            n4 = 0;
                            try {
                                CacheEntry cacheEntry = this.manager.allocateCacheSpace(1, this, directByteBuffer3, l, n11);
                                cacheEntry.setClean();
                                try {
                                    this.this_mon.enter();
                                    this.flushCache(l, n11, true, -1L, 0L, -1L);
                                    this.getFMFile().read(directByteBuffer3, l);
                                    this.read_ahead_bytes_made += (long)n11;
                                    this.manager.fileBytesRead(n11);
                                    directByteBuffer3.position((byte)3, 0);
                                    this.cache.add(cacheEntry);
                                    this.manager.addCacheSpace(cacheEntry);
                                }
                                finally {
                                    this.this_mon.exit();
                                }
                                n4 = 1;
                            }
                            finally {
                                if (n4 == 0) {
                                    directByteBuffer3.returnToPool();
                                }
                            }
                            this.readCache(directByteBuffer, l, true, bl2);
                            break block48;
                        }
                        if (TRACE) {
                            Logger.log(new LogEvent(this.torrent, LOGID, "\tnot performing read-ahead"));
                        }
                        try {
                            this.this_mon.enter();
                            this.flushCache(l, n3, true, -1L, 0L, -1L);
                            this.getFMFile().read(directByteBuffer, l);
                        }
                        finally {
                            this.this_mon.exit();
                        }
                        this.manager.fileBytesRead(n3);
                        break block48;
                    }
                    catch (CacheFileManagerException cacheFileManagerException) {
                        if (i != 1) continue;
                        throw cacheFileManagerException;
                    }
                    catch (FMFileManagerException fMFileManagerException) {
                        if (i != 1) continue;
                        this.manager.rethrow(this, fMFileManagerException);
                    }
                }
                break block48;
            }
            try {
                this.getFMFile().read(directByteBuffer, l);
                this.manager.fileBytesRead(n3);
            }
            catch (FMFileManagerException fMFileManagerException) {
                this.manager.rethrow(this, fMFileManagerException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeCache(DirectByteBuffer object, long l, boolean bl) throws CacheFileManagerException {
        block22: {
            this.checkPendingException();
            boolean bl2 = false;
            boolean bl3 = false;
            try {
                int n = ((DirectByteBuffer)object).position((byte)3);
                int n2 = ((DirectByteBuffer)object).limit((byte)3);
                int n3 = n2 - n;
                if (n3 == 0) {
                    return;
                }
                if (this.manager.isWriteCacheEnabled()) {
                    Object object2;
                    if (TRACE) {
                        Logger.log(new LogEvent(this.torrent, LOGID, "writeCache: " + this.getName() + ", " + l + " - " + (l + (long)n3 - 1L) + ":" + n + "/" + n2));
                    }
                    if (!bl && n3 < this.piece_size) {
                        if (TRACE) {
                            Logger.log(new LogEvent(this.torrent, LOGID, "    making copy of non-handedover buffer"));
                        }
                        object2 = DirectByteBufferPool.getBuffer((byte)10, n3);
                        ((DirectByteBuffer)object2).put((byte)3, (DirectByteBuffer)object);
                        ((DirectByteBuffer)object2).position((byte)3, 0);
                        object = object2;
                        n = 0;
                        n2 = n3;
                        bl = true;
                    }
                    if (bl) {
                        object2 = this.manager.allocateCacheSpace(0, this, (DirectByteBuffer)object, l, n3);
                        try {
                            this.this_mon.enter();
                            if (this.access_mode != 2) {
                                throw new CacheFileManagerException(this, "Write failed - cache file is read only");
                            }
                            this.flushCache(l, n3, true, -1L, 0L, -1L);
                            this.cache.add(object2);
                            this.manager.addCacheSpace((CacheEntry)object2);
                        }
                        finally {
                            this.this_mon.exit();
                        }
                        this.manager.cacheBytesWritten(n3);
                        bl2 = true;
                        break block22;
                    }
                    try {
                        this.this_mon.enter();
                        this.flushCache(l, n3, true, -1L, 0L, -1L);
                        this.getFMFile().write((DirectByteBuffer)object, l);
                    }
                    finally {
                        this.this_mon.exit();
                    }
                    this.manager.fileBytesWritten(n3);
                    break block22;
                }
                this.getFMFile().write((DirectByteBuffer)object, l);
                this.manager.fileBytesWritten(n3);
            }
            catch (CacheFileManagerException cacheFileManagerException) {
                bl3 = true;
                throw cacheFileManagerException;
            }
            catch (FMFileManagerException fMFileManagerException) {
                bl3 = true;
                this.manager.rethrow(this, fMFileManagerException);
            }
            finally {
                if (bl && !bl3 && !bl2) {
                    ((DirectByteBuffer)object).returnToPool();
                }
            }
        }
    }

    protected void flushCache(long l, long l2, boolean bl, long l3, long l4, long l5) throws CacheFileManagerException {
        try {
            this.flushCacheSupport(l, l2, bl, l3, l4, l5);
        }
        catch (CacheFileManagerException cacheFileManagerException) {
            if (!bl) {
                this.flushCacheSupport(0L, -1L, true, -1L, 0L, -1L);
            }
            throw cacheFileManagerException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flushCacheSupport(long l, long l2, boolean bl, long l3, long l4, long l5) throws CacheFileManagerException {
        try {
            this.this_mon.enter();
            if (this.cache.size() == 0) {
                return;
            }
            Iterator iterator = this.cache.iterator();
            Throwable throwable = null;
            long l6 = 0L;
            ArrayList<CacheEntry> arrayList = new ArrayList<CacheEntry>();
            long l7 = -1L;
            long l8 = -1L;
            while (iterator.hasNext()) {
                int n;
                CacheEntry cacheEntry = (CacheEntry)iterator.next();
                long l9 = cacheEntry.getFilePosition();
                if (l9 + (long)(n = cacheEntry.getLength()) <= l) continue;
                if (l2 != -1L && l + l2 <= l9) break;
                boolean bl2 = cacheEntry.isDirty();
                try {
                    if (!bl2 || l4 != 0L && cacheEntry.getLastUsed() >= l4) continue;
                    if (l7 == -1L) {
                        l7 = l9;
                        l8 = l9 + (long)n;
                        arrayList.add(cacheEntry);
                        continue;
                    }
                    if (l8 == l9) {
                        l8 = l9 + (long)n;
                        arrayList.add(cacheEntry);
                        continue;
                    }
                    boolean bl3 = false;
                    if (l5 != -1L) {
                        if (bl) {
                            Debug.out("CacheFile: can't use min chunk with release option");
                        } else {
                            bl3 = l8 - l7 < l5;
                        }
                    }
                    ArrayList<CacheEntry> arrayList2 = arrayList;
                    long l10 = l7;
                    long l11 = l8;
                    l7 = l9;
                    l8 = l9 + (long)n;
                    arrayList = new ArrayList();
                    arrayList.add(cacheEntry);
                    if (bl3) {
                        if (!TRACE) continue;
                        Logger.log(new LogEvent(this.torrent, LOGID, "flushCache: skipping " + arrayList.size() + " entries, [" + l7 + "," + l8 + "] as too small"));
                        continue;
                    }
                    this.multiBlockFlush(arrayList2, l10, l11, bl);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                }
                finally {
                    if (!bl) continue;
                    iterator.remove();
                    if (!bl2) {
                        this.manager.releaseCacheSpace(cacheEntry);
                    }
                    if (l3 != -1L && (l6 += (long)cacheEntry.getLength()) > l3) break;
                }
            }
            if (l7 != -1L) {
                boolean bl4 = false;
                if (l5 != -1L) {
                    if (bl) {
                        Debug.out("CacheFile: can't use min chunk with release option");
                    } else {
                        boolean bl5 = bl4 = l8 - l7 < l5;
                    }
                }
                if (bl4) {
                    if (TRACE) {
                        Logger.log(new LogEvent(this.torrent, LOGID, "flushCache: skipping " + arrayList.size() + " entries, [" + l7 + "," + l8 + "] as too small"));
                    }
                } else {
                    this.multiBlockFlush(arrayList, l7, l8, bl);
                }
            }
            if (throwable != null) {
                if (throwable instanceof CacheFileManagerException) {
                    throw (CacheFileManagerException)throwable;
                }
                throw new CacheFileManagerException(this, "cache flush failed", throwable);
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected void multiBlockFlush(List list, long l, long l2, boolean bl) throws CacheFileManagerException {
        boolean bl2 = false;
        try {
            if (TRACE) {
                Logger.log(new LogEvent(this.torrent, LOGID, "multiBlockFlush: writing " + list.size() + " entries, [" + l + "," + l2 + "," + bl + "]"));
            }
            DirectByteBuffer[] directByteBufferArray = new DirectByteBuffer[list.size()];
            long l3 = 0L;
            for (int i = 0; i < directByteBufferArray.length; ++i) {
                CacheEntry cacheEntry = (CacheEntry)list.get(i);
                DirectByteBuffer directByteBuffer = cacheEntry.getBuffer();
                if (directByteBuffer.limit((byte)3) - directByteBuffer.position((byte)3) != cacheEntry.getLength()) {
                    throw new CacheFileManagerException(this, "flush: inconsistent entry length, position wrong");
                }
                l3 += (long)cacheEntry.getLength();
                directByteBufferArray[i] = directByteBuffer;
            }
            long l4 = l2 - l;
            if (l3 != l4) {
                throw new CacheFileManagerException(this, "flush: inconsistent write length, entrys = " + l3 + " overall = " + l4);
            }
            this.getFMFile().write(directByteBufferArray, l);
            this.manager.fileBytesWritten(l4);
            bl2 = true;
        }
        catch (FMFileManagerException fMFileManagerException) {
            throw new CacheFileManagerException(this, "flush fails", fMFileManagerException);
        }
        finally {
            for (int i = 0; i < list.size(); ++i) {
                CacheEntry cacheEntry = (CacheEntry)list.get(i);
                if (bl) {
                    this.manager.releaseCacheSpace(cacheEntry);
                    continue;
                }
                cacheEntry.resetBufferPosition();
                if (!bl2) continue;
                cacheEntry.setClean();
            }
        }
    }

    protected void flushCache(long l, boolean bl, long l2) throws CacheFileManagerException {
        if (this.manager.isCacheEnabled()) {
            if (TRACE) {
                Logger.log(new LogEvent(this.torrent, LOGID, "flushCache: " + this.getName() + ", rel = " + bl + ", min = " + l2));
            }
            this.flushCache(l, -1L, bl, l2, 0L, -1L);
        }
    }

    protected void flushCachePublic(boolean bl, long l) throws CacheFileManagerException {
        this.checkPendingException();
        this.flushCache(0L, bl, l);
    }

    protected void flushOldDirtyData(long l, long l2) throws CacheFileManagerException {
        if (this.manager.isCacheEnabled()) {
            if (TRACE) {
                Logger.log(new LogEvent(this.torrent, LOGID, "flushOldDirtyData: " + this.getName()));
            }
            this.flushCache(0L, -1L, false, -1L, l, l2);
        }
    }

    protected void flushOldDirtyData(long l) throws CacheFileManagerException {
        this.flushOldDirtyData(l, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getBytesInCache(boolean[] blArray, long[] lArray, long[] lArray2) {
        long l = this.file_offset_in_torrent;
        int n = 0;
        long l2 = lArray[0];
        long l3 = lArray[lArray.length - 1] + lArray2[lArray2.length - 1];
        long l4 = Math.max(lArray[0], l);
        while (lArray[n] + lArray2[n] < l) {
            ++n;
        }
        boolean bl = true;
        if (!this.this_mon.enter(250)) {
            Debug.outNoStack("Failed to lock stats, abandoning");
            return;
        }
        try {
            for (CacheEntry cacheEntry : this.cache.subSet(new CacheEntry(l2 - 1L - l), new CacheEntry(l3 - l))) {
                long l5 = cacheEntry.getFilePosition() + l;
                long l6 = l5 + (long)cacheEntry.getLength();
                if (l5 < l2) continue;
                if (bl) {
                    while (n < lArray.length && lArray[n] < l5) {
                        blArray[n] = false;
                        ++n;
                    }
                }
                if (n >= lArray.length) {
                    break;
                }
                bl = false;
                if (l5 >= lArray[n] && l6 >= lArray[n] + lArray2[n]) {
                    ++n;
                    bl = true;
                } else if (l5 >= l4) {
                    bl = true;
                } else if (l5 >= lArray[n] + lArray2[n]) {
                    ++n;
                    bl = true;
                }
                if (l6 > l3) {
                    break;
                }
                l4 = l6;
            }
        }
        finally {
            this.this_mon.exit();
        }
        if (bl) {
            while (n < lArray.length) {
                if (lArray[n] + lArray2[n] < l || lArray[n] > l + this.torrent_file.getLength()) {
                    ++n;
                    continue;
                }
                blArray[n] = false;
                ++n;
            }
        }
    }

    protected void checkPendingException() throws CacheFileManagerException {
        if (this.pending_exception != null) {
            throw this.pending_exception;
        }
    }

    protected void setPendingException(CacheFileManagerException cacheFileManagerException) {
        this.pending_exception = cacheFileManagerException;
    }

    protected String getName() {
        return this.file.getName();
    }

    protected FMFile getFMFile() {
        return this.file;
    }

    public boolean exists() {
        return this.file.exists();
    }

    public void moveFile(File file) throws CacheFileManagerException {
        try {
            this.flushCachePublic(true, -1L);
            this.file.moveFile(file);
        }
        catch (FMFileManagerException fMFileManagerException) {
            this.manager.rethrow(this, fMFileManagerException);
        }
    }

    public void renameFile(String string) throws CacheFileManagerException {
        try {
            this.flushCachePublic(true, -1L);
            this.file.renameFile(string);
        }
        catch (FMFileManagerException fMFileManagerException) {
            this.manager.rethrow(this, fMFileManagerException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAccessMode(int n) throws CacheFileManagerException {
        try {
            this.this_mon.enter();
            if (this.access_mode != n) {
                this.flushCachePublic(false, -1L);
            }
            this.file.setAccessMode(n == 1 ? 1 : 2);
            this.access_mode = n;
        }
        catch (FMFileManagerException fMFileManagerException) {
            this.manager.rethrow(this, fMFileManagerException);
        }
        finally {
            this.this_mon.exit();
        }
    }

    public int getAccessMode() {
        return this.access_mode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStorageType(int n) throws CacheFileManagerException {
        try {
            this.this_mon.enter();
            if (this.getStorageType() != n) {
                this.flushCachePublic(false, -1L);
            }
            this.file.setStorageType(CacheFileManagerImpl.convertCacheToFileType(n));
        }
        catch (FMFileManagerException fMFileManagerException) {
            this.manager.rethrow(this, fMFileManagerException);
        }
        finally {
            this.this_mon.exit();
        }
    }

    public int getStorageType() {
        return CacheFileManagerImpl.convertFileToCacheType(this.file.getStorageType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getLength() throws CacheFileManagerException {
        try {
            if (this.manager.isCacheEnabled()) {
                try {
                    this.this_mon.enter();
                    long l = this.file.exists() ? this.file.getLength() : 0L;
                    Iterator iterator = this.cache.iterator();
                    while (iterator.hasNext()) {
                        int n;
                        long l2;
                        long l3;
                        CacheEntry cacheEntry = (CacheEntry)iterator.next();
                        if (iterator.hasNext() || (l3 = (l2 = cacheEntry.getFilePosition()) + (long)(n = cacheEntry.getLength())) <= l) continue;
                        l = l3;
                    }
                    long l4 = l;
                    return l4;
                }
                finally {
                    this.this_mon.exit();
                }
            }
            if (!this.file.exists()) return 0L;
            long l = this.file.getLength();
            return l;
        }
        catch (FMFileManagerException fMFileManagerException) {
            this.manager.rethrow(this, fMFileManagerException);
            return 0L;
        }
    }

    public long compareLength(long l) throws CacheFileManagerException {
        try {
            long l2 = this.file.exists() ? this.file.getLength() : 0L;
            long l3 = l2 - l;
            if (l3 >= 0L) {
                return l3;
            }
            return this.getLength() - l;
        }
        catch (FMFileManagerException fMFileManagerException) {
            this.manager.rethrow(this, fMFileManagerException);
            return 0L;
        }
    }

    public void setLength(long l) throws CacheFileManagerException {
        try {
            this.flushCachePublic(true, -1L);
            this.file.setLength(l);
        }
        catch (FMFileManagerException fMFileManagerException) {
            this.manager.rethrow(this, fMFileManagerException);
        }
    }

    public void setPieceComplete(int n, DirectByteBuffer directByteBuffer) throws CacheFileManagerException {
        try {
            this.file.setPieceComplete(n, directByteBuffer);
        }
        catch (FMFileManagerException fMFileManagerException) {
            this.manager.rethrow(this, fMFileManagerException);
        }
    }

    public void read(DirectByteBuffer[] directByteBufferArray, long l, short s) throws CacheFileManagerException {
        for (int i = 0; i < directByteBufferArray.length; ++i) {
            DirectByteBuffer directByteBuffer = directByteBufferArray[i];
            int n = directByteBuffer.remaining((byte)3);
            try {
                this.read(directByteBuffer, l, s);
                l += (long)n;
                continue;
            }
            catch (CacheFileManagerException cacheFileManagerException) {
                throw new CacheFileManagerException(this, cacheFileManagerException.getMessage(), cacheFileManagerException, i);
            }
        }
    }

    public void read(DirectByteBuffer directByteBuffer, long l, short s) throws CacheFileManagerException {
        boolean bl;
        boolean bl2 = (s & 1) != 0;
        boolean bl3 = bl = (s & 2) != 0;
        if (bl) {
            int n = directByteBuffer.position((byte)3);
            int n2 = directByteBuffer.limit((byte)3);
            int n3 = n2 - n;
            this.flushCache(l, n3, false, -1L, 0L, -1L);
        }
        this.readCache(directByteBuffer, l, false, !bl2);
    }

    public void write(DirectByteBuffer directByteBuffer, long l) throws CacheFileManagerException {
        this.writeCache(directByteBuffer, l, false);
    }

    public void write(DirectByteBuffer[] directByteBufferArray, long l) throws CacheFileManagerException {
        for (int i = 0; i < directByteBufferArray.length; ++i) {
            DirectByteBuffer directByteBuffer = directByteBufferArray[i];
            int n = directByteBuffer.remaining((byte)3);
            try {
                this.write(directByteBuffer, l);
                l += (long)n;
                continue;
            }
            catch (CacheFileManagerException cacheFileManagerException) {
                throw new CacheFileManagerException(this, cacheFileManagerException.getMessage(), cacheFileManagerException, i);
            }
        }
    }

    public void writeAndHandoverBuffer(DirectByteBuffer directByteBuffer, long l) throws CacheFileManagerException {
        this.writeCache(directByteBuffer, l, true);
    }

    public void writeAndHandoverBuffers(DirectByteBuffer[] directByteBufferArray, long l) throws CacheFileManagerException {
        for (int i = 0; i < directByteBufferArray.length; ++i) {
            DirectByteBuffer directByteBuffer = directByteBufferArray[i];
            int n = directByteBuffer.remaining((byte)3);
            try {
                this.writeAndHandoverBuffer(directByteBuffer, l);
                l += (long)n;
                continue;
            }
            catch (CacheFileManagerException cacheFileManagerException) {
                throw new CacheFileManagerException(this, cacheFileManagerException.getMessage(), cacheFileManagerException, i);
            }
        }
    }

    public void flushCache() throws CacheFileManagerException {
        try {
            this.flushCachePublic(false, -1L);
            this.file.flush();
        }
        catch (FMFileManagerException fMFileManagerException) {
            this.manager.rethrow(this, fMFileManagerException);
        }
    }

    public void clearCache() throws CacheFileManagerException {
        this.flushCachePublic(true, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws CacheFileManagerException {
        boolean bl = false;
        try {
            this.flushCachePublic(true, -1L);
            this.file.close();
            bl = true;
        }
        catch (FMFileManagerException fMFileManagerException) {
            this.manager.rethrow(this, fMFileManagerException);
        }
        finally {
            if (!bl) {
                try {
                    this.file.close();
                }
                catch (Throwable throwable) {}
            }
            this.manager.closeFile(this);
        }
    }

    public boolean isOpen() {
        return this.file.isOpen();
    }

    public void delete() throws CacheFileManagerException {
        try {
            this.file.delete();
        }
        catch (FMFileManagerException fMFileManagerException) {
            this.manager.rethrow(this, fMFileManagerException);
        }
    }

    static {
        TRACE = COConfigurationManager.getBooleanParameter("diskmanager.perf.cache.trace");
        if (TRACE) {
            System.out.println("**** Disk Cache tracing enabled ****");
        }
    }
}

