/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.diskmanager.cache.impl;

import com.aelitis.azureus.core.diskmanager.cache.CacheFile;
import com.aelitis.azureus.core.diskmanager.cache.CacheFileManagerException;
import com.aelitis.azureus.core.diskmanager.cache.impl.CacheFileManagerImpl;
import com.aelitis.azureus.core.diskmanager.file.FMFile;
import com.aelitis.azureus.core.diskmanager.file.FMFileManagerException;
import java.io.File;
import org.gudy.azureus2.core3.torrent.TOTorrentFile;
import org.gudy.azureus2.core3.util.DirectByteBuffer;

public class CacheFileWithoutCacheMT
implements CacheFile {
    private static final int MAX_CLONES = 20;
    private static int num_clones;
    private static int max_clone_depth;
    private CacheFileManagerImpl manager;
    private FMFile base_file;
    private FMFile[] files;
    private int[] files_use_count;
    private TOTorrentFile torrent_file;
    private boolean moving;

    protected CacheFileWithoutCacheMT(CacheFileManagerImpl cacheFileManagerImpl, FMFile fMFile, TOTorrentFile tOTorrentFile) {
        this.manager = cacheFileManagerImpl;
        this.base_file = fMFile;
        this.torrent_file = tOTorrentFile;
        this.files = new FMFile[]{this.base_file};
        this.files_use_count = new int[]{0};
    }

    public TOTorrentFile getTorrentFile() {
        return this.torrent_file;
    }

    public boolean exists() {
        return this.base_file.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void moveFile(File file) throws CacheFileManagerException {
        try {
            CacheFileWithoutCacheMT cacheFileWithoutCacheMT = this;
            // MONITORENTER : cacheFileWithoutCacheMT
            this.moving = true;
            // MONITOREXIT : cacheFileWithoutCacheMT
            while (true) {
                int n;
                cacheFileWithoutCacheMT = this;
                // MONITORENTER : cacheFileWithoutCacheMT
                boolean bl = false;
                for (n = 1; n < this.files_use_count.length; ++n) {
                    if (this.files_use_count[n] <= 0) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    n = 1;
                    while (true) {
                        if (n >= this.files_use_count.length) {
                            this.files = new FMFile[]{this.base_file};
                            this.files_use_count = new int[]{this.files_use_count[0]};
                            this.base_file.moveFile(file);
                            // MONITOREXIT : cacheFileWithoutCacheMT
                            return;
                        }
                        FMFile fMFile = this.files[n];
                        if (fMFile.isClone()) {
                            Class<CacheFileWithoutCacheMT> clazz = CacheFileWithoutCacheMT.class;
                            // MONITORENTER : com.aelitis.azureus.core.diskmanager.cache.impl.CacheFileWithoutCacheMT.class
                            --num_clones;
                            // MONITOREXIT : clazz
                        }
                        fMFile.close();
                        ++n;
                    }
                }
                // MONITOREXIT : cacheFileWithoutCacheMT
                try {
                    System.out.println("CacheFileWithoutCacheMT: waiting for clones to die");
                    Thread.sleep(250L);
                }
                catch (Throwable throwable) {}
            }
        }
        catch (FMFileManagerException fMFileManagerException) {
            this.manager.rethrow(this, fMFileManagerException);
            return;
        }
        finally {
            CacheFileWithoutCacheMT cacheFileWithoutCacheMT = this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void renameFile(String string) throws CacheFileManagerException {
        try {
            CacheFileWithoutCacheMT cacheFileWithoutCacheMT = this;
            // MONITORENTER : cacheFileWithoutCacheMT
            this.moving = true;
            // MONITOREXIT : cacheFileWithoutCacheMT
            while (true) {
                int n;
                cacheFileWithoutCacheMT = this;
                // MONITORENTER : cacheFileWithoutCacheMT
                boolean bl = false;
                for (n = 1; n < this.files_use_count.length; ++n) {
                    if (this.files_use_count[n] <= 0) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    n = 1;
                    while (true) {
                        if (n >= this.files_use_count.length) {
                            this.files = new FMFile[]{this.base_file};
                            this.files_use_count = new int[]{this.files_use_count[0]};
                            this.base_file.renameFile(string);
                            // MONITOREXIT : cacheFileWithoutCacheMT
                            return;
                        }
                        FMFile fMFile = this.files[n];
                        if (fMFile.isClone()) {
                            Class<CacheFileWithoutCacheMT> clazz = CacheFileWithoutCacheMT.class;
                            // MONITORENTER : com.aelitis.azureus.core.diskmanager.cache.impl.CacheFileWithoutCacheMT.class
                            --num_clones;
                            // MONITOREXIT : clazz
                        }
                        fMFile.close();
                        ++n;
                    }
                }
                // MONITOREXIT : cacheFileWithoutCacheMT
                try {
                    System.out.println("CacheFileWithoutCacheMT: waiting for clones to die");
                    Thread.sleep(250L);
                }
                catch (Throwable throwable) {}
            }
        }
        catch (FMFileManagerException fMFileManagerException) {
            this.manager.rethrow(this, fMFileManagerException);
            return;
        }
        finally {
            CacheFileWithoutCacheMT cacheFileWithoutCacheMT = this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAccessMode(int n) throws CacheFileManagerException {
        try {
            CacheFileWithoutCacheMT cacheFileWithoutCacheMT = this;
            synchronized (cacheFileWithoutCacheMT) {
                for (int i = 0; i < this.files.length; ++i) {
                    this.files[i].setAccessMode(n == 1 ? 1 : 2);
                }
            }
        }
        catch (FMFileManagerException fMFileManagerException) {
            this.manager.rethrow(this, fMFileManagerException);
        }
    }

    public int getAccessMode() {
        return this.base_file.getAccessMode() == 1 ? 1 : 2;
    }

    public void setStorageType(int n) throws CacheFileManagerException {
        throw new CacheFileManagerException(this, "Not Implemented");
    }

    public int getStorageType() {
        return CacheFileManagerImpl.convertFileToCacheType(this.base_file.getStorageType());
    }

    public long getLength() throws CacheFileManagerException {
        try {
            return this.base_file.exists() ? this.base_file.getLength() : 0L;
        }
        catch (FMFileManagerException fMFileManagerException) {
            this.manager.rethrow(this, fMFileManagerException);
            return 0L;
        }
    }

    public long compareLength(long l) throws CacheFileManagerException {
        return this.getLength() - l;
    }

    public void setLength(long l) throws CacheFileManagerException {
        try {
            this.base_file.setLength(l);
        }
        catch (FMFileManagerException fMFileManagerException) {
            this.manager.rethrow(this, fMFileManagerException);
        }
    }

    public void setPieceComplete(int n, DirectByteBuffer directByteBuffer) throws CacheFileManagerException {
        try {
            this.base_file.setPieceComplete(n, directByteBuffer);
        }
        catch (FMFileManagerException fMFileManagerException) {
            this.manager.rethrow(this, fMFileManagerException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FMFile getFile() throws CacheFileManagerException {
        CacheFileWithoutCacheMT cacheFileWithoutCacheMT = this;
        synchronized (cacheFileWithoutCacheMT) {
            int n;
            if (this.moving) {
                this.files_use_count[0] = this.files_use_count[0] + 1;
                return this.files[0];
            }
            int n2 = -1;
            int n3 = Integer.MAX_VALUE;
            for (int i = 0; i < this.files_use_count.length; ++i) {
                n = this.files_use_count[i];
                if (n >= n3) continue;
                n3 = n;
                n2 = i;
            }
            if (n3 == 0 || this.files_use_count.length == 20) {
                int n4 = n2;
                this.files_use_count[n4] = this.files_use_count[n4] + 1;
                return this.files[n2];
            }
            try {
                FMFile fMFile = this.base_file.createClone();
                n = this.files.length;
                int n5 = n + 1;
                FMFile[] fMFileArray = CacheFileWithoutCacheMT.class;
                synchronized (CacheFileWithoutCacheMT.class) {
                    if (++num_clones % 100 == 0) {
                        // empty if block
                    }
                    if (n5 == 20 || n5 > max_clone_depth) {
                        max_clone_depth = n5;
                    }
                    // ** MonitorExit[var7_9] (shouldn't be in output)
                    fMFileArray = new FMFile[n5];
                    int[] nArray = new int[n5];
                    System.arraycopy(this.files, 0, fMFileArray, 0, n);
                    System.arraycopy(this.files_use_count, 0, nArray, 0, n);
                    fMFileArray[n] = fMFile;
                    nArray[n] = 1;
                    this.files = fMFileArray;
                    this.files_use_count = nArray;
                    return fMFile;
                }
            }
            catch (FMFileManagerException fMFileManagerException) {
                this.manager.rethrow(this, fMFileManagerException);
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseFile(FMFile fMFile) {
        CacheFileWithoutCacheMT cacheFileWithoutCacheMT = this;
        synchronized (cacheFileWithoutCacheMT) {
            for (int i = 0; i < this.files_use_count.length; ++i) {
                if (this.files[i] != fMFile) continue;
                int n = this.files_use_count[i];
                if (n > 0) {
                    // empty if block
                }
                this.files_use_count[i] = --n;
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(DirectByteBuffer[] directByteBufferArray, long l, short s) throws CacheFileManagerException {
        int n = 0;
        for (int i = 0; i < directByteBufferArray.length; ++i) {
            n += directByteBufferArray[i].remaining((byte)3);
        }
        FMFile fMFile = null;
        try {
            fMFile = this.getFile();
            fMFile.read(directByteBufferArray, l);
            this.manager.fileBytesRead(n);
        }
        catch (FMFileManagerException fMFileManagerException) {
            this.manager.rethrow(this, fMFileManagerException);
        }
        finally {
            this.releaseFile(fMFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(DirectByteBuffer directByteBuffer, long l, short s) throws CacheFileManagerException {
        int n = directByteBuffer.remaining((byte)3);
        FMFile fMFile = null;
        try {
            fMFile = this.getFile();
            fMFile.read(directByteBuffer, l);
            this.manager.fileBytesRead(n);
        }
        catch (FMFileManagerException fMFileManagerException) {
            this.manager.rethrow(this, fMFileManagerException);
        }
        finally {
            this.releaseFile(fMFile);
        }
    }

    public void write(DirectByteBuffer directByteBuffer, long l) throws CacheFileManagerException {
        int n = directByteBuffer.remaining((byte)3);
        try {
            this.base_file.write(directByteBuffer, l);
            this.manager.fileBytesWritten(n);
        }
        catch (FMFileManagerException fMFileManagerException) {
            this.manager.rethrow(this, fMFileManagerException);
        }
    }

    public void write(DirectByteBuffer[] directByteBufferArray, long l) throws CacheFileManagerException {
        int n = 0;
        for (int i = 0; i < directByteBufferArray.length; ++i) {
            n += directByteBufferArray[i].remaining((byte)3);
        }
        try {
            this.base_file.write(directByteBufferArray, l);
            this.manager.fileBytesWritten(n);
        }
        catch (FMFileManagerException fMFileManagerException) {
            this.manager.rethrow(this, fMFileManagerException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeAndHandoverBuffer(DirectByteBuffer directByteBuffer, long l) throws CacheFileManagerException {
        int n = directByteBuffer.remaining((byte)3);
        boolean bl = false;
        try {
            this.base_file.write(directByteBuffer, l);
            this.manager.fileBytesWritten(n);
            bl = true;
        }
        catch (FMFileManagerException fMFileManagerException) {
            this.manager.rethrow(this, fMFileManagerException);
        }
        finally {
            if (bl) {
                directByteBuffer.returnToPool();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeAndHandoverBuffers(DirectByteBuffer[] directByteBufferArray, long l) throws CacheFileManagerException {
        block7: {
            int n;
            int n2 = 0;
            for (n = 0; n < directByteBufferArray.length; ++n) {
                n2 += directByteBufferArray[n].remaining((byte)3);
            }
            n = 0;
            try {
                this.base_file.write(directByteBufferArray, l);
                this.manager.fileBytesWritten(n2);
                n = 1;
            }
            catch (FMFileManagerException fMFileManagerException) {
                this.manager.rethrow(this, fMFileManagerException);
            }
            finally {
                if (n == 0) break block7;
                for (int i = 0; i < directByteBufferArray.length; ++i) {
                    directByteBufferArray[i].returnToPool();
                }
            }
        }
    }

    public void flushCache() throws CacheFileManagerException {
        try {
            this.base_file.flush();
        }
        catch (FMFileManagerException fMFileManagerException) {
            this.manager.rethrow(this, fMFileManagerException);
        }
    }

    public void clearCache() throws CacheFileManagerException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void close() throws CacheFileManagerException {
        try {
            CacheFileWithoutCacheMT cacheFileWithoutCacheMT = this;
            // MONITORENTER : cacheFileWithoutCacheMT
            int n = 0;
            while (true) {
                if (n >= this.files.length) {
                    // MONITOREXIT : cacheFileWithoutCacheMT
                    return;
                }
                FMFile fMFile = this.files[n];
                if (fMFile.isClone()) {
                    Class<CacheFileWithoutCacheMT> clazz = CacheFileWithoutCacheMT.class;
                    // MONITORENTER : com.aelitis.azureus.core.diskmanager.cache.impl.CacheFileWithoutCacheMT.class
                    --num_clones;
                    // MONITOREXIT : clazz
                }
                fMFile.close();
                ++n;
            }
        }
        catch (FMFileManagerException fMFileManagerException) {
            this.manager.rethrow(this, fMFileManagerException);
        }
    }

    public boolean isOpen() {
        return this.base_file.isOpen();
    }

    public void delete() throws CacheFileManagerException {
        try {
            this.base_file.delete();
        }
        catch (FMFileManagerException fMFileManagerException) {
            this.manager.rethrow(this, fMFileManagerException);
        }
    }
}

