/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.diskmanager.file.impl;

import com.aelitis.azureus.core.diskmanager.file.FMFileManagerException;
import com.aelitis.azureus.core.diskmanager.file.impl.FMFileAccess;
import com.aelitis.azureus.core.diskmanager.file.impl.FMFileAccessCompact;
import com.aelitis.azureus.core.diskmanager.file.impl.FMFileAccessLinear;
import com.aelitis.azureus.core.diskmanager.file.impl.FMFileAccessPieceReorderer;
import com.aelitis.azureus.core.diskmanager.file.impl.FMFileImpl;
import java.io.File;
import java.io.RandomAccessFile;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentFile;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.DirectByteBufferPool;
import org.gudy.azureus2.core3.util.StringInterner;

public class FMFileAccessController
implements FMFileAccess {
    private static final String REORDER_SUFFIX = ".2";
    private FMFileImpl owner;
    private int type = 1;
    private File controlPath;
    private String controlFileName;
    private FMFileAccess file_access;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected FMFileAccessController(FMFileImpl fMFileImpl, int n) throws FMFileManagerException {
        this.owner = fMFileImpl;
        this.setControlFile();
        if (this.controlPath == null) {
            if (n != 1) throw new FMFileManagerException("Compact storage not supported: no control file available");
            this.file_access = new FMFileAccessLinear(this.owner);
            return;
        } else {
            this.type = new File(this.controlPath, this.controlFileName).exists() ? 2 : (new File(this.controlPath, this.controlFileName + REORDER_SUFFIX).exists() ? 3 : (n == 3 && !this.owner.getLinkedFile().exists() ? 3 : 1));
            this.file_access = this.type == 1 ? new FMFileAccessLinear(this.owner) : (this.type == 2 ? new FMFileAccessCompact(this.owner.getOwner().getTorrentFile(), this.controlPath, this.controlFileName, new FMFileAccessLinear(this.owner)) : new FMFileAccessPieceReorderer(this.owner.getOwner().getTorrentFile(), this.controlPath, this.controlFileName + REORDER_SUFFIX, new FMFileAccessLinear(this.owner)));
            if (this.type == n) return;
            this.convert(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void convert(int n) throws FMFileManagerException {
        block30: {
            if (this.type == 3 || n == 3) {
                throw new FMFileManagerException("Conversion to/from piece-reorder not supported");
            }
            File file = this.owner.getLinkedFile();
            RandomAccessFile randomAccessFile = null;
            boolean bl = false;
            FMFileAccess fMFileAccess = n == 1 ? new FMFileAccessLinear(this.owner) : new FMFileAccessCompact(this.owner.getOwner().getTorrentFile(), this.controlPath, this.controlFileName, new FMFileAccessLinear(this.owner));
            if (file.exists()) {
                randomAccessFile = new RandomAccessFile(file, "rw");
                FMFileAccessCompact fMFileAccessCompact = n == 1 ? (FMFileAccessCompact)this.file_access : (FMFileAccessCompact)fMFileAccess;
                long l = this.file_access.getLength(randomAccessFile);
                long l2 = fMFileAccessCompact.getLastPieceStart();
                long l3 = fMFileAccessCompact.getLastPieceLength();
                if (l3 > 0L && l > l2) {
                    long l4 = l - l2;
                    if (l4 > l3) {
                        Debug.out("data length inconsistent: len=" + l4 + ",limit=" + l3);
                        l4 = l3;
                    }
                    DirectByteBuffer directByteBuffer = DirectByteBufferPool.getBuffer((byte)25, (int)l4);
                    try {
                        this.file_access.read(randomAccessFile, new DirectByteBuffer[]{directByteBuffer}, l2);
                        if (n == 2) {
                            long l5 = fMFileAccessCompact.getFirstPieceLength();
                            long l6 = randomAccessFile.length();
                            if (l6 > l5) {
                                randomAccessFile.setLength(l5);
                            }
                        }
                        directByteBuffer.flip((byte)25);
                        fMFileAccess.write(randomAccessFile, new DirectByteBuffer[]{directByteBuffer}, l2);
                        Object var21_17 = null;
                        directByteBuffer.returnToPool();
                    }
                    catch (Throwable throwable) {
                        Object var21_18 = null;
                        directByteBuffer.returnToPool();
                        throw throwable;
                    }
                } else if (n == 2) {
                    long l7 = fMFileAccessCompact.getFirstPieceLength();
                    long l8 = randomAccessFile.length();
                    if (l8 > l7) {
                        randomAccessFile.setLength(l7);
                    }
                }
                fMFileAccess.setLength(randomAccessFile, l);
                fMFileAccess.flush();
            }
            this.type = n;
            this.file_access = fMFileAccess;
            bl = true;
            Object var23_20 = null;
            try {
                block29: {
                    if (randomAccessFile != null) {
                        try {
                            randomAccessFile.close();
                        }
                        catch (Throwable throwable) {
                            if (!bl) break block29;
                            bl = false;
                            throw new FMFileManagerException("convert fails", throwable);
                        }
                    }
                }
                Object var26_24 = null;
                if (!bl) {
                    this.type = 1;
                    this.file_access = new FMFileAccessLinear(this.owner);
                }
                if (this.type != 1) break block30;
                new File(this.controlPath, this.controlFileName).delete();
            }
            catch (Throwable throwable) {
                Object var26_25 = null;
                if (!bl) {
                    this.type = 1;
                    this.file_access = new FMFileAccessLinear(this.owner);
                }
                if (this.type == 1) {
                    new File(this.controlPath, this.controlFileName).delete();
                }
                throw throwable;
            }
            {
                break block30;
            }
            {
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                    throw new FMFileManagerException("convert fails", throwable);
                }
            }
            catch (Throwable throwable) {
                block32: {
                    Object var23_21 = null;
                    try {
                        block31: {
                            if (randomAccessFile != null) {
                                try {
                                    randomAccessFile.close();
                                }
                                catch (Throwable throwable2) {
                                    if (!bl) break block31;
                                    bl = false;
                                    throw new FMFileManagerException("convert fails", throwable2);
                                }
                            }
                        }
                        Object var26_26 = null;
                        if (!bl) {
                            this.type = 1;
                            this.file_access = new FMFileAccessLinear(this.owner);
                        }
                        if (this.type != 1) break block32;
                        new File(this.controlPath, this.controlFileName).delete();
                    }
                    catch (Throwable throwable3) {
                        Object var26_27 = null;
                        if (!bl) {
                            this.type = 1;
                            this.file_access = new FMFileAccessLinear(this.owner);
                        }
                        if (this.type == 1) {
                            new File(this.controlPath, this.controlFileName).delete();
                        }
                        throw throwable3;
                    }
                    {
                    }
                }
                throw throwable;
            }
        }
    }

    protected void setControlFile() {
        TOTorrentFile tOTorrentFile = this.owner.getOwner().getTorrentFile();
        if (tOTorrentFile == null) {
            this.controlFileName = null;
            this.controlPath = null;
        }
        TOTorrent tOTorrent = tOTorrentFile.getTorrent();
        TOTorrentFile[] tOTorrentFileArray = tOTorrent.getFiles();
        int n = -1;
        for (int i = 0; i < tOTorrentFileArray.length; ++i) {
            if (tOTorrentFileArray[i] != tOTorrentFile) continue;
            n = i;
            break;
        }
        if (n == -1) {
            Debug.out("File '" + this.owner.getName() + "' not found in torrent!");
            this.controlFileName = null;
            this.controlPath = null;
        } else {
            this.controlPath = this.owner.getOwner().getControlFileDir();
            this.controlFileName = StringInterner.intern("fmfile" + n + ".dat");
        }
    }

    public void setStorageType(int n) throws FMFileManagerException {
        if (n == this.type) {
            return;
        }
        this.convert(n);
    }

    public int getStorageType() {
        return this.type;
    }

    public void aboutToOpen() throws FMFileManagerException {
        this.file_access.aboutToOpen();
    }

    public long getLength(RandomAccessFile randomAccessFile) throws FMFileManagerException {
        return this.file_access.getLength(randomAccessFile);
    }

    public void setLength(RandomAccessFile randomAccessFile, long l) throws FMFileManagerException {
        this.file_access.setLength(randomAccessFile, l);
    }

    public void setPieceComplete(RandomAccessFile randomAccessFile, int n, DirectByteBuffer directByteBuffer) throws FMFileManagerException {
        this.file_access.setPieceComplete(randomAccessFile, n, directByteBuffer);
    }

    public void read(RandomAccessFile randomAccessFile, DirectByteBuffer[] directByteBufferArray, long l) throws FMFileManagerException {
        this.file_access.read(randomAccessFile, directByteBufferArray, l);
    }

    public void write(RandomAccessFile randomAccessFile, DirectByteBuffer[] directByteBufferArray, long l) throws FMFileManagerException {
        this.file_access.write(randomAccessFile, directByteBufferArray, l);
    }

    public void flush() throws FMFileManagerException {
        this.file_access.flush();
    }

    public String getString() {
        return "type=" + this.type + ",acc=" + this.file_access.getString();
    }
}

