/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.diskmanager.file.impl;

import com.aelitis.azureus.core.diskmanager.file.FMFileManagerException;
import com.aelitis.azureus.core.diskmanager.file.impl.FMFileAccess;
import com.aelitis.azureus.core.diskmanager.file.impl.FMFileImpl;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.SystemTime;

public class FMFileAccessLinear
implements FMFileAccess {
    private static final int WRITE_RETRY_LIMIT = 10;
    private static final int WRITE_RETRY_DELAY = 100;
    private static final int READ_RETRY_LIMIT = 10;
    private static final int READ_RETRY_DELAY = 100;
    private static final boolean DEBUG = true;
    private static final boolean DEBUG_VERBOSE = false;
    private FMFileImpl owner;

    protected FMFileAccessLinear(FMFileImpl fMFileImpl) {
        this.owner = fMFileImpl;
    }

    public void aboutToOpen() throws FMFileManagerException {
    }

    public long getLength(RandomAccessFile randomAccessFile) throws FMFileManagerException {
        try {
            AEThread2.setDebug(this.owner);
            return randomAccessFile.length();
        }
        catch (Throwable throwable) {
            throw new FMFileManagerException("getLength fails", throwable);
        }
    }

    public void setLength(RandomAccessFile randomAccessFile, long l) throws FMFileManagerException {
        try {
            AEThread2.setDebug(this.owner);
            randomAccessFile.setLength(l);
        }
        catch (Throwable throwable) {
            throw new FMFileManagerException("setLength fails", throwable);
        }
    }

    public void setPieceComplete(RandomAccessFile randomAccessFile, int n, DirectByteBuffer directByteBuffer) throws FMFileManagerException {
    }

    public void read(RandomAccessFile randomAccessFile, DirectByteBuffer directByteBuffer, long l) throws FMFileManagerException {
        if (randomAccessFile == null) {
            throw new FMFileManagerException("read: raf is null");
        }
        FileChannel fileChannel = randomAccessFile.getChannel();
        if (!fileChannel.isOpen()) {
            Debug.out("FileChannel is closed: " + this.owner.getName());
            throw new FMFileManagerException("read - file is closed");
        }
        AEThread2.setDebug(this.owner);
        try {
            fileChannel.position(l);
            while (fileChannel.position() < fileChannel.size() && directByteBuffer.hasRemaining((byte)4)) {
                directByteBuffer.read((byte)4, fileChannel);
            }
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
            throw new FMFileManagerException("read fails", exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void read(RandomAccessFile randomAccessFile, DirectByteBuffer[] directByteBufferArray, long l) throws FMFileManagerException {
        if (randomAccessFile == null) {
            throw new FMFileManagerException("read: raf is null");
        }
        FileChannel fileChannel = randomAccessFile.getChannel();
        if (!fileChannel.isOpen()) {
            Debug.out("FileChannel is closed: " + this.owner.getName());
            throw new FMFileManagerException("read - file is closed");
        }
        AEThread2.setDebug(this.owner);
        int[] nArray = null;
        long l2 = SystemTime.getHighPrecisionCounter();
        try {
            try {
                int n;
                fileChannel.position(l);
                ByteBuffer[] byteBufferArray = new ByteBuffer[directByteBufferArray.length];
                nArray = new int[directByteBufferArray.length];
                Buffer buffer = null;
                for (n = 0; n < byteBufferArray.length; ++n) {
                    byteBufferArray[n] = directByteBufferArray[n].getBuffer((byte)4);
                    ByteBuffer byteBuffer = byteBufferArray[n];
                    nArray[n] = byteBuffer.position();
                    int n2 = nArray[n];
                    if (n2 == byteBuffer.limit()) continue;
                    buffer = byteBufferArray[n];
                }
                if (buffer != null) {
                    n = 0;
                    while (fileChannel.position() < fileChannel.size() && buffer.hasRemaining()) {
                        long l3 = fileChannel.read(byteBufferArray);
                        if (l3 > 0L) {
                            n = 0;
                            continue;
                        }
                        if (++n == 10) {
                            Debug.out("FMFile::read: zero length read - abandoning");
                            throw new FMFileManagerException("read fails: retry limit exceeded");
                        }
                        try {
                            Thread.sleep(100 * n);
                        }
                        catch (InterruptedException interruptedException) {
                            throw new FMFileManagerException("read fails: interrupted");
                        }
                    }
                }
                Object var16_18 = null;
            }
            catch (Throwable throwable) {
                try {
                    Debug.out("Read failed: " + this.owner.getString() + ": raf open=" + randomAccessFile.getChannel().isOpen() + ", len=" + randomAccessFile.length() + ",off=" + l);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                Debug.printStackTrace(throwable);
                if (nArray == null) throw new FMFileManagerException("read fails", throwable);
                try {
                    int i = 0;
                    while (i < nArray.length) {
                        directByteBufferArray[i].position((byte)4, nArray[i]);
                        ++i;
                    }
                    throw new FMFileManagerException("read fails", throwable);
                }
                catch (Throwable throwable2) {
                    Debug.out(throwable2);
                }
                throw new FMFileManagerException("read fails", throwable);
            }
        }
        catch (Throwable throwable) {
            Object var16_19 = null;
            long l4 = (SystemTime.getHighPrecisionCounter() - l2) / 1000000L;
            if (l4 <= 10000L) throw throwable;
            System.out.println("read took " + l4 + " for " + this.owner.getString());
            throw throwable;
        }
        long l5 = (SystemTime.getHighPrecisionCounter() - l2) / 1000000L;
        if (l5 <= 10000L) return;
        System.out.println("read took " + l5 + " for " + this.owner.getString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void write(RandomAccessFile randomAccessFile, DirectByteBuffer[] directByteBufferArray, long l) throws FMFileManagerException {
        if (randomAccessFile == null) {
            throw new FMFileManagerException("write fails: raf is null");
        }
        FileChannel fileChannel = randomAccessFile.getChannel();
        if (!fileChannel.isOpen()) {
            Debug.out("FileChannel is closed: " + this.owner.getName());
            throw new FMFileManagerException("read - file is closed");
        }
        AEThread2.setDebug(this.owner);
        int[] nArray = null;
        try {
            int n;
            long l2 = 0L;
            long l3 = 0L;
            boolean bl = false;
            for (int i = 0; i < directByteBufferArray.length; ++i) {
                l2 += (long)(directByteBufferArray[i].limit((byte)4) - directByteBufferArray[i].position((byte)4));
            }
            fileChannel.position(l);
            ByteBuffer[] byteBufferArray = new ByteBuffer[directByteBufferArray.length];
            nArray = new int[directByteBufferArray.length];
            Buffer buffer = null;
            for (n = 0; n < byteBufferArray.length; ++n) {
                byteBufferArray[n] = directByteBufferArray[n].getBuffer((byte)4);
                ByteBuffer byteBuffer = byteBufferArray[n];
                nArray[n] = byteBuffer.position();
                int n2 = nArray[n];
                if (n2 == byteBuffer.limit()) continue;
                buffer = byteBufferArray[n];
            }
            if (buffer != null) {
                n = 0;
                while (buffer.position() != buffer.limit()) {
                    long l4 = fileChannel.write(byteBufferArray);
                    l3 += l4;
                    if (l4 > 0L) {
                        n = 0;
                        if (buffer.position() == buffer.limit()) continue;
                        bl = true;
                        continue;
                    }
                    if (++n == 10) {
                        Debug.out("FMFile::write: zero length write - abandoning");
                        throw new FMFileManagerException("write fails: retry limit exceeded");
                    }
                    try {
                        Thread.sleep(100 * n);
                    }
                    catch (InterruptedException interruptedException) {
                        throw new FMFileManagerException("write fails: interrupted");
                    }
                }
            }
            if (l2 != l3) {
                Debug.out("FMFile::write: **** partial write **** failed: expected = " + l2 + ", actual = " + l3);
                throw new FMFileManagerException("write fails: expected write/actual write mismatch");
            }
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (nArray == null) throw new FMFileManagerException("write fails", throwable);
            try {
                for (int i = 0; i < nArray.length; ++i) {
                    directByteBufferArray[i].position((byte)4, (int)nArray[i]);
                }
                throw new FMFileManagerException("write fails", throwable);
            }
            catch (Throwable throwable2) {
                Debug.out(throwable2);
            }
            throw new FMFileManagerException("write fails", throwable);
        }
    }

    public void flush() throws FMFileManagerException {
    }

    public String getString() {
        return "linear";
    }
}

