/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.diskmanager.file.impl;

import com.aelitis.azureus.core.diskmanager.file.FMFileManagerException;
import com.aelitis.azureus.core.diskmanager.file.impl.FMFileAccess;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentFile;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.DirectByteBufferPool;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.SystemTime;

public class FMFileAccessPieceReorderer
implements FMFileAccess {
    private static final boolean TRACE = false;
    private static final int MIN_PIECES_REORDERABLE = 3;
    private static final byte SS_FILE = 4;
    private static final int DIRT_CLEAN = 0;
    private static final int DIRT_DIRTY = 1;
    private static final int DIRT_NEVER_WRITTEN = 2;
    private static final long DIRT_FLUSH_MILLIS = 30000L;
    private FMFileAccess delegate;
    private File control_dir;
    private String control_file;
    private int piece_size;
    private int first_piece_length;
    private int first_piece_number;
    private int last_piece_length;
    private int num_pieces;
    private long current_length;
    private int[] piece_map;
    private int[] piece_reverse_map;
    private int next_piece_index;
    private int dirt_state;
    private long dirt_time = -1L;

    protected FMFileAccessPieceReorderer(TOTorrentFile tOTorrentFile, File file, String string, FMFileAccess fMFileAccess) throws FMFileManagerException {
        this.delegate = fMFileAccess;
        this.control_dir = file;
        this.control_file = string;
        try {
            this.first_piece_number = tOTorrentFile.getFirstPieceNumber();
            this.num_pieces = tOTorrentFile.getLastPieceNumber() - this.first_piece_number + 1;
            if (this.num_pieces >= 3) {
                TOTorrentFile tOTorrentFile2;
                int n;
                this.piece_size = (int)tOTorrentFile.getTorrent().getPieceLength();
                TOTorrent tOTorrent = tOTorrentFile.getTorrent();
                long l = tOTorrentFile.getLength();
                long l2 = 0L;
                TOTorrentFile[] tOTorrentFileArray = tOTorrent.getFiles();
                for (n = 0; n < tOTorrentFileArray.length && (tOTorrentFile2 = tOTorrentFileArray[n]) != tOTorrentFile; ++n) {
                    l2 += tOTorrentFile2.getLength();
                }
                n = (int)(l2 % (long)this.piece_size);
                this.first_piece_length = this.piece_size - n;
                long l3 = l2 + l;
                this.last_piece_length = (int)(l3 - l3 / (long)this.piece_size * (long)this.piece_size);
                if (this.last_piece_length == 0) {
                    this.last_piece_length = this.piece_size;
                }
            }
            this.dirt_state = new File(this.control_dir, this.control_file).exists() ? 0 : 2;
        }
        catch (Throwable throwable) {
            throw new FMFileManagerException("Piece-reorder file init fail", throwable);
        }
    }

    public void aboutToOpen() throws FMFileManagerException {
        if (this.dirt_state == 2) {
            this.writeConfig();
        }
    }

    public long getLength(RandomAccessFile randomAccessFile) throws FMFileManagerException {
        if (this.num_pieces >= 3) {
            if (this.piece_map == null) {
                this.readConfig();
            }
            return this.current_length;
        }
        return this.delegate.getLength(randomAccessFile);
    }

    public void setLength(RandomAccessFile randomAccessFile, long l) throws FMFileManagerException {
        if (this.num_pieces >= 3) {
            if (this.piece_map == null) {
                this.readConfig();
            }
            if (this.current_length != l) {
                this.current_length = l;
                this.setDirty();
            }
        } else {
            this.delegate.setLength(randomAccessFile, l);
        }
    }

    protected long getPieceOffset(RandomAccessFile randomAccessFile, int n, boolean bl) throws FMFileManagerException {
        int n2;
        if (this.piece_map == null) {
            this.readConfig();
        }
        if ((n2 = this.getPieceIndex(randomAccessFile, n, bl)) < 0) {
            return n2;
        }
        if (n2 == 0) {
            return 0L;
        }
        if (n2 == 1) {
            return this.first_piece_length;
        }
        return this.first_piece_length + (n2 - 1) * this.piece_size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int readWritePiece(RandomAccessFile randomAccessFile, DirectByteBuffer[] directByteBufferArray, int n, int n2, boolean bl) throws FMFileManagerException {
        int n3;
        long l;
        int[] nArray;
        int n4;
        int n5;
        block12: {
            int n6;
            String string;
            String string2 = string = bl ? "read" : "write";
            if (n >= this.num_pieces) {
                throw new FMFileManagerException("Attempt to " + string + " piece " + n + ": last=" + this.num_pieces);
            }
            int n7 = n == 0 ? this.first_piece_length : (n == this.num_pieces - 1 ? this.last_piece_length : this.piece_size);
            n5 = n7 - n2;
            if (n5 <= 0) {
                throw new FMFileManagerException("Attempt to " + string + " piece " + n + ", offset " + n2 + " - no space in piece");
            }
            n4 = n5;
            nArray = new int[directByteBufferArray.length];
            for (int i = 0; i < directByteBufferArray.length; ++i) {
                DirectByteBuffer directByteBuffer = directByteBufferArray[i];
                nArray[i] = directByteBuffer.limit((byte)4);
                n6 = directByteBuffer.remaining((byte)4);
                if (n6 > n4) {
                    directByteBuffer.limit((byte)4, directByteBuffer.position((byte)4) + n4);
                    n4 = 0;
                    continue;
                }
                n4 -= n6;
            }
            l = this.getPieceOffset(randomAccessFile, n, !bl);
            if (l != -1L) break block12;
            n6 = 0;
            Object var17_16 = null;
            for (int i = 0; i < directByteBufferArray.length; ++i) {
                directByteBufferArray[i].limit((byte)4, nArray[i]);
            }
            return n6;
        }
        try {
            long l2 = l + (long)n2;
            if (bl) {
                this.delegate.read(randomAccessFile, directByteBufferArray, l2);
            } else {
                this.delegate.write(randomAccessFile, directByteBufferArray, l2);
            }
            n3 = n5 - n4;
            Object var17_17 = null;
        }
        catch (Throwable throwable) {
            Object var17_18 = null;
            for (int i = 0; i < directByteBufferArray.length; ++i) {
                directByteBufferArray[i].limit((byte)4, nArray[i]);
            }
            throw throwable;
        }
        for (int i = 0; i < directByteBufferArray.length; ++i) {
            directByteBufferArray[i].limit((byte)4, nArray[i]);
        }
        return n3;
    }

    protected void readWrite(RandomAccessFile randomAccessFile, DirectByteBuffer[] directByteBufferArray, long l, boolean bl) throws FMFileManagerException {
        long l2 = 0L;
        for (DirectByteBuffer directByteBuffer : directByteBufferArray) {
            l2 += (long)directByteBuffer.remaining((byte)4);
        }
        if (!bl && l + l2 > this.current_length) {
            this.current_length = l + l2;
            this.setDirty();
        }
        long l3 = l;
        while (l2 > 0L) {
            int n;
            int n2;
            if (l3 < (long)this.first_piece_length) {
                n2 = 0;
                n = (int)l3;
            } else {
                long l4 = l3 - (long)this.first_piece_length;
                n2 = (int)(l4 / (long)this.piece_size) + 1;
                n = (int)(l4 % (long)this.piece_size);
            }
            int n3 = this.readWritePiece(randomAccessFile, directByteBufferArray, n2, n, bl);
            if (n3 == 0) {
                if (bl) {
                    for (DirectByteBuffer directByteBuffer : directByteBufferArray) {
                        ByteBuffer byteBuffer = directByteBuffer.getBuffer((byte)4);
                        int n4 = byteBuffer.remaining();
                        byteBuffer.put(new byte[n4]);
                    }
                } else {
                    throw new FMFileManagerException("partial write operation");
                }
                return;
            }
            l2 -= (long)n3;
            l3 += (long)n3;
        }
    }

    public void read(RandomAccessFile randomAccessFile, DirectByteBuffer[] directByteBufferArray, long l) throws FMFileManagerException {
        if (this.num_pieces >= 3) {
            this.readWrite(randomAccessFile, directByteBufferArray, l, true);
        } else {
            this.delegate.read(randomAccessFile, directByteBufferArray, l);
        }
    }

    public void write(RandomAccessFile randomAccessFile, DirectByteBuffer[] directByteBufferArray, long l) throws FMFileManagerException {
        if (this.num_pieces >= 3) {
            this.readWrite(randomAccessFile, directByteBufferArray, l, false);
        } else {
            this.delegate.write(randomAccessFile, directByteBufferArray, l);
        }
    }

    public void flush() throws FMFileManagerException {
        if (this.num_pieces >= 3) {
            if (this.dirt_state != 0) {
                this.writeConfig();
            }
        } else {
            this.delegate.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPieceComplete(RandomAccessFile randomAccessFile, int n, DirectByteBuffer directByteBuffer) throws FMFileManagerException {
        if (this.num_pieces >= 3) {
            if ((n -= this.first_piece_number) >= this.next_piece_index) {
                return;
            }
            int n2 = this.getPieceIndex(randomAccessFile, n, false);
            if (n2 == -1) {
                throw new FMFileManagerException("piece marked as complete but not yet allocated");
            }
            if (n == n2) {
                return;
            }
            int n3 = this.piece_reverse_map[n];
            if (n3 < 1) {
                throw new FMFileManagerException("Inconsistent: failed to find piece to swap");
            }
            DirectByteBuffer directByteBuffer2 = DirectByteBufferPool.getBuffer((byte)4, this.piece_size);
            DirectByteBuffer[] directByteBufferArray = new DirectByteBuffer[]{directByteBuffer2};
            try {
                long l = this.first_piece_length + (n2 - 1) * this.piece_size;
                long l2 = this.first_piece_length + (n - 1) * this.piece_size;
                this.delegate.read(randomAccessFile, directByteBufferArray, l2);
                directByteBuffer.position((byte)4, 0);
                this.delegate.write(randomAccessFile, new DirectByteBuffer[]{directByteBuffer}, l2);
                directByteBuffer2.position((byte)4, 0);
                this.delegate.write(randomAccessFile, directByteBufferArray, l);
                this.piece_map[n] = n;
                this.piece_reverse_map[n] = n;
                this.piece_map[n3] = n2;
                this.piece_reverse_map[n2] = n3;
                this.setDirty();
                if (n == this.num_pieces - 1) {
                    long l3 = l2 + (long)this.last_piece_length;
                    if (this.delegate.getLength(randomAccessFile) > l3) {
                        this.delegate.setLength(randomAccessFile, l3);
                    }
                }
                Object var15_11 = null;
                directByteBuffer2.returnToPool();
            }
            catch (Throwable throwable) {
                Object var15_12 = null;
                directByteBuffer2.returnToPool();
                throw throwable;
            }
        } else {
            this.delegate.setPieceComplete(randomAccessFile, n, directByteBuffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getPieceIndex(RandomAccessFile randomAccessFile, int n, boolean bl) throws FMFileManagerException {
        int n2 = this.piece_map[n];
        if (n2 == -1 && bl) {
            int n3;
            this.piece_map[n] = n2 = this.next_piece_index++;
            this.piece_reverse_map[n2] = n;
            if (n != n2 && (n3 = this.piece_map[n2]) > 0) {
                DirectByteBuffer directByteBuffer = DirectByteBufferPool.getBuffer((byte)4, this.piece_size);
                DirectByteBuffer[] directByteBufferArray = new DirectByteBuffer[]{directByteBuffer};
                try {
                    long l = this.first_piece_length + (n2 - 1) * this.piece_size;
                    long l2 = this.first_piece_length + (n3 - 1) * this.piece_size;
                    this.delegate.read(randomAccessFile, directByteBufferArray, l2);
                    directByteBuffer.position((byte)4, 0);
                    this.delegate.write(randomAccessFile, directByteBufferArray, l);
                    this.piece_map[n2] = n2;
                    this.piece_reverse_map[n2] = n2;
                    this.piece_map[n] = n3;
                    this.piece_reverse_map[n3] = n;
                    if (n2 == this.num_pieces - 1) {
                        long l3 = l + (long)this.last_piece_length;
                        if (this.delegate.getLength(randomAccessFile) > l3) {
                            this.delegate.setLength(randomAccessFile, l3);
                        }
                    }
                    n2 = n3;
                    Object var15_11 = null;
                    directByteBuffer.returnToPool();
                }
                catch (Throwable throwable) {
                    Object var15_12 = null;
                    directByteBuffer.returnToPool();
                    throw throwable;
                }
            }
            this.setDirty();
        }
        return n2;
    }

    protected void readConfig() throws FMFileManagerException {
        this.piece_map = new int[this.num_pieces];
        this.piece_reverse_map = new int[this.num_pieces];
        if (this.dirt_state == 2) {
            Arrays.fill(this.piece_map, -1);
            this.piece_map[0] = 0;
            this.piece_reverse_map[0] = 0;
            this.next_piece_index = 1;
            this.current_length = 0L;
        } else {
            Map map = FileUtil.readResilientFile(this.control_dir, this.control_file, false);
            Long l = (Long)map.get("len");
            Long l2 = (Long)map.get("next");
            byte[] byArray = (byte[])map.get("pieces");
            if (l == null || l2 == null || byArray == null) {
                throw new FMFileManagerException("Failed to read control file " + new File(this.control_dir, this.control_file).getAbsolutePath() + ": map invalid - " + map);
            }
            this.current_length = l;
            this.next_piece_index = l2.intValue();
            if (byArray.length != this.num_pieces * 4) {
                throw new FMFileManagerException("Failed to read control file " + new File(this.control_dir, this.control_file).getAbsolutePath() + ": piece bytes invalid");
            }
            int n = 0;
            for (int i = 0; i < this.num_pieces; ++i) {
                int n2;
                this.piece_map[i] = n2 = (byArray[n++] << 24) + ((byArray[n++] & 0xFF) << 16) + ((byArray[n++] & 0xFF) << 8) + (byArray[n++] & 0xFF);
                if (n2 == -1) continue;
                this.piece_reverse_map[n2] = i;
            }
        }
    }

    protected void setDirty() throws FMFileManagerException {
        if (this.dirt_state == 2) {
            Debug.out("shouldn't get here");
            this.writeConfig();
        } else {
            long l = SystemTime.getMonotonousTime();
            if (this.dirt_state == 0) {
                this.dirt_state = 1;
                this.dirt_time = l;
            } else if (this.dirt_time >= 0L && l - this.dirt_time >= 30000L) {
                this.writeConfig();
            }
        }
    }

    protected void writeConfig() throws FMFileManagerException {
        if (this.piece_map == null) {
            this.readConfig();
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("len", new Long(this.current_length));
        hashMap.put("next", new Long(this.next_piece_index));
        byte[] byArray = new byte[this.piece_map.length * 4];
        int n = 0;
        for (int i = 0; i < this.piece_map.length; ++i) {
            int n2 = this.piece_map[i];
            if (n2 == -1) {
                int n3 = n++;
                int n4 = n++;
                int n5 = n++;
                byArray[n++] = -1;
                byArray[n5] = -1;
                byArray[n4] = -1;
                byArray[n3] = -1;
                continue;
            }
            byArray[n++] = (byte)(n2 >> 24);
            byArray[n++] = (byte)(n2 >> 16);
            byArray[n++] = (byte)(n2 >> 8);
            byArray[n++] = (byte)n2;
        }
        hashMap.put("pieces", byArray);
        if (!this.control_dir.exists()) {
            this.control_dir.mkdirs();
        }
        if (!FileUtil.writeResilientFileWithResult(this.control_dir, this.control_file, hashMap)) {
            throw new FMFileManagerException("Failed to write control file " + new File(this.control_dir, this.control_file).getAbsolutePath());
        }
        this.dirt_state = 0;
        this.dirt_time = -1L;
    }

    public String getString() {
        return "reorderer";
    }
}

