/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.diskmanager.file.impl;

import com.aelitis.azureus.core.diskmanager.file.FMFile;
import com.aelitis.azureus.core.diskmanager.file.FMFileManager;
import com.aelitis.azureus.core.diskmanager.file.FMFileManagerException;
import com.aelitis.azureus.core.diskmanager.file.FMFileOwner;
import com.aelitis.azureus.core.diskmanager.file.impl.FMFileImpl;
import com.aelitis.azureus.core.diskmanager.file.impl.FMFileLimited;
import com.aelitis.azureus.core.diskmanager.file.impl.FMFileUnlimited;
import com.aelitis.azureus.core.util.CaseSensitiveFileMap;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.IndentWriter;

public class FMFileManagerImpl
implements FMFileManager {
    public static final boolean DEBUG = false;
    protected static FMFileManagerImpl singleton;
    protected static AEMonitor class_mon;
    protected LinkedHashMap map;
    protected AEMonitor map_mon = new AEMonitor("FMFileManager:Map");
    protected HashMap links = new HashMap();
    protected AEMonitor links_mon = new AEMonitor("FMFileManager:Links");
    protected boolean limited;
    protected int limit_size;
    protected AESemaphore close_queue_sem;
    protected List close_queue;
    protected AEMonitor close_queue_mon = new AEMonitor("FMFileManager:CQ");
    protected List files;
    protected AEMonitor files_mon = new AEMonitor("FMFileManager:File");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FMFileManager getSingleton() {
        try {
            class_mon.enter();
            if (singleton == null) {
                singleton = new FMFileManagerImpl();
            }
            FMFileManagerImpl fMFileManagerImpl = singleton;
            Object var2_1 = null;
            class_mon.exit();
            return fMFileManagerImpl;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            class_mon.exit();
            throw throwable;
        }
    }

    protected FMFileManagerImpl() {
        this.limit_size = COConfigurationManager.getIntParameter("File Max Open");
        this.limited = this.limit_size > 0;
        this.map = new LinkedHashMap(this.limit_size, 0.75f, true);
        if (this.limited) {
            this.close_queue_sem = new AESemaphore("FMFileManager::closeqsem");
            this.close_queue = new LinkedList();
            AEThread aEThread = new AEThread("FMFileManager::closeQueueDispatcher"){

                public void runSupport() {
                    FMFileManagerImpl.this.closeQueueDispatch();
                }
            };
            aEThread.setDaemon(true);
            aEThread.start();
        }
    }

    protected CaseSensitiveFileMap getLinksEntry(TOTorrent tOTorrent) {
        Object object;
        try {
            object = tOTorrent.getHashWrapper();
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
            object = "";
        }
        CaseSensitiveFileMap caseSensitiveFileMap = (CaseSensitiveFileMap)this.links.get(object);
        if (caseSensitiveFileMap == null) {
            caseSensitiveFileMap = new CaseSensitiveFileMap();
            this.links.put(object, caseSensitiveFileMap);
        }
        return caseSensitiveFileMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFileLinks(TOTorrent tOTorrent, CaseSensitiveFileMap caseSensitiveFileMap) {
        try {
            this.links_mon.enter();
            CaseSensitiveFileMap caseSensitiveFileMap2 = this.getLinksEntry(tOTorrent);
            Iterator iterator = caseSensitiveFileMap.keySetIterator();
            while (iterator.hasNext()) {
                File file = (File)iterator.next();
                File file2 = caseSensitiveFileMap.get(file);
                if (file2 != null && !file.equals(file2)) {
                    caseSensitiveFileMap2.put(file, file2);
                    continue;
                }
                caseSensitiveFileMap2.remove(file);
            }
            Object var8_7 = null;
            this.links_mon.exit();
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.links_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getFileLink(TOTorrent tOTorrent, File file) {
        try {
            this.links_mon.enter();
            CaseSensitiveFileMap caseSensitiveFileMap = this.getLinksEntry(tOTorrent);
            File file2 = caseSensitiveFileMap.get(file);
            if (file2 == null) {
                file2 = file;
            }
            File file3 = file2;
            Object var7_6 = null;
            this.links_mon.exit();
            return file3;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.links_mon.exit();
            throw throwable;
        }
    }

    public FMFile createFile(FMFileOwner fMFileOwner, File file, int n) throws FMFileManagerException {
        FMFileImpl fMFileImpl = this.limited ? new FMFileLimited(fMFileOwner, this, file, n) : new FMFileUnlimited(fMFileOwner, this, file, n);
        return fMFileImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getSlot(FMFileLimited fMFileLimited) {
        FMFileLimited fMFileLimited2 = null;
        try {
            this.map_mon.enter();
            if (this.map.size() >= this.limit_size) {
                Iterator iterator = this.map.keySet().iterator();
                fMFileLimited2 = (FMFileLimited)iterator.next();
                iterator.remove();
            }
            this.map.put(fMFileLimited, fMFileLimited);
            Object var5_4 = null;
            this.map_mon.exit();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.map_mon.exit();
            throw throwable;
        }
        if (fMFileLimited2 != null) {
            this.closeFile(fMFileLimited2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseSlot(FMFileLimited fMFileLimited) {
        try {
            this.map_mon.enter();
            this.map.remove(fMFileLimited);
            Object var3_2 = null;
            this.map_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.map_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void usedSlot(FMFileLimited fMFileLimited) {
        try {
            this.map_mon.enter();
            if (this.map.containsKey(fMFileLimited)) {
                this.map.put(fMFileLimited, fMFileLimited);
            }
            Object var3_2 = null;
            this.map_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.map_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeFile(FMFileLimited fMFileLimited) {
        try {
            this.close_queue_mon.enter();
            this.close_queue.add(fMFileLimited);
            Object var3_2 = null;
            this.close_queue_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.close_queue_mon.exit();
            throw throwable;
        }
        this.close_queue_sem.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeQueueDispatch() {
        while (true) {
            Object var3_4;
            this.close_queue_sem.reserve();
            FMFileLimited fMFileLimited = null;
            try {
                this.close_queue_mon.enter();
                if (this.close_queue.size() > 0) {
                    fMFileLimited = (FMFileLimited)this.close_queue.remove(0);
                }
                var3_4 = null;
                this.close_queue_mon.exit();
            }
            catch (Throwable throwable) {
                var3_4 = null;
                this.close_queue_mon.exit();
                throw throwable;
            }
            if (fMFileLimited == null) continue;
            try {
                fMFileLimited.close(false);
                continue;
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generate(IndentWriter indentWriter) {
        indentWriter.println("FMFileManager slots");
        try {
            indentWriter.indent();
            try {
                this.map_mon.enter();
                for (FMFileLimited fMFileLimited : this.map.keySet()) {
                    indentWriter.println(fMFileLimited.getString());
                }
                Object var5_4 = null;
                this.map_mon.exit();
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.map_mon.exit();
                throw throwable;
            }
            Object var7_7 = null;
            indentWriter.exdent();
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            indentWriter.exdent();
            throw throwable;
        }
    }

    protected static void generateEvidence(IndentWriter indentWriter) {
        FMFileManagerImpl.getSingleton();
        singleton.generate(indentWriter);
    }

    static {
        class_mon = new AEMonitor("FMFileManager:class");
    }
}

