/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.diskmanager.test;

import com.aelitis.azureus.core.diskmanager.MemoryMappedFile;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.DirectByteBufferPool;
import org.gudy.azureus2.core3.util.RandomUtils;

public class MemoryMappedFileTester {
    static long MAX_SIZE = 0x40000000L;
    static int BUFF_SIZE = 0x500000;
    static DirectByteBuffer dbb = DirectByteBufferPool.getBuffer((byte)2, BUFF_SIZE);
    static byte[] raw = new byte[BUFF_SIZE];

    public static void main(String[] stringArray) {
        try {
            File file = new File("e:\\fraf.bin");
            File file2 = new File("e:\\fchan.bin");
            File file3 = new File("e:\\fmapd.bin");
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
            FileChannel fileChannel = new RandomAccessFile(file2, "rw").getChannel();
            MemoryMappedFile memoryMappedFile = new MemoryMappedFile(file3);
            memoryMappedFile.setAccessMode(1);
            long l = 0L;
            long l2 = 0L;
            long l3 = 0L;
            long l4 = 0L;
            int n = 1;
            while (l < MAX_SIZE) {
                System.out.print("|");
                if (n % 80 == 0) {
                    System.out.println();
                }
                MemoryMappedFileTester.refreshBuffers();
                long l5 = new Float(RandomUtils.nextFloat() * (float)(MAX_SIZE - (long)BUFF_SIZE)).longValue();
                long l6 = System.currentTimeMillis();
                l2 += System.currentTimeMillis() - l6;
                l6 = System.currentTimeMillis();
                l3 += System.currentTimeMillis() - l6;
                l6 = System.currentTimeMillis();
                memoryMappedFile.write(dbb, 0, l5, dbb.limit((byte)2));
                l4 += System.currentTimeMillis() - l6;
                l += (long)raw.length;
                ++n;
            }
            System.out.println();
            System.out.println("RandomAccessFile = " + l2);
            System.out.println("FileChannel = " + l3);
            System.out.println("MemoryMappedFile = " + l4);
            System.out.println("Cache H: " + MemoryMappedFile.cache_hits + " M: " + MemoryMappedFile.cache_misses);
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
        }
    }

    private static void refreshBuffers() {
        RandomUtils.nextBytes(raw);
        dbb.clear((byte)2);
        dbb.put((byte)2, raw);
        dbb.flip((byte)2);
    }
}

