/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.download;

import com.aelitis.azureus.core.download.DownloadManagerEnhancer;
import com.aelitis.azureus.core.download.EnhancedDownloadManagerFile;
import com.aelitis.azureus.core.peer.cache.CacheDiscovery;
import com.aelitis.azureus.core.peer.cache.CachePeer;
import com.aelitis.azureus.core.peermanager.piecepicker.PiecePicker;
import com.aelitis.azureus.core.peermanager.piecepicker.PieceRTAProvider;
import com.aelitis.azureus.core.peermanager.utils.PeerClassifier;
import com.aelitis.azureus.core.torrent.PlatformTorrentUtils;
import com.aelitis.azureus.core.util.average.Average;
import com.aelitis.azureus.core.util.average.AverageFactory;
import com.aelitis.azureus.plugins.extseed.ExternalSeedException;
import com.aelitis.azureus.plugins.extseed.ExternalSeedManualPeer;
import com.aelitis.azureus.plugins.extseed.ExternalSeedPlugin;
import com.aelitis.azureus.util.ConstantsVuze;
import com.aelitis.azureus.util.DownloadUtils;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.config.impl.TransferSpeedValidator;
import org.gudy.azureus2.core3.disk.DiskManager;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.disk.DiskManagerPiece;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerListener;
import org.gudy.azureus2.core3.download.DownloadManagerPeerListener;
import org.gudy.azureus2.core3.download.impl.DownloadManagerAdapter;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.peer.PEPeerManagerStats;
import org.gudy.azureus2.core3.peer.PEPeerStats;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsLogger;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.core3.util.RealTimeInfo;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;
import org.gudy.azureus2.pluginsimpl.local.utils.PooledByteBufferImpl;

public class EnhancedDownloadManager {
    public static int DEFAULT_MINIMUM_INITIAL_BUFFER_SECS_FOR_ETA = 30;
    public static int WMP_MINIMUM_INITIAL_BUFFER_SECS_FOR_ETA = 60;
    public static int MINIMUM_INITIAL_BUFFER_SECS;
    public static final int SPEED_CONTROL_INITIAL_DELAY = 10000;
    public static final int SPEED_INCREASE_GRACE_PERIOD = 3000;
    public static final int PEER_INJECT_GRACE_PERIOD = 3000;
    public static final int IDLE_PEER_DISCONNECT_PERIOD = 60000;
    public static final int IDLE_SEED_DISCONNECT_PERIOD = 60000;
    public static final int MIN_SEED_CONNECTION_TIME = 60000;
    public static final int IDLE_SEED_DISCONNECT_SECS = 60;
    public static final int CACHE_RECONNECT_MIN_PERIOD = 900000;
    public static final int CACHE_REQUERY_MIN_PERIOD = 3600000;
    public static final int TARGET_SPEED_EXCESS_MARGIN = 2048;
    public static final int DISCONNECT_CHECK_PERIOD = 10000;
    public static final int DISCONNECT_CHECK_TICKS = 10;
    public static final int REACTIVATE_PROVIDER_PERIOD = 5000;
    public static final int REACTIVATE_PROVIDER_PERIOD_TICKS = 5;
    public static final int LOG_PROG_STATS_PERIOD = 10000;
    public static final int LOG_PROG_STATS_TICKS = 10;
    private static final String TRACKER_PROG_PREFIX = "azprog";
    private static final String PM_SEED_TIME_KEY = "EnhancedDownloadManager:seedtime";
    private static final String PEER_CACHE_KEY = "EnhancedDownloadManager:cachepeer";
    private static int internal_content_stream_bps_increase_ratio;
    private static int internal_content_stream_bps_increase_absolute;
    private DownloadManagerEnhancer enhancer;
    private DownloadManager download_manager;
    private boolean platform_content;
    private transient PiecePicker current_piece_pickler;
    private boolean progressive_active = false;
    private long content_min_delivery_bps;
    private int minimum_initial_buffer_secs_for_eta;
    private int explicit_minimum_buffer_bytes;
    private bufferETAProvider buffer_provider = new bufferETAProvider();
    private boostETAProvider boost_provider = new boostETAProvider();
    private progressiveStats progressive_stats;
    private boolean progressive_informed = false;
    private long time_download_started;
    private Average download_speed_average = AverageFactory.MovingImmediateAverage(5);
    private boolean marked_active;
    private boolean destroyed;
    private DownloadManagerListener dmListener;
    private static final int STALLED_TIMEOUT = 120000;
    private boolean publish_handling_complete;
    private long publish_sent = -1L;
    private long publish_sent_time;
    private EnhancedDownloadManagerFile[] enhanced_files;
    private EnhancedDownloadManagerFile primary_file;
    private long last_speed_increase;
    private long last_peer_inject;
    private long last_lookup_time;
    private LinkedList new_peers;
    private List cache_peers;
    private List disconnected_cache_peers;
    private CachePeer[] lookup_peers;

    public static void setInternalContentStreamBPSIncreaseRatio(String string, int n) {
        internal_content_stream_bps_increase_ratio = n;
    }

    public static void setInternalContentStreamBPSIncreaseAbsolute(String string, int n) {
        internal_content_stream_bps_increase_absolute = n;
    }

    private void resetVars() {
        this.last_speed_increase = 0L;
        this.last_peer_inject = 0L;
        this.last_lookup_time = 0L;
        this.new_peers = null;
        this.cache_peers = null;
        this.disconnected_cache_peers = null;
        this.lookup_peers = null;
    }

    protected EnhancedDownloadManager(DownloadManagerEnhancer downloadManagerEnhancer, DownloadManager downloadManager) {
        Object object;
        this.enhancer = downloadManagerEnhancer;
        this.download_manager = downloadManager;
        DiskManagerFileInfo[] diskManagerFileInfoArray = this.download_manager.getDiskManagerFileInfo();
        boolean bl = false;
        for (int i = 0; i < diskManagerFileInfoArray.length; ++i) {
            object = diskManagerFileInfoArray[i].getFile(true).getName().toLowerCase();
            if (!((String)object).endsWith(".wmv")) continue;
            bl = true;
            break;
        }
        this.minimum_initial_buffer_secs_for_eta = bl ? WMP_MINIMUM_INITIAL_BUFFER_SECS_FOR_ETA : DEFAULT_MINIMUM_INITIAL_BUFFER_SECS_FOR_ETA;
        TOTorrent tOTorrent = this.download_manager.getTorrent();
        if (tOTorrent != null) {
            int n;
            this.content_min_delivery_bps = PlatformTorrentUtils.getContentMinimumSpeedBps(tOTorrent);
            this.platform_content = PlatformTorrentUtils.isContent(tOTorrent, true);
            this.enhanced_files = new EnhancedDownloadManagerFile[diskManagerFileInfoArray.length];
            object = PlatformTorrentUtils.getFileMetaData(tOTorrent);
            Object var7_8 = object == null ? null : object.get("files");
            Map map = var7_8 instanceof Map ? (Map)var7_8 : null;
            long l = 0L;
            for (n = 0; n < diskManagerFileInfoArray.length; ++n) {
                DiskManagerFileInfo diskManagerFileInfo = diskManagerFileInfoArray[n];
                Map map2 = map == null ? null : (Map)map.get("" + n);
                this.enhanced_files[n] = new EnhancedDownloadManagerFile(diskManagerFileInfo, l, map2);
                l += diskManagerFileInfo.getLength();
            }
            n = PlatformTorrentUtils.getContentPrimaryFileIndex(this.download_manager.getTorrent());
            this.primary_file = n >= 0 && n < diskManagerFileInfoArray.length ? this.enhanced_files[n] : this.enhanced_files[0];
        } else {
            this.enhanced_files = new EnhancedDownloadManagerFile[0];
        }
        this.progressive_stats = this.createProgressiveStats(this.download_manager, this.primary_file);
        this.download_manager.addPeerListener(new DownloadManagerPeerListener(){

            public void peerManagerWillBeAdded(PEPeerManager pEPeerManager) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void peerManagerAdded(PEPeerManager pEPeerManager) {
                EnhancedDownloadManager enhancedDownloadManager = EnhancedDownloadManager.this;
                synchronized (enhancedDownloadManager) {
                    EnhancedDownloadManager.this.time_download_started = SystemTime.getCurrentTime();
                    EnhancedDownloadManager.this.current_piece_pickler = pEPeerManager.getPiecePicker();
                    if (EnhancedDownloadManager.this.progressive_active && EnhancedDownloadManager.this.current_piece_pickler != null) {
                        EnhancedDownloadManager.this.buffer_provider.activate(EnhancedDownloadManager.this.current_piece_pickler);
                        EnhancedDownloadManager.this.boost_provider.activate(EnhancedDownloadManager.this.current_piece_pickler);
                    }
                    EnhancedDownloadManager.this.resetVars();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void peerManagerRemoved(PEPeerManager pEPeerManager) {
                EnhancedDownloadManager enhancedDownloadManager = EnhancedDownloadManager.this;
                synchronized (enhancedDownloadManager) {
                    EnhancedDownloadManager.this.time_download_started = 0L;
                    EnhancedDownloadManager.this.progressive_active = false;
                    if (EnhancedDownloadManager.this.current_piece_pickler != null) {
                        EnhancedDownloadManager.this.buffer_provider.deactivate(EnhancedDownloadManager.this.current_piece_pickler);
                        EnhancedDownloadManager.this.boost_provider.deactivate(EnhancedDownloadManager.this.current_piece_pickler);
                        EnhancedDownloadManager.this.current_piece_pickler = null;
                    }
                    EnhancedDownloadManager.this.resetVars();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void peerAdded(PEPeer pEPeer) {
                if (EnhancedDownloadManager.this.platform_content) {
                    EnhancedDownloadManager enhancedDownloadManager = EnhancedDownloadManager.this;
                    synchronized (enhancedDownloadManager) {
                        if (EnhancedDownloadManager.this.new_peers == null) {
                            EnhancedDownloadManager.this.new_peers = new LinkedList();
                        }
                        EnhancedDownloadManager.this.new_peers.add(pEPeer);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void peerRemoved(PEPeer pEPeer) {
                if (EnhancedDownloadManager.this.platform_content) {
                    EnhancedDownloadManager enhancedDownloadManager = EnhancedDownloadManager.this;
                    synchronized (enhancedDownloadManager) {
                        CachePeer cachePeer;
                        if (EnhancedDownloadManager.this.new_peers != null) {
                            EnhancedDownloadManager.this.new_peers.remove(pEPeer);
                            if (EnhancedDownloadManager.this.new_peers.size() == 0) {
                                EnhancedDownloadManager.this.new_peers = null;
                            }
                        }
                        if (EnhancedDownloadManager.this.cache_peers != null) {
                            EnhancedDownloadManager.this.cache_peers.remove(pEPeer);
                            if (EnhancedDownloadManager.this.cache_peers.size() == 0) {
                                EnhancedDownloadManager.this.cache_peers = null;
                            }
                        }
                        if ((cachePeer = (CachePeer)pEPeer.getData(EnhancedDownloadManager.PEER_CACHE_KEY)) == null && EnhancedDownloadManager.this.lookup_peers != null) {
                            for (int i = 0; i < EnhancedDownloadManager.this.lookup_peers.length; ++i) {
                                CachePeer cachePeer2 = EnhancedDownloadManager.this.lookup_peers[i];
                                if (!cachePeer2.getAddress().getHostAddress().equals(pEPeer.getIp()) || cachePeer2.getPort() != pEPeer.getPort()) continue;
                                cachePeer = cachePeer2;
                            }
                        }
                        if (!(cachePeer == null || cachePeer.getType() != 2 || EnhancedDownloadManager.this.disconnected_cache_peers != null && EnhancedDownloadManager.this.disconnected_cache_peers.contains(cachePeer) || pEPeer.hasReceivedBitField())) {
                            cachePeer.setAutoReconnect(false);
                        }
                    }
                }
            }
        });
    }

    public String getName() {
        return this.download_manager.getDisplayName();
    }

    public byte[] getHash() {
        TOTorrent tOTorrent = this.download_manager.getTorrent();
        if (tOTorrent == null) {
            return null;
        }
        try {
            return tOTorrent.getHash();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public boolean isPlatform() {
        TOTorrent tOTorrent = this.download_manager.getTorrent();
        if (tOTorrent != null) {
            return PlatformTorrentUtils.isContent(tOTorrent, true);
        }
        return false;
    }

    public EnhancedDownloadManagerFile[] getFiles() {
        return this.enhanced_files;
    }

    public void setMinimumBufferBytes(int n) {
        this.log("Explicit min buffer set to " + n);
        this.explicit_minimum_buffer_bytes = n;
    }

    protected void refreshMetaData() {
        this.progressive_stats.refreshMetaData();
    }

    protected long getTimeRunning() {
        if (this.time_download_started == 0L) {
            return 0L;
        }
        long l = SystemTime.getCurrentTime();
        if (l < this.time_download_started) {
            this.time_download_started = l;
        }
        return l - this.time_download_started;
    }

    protected long getTargetSpeed() {
        long l;
        long l2 = l = this.progressive_active ? this.progressive_stats.getStreamBytesPerSecondMax() : this.content_min_delivery_bps;
        if (l < this.content_min_delivery_bps) {
            l = this.content_min_delivery_bps;
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateStats(int n) {
        long l;
        CachePeer cachePeer;
        Serializable serializable;
        this.updateProgressiveStats(n);
        if (!this.platform_content) {
            return;
        }
        int n2 = this.download_manager.getState();
        if (n2 != 60 && n2 != 50) {
            return;
        }
        PEPeerManager pEPeerManager = this.download_manager.getPeerManager();
        if (pEPeerManager == null) {
            return;
        }
        long l2 = SystemTime.getCurrentTime();
        long l3 = this.getTargetSpeed();
        PEPeerManagerStats pEPeerManagerStats = pEPeerManager.getStats();
        long l4 = pEPeerManagerStats.getDataReceiveRate();
        this.download_speed_average.update(l4);
        long l5 = this.getTimeRunning();
        int n3 = pEPeerManager.getStats().getTimeSinceLastDataSentInSeconds();
        if (n3 == -1) {
            serializable = (Long)pEPeerManager.getData(PM_SEED_TIME_KEY);
            if (serializable == null) {
                serializable = new Long(l2);
                pEPeerManager.setData(PM_SEED_TIME_KEY, serializable);
            }
            n3 = (int)((l2 - (Long)serializable) / 1000L);
        }
        serializable = new ArrayList();
        EnhancedDownloadManager enhancedDownloadManager = this;
        synchronized (enhancedDownloadManager) {
            if (this.new_peers != null) {
                Iterator iterator = this.new_peers.iterator();
                while (iterator.hasNext()) {
                    PEPeer pEPeer = (PEPeer)iterator.next();
                    cachePeer = (CachePeer)pEPeer.getData(PEER_CACHE_KEY);
                    if (cachePeer == null) {
                        byte[] byArray = pEPeer.getId();
                        if (byArray == null) continue;
                        try {
                            cachePeer = CacheDiscovery.categorisePeer(byArray, InetAddress.getByName(pEPeer.getIp()), pEPeer.getPort());
                            pEPeer.setData(PEER_CACHE_KEY, cachePeer);
                            if (cachePeer.getType() == 2) {
                                if (n2 == 60) {
                                    if (l2 - cachePeer.getCreateTime(l2) >= 60000L && n3 >= 60) {
                                        serializable.add(pEPeer);
                                        this.addToDisconnectedCachePeers(cachePeer);
                                    } else {
                                        if (this.cache_peers == null) {
                                            this.cache_peers = new LinkedList();
                                        }
                                        this.cache_peers.add(pEPeer);
                                    }
                                } else {
                                    pEPeer.setHaveAggregationEnabled(false);
                                    if (l3 <= 0L) {
                                        this.setPeerSpeed(pEPeer, -1, l2);
                                        serializable.add(pEPeer);
                                        this.addToDisconnectedCachePeers(cachePeer);
                                    } else {
                                        l = (long)this.download_speed_average.getAverage();
                                        if (l + 2048L > l3) {
                                            this.setPeerSpeed(pEPeer, -1, l2);
                                        }
                                        if (this.cache_peers == null) {
                                            this.cache_peers = new LinkedList();
                                        }
                                        this.cache_peers.add(pEPeer);
                                    }
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            Debug.printStackTrace(throwable);
                        }
                        iterator.remove();
                        continue;
                    }
                    iterator.remove();
                }
                if (this.new_peers.size() == 0) {
                    this.new_peers = null;
                }
            }
        }
        for (int i = 0; i < serializable.size(); ++i) {
            pEPeerManager.removePeer((PEPeer)serializable.get(i), "Cache peer not required");
        }
        if (n2 == 50 && l5 > 10000L) {
            Object object;
            Object object2;
            long l6 = (long)this.download_speed_average.getAverage();
            if (l6 < l3) {
                long l7 = this.getCurrentSpeed();
                long l8 = l3 - l7;
                if (this.last_speed_increase > l2 || l2 - this.last_speed_increase > 3000L) {
                    Object object3;
                    Object object4;
                    object2 = this;
                    synchronized (object2) {
                        if (this.cache_peers != null) {
                            object = this.cache_peers.iterator();
                            while (object.hasNext() && l8 > 0L) {
                                object4 = (PEPeer)object.next();
                                object3 = object4.getStats();
                                long l9 = object3.getDownloadRateLimitBytesPerSecond();
                                if (l9 == 0L || l9 >= l3) continue;
                                this.setPeerSpeed((PEPeer)object4, (int)l3, l2);
                                this.last_speed_increase = l2;
                                l8 = 0L;
                            }
                        }
                    }
                    if (l8 > 0L && this.last_peer_inject > l2 || l2 - this.last_peer_inject > 3000L) {
                        object2 = new HashSet();
                        object = new ArrayList();
                        if (this.cache_peers != null) {
                            object4 = this.cache_peers.iterator();
                            while (object4.hasNext() && l8 > 0L) {
                                object3 = (PEPeer)object4.next();
                                object2.add(object3.getIp() + ":" + object3.getPort());
                            }
                        }
                        if (this.disconnected_cache_peers != null) {
                            while (this.disconnected_cache_peers.size() > 0) {
                                object4 = (CachePeer)this.disconnected_cache_peers.remove(0);
                                if (object2.contains(object4.getAddress().getHostAddress() + ":" + object4.getPort())) continue;
                                if (this.lookup_peers != null) {
                                    for (int i = 0; i < this.lookup_peers.length; ++i) {
                                        CachePeer cachePeer2 = this.lookup_peers[i];
                                        if (!cachePeer2.sameAs((CachePeer)object4)) continue;
                                        object4 = null;
                                        break;
                                    }
                                }
                                if (object4 == null) continue;
                                object.add(object4);
                                break;
                            }
                            if (this.disconnected_cache_peers.size() == 0) {
                                this.disconnected_cache_peers = null;
                            }
                        }
                        if (object.size() == 0) {
                            if (this.lookup_peers == null || l2 < this.last_lookup_time || l2 - this.last_lookup_time > 3600000L) {
                                this.last_lookup_time = l2;
                                this.lookup_peers = CacheDiscovery.lookup(this.download_manager.getTorrent());
                            }
                            for (int i = 0; i < this.lookup_peers.length; ++i) {
                                CachePeer cachePeer3 = this.lookup_peers[i];
                                if (!cachePeer3.getAutoReconnect() || l2 - cachePeer3.getInjectTime(l2) <= 900000L || object2.contains(cachePeer3.getAddress().getHostAddress() + ":" + cachePeer3.getPort())) continue;
                                object.add(cachePeer3);
                            }
                        }
                        if (object.size() > 0) {
                            CachePeer cachePeer4 = (CachePeer)object.get((int)(Math.random() * (double)object.size()));
                            cachePeer4.setInjectTime(l2);
                            pEPeerManager.addPeer(cachePeer4.getAddress().getHostAddress(), cachePeer4.getPort(), 0, false, null);
                            this.last_peer_inject = l2;
                        }
                    }
                }
            } else if (l6 > l3 + 2048L) {
                long l10 = this.getCurrentSpeed();
                long l11 = l10 - (l3 + 2048L);
                object2 = this;
                synchronized (object2) {
                    if (this.cache_peers != null) {
                        object = this.cache_peers.iterator();
                        while (object.hasNext() && l11 > 0L) {
                            PEPeer pEPeer = (PEPeer)object.next();
                            PEPeerStats pEPeerStats = pEPeer.getStats();
                            long l12 = pEPeerStats.getDataReceiveRate();
                            long l13 = pEPeerStats.getDownloadRateLimitBytesPerSecond();
                            if (l13 == -1L) {
                                l11 -= l12;
                                continue;
                            }
                            if (l13 != 0L && l12 > l13) {
                                l11 -= l12 - l13;
                                continue;
                            }
                            if (l12 > l11) {
                                this.setPeerSpeed(pEPeer, (int)(l12 - l11), l2);
                                l11 = 0L;
                                continue;
                            }
                            this.setPeerSpeed(pEPeer, -1, l2);
                            l11 -= l12;
                        }
                    }
                }
            }
        }
        if (n % 10 == 0) {
            serializable.clear();
            EnhancedDownloadManager enhancedDownloadManager2 = this;
            synchronized (enhancedDownloadManager2) {
                if (this.cache_peers != null) {
                    for (PEPeer pEPeer : this.cache_peers) {
                        cachePeer = (CachePeer)pEPeer.getData(PEER_CACHE_KEY);
                        if (n2 == 60) {
                            if (l2 - cachePeer.getCreateTime(l2) < 60000L || n3 < 60) continue;
                            serializable.add(pEPeer);
                            this.addToDisconnectedCachePeers(cachePeer);
                            continue;
                        }
                        PEPeerStats pEPeerStats = pEPeer.getStats();
                        if (pEPeerStats.getDownloadRateLimitBytesPerSecond() != -1 || l2 - (l = cachePeer.getSpeedChangeTime(l2)) <= 60000L) continue;
                        serializable.add(pEPeer);
                        this.addToDisconnectedCachePeers(cachePeer);
                    }
                }
            }
            for (int i = 0; i < serializable.size(); ++i) {
                pEPeerManager.removePeer((PEPeer)serializable.get(i), "Cache peer disconnect-on-idle");
            }
        }
    }

    protected void addToDisconnectedCachePeers(CachePeer cachePeer) {
        if (this.disconnected_cache_peers == null) {
            this.disconnected_cache_peers = new ArrayList();
        }
        for (int i = 0; i < this.disconnected_cache_peers.size(); ++i) {
            CachePeer cachePeer2 = (CachePeer)this.disconnected_cache_peers.get(i);
            if (!cachePeer2.sameAs(cachePeer)) continue;
            return;
        }
        this.disconnected_cache_peers.add(cachePeer);
    }

    protected void setPeerSpeed(PEPeer pEPeer, int n, long l) {
        CachePeer cachePeer = (CachePeer)pEPeer.getData(PEER_CACHE_KEY);
        cachePeer.setSpeedChangeTime(l);
        pEPeer.getStats().setDownloadRateLimitBytesPerSecond(n);
    }

    protected long getCurrentSpeed() {
        PEPeerManager pEPeerManager = this.download_manager.getPeerManager();
        long l = 0L;
        if (pEPeerManager != null) {
            Iterator<PEPeer> iterator = pEPeerManager.getPeers().iterator();
            while (iterator.hasNext()) {
                l += iterator.next().getStats().getDataReceiveRate();
            }
        }
        return l;
    }

    public boolean supportsProgressiveMode() {
        TOTorrent tOTorrent = this.download_manager.getTorrent();
        if (tOTorrent == null) {
            return false;
        }
        return this.enhancer.isProgressiveAvailable() && PlatformTorrentUtils.isContentProgressive(tOTorrent);
    }

    public void setProgressiveMode(boolean bl) {
        this.setProgressiveMode(bl, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setProgressiveMode(boolean bl, boolean bl2) {
        TOTorrent tOTorrent = this.download_manager.getTorrent();
        if (tOTorrent == null) {
            return;
        }
        Object object = this;
        synchronized (object) {
            if (this.progressive_active == bl) {
                return;
            }
            if (bl && !this.supportsProgressiveMode()) {
                Debug.out("Attempt to set progress mode on non-progressible content - " + this.getName());
                return;
            }
            this.log("Progressive mode changed to " + bl);
            final GlobalManager globalManager = this.download_manager.getGlobalManager();
            if (bl) {
                if (this.dmListener == null) {
                    this.dmListener = new DownloadManagerAdapter(){

                        public void downloadComplete(DownloadManager downloadManager) {
                            globalManager.resumeDownloads();
                        }
                    };
                }
                this.download_manager.addListener(this.dmListener);
                Object[] objectArray = globalManager.getDownloadManagers().toArray();
                for (int i = 0; i < objectArray.length; ++i) {
                    EnhancedDownloadManager enhancedDownloadManager;
                    DownloadManager downloadManager = (DownloadManager)objectArray[i];
                    if (downloadManager.equals(this.download_manager) || downloadManager.isDownloadComplete(false)) continue;
                    int n = downloadManager.getState();
                    if (n == 50 || n == 75) {
                        downloadManager.pause();
                    }
                    if ((enhancedDownloadManager = this.enhancer.getEnhancedDownload(downloadManager)) == null || !enhancedDownloadManager.getProgressiveMode()) continue;
                    enhancedDownloadManager.setProgressiveMode(false, true);
                }
                if (this.download_manager.isPaused()) {
                    this.download_manager.resume();
                }
                if (this.download_manager.getState() == 70) {
                    this.download_manager.setStateWaiting();
                }
                if (this.download_manager.getPosition() != 1) {
                    this.download_manager.getGlobalManager().moveTo(this.download_manager, 1);
                }
            } else {
                this.download_manager.removeListener(this.dmListener);
                if (!bl2) {
                    globalManager.resumeDownloads();
                }
            }
            this.progressive_active = bl;
            if (this.current_piece_pickler != null) {
                if (this.progressive_active) {
                    this.buffer_provider.activate(this.current_piece_pickler);
                    this.boost_provider.activate(this.current_piece_pickler);
                    this.progressive_stats.update(0);
                } else {
                    this.buffer_provider.deactivate(this.current_piece_pickler);
                    this.boost_provider.deactivate(this.current_piece_pickler);
                    this.progressive_stats = this.createProgressiveStats(this.download_manager, this.primary_file);
                }
            } else {
                this.progressive_stats = this.createProgressiveStats(this.download_manager, this.primary_file);
            }
            if (!bl2) {
                if (bl) {
                    RealTimeInfo.setProgressiveActive(this.progressive_stats.getStreamBytesPerSecondMax());
                } else {
                    RealTimeInfo.setProgressiveInactive();
                }
            }
        }
        if (bl && !this.progressive_informed) {
            this.progressive_informed = true;
            object = PluginCoreUtils.wrap(this.download_manager);
            DownloadUtils.addTrackerExtension((Download)object, TRACKER_PROG_PREFIX, "y");
            this.download_manager.requestTrackerAnnounce(true);
        }
    }

    public boolean getProgressiveMode() {
        return this.progressive_active;
    }

    public long getProgressivePlayETA() {
        return this.getProgressivePlayETA(false);
    }

    public long getProgressivePlayETA(boolean bl) {
        progressiveStats progressiveStats2 = this.getProgressiveStats();
        long l = progressiveStats2.getETA(bl);
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected progressiveStats getProgressiveStats() {
        EnhancedDownloadManager enhancedDownloadManager = this;
        synchronized (enhancedDownloadManager) {
            return this.progressive_stats.getCopy();
        }
    }

    protected progressiveStats createProgressiveStats(DownloadManager downloadManager, EnhancedDownloadManagerFile enhancedDownloadManagerFile) {
        TOTorrent tOTorrent = this.download_manager.getTorrent();
        if (tOTorrent != null && PlatformTorrentUtils.useEMP(tOTorrent)) {
            return new progressiveStatsInternal(downloadManager, enhancedDownloadManagerFile);
        }
        return new progressiveStatsExternal(downloadManager, enhancedDownloadManagerFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateProgressiveStats(int n) {
        if (!this.progressive_active) {
            return;
        }
        EnhancedDownloadManager enhancedDownloadManager = this;
        synchronized (enhancedDownloadManager) {
            PiecePicker piecePicker;
            if (!this.progressive_active) {
                return;
            }
            if (n % 5 == 0 && (piecePicker = this.current_piece_pickler) != null) {
                this.buffer_provider.checkActivation(piecePicker);
            }
            this.progressive_stats.update(n);
            long l = this.progressive_stats.getStreamBytesPerSecondMax();
            if (RealTimeInfo.getProgressiveActiveBytesPerSec() != l) {
                RealTimeInfo.setProgressiveActive(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setRTA(boolean bl) {
        EnhancedDownloadManager enhancedDownloadManager = this;
        synchronized (enhancedDownloadManager) {
            if (this.marked_active && !bl) {
                this.marked_active = false;
                RealTimeInfo.removeRealTimeTask();
            }
            if (this.destroyed) {
                return;
            }
            if (!this.marked_active && bl) {
                this.marked_active = true;
                RealTimeInfo.addRealTimeTask();
            }
        }
    }

    public DiskManagerFileInfo getPrimaryFile() {
        return this.primary_file.getFile();
    }

    public long getContiguousAvailableBytes(DiskManagerFileInfo diskManagerFileInfo) {
        return this.getContiguousAvailableBytes(diskManagerFileInfo, 0);
    }

    public long getContiguousAvailableBytes(DiskManagerFileInfo diskManagerFileInfo, int n) {
        long l;
        int n2;
        if (diskManagerFileInfo == null) {
            return -1L;
        }
        DiskManager diskManager = this.download_manager.getDiskManager();
        if (diskManager == null) {
            return -1L;
        }
        int n3 = diskManager.getPieceLength();
        DiskManagerFileInfo[] diskManagerFileInfoArray = diskManager.getFiles();
        long l2 = n;
        for (n2 = 0; n2 < diskManagerFileInfoArray.length && diskManagerFileInfoArray[n2].getIndex() != diskManagerFileInfo.getIndex(); ++n2) {
            l2 += diskManagerFileInfoArray[n2].getLength();
        }
        n2 = (int)(l2 / (long)n3);
        int n4 = (int)(l2 % (long)n3);
        int n5 = diskManagerFileInfo.getLastPieceNumber();
        DiskManagerPiece[] diskManagerPieceArray = diskManager.getPieces();
        DiskManagerPiece diskManagerPiece = diskManagerPieceArray[n2];
        long l3 = 0L;
        if (!diskManagerPiece.isDone()) {
            boolean[] blArray = diskManagerPiece.getWritten();
            if (blArray == null) {
                if (diskManagerPiece.isDone()) {
                    l3 = diskManagerPiece.getLength() - n4;
                }
            } else {
                int n6 = 0;
                for (int i = 0; i < blArray.length && blArray[i]; ++i) {
                    int n7 = diskManagerPiece.getBlockSize(i);
                    n6 += n7;
                    if (l3 == 0L) {
                        if (n6 <= n4) continue;
                        l3 = n6 - n4;
                        continue;
                    }
                    l3 += (long)n7;
                }
            }
        } else {
            l3 = diskManagerPiece.getLength() - n4;
            for (int i = n2 + 1; i <= n5; ++i) {
                DiskManagerPiece diskManagerPiece2 = diskManagerPieceArray[i];
                if (diskManagerPiece2.isDone()) {
                    l3 += (long)diskManagerPiece2.getLength();
                    continue;
                }
                boolean[] blArray = diskManagerPiece2.getWritten();
                if (blArray == null) {
                    if (!diskManagerPiece2.isDone()) break;
                    l3 += (long)diskManagerPiece2.getLength();
                    break;
                }
                for (int j = 0; j < blArray.length && blArray[j]; ++j) {
                    l3 += (long)diskManagerPiece2.getBlockSize(j);
                }
                break;
            }
        }
        if (l3 > (l = diskManagerFileInfo.getLength() - (long)n)) {
            l3 = l;
        }
        return l3;
    }

    public void setViewerPosition(DiskManagerFileInfo diskManagerFileInfo, long l) {
        int n;
        if (diskManagerFileInfo != null && (n = diskManagerFileInfo.getIndex()) < this.enhanced_files.length) {
            l += this.enhanced_files[n].getByteOffestInTorrent();
        }
        this.progressive_stats.setViewerBytePosition(l);
    }

    public DownloadManager getDownloadManager() {
        return this.download_manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroy() {
        EnhancedDownloadManager enhancedDownloadManager = this;
        synchronized (enhancedDownloadManager) {
            this.setRTA(false);
            this.destroyed = true;
        }
    }

    protected void log(String string) {
        this.log(string, true);
    }

    protected void log(String string, boolean bl) {
        this.log(this.download_manager, string, bl);
    }

    protected void log(DownloadManager downloadManager, String string, boolean bl) {
        string = downloadManager.getDisplayName() + ": " + string;
        if (bl) {
            AEDiagnosticsLogger aEDiagnosticsLogger = AEDiagnostics.getLogger("v3.Stream");
            aEDiagnosticsLogger.log(string);
        }
        if (ConstantsVuze.DIAG_TO_STDOUT) {
            System.out.println(Thread.currentThread().getName() + "|" + System.currentTimeMillis() + "] " + string);
        }
    }

    static {
        COConfigurationManager.addAndFireParameterListeners(new String[]{"filechannel.rt.buffer.millis"}, new ParameterListener(){

            public void parameterChanged(String string) {
                int n = COConfigurationManager.getIntParameter("filechannel.rt.buffer.millis");
                MINIMUM_INITIAL_BUFFER_SECS = 2 * n / 1000;
            }
        });
        internal_content_stream_bps_increase_ratio = 5;
        internal_content_stream_bps_increase_absolute = 0;
    }

    protected class progressiveStatsInternal
    extends progressiveStatsCommon {
        private long content_stream_bps_min;
        private long content_stream_bps_max;
        private long viewer_byte_position;
        private long viewer_byte_position_set_time;
        private long last_warning;

        protected progressiveStatsInternal(DownloadManager downloadManager, EnhancedDownloadManagerFile enhancedDownloadManagerFile) {
            super(downloadManager, enhancedDownloadManagerFile);
        }

        protected void calculateSpeeds(DownloadManager downloadManager, EnhancedDownloadManagerFile enhancedDownloadManagerFile) {
            TOTorrent tOTorrent = downloadManager.getTorrent();
            if (tOTorrent == null) {
                return;
            }
            this.content_stream_bps_min = PlatformTorrentUtils.getContentStreamSpeedBps(tOTorrent);
            if (this.content_stream_bps_min == 0L) {
                long l = tOTorrent.getSize();
                this.content_stream_bps_min = l < 0xC800000L ? 30720L : (l < 1048576000L ? 204800L : 409600L);
            }
            this.content_stream_bps_min += (long)internal_content_stream_bps_increase_absolute;
            this.content_stream_bps_max = this.content_stream_bps_min + this.content_stream_bps_min / (long)internal_content_stream_bps_increase_ratio;
        }

        protected long getStreamBytesPerSecondMax() {
            return this.content_stream_bps_max;
        }

        protected long getStreamBytesPerSecondMin() {
            return this.content_stream_bps_min;
        }

        public long getInitialBufferBytes(long l, boolean bl) {
            long l2 = bl ? 0L : (long)EnhancedDownloadManager.this.explicit_minimum_buffer_bytes;
            long l3 = EnhancedDownloadManager.this.primary_file.getInitialBufferBytes(l);
            if (l3 == 0L) {
                l3 = (long)EnhancedDownloadManager.this.minimum_initial_buffer_secs_for_eta * this.getStreamBytesPerSecondMax();
            } else if (!bl) {
                l3 += (long)EnhancedDownloadManager.this.explicit_minimum_buffer_bytes;
            }
            l2 = Math.max(l3, l2);
            return l2;
        }

        protected void updateViewerPosition() {
        }

        protected void setViewerBytePosition(long l) {
            this.viewer_byte_position_set_time = SystemTime.getCurrentTime();
            this.viewer_byte_position = l;
        }

        protected long getViewerBytePosition() {
            long l = SystemTime.getCurrentTime();
            if (l < this.viewer_byte_position_set_time) {
                this.viewer_byte_position_set_time = l;
            } else if (l - this.viewer_byte_position_set_time > 10000L && this.viewer_byte_position != 0L && (l < this.last_warning || l - this.last_warning >= 1000L)) {
                this.last_warning = l;
                EnhancedDownloadManager.this.log("No recent viewer position update (current=" + this.viewer_byte_position + ")");
            }
            return this.viewer_byte_position;
        }
    }

    protected class progressiveStatsExternal
    extends progressiveStatsCommon {
        private long content_stream_bps_min;
        private long content_stream_bps_max;
        private long viewer_byte_position;

        protected progressiveStatsExternal(DownloadManager downloadManager, EnhancedDownloadManagerFile enhancedDownloadManagerFile) {
            super(downloadManager, enhancedDownloadManagerFile);
        }

        protected void calculateSpeeds(DownloadManager downloadManager, EnhancedDownloadManagerFile enhancedDownloadManagerFile) {
            TOTorrent tOTorrent = downloadManager.getTorrent();
            if (tOTorrent == null) {
                return;
            }
            this.content_stream_bps_min = PlatformTorrentUtils.getContentStreamSpeedBps(tOTorrent);
            if (this.content_stream_bps_min == 0L) {
                long l = tOTorrent.getSize();
                this.content_stream_bps_min = l < 0xC800000L ? 30720L : (l < 1048576000L ? 204800L : 409600L);
            }
            this.content_stream_bps_max = this.content_stream_bps_min + this.content_stream_bps_min / 5L;
        }

        protected long getStreamBytesPerSecondMax() {
            return this.content_stream_bps_max;
        }

        protected long getStreamBytesPerSecondMin() {
            return this.content_stream_bps_min;
        }

        public long getInitialBufferBytes(long l, boolean bl) {
            long l2 = (long)EnhancedDownloadManager.this.minimum_initial_buffer_secs_for_eta * this.getStreamBytesPerSecondMax();
            l2 = Math.max(l2, bl ? 0L : (long)EnhancedDownloadManager.this.explicit_minimum_buffer_bytes);
            long l3 = EnhancedDownloadManager.this.primary_file.getInitialBufferBytes(l);
            l2 = Math.max(l3, l2);
            return l2;
        }

        protected void updateViewerPosition() {
            this.viewer_byte_position = this.getInitialProviderPosition() + this.getStreamBytesPerSecondMax() * this.getProviderLifeSecs();
            if (this.viewer_byte_position > this.total_file_length) {
                this.viewer_byte_position = this.total_file_length;
            }
            if (this.viewer_byte_position > this.getProviderBytePosition()) {
                this.viewer_byte_position = this.getProviderBytePosition();
            }
        }

        protected void setViewerBytePosition(long l) {
        }

        protected long getViewerBytePosition() {
            return this.viewer_byte_position;
        }
    }

    protected abstract class progressiveStatsCommon
    extends progressiveStats {
        private PieceRTAProvider current_provider;
        private String current_user_agent;
        protected long total_file_length;
        private Average capped_download_rate_average;
        private Average discard_rate_average;
        private long last_discard_bytes;
        private long actual_bytes_to_download;
        private long weighted_bytes_to_download;
        private long provider_life_secs;
        private long provider_initial_position;
        private long provider_byte_position;
        private long provider_last_byte_position;
        private long provider_blocking_byte_position;
        private Average provider_speed_average;
        private long last_eta;

        protected progressiveStatsCommon(DownloadManager downloadManager, EnhancedDownloadManagerFile enhancedDownloadManagerFile) {
            this.total_file_length = EnhancedDownloadManager.this.download_manager.getSize();
            this.capped_download_rate_average = AverageFactory.MovingImmediateAverage(10);
            this.discard_rate_average = AverageFactory.MovingImmediateAverage(10);
            this.last_discard_bytes = EnhancedDownloadManager.this.download_manager.getStats().getDiscarded();
            this.provider_last_byte_position = -1L;
            this.provider_speed_average = AverageFactory.MovingImmediateAverage(10);
            this.last_eta = -1L;
            this.calculateSpeeds(downloadManager, enhancedDownloadManagerFile);
            EnhancedDownloadManager.this.setRTA(false);
            EnhancedDownloadManager.this.log(EnhancedDownloadManager.this.download_manager, "content_stream_bps=" + this.getStreamBytesPerSecondMin() + ",primary=" + (enhancedDownloadManagerFile == null ? "null" : enhancedDownloadManagerFile.getString()), true);
        }

        protected void refreshMetaData() {
            this.calculateSpeeds(EnhancedDownloadManager.this.download_manager, EnhancedDownloadManager.this.primary_file);
        }

        protected abstract void calculateSpeeds(DownloadManager var1, EnhancedDownloadManagerFile var2);

        protected void updateCurrentProvider(PieceRTAProvider pieceRTAProvider) {
            if (this.current_provider != pieceRTAProvider || pieceRTAProvider == null) {
                this.current_provider = pieceRTAProvider;
                this.current_user_agent = null;
                this.provider_speed_average = AverageFactory.MovingImmediateAverage(10);
                if (this.current_provider == null) {
                    this.provider_life_secs = 0L;
                    this.provider_initial_position = 0L;
                    this.provider_byte_position = 0L;
                    this.provider_blocking_byte_position = 0L;
                    this.provider_last_byte_position = -1L;
                } else {
                    this.provider_byte_position = this.provider_initial_position = this.current_provider.getStartPosition();
                    this.provider_last_byte_position = this.provider_initial_position;
                    this.provider_blocking_byte_position = this.current_provider.getBlockingPosition();
                    this.provider_life_secs = (SystemTime.getCurrentTime() - this.current_provider.getStartTime()) / 1000L;
                    if (this.provider_life_secs < 0L) {
                        this.provider_life_secs = 0L;
                    }
                }
                EnhancedDownloadManager.this.setRTA(this.current_provider != null);
            } else {
                ++this.provider_life_secs;
                if (this.current_user_agent == null) {
                    this.current_user_agent = this.current_provider.getUserAgent();
                    if (this.current_user_agent != null) {
                        EnhancedDownloadManager.this.log("Provider user agent = " + this.current_user_agent);
                    }
                }
                this.provider_byte_position = this.current_provider.getCurrentPosition();
                this.provider_blocking_byte_position = this.current_provider.getBlockingPosition();
                long l = this.provider_byte_position - this.provider_last_byte_position;
                this.provider_speed_average.update(l);
                this.provider_last_byte_position = this.provider_byte_position;
            }
        }

        protected boolean isProviderActive() {
            return this.current_provider != null;
        }

        protected long getInitialProviderPosition() {
            return this.provider_initial_position;
        }

        protected long getProviderBytePosition() {
            return this.provider_byte_position;
        }

        protected long getProviderLifeSecs() {
            return this.provider_life_secs;
        }

        protected void update(int n) {
            long l = EnhancedDownloadManager.this.download_manager.getStats().getDataReceiveRate();
            this.capped_download_rate_average.update(l);
            long l2 = EnhancedDownloadManager.this.download_manager.getStats().getDiscarded();
            this.discard_rate_average.update(l2 - this.last_discard_bytes);
            this.last_discard_bytes = l2;
            DiskManager diskManager = EnhancedDownloadManager.this.download_manager.getDiskManager();
            PiecePicker piecePicker = EnhancedDownloadManager.this.current_piece_pickler;
            if (this.getStreamBytesPerSecondMin() > 0L && diskManager != null && piecePicker != null) {
                List list = piecePicker.getRTAProviders();
                long l3 = 0L;
                PieceRTAProvider pieceRTAProvider = null;
                for (int i = 0; i < list.size(); ++i) {
                    long l4;
                    PieceRTAProvider pieceRTAProvider2 = (PieceRTAProvider)list.get(i);
                    if (pieceRTAProvider2.getStartTime() <= 0L || (l4 = pieceRTAProvider2.getCurrentPosition()) < l3) continue;
                    pieceRTAProvider = pieceRTAProvider2;
                    l3 = l4;
                }
                this.updateCurrentProvider(pieceRTAProvider);
                this.updateViewerPosition();
                if (pieceRTAProvider != null) {
                    long l5 = this.getViewerBufferSeconds();
                    if (l5 < 10L) {
                        l5 = 10L;
                    }
                    pieceRTAProvider.setBufferMillis(l5 * 1000L);
                }
                DiskManagerPiece[] diskManagerPieceArray = diskManager.getPieces();
                this.actual_bytes_to_download = 0L;
                this.weighted_bytes_to_download = 0L;
                int n2 = -1;
                int n3 = diskManager.getPieceLength();
                for (int i = (int)(this.provider_byte_position / (long)n3); i < diskManagerPieceArray.length; ++i) {
                    int n4;
                    DiskManagerPiece diskManagerPiece = diskManagerPieceArray[i];
                    if (diskManagerPiece.isDone()) continue;
                    if (n2 == -1) {
                        n2 = i;
                    }
                    boolean[] blArray = diskManagerPiece.getWritten();
                    int n5 = 0;
                    if (blArray == null) {
                        n5 = diskManagerPiece.getLength();
                    } else {
                        for (n4 = 0; n4 < blArray.length; ++n4) {
                            if (blArray[n4]) continue;
                            n5 += diskManagerPiece.getBlockSize(n4);
                        }
                    }
                    if (n5 <= 0) continue;
                    this.actual_bytes_to_download += (long)n5;
                    n4 = i - n2;
                    if (n4 == 0) {
                        this.weighted_bytes_to_download += (long)n5;
                        continue;
                    }
                    int n6 = diskManagerPiece.getLength() - n5;
                    n6 = n6 * (diskManagerPieceArray.length - i) / (diskManagerPieceArray.length - n2);
                    this.weighted_bytes_to_download += (long)(diskManagerPiece.getLength() - n6);
                }
            }
            EnhancedDownloadManager.this.log(this.getString(), n % 10 == 0);
        }

        protected abstract void updateViewerPosition();

        protected abstract long getInitialBufferBytes(long var1, boolean var3);

        protected long getETA(boolean bl) {
            long l;
            DiskManager diskManager = EnhancedDownloadManager.this.download_manager.getDiskManager();
            if (diskManager == null) {
                return Long.MAX_VALUE;
            }
            if (diskManager.getRemainingExcludingDND() == 0L) {
                return 0L;
            }
            long l2 = this.getDownloadBytesPerSecond();
            if (l2 <= 0L) {
                return Long.MAX_VALUE;
            }
            long l3 = this.getInitialBufferBytes(l2, bl);
            long l4 = this.getInitialBytesDownloaded(l3);
            long l5 = l3 - l4;
            long l6 = l5 / l2;
            long l7 = this.getSecondsToDownload();
            long l8 = this.getSecondsToWatch();
            if (l6 > (l = (l7 += l7 / 10L) - l8)) {
                l = l6;
            }
            if (!bl && l == 0L && this.last_eta != 0L) {
                this.last_eta = l;
                EnhancedDownloadManager.this.log("ETA=0: rate=" + DisplayFormatters.formatByteCountToKiBEtcPerSec(l2) + ",init_buff=" + l3 + ",to_dl=" + l7 + ",to_watch=" + l8);
            }
            return l;
        }

        public long getInitialBytesDownloaded() {
            return this.getInitialBytesDownloaded(Long.MAX_VALUE);
        }

        protected long getDownloadBytesPerSecond() {
            int n;
            long l;
            long l2 = l = (long)this.capped_download_rate_average.getAverage();
            int n2 = EnhancedDownloadManager.this.download_manager.getStats().getDownloadRateLimitBytesPerSecond();
            if (n2 > 0) {
                l2 = Math.min(l2, (long)n2);
            }
            if ((n = TransferSpeedValidator.getGlobalDownloadRateLimitBytesPerSecond()) > 0) {
                l2 = Math.min(l2, (long)n);
            }
            return l2;
        }

        public long getInitialBytesDownloaded(long l) {
            DiskManager diskManager = EnhancedDownloadManager.this.download_manager.getDiskManager();
            if (diskManager == null) {
                return 0L;
            }
            long l2 = 0L;
            DiskManagerPiece[] diskManagerPieceArray = diskManager.getPieces();
            for (int i = 0; i < diskManagerPieceArray.length; ++i) {
                DiskManagerPiece diskManagerPiece = diskManagerPieceArray[i];
                if (!diskManagerPiece.isDone()) {
                    boolean[] blArray = diskManagerPiece.getWritten();
                    if (blArray == null) break;
                    for (int j = 0; j < blArray.length && blArray[j]; ++j) {
                        l2 += (long)diskManagerPiece.getBlockSize(j);
                    }
                    break;
                }
                if ((l2 += (long)diskManagerPiece.getLength()) >= l) break;
            }
            return l2;
        }

        protected long getSecondsToDownload() {
            long l = this.getDownloadBytesPerSecond();
            if (l == 0L) {
                return Long.MAX_VALUE;
            }
            return this.weighted_bytes_to_download / l;
        }

        protected long getSecondsToWatch() {
            return (this.total_file_length - this.getViewerBytePosition()) / this.getStreamBytesPerSecondMin();
        }

        protected long getBytePosition() {
            return this.getViewerBytePosition();
        }

        protected long getViewerBufferSeconds() {
            return (this.provider_byte_position - this.getViewerBytePosition()) / this.getStreamBytesPerSecondMax();
        }

        protected String getString() {
            long l = this.getDownloadBytesPerSecond();
            long l2 = this.getInitialBufferBytes(l, false);
            return "play_eta=" + this.getETA(false) + "/d=" + this.getSecondsToDownload() + "/w=" + this.getSecondsToWatch() + ", dl_rate=" + this.formatSpeed(l) + ", download_rem=" + this.formatBytes(this.weighted_bytes_to_download) + "/" + this.formatBytes(this.actual_bytes_to_download) + ", discard_rate=" + this.formatSpeed((long)this.discard_rate_average.getAverage()) + ", init_done=" + this.getInitialBytesDownloaded(l2) + ", init_buff=" + l2 + ", viewer: byte=" + this.formatBytes(this.getViewerBytePosition()) + " secs=" + this.getViewerBytePosition() / this.getStreamBytesPerSecondMin() + ", prov: byte=" + this.formatBytes(this.provider_byte_position) + " secs=" + this.provider_byte_position / this.getStreamBytesPerSecondMin() + " speed=" + this.formatSpeed((long)this.provider_speed_average.getAverage()) + " block= " + this.formatBytes(this.provider_blocking_byte_position) + " buffer=" + this.formatBytes(this.provider_byte_position - this.getViewerBytePosition()) + "/" + this.getViewerBufferSeconds();
        }
    }

    protected abstract class progressiveStats
    implements Cloneable {
        protected progressiveStats() {
        }

        protected abstract boolean isProviderActive();

        protected abstract long getBytePosition();

        protected abstract long getStreamBytesPerSecondMax();

        protected abstract long getStreamBytesPerSecondMin();

        protected abstract long getInitialBytesDownloaded();

        protected abstract long getDownloadBytesPerSecond();

        protected abstract long getETA(boolean var1);

        protected abstract void setViewerBytePosition(long var1);

        protected abstract long getViewerBytePosition();

        protected abstract void update(int var1);

        protected abstract void refreshMetaData();

        protected progressiveStats getCopy() {
            try {
                return (progressiveStats)this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                Debug.printStackTrace(cloneNotSupportedException);
                return null;
            }
        }

        protected String formatBytes(long l) {
            return DisplayFormatters.formatByteCountToKiBEtc(l);
        }

        protected String formatSpeed(long l) {
            return DisplayFormatters.formatByteCountToKiBEtcPerSec(l);
        }
    }

    protected class boostETAProvider
    implements PieceRTAProvider {
        private long[] piece_rtas;
        private long last_recalc;
        private int aggression;
        private boolean active;
        private interventionHandler intervention_handler = new interventionHandler();
        private long last_intervention;

        protected boostETAProvider() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void activate(PiecePicker piecePicker) {
            if (EnhancedDownloadManager.this.supportsProgressiveMode()) {
                EnhancedDownloadManager.this.log("Activating boost provider");
                EnhancedDownloadManager enhancedDownloadManager = EnhancedDownloadManager.this;
                synchronized (enhancedDownloadManager) {
                    this.intervention_handler.activate();
                    this.active = true;
                    piecePicker.addRTAProvider(this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void deactivate(PiecePicker piecePicker) {
            if (this.active) {
                EnhancedDownloadManager.this.log("Deactivating boost provider");
            }
            EnhancedDownloadManager enhancedDownloadManager = EnhancedDownloadManager.this;
            synchronized (enhancedDownloadManager) {
                piecePicker.removeRTAProvider(this);
                this.piece_rtas = null;
                this.active = false;
                this.intervention_handler.deactivate();
            }
        }

        public long[] updateRTAs(PiecePicker piecePicker) {
            long l = SystemTime.getCurrentTime();
            if (l < this.last_recalc || l - this.last_recalc > 1000L) {
                this.last_recalc = l;
                DiskManager diskManager = EnhancedDownloadManager.this.download_manager.getDiskManager();
                progressiveStats progressiveStats2 = EnhancedDownloadManager.this.getProgressiveStats();
                long l2 = progressiveStats2.getStreamBytesPerSecondMax();
                if (diskManager == null || !progressiveStats2.isProviderActive() || progressiveStats2.getETA(false) < (long)(-MINIMUM_INITIAL_BUFFER_SECS) || l2 == 0L) {
                    if (this.piece_rtas != null) {
                        EnhancedDownloadManager.this.log("Suspending boost provider");
                    }
                    this.piece_rtas = null;
                } else {
                    if (this.piece_rtas == null) {
                        EnhancedDownloadManager.this.log("Resuming boost provider");
                    }
                    this.piece_rtas = new long[diskManager.getNbPieces()];
                    long[] lArray = this.piece_rtas;
                    long l3 = diskManager.getPieceLength();
                    int n = (int)(progressiveStats2.getBytePosition() / l3);
                    long l4 = 0L;
                    int n2 = -1;
                    long l5 = 0L;
                    if (EnhancedDownloadManager.this.explicit_minimum_buffer_bytes > 0) {
                        long l6 = EnhancedDownloadManager.this.getContiguousAvailableBytes(EnhancedDownloadManager.this.getPrimaryFile());
                        long l7 = progressiveStats2.getViewerBytePosition();
                        long l8 = l6 - l7;
                        l5 = (l8 - (long)EnhancedDownloadManager.this.explicit_minimum_buffer_bytes) * 1000L / l2;
                        long l9 = 3 * EnhancedDownloadManager.this.explicit_minimum_buffer_bytes;
                        if (l8 <= l9) {
                            if (l8 < 0L) {
                                l8 = 0L;
                            }
                            this.aggression = l8 <= (long)EnhancedDownloadManager.this.explicit_minimum_buffer_bytes ? 10 : (int)((l9 - l8) * 10L / (l9 - (long)EnhancedDownloadManager.this.explicit_minimum_buffer_bytes));
                            n2 = n + (int)((l9 + l3 - 1L) / l3);
                        } else {
                            this.aggression = 0;
                        }
                    } else {
                        this.aggression = 0;
                    }
                    DiskManagerPiece[] diskManagerPieceArray = diskManager.getPieces();
                    for (int i = n; i < lArray.length; ++i) {
                        int n3;
                        if (i <= n2) {
                            n3 = (10 - this.aggression) * 1000 / 10;
                            n3 = Math.max(n3, 10);
                            if (!(this.aggression < 7 || diskManagerPieceArray[i].isDone() || l5 > 10000L || l >= this.last_intervention && l - this.last_intervention < 500L)) {
                                this.last_intervention = l;
                                this.intervention_handler.addPiece(i, SystemTime.getCurrentTime() + l5);
                            }
                        } else {
                            n3 = 1000;
                        }
                        lArray[i] = l + (long)n3 * (l4 / l2);
                        l4 += l3;
                    }
                }
            }
            return this.piece_rtas;
        }

        public long getCurrentPosition() {
            return 0L;
        }

        public long getBlockingPosition() {
            return 0L;
        }

        public long getStartTime() {
            return 0L;
        }

        public long getStartPosition() {
            return 0L;
        }

        public void setBufferMillis(long l) {
        }

        public String getUserAgent() {
            return null;
        }

        protected class interventionHandler {
            private AEThread2 thread;
            private AESemaphore request_sem;
            private List request_list;
            private List http_peers;
            private boolean borked;

            protected interventionHandler() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void activate() {
                interventionHandler interventionHandler2 = this;
                synchronized (interventionHandler2) {
                    boostETAProvider.this.active = true;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void deactivate() {
                interventionHandler interventionHandler2 = this;
                synchronized (interventionHandler2) {
                    boostETAProvider.this.active = false;
                    if (this.thread != null) {
                        this.thread = null;
                        this.request_list = null;
                        this.request_sem.release();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void addPiece(int n, long l) {
                interventionHandler interventionHandler2 = this;
                synchronized (interventionHandler2) {
                    Object[] objectArray;
                    if (!boostETAProvider.this.active || this.borked) {
                        return;
                    }
                    if (this.thread == null) {
                        PluginInterface pluginInterface = EnhancedDownloadManager.this.enhancer.getCore().getPluginManager().getPluginInterfaceByClass(ExternalSeedPlugin.class);
                        if (pluginInterface == null) {
                            this.borked = true;
                            return;
                        }
                        ExternalSeedPlugin externalSeedPlugin = (ExternalSeedPlugin)pluginInterface.getPlugin();
                        objectArray = externalSeedPlugin.getManualWebSeeds(PluginCoreUtils.wrap(EnhancedDownloadManager.this.download_manager));
                        this.http_peers = null;
                        for (int i = 0; i < objectArray.length; ++i) {
                            ExternalSeedManualPeer externalSeedManualPeer = objectArray[i];
                            if (!PeerClassifier.isAzureusIP(externalSeedManualPeer.getIP())) continue;
                            if (this.http_peers == null) {
                                this.http_peers = new ArrayList();
                            }
                            this.http_peers.add(externalSeedManualPeer);
                        }
                        this.request_sem = new AESemaphore("EDH:intervention");
                        this.request_list = new ArrayList();
                        this.thread = new AEThread2("EDH:intervention", true){
                            private AESemaphore my_sem;
                            private List my_list;
                            private ExternalSeedManualPeer current_peer;
                            {
                                this.my_sem = interventionHandler.this.request_sem;
                                this.my_list = interventionHandler.this.request_list;
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             * Unable to fully structure code
                             * Enabled aggressive block sorting
                             * Enabled unnecessary exception pruning
                             * Enabled aggressive exception aggregation
                             */
                            public void run() {
                                while (true) {
                                    block43: {
                                        block41: {
                                            block40: {
                                                block39: {
                                                    block38: {
                                                        this.my_sem.reserve();
                                                        var4_4 = interventionHandler.this;
                                                        synchronized (var4_4) {
                                                            if (this.my_list.isEmpty()) {
                                                                return;
                                                            }
                                                            var5_5 = (long[])this.my_list.get(0);
                                                            var1_1 = (int)var5_5[0];
                                                            var2_2 = var5_5[1];
                                                        }
                                                        try {
                                                            var4_3 = (int)(var2_2 - SystemTime.getCurrentTime());
                                                            if (var4_3 < 500) {
                                                                var23_26 = null;
                                                                var24_27 = interventionHandler.this;
                                                                break block38;
                                                            }
                                                            var5_5 = EnhancedDownloadManager.access$1100(EnhancedDownloadManager.this).getDiskManager();
                                                            var6_6 = EnhancedDownloadManager.access$1100(EnhancedDownloadManager.this).getPeerManager();
                                                            if (var5_5 == null) break block39;
                                                            if (var6_6 == null) {
                                                                break block39;
                                                            }
                                                            var7_7 = var5_5.getPiece(var1_1);
                                                            if (var7_7.isDone()) {
                                                                break block40;
                                                            }
                                                            var8_8 = interventionHandler.access$1800(interventionHandler.this);
                                                            if (this.current_peer == null) {
                                                                if (var8_8 == null && var8_8.size() == 0) {
                                                                    break block41;
                                                                }
                                                                this.current_peer = (ExternalSeedManualPeer)var8_8.remove(0);
                                                            }
                                                            var9_9 = var6_6.getPiece(var1_1);
                                                            var10_10 = new boolean[var7_7.getNbBlocks()];
                                                            if (var9_9 == null) {
                                                                var11_12 = var7_7.getWritten();
                                                                if (var11_12 == null) {
                                                                    Arrays.fill(var10_10, true);
                                                                } else {
                                                                    for (var12_13 = 0; var12_13 < var10_10.length; ++var12_13) {
                                                                        if (var11_12[var12_13]) continue;
                                                                        var10_10[var12_13] = true;
                                                                    }
                                                                }
                                                            } else {
                                                                var11_12 = var9_9.getDownloaded();
                                                                for (var12_13 = 0; var12_13 < var10_10.length; ++var12_13) {
                                                                    if (var11_12[var12_13]) continue;
                                                                    var10_10[var12_13] = true;
                                                                }
                                                            }
                                                            var11_11 = 0;
                                                            block16: while (true) {
                                                                var12_13 = 0;
                                                                var13_14 = 0;
                                                                while (var11_11 < var10_10.length) {
                                                                    if (var10_10[var11_11]) {
                                                                        if (var13_14 == 0) {
                                                                            var12_13 = var11_11;
                                                                        }
                                                                        ++var13_14;
                                                                    } else if (var13_14 > 0) break;
                                                                    ++var11_11;
                                                                }
                                                                if (var13_14 != 0) {
                                                                    var14_15 = 0;
                                                                    var15_16 = 0;
                                                                    for (var16_18 = 0; var16_18 < var12_13 + var13_14; ++var16_18) {
                                                                        var17_19 = var7_7.getBlockSize(var16_18);
                                                                        if (var16_18 < var12_13) {
                                                                            var14_15 += var17_19;
                                                                            continue;
                                                                        }
                                                                        var15_16 += var17_19;
                                                                    }
                                                                    var16_17 = PluginCoreUtils.wrap(var6_6);
                                                                    while (true) {
                                                                        if (this.current_peer == null) continue block16;
                                                                        EnhancedDownloadManager.this.log("Intervention: peer=" + this.current_peer.getIP() + ", piece=" + var1_1 + ", block_start=" + var12_13 + ", block_num=" + var13_14 + ", offset=" + var14_15 + ", length=" + var15_16 + ", rem=" + var4_3);
                                                                        try {
                                                                            var17_20 = this.current_peer.read(var1_1, var14_15, var15_16, var4_3);
                                                                            var18_22 = 0;
                                                                            var19_23 = var12_13;
                                                                            while (true) {
                                                                                if (var19_23 < var12_13 + var13_14) ** break;
                                                                                continue block16;
                                                                                var20_24 = var7_7.getBlockSize(var19_23);
                                                                                var21_25 = new byte[var20_24];
                                                                                System.arraycopy(var17_20, var18_22, var21_25, 0, var20_24);
                                                                                EnhancedDownloadManager.this.log("    Read block " + var19_23 + ", offset=" + var18_22 + ", length=" + var20_24);
                                                                                var16_17.requestComplete(var5_5.createReadRequest(var1_1, var14_15 + var18_22, var20_24), new PooledByteBufferImpl(var21_25), this.current_peer.getDelegate());
                                                                                var18_22 += var20_24;
                                                                                ++var19_23;
                                                                            }
                                                                        }
                                                                        catch (Throwable var17_21) {
                                                                            if (!(var17_21 instanceof ExternalSeedException)) {
                                                                                Debug.printStackTrace(var17_21);
                                                                            }
                                                                            if (var8_8 != null && var8_8.size() > 0) {
                                                                                this.current_peer = (ExternalSeedManualPeer)var8_8.remove(0);
                                                                                continue;
                                                                            }
                                                                            this.current_peer = null;
                                                                            continue;
                                                                        }
                                                                        break;
                                                                    }
                                                                }
                                                                break block43;
                                                                break;
                                                            }
                                                        }
                                                        catch (Throwable var22_28) {
                                                            var23_26 = null;
                                                            var24_27 = interventionHandler.this;
                                                            synchronized (var24_27) {
                                                                this.my_list.remove(0);
                                                                throw var22_28;
                                                            }
                                                        }
                                                    }
                                                    synchronized (var24_27) {
                                                        this.my_list.remove(0);
                                                        continue;
                                                    }
                                                }
                                                var23_26 = null;
                                                var24_27 = interventionHandler.this;
                                                synchronized (var24_27) {
                                                    this.my_list.remove(0);
                                                    continue;
                                                }
                                            }
                                            var23_26 = null;
                                            var24_27 = interventionHandler.this;
                                            synchronized (var24_27) {
                                                this.my_list.remove(0);
                                                continue;
                                            }
                                        }
                                        var23_26 = null;
                                        var24_27 = interventionHandler.this;
                                        synchronized (var24_27) {
                                            this.my_list.remove(0);
                                            continue;
                                        }
                                    }
                                    var23_26 = null;
                                    var24_27 = interventionHandler.this;
                                    synchronized (var24_27) {
                                        this.my_list.remove(0);
                                    }
                                }
                            }
                        };
                        this.thread.start();
                    }
                    if ((this.request_list.isEmpty() || (long)n < ((long[])this.request_list.get(0))[0] + 10L) && this.request_list.size() < 5) {
                        boolean bl = false;
                        for (int i = 0; i < this.request_list.size(); ++i) {
                            objectArray = (long[])this.request_list.get(i);
                            if (objectArray[0] != (long)n) continue;
                            bl = true;
                            objectArray[1] = (ExternalSeedManualPeer)Math.min(l, (long)objectArray[1]);
                        }
                        if (!bl) {
                            EnhancedDownloadManager.this.log("Intervention: queueing piece " + n + ", stall_time=" + (l - SystemTime.getCurrentTime()));
                            this.request_list.add(new long[]{n, l});
                            this.request_sem.release();
                        }
                    }
                }
            }

            static /* synthetic */ List access$1800(interventionHandler interventionHandler2) {
                return interventionHandler2.http_peers;
            }
        }
    }

    protected class bufferETAProvider
    implements PieceRTAProvider {
        private long[] piece_rtas;
        private long last_buffer_size;
        private long last_buffer_size_time;
        private boolean active;

        protected bufferETAProvider() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void activate(PiecePicker piecePicker) {
            EnhancedDownloadManager.this.log("Activating buffer provider");
            EnhancedDownloadManager enhancedDownloadManager = EnhancedDownloadManager.this;
            synchronized (enhancedDownloadManager) {
                this.active = true;
                this.piece_rtas = new long[piecePicker.getNumberOfPieces()];
                long l = SystemTime.getCurrentTime();
                for (int i = 0; i < this.piece_rtas.length; ++i) {
                    this.piece_rtas[i] = l + (long)(i * 60000);
                }
                piecePicker.addRTAProvider(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void deactivate(PiecePicker piecePicker) {
            if (this.active) {
                EnhancedDownloadManager.this.log("Deactivating buffer provider");
            }
            EnhancedDownloadManager enhancedDownloadManager = EnhancedDownloadManager.this;
            synchronized (enhancedDownloadManager) {
                piecePicker.removeRTAProvider(this);
                this.piece_rtas = null;
                this.active = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void checkActivation(PiecePicker piecePicker) {
            if (EnhancedDownloadManager.this.getProgressivePlayETA() > 0L) {
                EnhancedDownloadManager enhancedDownloadManager = EnhancedDownloadManager.this;
                synchronized (enhancedDownloadManager) {
                    if (this.piece_rtas == null) {
                        this.activate(piecePicker);
                    }
                }
            }
        }

        public long[] updateRTAs(PiecePicker piecePicker) {
            long[] lArray;
            DiskManager diskManager = EnhancedDownloadManager.this.download_manager.getDiskManager();
            if (diskManager != null && EnhancedDownloadManager.this.getProgressivePlayETA() <= 0L) {
                this.deactivate(piecePicker);
            }
            if ((lArray = this.piece_rtas) != null) {
                long l = EnhancedDownloadManager.this.progressive_stats.getInitialBytesDownloaded();
                long l2 = SystemTime.getCurrentTime();
                if (this.last_buffer_size != l) {
                    this.last_buffer_size = l;
                    this.last_buffer_size_time = l2;
                } else if (l2 < this.last_buffer_size_time) {
                    this.last_buffer_size_time = l2;
                } else {
                    long l3;
                    long l4 = l2 - this.last_buffer_size_time;
                    long l5 = EnhancedDownloadManager.this.progressive_stats.getDownloadBytesPerSecond();
                    if (l5 > 0L && l4 > Math.max(5000L, 5L * (l3 = 0xFA0000L / l5))) {
                        long l6;
                        DiskManagerPiece[] diskManagerPieceArray;
                        long l7 = l2 + l3;
                        int n = (int)(l / (long)diskManager.getPieceLength());
                        if (n < (diskManagerPieceArray = diskManager.getPieces()).length && diskManagerPieceArray[n].isDone()) {
                            if (++n < diskManagerPieceArray.length) {
                                if (diskManagerPieceArray[n].isDone()) {
                                    n = -1;
                                }
                            } else {
                                n = -1;
                            }
                        }
                        if (n >= 0 && l7 < (l6 = lArray[n])) {
                            lArray[n] = l7;
                            EnhancedDownloadManager.this.log("Buffer provider: reprioritising lagging piece " + n + " with rta " + l3);
                        }
                    }
                }
            }
            return lArray;
        }

        public long getCurrentPosition() {
            return 0L;
        }

        public long getStartTime() {
            return 0L;
        }

        public long getStartPosition() {
            return 0L;
        }

        public long getBlockingPosition() {
            return 0L;
        }

        public void setBufferMillis(long l) {
        }

        public String getUserAgent() {
            return null;
        }
    }
}

