/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.download;

import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.util.Debug;

public class EnhancedDownloadManagerFile {
    private DiskManagerFileInfo file;
    private long offset;
    private int header_size;
    private int[][] speeds;

    protected EnhancedDownloadManagerFile(DiskManagerFileInfo diskManagerFileInfo, long l, Map map) {
        this.file = diskManagerFileInfo;
        this.offset = l;
        try {
            if (map != null) {
                List list;
                Long l2 = (Long)map.get("header_size");
                if (l2 != null) {
                    this.header_size = l2.intValue();
                }
                if ((list = (List)map.get("stream_info")) != null) {
                    this.speeds = new int[list.size()][];
                    for (int i = 0; i < list.size(); ++i) {
                        List list2 = (List)list.get(i);
                        int n = ((Long)list2.get(0)).intValue();
                        int n2 = ((Long)list2.get(1)).intValue();
                        int n3 = ((Long)list2.get(2)).intValue();
                        this.speeds[i] = new int[]{n, n2, n3};
                    }
                }
            }
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
        }
    }

    public DiskManagerFileInfo getFile() {
        return this.file;
    }

    public long getByteOffestInTorrent() {
        return this.offset;
    }

    public int getHeaderSize() {
        return this.header_size;
    }

    public int getInitialBufferBytes(long l) {
        int n = 0;
        if (this.speeds != null && this.speeds.length > 0) {
            boolean bl = false;
            int n2 = (int)l / 1024;
            for (int i = 0; i < this.speeds.length; ++i) {
                if (n2 <= this.speeds[i][0]) continue;
                n = this.speeds[i][2] * 1024;
                bl = true;
                break;
            }
            if (!bl) {
                n = this.speeds[this.speeds.length - 1][2] * 1024;
            }
        }
        return this.header_size + n;
    }

    public String getString() {
        String string = "";
        if (this.speeds != null) {
            string = ",speeds=";
            for (int i = 0; i < this.speeds.length; ++i) {
                int[] nArray = this.speeds[i];
                string = string + (i == 0 ? "" : ",") + "[" + nArray[0] + "," + nArray[1] + "," + nArray[2] + "]";
            }
        }
        return this.file.getFile(true).getName() + ",header=" + this.header_size + string;
    }
}

