/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.instancemanager.impl;

import com.aelitis.azureus.core.instancemanager.AZInstance;
import com.aelitis.azureus.core.instancemanager.AZInstanceManagerListener;
import com.aelitis.azureus.core.instancemanager.AZInstanceTracked;
import com.aelitis.azureus.core.instancemanager.impl.AZInstanceManagerImpl;
import java.net.InetAddress;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.Logger;

public class AZPortClashHandler
implements AZInstanceManagerListener {
    private AZInstance my_instance;
    private int last_warned_tcp;
    private int last_warned_udp;
    private int last_warned_udp2;

    protected AZPortClashHandler(AZInstanceManagerImpl aZInstanceManagerImpl) {
        this.my_instance = aZInstanceManagerImpl.getMyInstance();
        aZInstanceManagerImpl.addListener(this);
    }

    protected void check(AZInstance aZInstance) {
        if (aZInstance == this.my_instance) {
            return;
        }
        InetAddress inetAddress = this.my_instance.getExternalAddress();
        InetAddress inetAddress2 = aZInstance.getExternalAddress();
        if (inetAddress.isLoopbackAddress() || inetAddress2.isLoopbackAddress() || inetAddress.equals(inetAddress2)) {
            String string = null;
            int n = this.my_instance.getTCPListenPort();
            if (n != 0 && n != this.last_warned_tcp && n == aZInstance.getTCPListenPort()) {
                string = "TCP " + n;
                this.last_warned_tcp = n;
            }
            int n2 = this.my_instance.getUDPListenPort();
            int n3 = this.my_instance.getUDPNonDataListenPort();
            int n4 = aZInstance.getUDPListenPort();
            int n5 = aZInstance.getUDPNonDataListenPort();
            if (n2 != 0 && n2 != this.last_warned_udp && (n2 == n4 || n2 == n5)) {
                string = (string == null ? "" : string + ", ") + "UDP " + n2;
                this.last_warned_udp = n2;
            }
            if (n2 != n3 && n3 != 0 && n3 != this.last_warned_udp2 && (n3 == n4 || n3 == n5)) {
                string = (string == null ? "" : string + ", ") + "UDP " + n3;
                this.last_warned_udp2 = n3;
            }
            if (string != null) {
                Logger.logTextResource(new LogAlert(true, 1, "azinstancehandler.alert.portclash"), new String[]{string, String.valueOf(10000), String.valueOf(65535)});
            }
        }
    }

    public void instanceFound(AZInstance aZInstance) {
        this.check(aZInstance);
    }

    public void instanceChanged(AZInstance aZInstance) {
        this.check(aZInstance);
    }

    public void instanceLost(AZInstance aZInstance) {
    }

    public void instanceTracked(AZInstanceTracked aZInstanceTracked) {
    }
}

