/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.lws;

import com.aelitis.azureus.core.diskmanager.access.DiskAccessController;
import com.aelitis.azureus.core.diskmanager.cache.CacheFile;
import com.aelitis.azureus.core.lws.LWSDiskManagerState;
import com.aelitis.azureus.core.lws.LightWeightSeed;
import java.io.File;
import org.gudy.azureus2.core3.disk.DiskManager;
import org.gudy.azureus2.core3.disk.DiskManagerCheckRequest;
import org.gudy.azureus2.core3.disk.DiskManagerCheckRequestListener;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfoSet;
import org.gudy.azureus2.core3.disk.DiskManagerListener;
import org.gudy.azureus2.core3.disk.DiskManagerPiece;
import org.gudy.azureus2.core3.disk.DiskManagerReadRequest;
import org.gudy.azureus2.core3.disk.DiskManagerReadRequestListener;
import org.gudy.azureus2.core3.disk.DiskManagerWriteRequest;
import org.gudy.azureus2.core3.disk.DiskManagerWriteRequestListener;
import org.gudy.azureus2.core3.disk.impl.DiskManagerFileInfoImpl;
import org.gudy.azureus2.core3.disk.impl.DiskManagerHelper;
import org.gudy.azureus2.core3.disk.impl.DiskManagerImpl;
import org.gudy.azureus2.core3.disk.impl.DiskManagerPieceImpl;
import org.gudy.azureus2.core3.disk.impl.DiskManagerRecheckScheduler;
import org.gudy.azureus2.core3.disk.impl.DiskManagerUtil;
import org.gudy.azureus2.core3.disk.impl.access.DMAccessFactory;
import org.gudy.azureus2.core3.disk.impl.access.DMChecker;
import org.gudy.azureus2.core3.disk.impl.access.DMReader;
import org.gudy.azureus2.core3.disk.impl.piecemapper.DMPieceList;
import org.gudy.azureus2.core3.disk.impl.piecemapper.DMPieceMap;
import org.gudy.azureus2.core3.disk.impl.piecemapper.DMPieceMapper;
import org.gudy.azureus2.core3.disk.impl.piecemapper.DMPieceMapperFactory;
import org.gudy.azureus2.core3.disk.impl.piecemapper.DMPieceMapperFile;
import org.gudy.azureus2.core3.download.DownloadManagerState;
import org.gudy.azureus2.core3.internat.LocaleTorrentUtil;
import org.gudy.azureus2.core3.internat.LocaleUtilDecoder;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.IndentWriter;

public class LWSDiskManager
implements DiskManagerHelper {
    private static sePiece piece = new sePiece();
    private LightWeightSeed lws;
    private DiskAccessController disk_access_controller;
    private File save_file;
    private DMReader reader;
    private DMChecker checker_use_accessor;
    private DMPieceMapper piece_mapper;
    private DMPieceMap piece_map_use_accessor;
    private sePiece[] pieces;
    private DiskManagerFileInfoImpl[] files;
    private String internal_name;
    private DownloadManagerState download_state;
    private int state = 1;
    private String error_message = "";

    protected LWSDiskManager(LightWeightSeed lightWeightSeed, File file) {
        this.lws = lightWeightSeed;
        this.save_file = file;
        this.disk_access_controller = DiskManagerImpl.getDefaultDiskAccessController();
        this.download_state = new LWSDiskManagerState();
        TOTorrent tOTorrent = this.lws.getTOTorrent(false);
        this.pieces = new sePiece[tOTorrent.getNumberOfPieces()];
        for (int i = 0; i < this.pieces.length; ++i) {
            this.pieces[i] = piece;
        }
    }

    public String getName() {
        return this.lws.getName();
    }

    public int getCacheMode() {
        return 1;
    }

    public long[] getReadStats() {
        if (this.reader == null) {
            return new long[]{0L, 0L};
        }
        return this.reader.getStats();
    }

    public void start() {
        try {
            TOTorrent tOTorrent = this.lws.getTOTorrent(false);
            this.internal_name = ByteFormatter.nicePrint(tOTorrent.getHash(), true);
            LocaleUtilDecoder localeUtilDecoder = LocaleTorrentUtil.getTorrentEncoding(tOTorrent);
            this.piece_mapper = DMPieceMapperFactory.create(tOTorrent);
            this.piece_mapper.construct(localeUtilDecoder, this.save_file.getName());
            this.files = this.getFileInfo(this.piece_mapper.getFiles(), this.save_file);
            this.reader = DMAccessFactory.createReader(this);
            this.reader.start();
            if (this.state != 10) {
                this.state = 4;
            }
        }
        catch (Throwable throwable) {
            this.setFailed("start failed - " + Debug.getNestedExceptionMessage(throwable));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DiskManagerFileInfoImpl[] getFileInfo(DMPieceMapperFile[] dMPieceMapperFileArray, File file) {
        DiskManagerFileInfoImpl[] diskManagerFileInfoImplArray;
        block12: {
            boolean bl = false;
            DiskManagerFileInfoImpl[] diskManagerFileInfoImplArray2 = new DiskManagerFileInfoImpl[dMPieceMapperFileArray.length];
            try {
                TOTorrent tOTorrent = this.lws.getTOTorrent(false);
                if (tOTorrent.isSimpleTorrent()) {
                    file = file.getParentFile();
                }
                for (int i = 0; i < dMPieceMapperFileArray.length; ++i) {
                    DiskManagerFileInfoImpl diskManagerFileInfoImpl;
                    DMPieceMapperFile dMPieceMapperFile = dMPieceMapperFileArray[i];
                    File file2 = dMPieceMapperFile.getDataFile();
                    long l = dMPieceMapperFile.getLength();
                    diskManagerFileInfoImplArray2[i] = diskManagerFileInfoImpl = new DiskManagerFileInfoImpl(this, new File(file, file2.toString()), i, dMPieceMapperFile.getTorrentFile(), true);
                    CacheFile cacheFile = diskManagerFileInfoImpl.getCacheFile();
                    File file3 = diskManagerFileInfoImpl.getFile(true);
                    if (!cacheFile.exists()) {
                        throw new Exception("File '" + file3 + "' doesn't exist");
                    }
                    if (cacheFile.getLength() != l) {
                        throw new Exception("File '" + file3 + "' doesn't exist");
                    }
                    dMPieceMapperFile.setFileInfo(diskManagerFileInfoImpl);
                }
                bl = true;
                diskManagerFileInfoImplArray = diskManagerFileInfoImplArray2;
                Object var15_16 = null;
                if (bl) break block12;
            }
            catch (Throwable throwable) {
                DiskManagerFileInfoImpl[] diskManagerFileInfoImplArray3;
                block13: {
                    try {
                        this.setFailed("getFiles failed - " + Debug.getNestedExceptionMessage(throwable));
                        diskManagerFileInfoImplArray3 = null;
                        Object var15_17 = null;
                        if (bl) break block13;
                    }
                    catch (Throwable throwable2) {
                        Object var15_18 = null;
                        if (!bl) {
                            for (int i = 0; i < diskManagerFileInfoImplArray2.length; ++i) {
                                if (diskManagerFileInfoImplArray2[i] == null) continue;
                                diskManagerFileInfoImplArray2[i].close();
                            }
                        }
                        throw throwable2;
                    }
                    for (int i = 0; i < diskManagerFileInfoImplArray2.length; ++i) {
                        if (diskManagerFileInfoImplArray2[i] == null) continue;
                        diskManagerFileInfoImplArray2[i].close();
                    }
                }
                return diskManagerFileInfoImplArray3;
            }
            for (int i = 0; i < diskManagerFileInfoImplArray2.length; ++i) {
                if (diskManagerFileInfoImplArray2[i] == null) continue;
                diskManagerFileInfoImplArray2[i].close();
            }
        }
        return diskManagerFileInfoImplArray;
    }

    public void setPieceDone(DiskManagerPieceImpl diskManagerPieceImpl, boolean bl) {
    }

    public void stop(boolean bl) {
        if (this.reader != null) {
            this.reader.stop();
            this.reader = null;
        }
        if (this.files != null) {
            for (int i = 0; i < this.files.length; ++i) {
                try {
                    this.files[i].getCacheFile().close();
                    continue;
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }
    }

    public boolean filesExist() {
        throw new RuntimeException("filesExist not implemented");
    }

    public DiskManagerWriteRequest createWriteRequest(int n, int n2, DirectByteBuffer directByteBuffer, Object object) {
        throw new RuntimeException("createWriteRequest not implemented");
    }

    public void enqueueWriteRequest(DiskManagerWriteRequest diskManagerWriteRequest, DiskManagerWriteRequestListener diskManagerWriteRequestListener) {
        throw new RuntimeException("enqueueWriteRequest not implemented");
    }

    public boolean hasOutstandingWriteRequestForPiece(int n) {
        throw new RuntimeException("hasOutstandingWriteRequestForPiece not implemented");
    }

    public boolean hasOutstandingReadRequestForPiece(int n) {
        throw new RuntimeException("hasOutstandingReadRequestForPiece not implemented");
    }

    public boolean hasOutstandingCheckRequestForPiece(int n) {
        throw new RuntimeException("hasOutstandingCheckRequestForPiece not implemented");
    }

    public DirectByteBuffer readBlock(int n, int n2, int n3) {
        return this.reader.readBlock(n, n2, n3);
    }

    public DiskManagerReadRequest createReadRequest(int n, int n2, int n3) {
        return this.reader.createReadRequest(n, n2, n3);
    }

    public void enqueueReadRequest(DiskManagerReadRequest diskManagerReadRequest, DiskManagerReadRequestListener diskManagerReadRequestListener) {
        this.reader.readBlock(diskManagerReadRequest, diskManagerReadRequestListener);
    }

    public DiskManagerCheckRequest createCheckRequest(int n, Object object) {
        DMChecker dMChecker = this.getChecker();
        return dMChecker.createCheckRequest(n, object);
    }

    public void enqueueCheckRequest(DiskManagerCheckRequest diskManagerCheckRequest, DiskManagerCheckRequestListener diskManagerCheckRequestListener) {
        DMChecker dMChecker = this.getChecker();
        dMChecker.enqueueCheckRequest(diskManagerCheckRequest, diskManagerCheckRequestListener);
    }

    public void enqueueCompleteRecheckRequest(DiskManagerCheckRequest diskManagerCheckRequest, DiskManagerCheckRequestListener diskManagerCheckRequestListener) {
        throw new RuntimeException("enqueueCompleteRecheckRequest not implemented");
    }

    public void setPieceCheckingEnabled(boolean bl) {
    }

    public void saveResumeData(boolean bl) {
    }

    public DiskManagerPiece[] getPieces() {
        return this.pieces;
    }

    public DiskManagerPiece getPiece(int n) {
        return this.pieces[n];
    }

    public boolean isInteresting(int n) {
        return false;
    }

    public boolean isDone(int n) {
        return false;
    }

    public int getNbPieces() {
        return this.pieces.length;
    }

    public DiskManagerFileInfo[] getFiles() {
        return this.files;
    }

    public DiskManagerFileInfoSet getFileSet() {
        throw new RuntimeException("getFileSet not implemented");
    }

    public int getState() {
        return this.state;
    }

    public long getTotalLength() {
        return this.piece_mapper.getTotalLength();
    }

    public int getPieceLength() {
        return this.piece_mapper.getPieceLength();
    }

    public int getPieceLength(int n) {
        if (n == this.pieces.length - 1) {
            return this.piece_mapper.getLastPieceLength();
        }
        return this.piece_mapper.getPieceLength();
    }

    public int getLastPieceLength() {
        return this.piece_mapper.getLastPieceLength();
    }

    public long getRemaining() {
        return 0L;
    }

    public long getRemainingExcludingDND() {
        return 0L;
    }

    public int getPercentDone() {
        return 100;
    }

    public String getErrorMessage() {
        return this.error_message;
    }

    public void downloadEnded() {
    }

    public void moveDataFiles(File file) {
        throw new RuntimeException("moveDataFiles not implemented");
    }

    public void moveDataFiles(File file, String string) {
        throw new RuntimeException("moveDataFiles not implemented");
    }

    public int getCompleteRecheckStatus() {
        return -1;
    }

    public boolean checkBlockConsistencyForWrite(String string, int n, int n2, DirectByteBuffer directByteBuffer) {
        long l = n * this.piece_mapper.getPieceLength() + n2 + directByteBuffer.remaining((byte)1);
        return l <= this.piece_mapper.getTotalLength();
    }

    public boolean checkBlockConsistencyForRead(String string, int n, int n2, int n3) {
        return DiskManagerUtil.checkBlockConsistencyForRead(this, string, n, n2, n3);
    }

    public boolean checkBlockConsistencyForHint(String string, int n, int n2, int n3) {
        return DiskManagerUtil.checkBlockConsistencyForHint(this, string, n, n2, n3);
    }

    public void addListener(DiskManagerListener diskManagerListener) {
    }

    public void removeListener(DiskManagerListener diskManagerListener) {
    }

    public boolean hasListener(DiskManagerListener diskManagerListener) {
        return false;
    }

    public void saveState() {
    }

    public DiskAccessController getDiskAccessController() {
        return this.disk_access_controller;
    }

    public DMPieceMap getPieceMap() {
        DMPieceMap dMPieceMap = this.piece_map_use_accessor;
        if (dMPieceMap == null) {
            this.piece_map_use_accessor = dMPieceMap = this.piece_mapper.getPieceMap();
        }
        return dMPieceMap;
    }

    public DMPieceList getPieceList(int n) {
        DMPieceMap dMPieceMap = this.getPieceMap();
        return dMPieceMap.getPieceList(n);
    }

    protected DMChecker getChecker() {
        DMChecker dMChecker = this.checker_use_accessor;
        if (dMChecker == null) {
            dMChecker = this.checker_use_accessor = DMAccessFactory.createChecker(this);
        }
        return dMChecker;
    }

    public byte[] getPieceHash(int n) throws TOTorrentException {
        return this.lws.getTorrent().getPieces()[n];
    }

    public DiskManagerRecheckScheduler getRecheckScheduler() {
        throw new RuntimeException("getPieceHash not implemented");
    }

    public void downloadRemoved() {
    }

    public void setFailed(String string) {
        this.state = 10;
        this.error_message = string;
    }

    public void setFailed(DiskManagerFileInfo diskManagerFileInfo, String string) {
        this.state = 10;
        this.error_message = string;
    }

    public long getAllocated() {
        return 0L;
    }

    public void setAllocated(long l) {
    }

    public void setPercentDone(int n) {
    }

    public TOTorrent getTorrent() {
        return this.lws.getTOTorrent(false);
    }

    public String[] getStorageTypes() {
        throw new RuntimeException("getStorageTypes not implemented");
    }

    public String getStorageType(int n) {
        throw new RuntimeException("getStorageType not implemented");
    }

    public void accessModeChanged(DiskManagerFileInfoImpl diskManagerFileInfoImpl, int n, int n2) {
    }

    public void skippedFileSetChanged(DiskManagerFileInfo diskManagerFileInfo) {
    }

    public void priorityChanged(DiskManagerFileInfo diskManagerFileInfo) {
    }

    public File getSaveLocation() {
        return this.save_file;
    }

    public String getInternalName() {
        return this.internal_name;
    }

    public DownloadManagerState getDownloadState() {
        return this.download_state;
    }

    public void generateEvidence(IndentWriter indentWriter) {
    }

    protected static class sePiece
    implements DiskManagerPiece {
        protected sePiece() {
        }

        public void clearChecking() {
            throw new RuntimeException("clearChecking not implemented");
        }

        public boolean isNeedsCheck() {
            throw new RuntimeException("isNeedsCheck not implemented");
        }

        public int getLength() {
            throw new RuntimeException("getLength not implemented");
        }

        public int getNbBlocks() {
            throw new RuntimeException("getNbBlocks not implemented");
        }

        public int getPieceNumber() {
            throw new RuntimeException("getPieceNumber not implemented");
        }

        public int getBlockSize(int n) {
            throw new RuntimeException("getBlockSize not implemented");
        }

        public boolean isWritten() {
            throw new RuntimeException("isWritten not implemented");
        }

        public int getNbWritten() {
            throw new RuntimeException("getNbWritten not implemented");
        }

        public boolean[] getWritten() {
            throw new RuntimeException("getWritten not implemented");
        }

        public void reDownloadBlock(int n) {
            throw new RuntimeException("reDownloadBlock not implemented");
        }

        public void reset() {
            throw new RuntimeException("reset not implemented");
        }

        public boolean isDownloadable() {
            return false;
        }

        public void setDownloadable() {
            throw new RuntimeException("setRequestable not implemented");
        }

        public DiskManager getManager() {
            throw new RuntimeException("getManager not implemented");
        }

        public boolean calcNeeded() {
            throw new RuntimeException("calcNeeded not implemented");
        }

        public void clearNeeded() {
            throw new RuntimeException("clearNeeded not implemented");
        }

        public boolean isNeeded() {
            throw new RuntimeException("isNeeded not implemented");
        }

        public void setNeeded() {
            throw new RuntimeException("setNeeded not implemented");
        }

        public void setNeeded(boolean bl) {
            throw new RuntimeException("setNeeded not implemented");
        }

        public void setWritten(int n) {
            throw new RuntimeException("setWritten not implemented");
        }

        public boolean isWritten(int n) {
            throw new RuntimeException("isWritten not implemented");
        }

        public boolean calcChecking() {
            throw new RuntimeException("calcChecking not implemented");
        }

        public boolean isChecking() {
            return false;
        }

        public void setChecking() {
            throw new RuntimeException("setChecking not implemented");
        }

        public void setChecking(boolean bl) {
            throw new RuntimeException("setChecking not implemented");
        }

        public boolean calcDone() {
            throw new RuntimeException("calcDone not implemented");
        }

        public boolean isDone() {
            return true;
        }

        public boolean isInteresting() {
            return false;
        }

        public boolean isSkipped() {
            return false;
        }

        public String getString() {
            return "";
        }

        public short getReadCount() {
            return 0;
        }

        public void setReadCount(short s) {
        }

        public void setDone(boolean bl) {
            if (!bl) {
                Debug.out("Piece failed recheck");
            }
        }
    }
}

