/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.lws;

import com.aelitis.azureus.core.lws.LightWeightSeed;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncer;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.disk.DiskManager;
import org.gudy.azureus2.plugins.disk.DiskManagerFileInfo;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadActivationEvent;
import org.gudy.azureus2.plugins.download.DownloadActivationListener;
import org.gudy.azureus2.plugins.download.DownloadAnnounceResult;
import org.gudy.azureus2.plugins.download.DownloadAttributeListener;
import org.gudy.azureus2.plugins.download.DownloadCompletionListener;
import org.gudy.azureus2.plugins.download.DownloadException;
import org.gudy.azureus2.plugins.download.DownloadListener;
import org.gudy.azureus2.plugins.download.DownloadPeerListener;
import org.gudy.azureus2.plugins.download.DownloadPropertyListener;
import org.gudy.azureus2.plugins.download.DownloadRemovalVetoException;
import org.gudy.azureus2.plugins.download.DownloadScrapeResult;
import org.gudy.azureus2.plugins.download.DownloadStats;
import org.gudy.azureus2.plugins.download.DownloadTrackerListener;
import org.gudy.azureus2.plugins.download.DownloadWillBeRemovedListener;
import org.gudy.azureus2.plugins.download.savelocation.SaveLocationChange;
import org.gudy.azureus2.plugins.peers.PeerManager;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.torrent.TorrentAttribute;
import org.gudy.azureus2.plugins.torrent.TorrentManager;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.pluginsimpl.local.download.DownloadAnnounceResultImpl;

public class LWSDownload
implements Download {
    private LightWeightSeed lws;
    private TRTrackerAnnouncer announcer;
    private DownloadAnnounceResultImpl announce_result;
    private Map user_data = new HashMap();
    private Map torrent_attributes = new HashMap();
    private DownloadScrapeResult scrape_result = new DownloadScrapeResult(){

        public Download getDownload() {
            return LWSDownload.this;
        }

        public int getResponseType() {
            return LWSDownload.this.announce_result.getResponseType() == 1 ? 1 : 2;
        }

        public int getSeedCount() {
            return LWSDownload.this.announce_result.getSeedCount();
        }

        public int getNonSeedCount() {
            int n = this.getSeedCount();
            int n2 = LWSDownload.this.announce_result.getReportedPeerCount();
            int n3 = n2 - n;
            int n4 = LWSDownload.this.announce_result.getNonSeedCount();
            if (n4 < n3) {
                n4 = n3;
            }
            return n4;
        }

        public long getScrapeStartTime() {
            return 0L;
        }

        public void setNextScrapeStartTime(long l) {
        }

        public long getNextScrapeStartTime() {
            return 0L;
        }

        public String getStatus() {
            if (this.getResponseType() == 1) {
                return "OK";
            }
            return LWSDownload.this.announce_result.getError();
        }

        public URL getURL() {
            return LWSDownload.this.announce_result.getURL();
        }
    };

    protected LWSDownload(LightWeightSeed lightWeightSeed, TRTrackerAnnouncer tRTrackerAnnouncer) {
        this.lws = lightWeightSeed;
        this.announcer = tRTrackerAnnouncer;
        this.announce_result = new DownloadAnnounceResultImpl(this, this.announcer.getLastResponse());
    }

    public int getState() {
        return 5;
    }

    public int getSubState() {
        return 5;
    }

    public String getErrorStateDetails() {
        return "";
    }

    public void setFlag(long l, boolean bl) {
        this.notSupported();
    }

    public boolean getFlag(long l) {
        return false;
    }

    public long getFlags() {
        return 0L;
    }

    public int getIndex() {
        return 0;
    }

    public File[] calculateDefaultPaths(boolean bl) {
        return new File[2];
    }

    public SaveLocationChange calculateDefaultDownloadLocation() {
        return null;
    }

    public boolean isInDefaultSaveDir() {
        return false;
    }

    public Torrent getTorrent() {
        return this.lws.getTorrent();
    }

    public void initialize() throws DownloadException {
    }

    public void start() throws DownloadException {
    }

    public void startDownload(boolean bl) {
    }

    public void stopDownload() {
    }

    public void stop() throws DownloadException {
    }

    public void stopAndQueue() throws DownloadException {
    }

    public void restart() throws DownloadException {
    }

    public void pause() {
    }

    public void resume() {
    }

    public void recheckData() throws DownloadException {
    }

    public boolean isStartStopLocked() {
        return false;
    }

    public boolean isForceStart() {
        return true;
    }

    public void setForceStart(boolean bl) {
    }

    public int getPriority() {
        return 0;
    }

    public void setPriority(int n) {
    }

    public boolean isPriorityLocked() {
        return false;
    }

    public boolean isPaused() {
        return false;
    }

    public String getName() {
        return this.lws.getName();
    }

    public String getTorrentFileName() {
        return this.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAttribute(TorrentAttribute torrentAttribute) {
        Map map = this.torrent_attributes;
        synchronized (map) {
            return (String)this.torrent_attributes.get(torrentAttribute);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(TorrentAttribute torrentAttribute, String string) {
        Map map = this.torrent_attributes;
        synchronized (map) {
            this.torrent_attributes.put(torrentAttribute, string);
        }
    }

    public String[] getListAttribute(TorrentAttribute torrentAttribute) {
        TorrentManager torrentManager = PluginInitializer.getDefaultInterface().getTorrentManager();
        if (torrentAttribute == torrentManager.getAttribute("Networks")) {
            return new String[]{"Public"};
        }
        if (torrentAttribute == torrentManager.getAttribute("PeerSources")) {
            return new String[]{"DHT"};
        }
        return null;
    }

    public void setListAttribute(TorrentAttribute torrentAttribute, String[] stringArray) {
        this.notSupported();
    }

    public void setMapAttribute(TorrentAttribute torrentAttribute, Map map) {
        this.notSupported();
    }

    public Map getMapAttribute(TorrentAttribute torrentAttribute) {
        return null;
    }

    public void setIntAttribute(TorrentAttribute torrentAttribute, int n) {
        this.notSupported();
    }

    public int getIntAttribute(TorrentAttribute torrentAttribute) {
        return 0;
    }

    public void setLongAttribute(TorrentAttribute torrentAttribute, long l) {
        this.notSupported();
    }

    public long getLongAttribute(TorrentAttribute torrentAttribute) {
        return 0L;
    }

    public void setBooleanAttribute(TorrentAttribute torrentAttribute, boolean bl) {
        this.notSupported();
    }

    public boolean getBooleanAttribute(TorrentAttribute torrentAttribute) {
        return false;
    }

    public boolean hasAttribute(TorrentAttribute torrentAttribute) {
        return false;
    }

    public void addAttributeListener(DownloadAttributeListener downloadAttributeListener, TorrentAttribute torrentAttribute, int n) {
    }

    public void removeAttributeListener(DownloadAttributeListener downloadAttributeListener, TorrentAttribute torrentAttribute, int n) {
    }

    public String getCategoryName() {
        return null;
    }

    public void setCategory(String string) {
        this.notSupported();
    }

    public void remove() throws DownloadException, DownloadRemovalVetoException {
        throw new DownloadRemovalVetoException("no way");
    }

    public void remove(boolean bl, boolean bl2) throws DownloadException, DownloadRemovalVetoException {
        throw new DownloadRemovalVetoException("no way");
    }

    public boolean isRemoved() {
        return false;
    }

    public int getPosition() {
        return 0;
    }

    public long getCreationTime() {
        return 0L;
    }

    public void setPosition(int n) {
        this.notSupported();
    }

    public void moveUp() {
        this.notSupported();
    }

    public void moveDown() {
        this.notSupported();
    }

    public void moveTo(int n) {
        this.notSupported();
    }

    public boolean canBeRemoved() throws DownloadRemovalVetoException {
        throw new DownloadRemovalVetoException("no way");
    }

    public void setAnnounceResult(DownloadAnnounceResult downloadAnnounceResult) {
        this.announcer.setAnnounceResult(downloadAnnounceResult);
    }

    public void setScrapeResult(DownloadScrapeResult downloadScrapeResult) {
    }

    public DownloadAnnounceResult getLastAnnounceResult() {
        this.announce_result.setContent(this.announcer.getLastResponse());
        return this.announce_result;
    }

    public DownloadScrapeResult getLastScrapeResult() {
        this.announce_result.setContent(this.announcer.getLastResponse());
        return this.scrape_result;
    }

    public DownloadActivationEvent getActivationState() {
        return null;
    }

    public DownloadStats getStats() {
        return null;
    }

    public boolean isPersistent() {
        return false;
    }

    public void setMaximumDownloadKBPerSecond(int n) {
        this.notSupported();
    }

    public int getMaximumDownloadKBPerSecond() {
        return 0;
    }

    public int getUploadRateLimitBytesPerSecond() {
        return 0;
    }

    public void setUploadRateLimitBytesPerSecond(int n) {
        this.notSupported();
    }

    public int getDownloadRateLimitBytesPerSecond() {
        return 0;
    }

    public void setDownloadRateLimitBytesPerSecond(int n) {
        this.notSupported();
    }

    public boolean isComplete() {
        return true;
    }

    public boolean isComplete(boolean bl) {
        return true;
    }

    public boolean isChecking() {
        return false;
    }

    public String getSavePath() {
        return "";
    }

    public void moveDataFiles(File file) throws DownloadException {
        this.notSupported();
    }

    public boolean canMoveDataFiles() {
        return false;
    }

    public void moveTorrentFile(File file) throws DownloadException {
        this.notSupported();
    }

    public void renameDownload(String string) throws DownloadException {
        this.notSupported();
    }

    public PeerManager getPeerManager() {
        return null;
    }

    public DiskManager getDiskManager() {
        return null;
    }

    public DiskManagerFileInfo[] getDiskManagerFileInfo() {
        return null;
    }

    public void requestTrackerAnnounce() {
    }

    public void requestTrackerAnnounce(boolean bl) {
    }

    public void requestTrackerScrape(boolean bl) {
    }

    public void addListener(DownloadListener downloadListener2) {
    }

    public void removeListener(DownloadListener downloadListener2) {
    }

    public void addCompletionListener(DownloadCompletionListener downloadCompletionListener) {
        this.notSupported();
    }

    public void removeCompletionListener(DownloadCompletionListener downloadCompletionListener) {
        this.notSupported();
    }

    public void addTrackerListener(DownloadTrackerListener downloadTrackerListener) {
    }

    public void addTrackerListener(DownloadTrackerListener downloadTrackerListener, boolean bl) {
    }

    public void removeTrackerListener(DownloadTrackerListener downloadTrackerListener) {
    }

    public void addDownloadWillBeRemovedListener(DownloadWillBeRemovedListener downloadWillBeRemovedListener) {
        this.notSupported();
    }

    public void removeDownloadWillBeRemovedListener(DownloadWillBeRemovedListener downloadWillBeRemovedListener) {
        this.notSupported();
    }

    public void addActivationListener(DownloadActivationListener downloadActivationListener) {
        this.notSupported();
    }

    public void removeActivationListener(DownloadActivationListener downloadActivationListener) {
        this.notSupported();
    }

    public void addPeerListener(DownloadPeerListener downloadPeerListener) {
        this.notSupported();
    }

    public void removePeerListener(DownloadPeerListener downloadPeerListener) {
        this.notSupported();
    }

    public int getSeedingRank() {
        return 0;
    }

    public void setSeedingRank(int n) {
        this.notSupported();
    }

    public void addPropertyListener(DownloadPropertyListener downloadPropertyListener) {
        this.notSupported();
    }

    public void removePropertyListener(DownloadPropertyListener downloadPropertyListener) {
        this.notSupported();
    }

    public byte[] getDownloadPeerId() {
        return null;
    }

    public boolean isMessagingEnabled() {
        return true;
    }

    public void setMessagingEnabled(boolean bl) {
    }

    public void moveDataFiles(File file, String string) throws DownloadException {
        this.notSupported();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getUserData(Object object) {
        Map map = this.user_data;
        synchronized (map) {
            return this.user_data.get(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUserData(Object object, Object object2) {
        Map map = this.user_data;
        synchronized (map) {
            this.user_data.put(object, object2);
        }
    }

    public void changeLocation(SaveLocationChange saveLocationChange) throws DownloadException {
        this.notSupported();
    }

    protected void notSupported() {
        Debug.out("Not Supported");
    }
}

