/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.messenger.browser;

import com.aelitis.azureus.core.messenger.browser.listeners.MessageCompletionListener;
import com.aelitis.azureus.util.ConstantsVuze;
import com.aelitis.azureus.util.JSONUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsLogger;
import org.gudy.azureus2.core3.util.Debug;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrowserMessage {
    public static final String MESSAGE_PREFIX = "AZMSG";
    public static final String MESSAGE_DELIM = ";";
    public static String MESSAGE_DELIM_ENCODED;
    public static final int NO_PARAM = 0;
    public static final int OBJECT_PARAM = 1;
    public static final int ARRAY_PARAM = 2;
    static int seqFake;
    private int sequence;
    private String listenerId;
    private String operationId;
    private String params;
    private int paramType;
    private Object decodedParams;
    private String sFullMessage;
    private ArrayList completionListeners = new ArrayList();
    private boolean completed;
    private boolean completeDelayed;
    private String referer;

    public BrowserMessage(String string) {
        if (string == null) {
            throw new IllegalArgumentException("event must be non-null");
        }
        this.sFullMessage = string;
        this.parse();
    }

    public BrowserMessage(String string, String string2, Map<?, ?> map) {
        this.listenerId = string;
        this.operationId = string2;
        this.paramType = 1;
        this.decodedParams = map;
        this.sequence = -1;
    }

    public void addCompletionListener(MessageCompletionListener messageCompletionListener) {
        this.completionListeners.add(messageCompletionListener);
    }

    public void complete(boolean bl, boolean bl2, Object object) {
        if (this.completed || bl && this.completeDelayed) {
            return;
        }
        this.triggerCompletionListeners(bl2, object);
        this.completed = true;
    }

    public void debug(String string) {
        this.debug(string, null);
    }

    public void debug(String string, Throwable throwable) {
        try {
            AEDiagnosticsLogger aEDiagnosticsLogger = AEDiagnostics.getLogger("v3.CMsgr");
            String string2 = "[" + this.getListenerId() + ":" + this.getOperationId() + "] " + string;
            aEDiagnosticsLogger.log(string2);
            if (throwable != null) {
                aEDiagnosticsLogger.log(throwable);
            }
            if (ConstantsVuze.DIAG_TO_STDOUT) {
                System.out.println(string2);
                if (throwable != null) {
                    throwable.printStackTrace();
                }
            }
        }
        catch (Throwable throwable2) {
            Debug.out(throwable2);
        }
    }

    public List getDecodedArray() {
        if (!this.isParamArray()) {
            throw new IllegalStateException("Decoded parameter is not a List");
        }
        return (List)this.decodedParams;
    }

    public Map getDecodedMap() {
        if (!this.isParamObject()) {
            throw new IllegalStateException("Decoded parameter is not a Map");
        }
        return (Map)this.decodedParams;
    }

    public String getListenerId() {
        return this.listenerId;
    }

    public String getOperationId() {
        return this.operationId;
    }

    public String getReferer() {
        return this.referer;
    }

    public int getSequence() {
        return this.sequence;
    }

    public boolean isParamArray() {
        return this.paramType == 2;
    }

    public boolean isParamObject() {
        return this.paramType == 1;
    }

    protected void parse() {
        String string = this.sFullMessage;
        int n = string.indexOf(MESSAGE_DELIM);
        if (n == -1) {
            throw new IllegalArgumentException("Message has no delimeters: " + string);
        }
        if (n == string.length() - 1) {
            throw new IllegalArgumentException("Message has no sequence number: " + string);
        }
        int n2 = string.indexOf(MESSAGE_DELIM, n + 1);
        if (n2 == -1 || n2 == string.length() - 1) {
            throw new IllegalArgumentException("Message has no listener ID: " + string);
        }
        try {
            this.sequence = Integer.parseInt(string.substring(n + 1, n2));
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println("Plese put the throw back in once souk fixes the seq # bug");
            this.sequence = seqFake++;
        }
        int n3 = string.indexOf(MESSAGE_DELIM, n2 + 1);
        if (n3 == -1 || n3 == string.length() - 1) {
            throw new IllegalArgumentException("Message has no operation ID: " + string);
        }
        this.listenerId = string.substring(n2 + 1, n3);
        int n4 = string.indexOf(MESSAGE_DELIM, n3 + 1);
        if (n4 == -1) {
            this.operationId = string.substring(n3 + 1);
        } else if (n4 == string.length() - 1) {
            this.operationId = string.substring(n3 + 1, n4);
            this.params = null;
            this.paramType = 0;
            this.decodedParams = null;
        } else {
            this.operationId = string.substring(n3 + 1, n4);
            this.params = string.substring(n4 + 1);
            char c = this.params.charAt(0);
            try {
                switch (c) {
                    case '{': {
                        this.paramType = 1;
                        this.decodedParams = JSONUtils.decodeJSON(this.params);
                        break;
                    }
                    case '[': {
                        this.paramType = 2;
                        Map map = JSONUtils.decodeJSON(this.params);
                        this.decodedParams = map != null ? map.get("value") : null;
                    }
                }
            }
            catch (Exception exception) {
                this.decodedParams = null;
            }
            if (this.decodedParams == null) {
                this.paramType = 0;
            }
        }
    }

    public void removeCompletionListener(MessageCompletionListener messageCompletionListener) {
        this.completionListeners.remove(messageCompletionListener);
    }

    public void setCompleteDelayed(boolean bl) {
        this.completeDelayed = bl;
    }

    public void setReferer(String string) {
        this.referer = string;
    }

    public String toString() {
        return "[" + this.sequence + "] " + this.listenerId + "." + this.operationId + "(" + (this.params == null ? this.decodedParams : this.params) + ")";
    }

    private void triggerCompletionListeners(boolean bl, Object object) {
        for (MessageCompletionListener messageCompletionListener : this.completionListeners) {
            try {
                messageCompletionListener.completed(bl, object);
            }
            catch (Throwable throwable) {
                Debug.out(throwable);
            }
        }
    }

    static {
        try {
            MESSAGE_DELIM_ENCODED = URLEncoder.encode(MESSAGE_DELIM, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            MESSAGE_DELIM_ENCODED = MESSAGE_DELIM;
        }
        seqFake = 1;
    }
}

