/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.messenger.config;

import com.aelitis.azureus.core.messenger.PlatformMessenger;
import com.aelitis.azureus.core.messenger.PlatformMessengerException;
import com.aelitis.azureus.core.messenger.config.PlatformMessengerConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PlatformMetaSearchMessenger {
    private static final int MAX_TEMPLATE_LIST = 512;
    private static final PlatformMessengerConfig dispatcher = new PlatformMessengerConfig("searchtemplate", true);
    private static final String OP_GET_TEMPLATE = "get-template";
    private static final String OP_GET_TEMPLATES = "get-templates";
    private static final String OP_LIST_POPULAR_TEMPLATES = "list-popular";
    private static final String OP_LIST_FEATURED_TEMPLATES = "list-featured";
    private static final String OP_TEMPLATE_SELECTED = "template-selected";

    public static templateDetails getTemplate(long l) throws PlatformMessengerException {
        int n;
        Map map = dispatcher.syncInvoke(OP_GET_TEMPLATE, PlatformMetaSearchMessenger.getParameter(l));
        templateInfo templateInfo2 = PlatformMetaSearchMessenger.getTemplateInfo(map);
        if (templateInfo2 == null) {
            throw new PlatformMessengerException("Invalid reply: " + map);
        }
        String string = (String)map.get("name");
        String string2 = (String)map.get("value");
        String string3 = (String)map.get("engine_id");
        if (string == null || string2 == null || string3 == null) {
            throw new PlatformMessengerException("Invalid reply; field missing: " + map);
        }
        if (string3.equals("json")) {
            n = 1;
        } else if (string3.equals("regexp")) {
            n = 2;
        } else {
            throw new PlatformMessengerException("Invalid type '" + string3 + ": " + map);
        }
        return new templateDetails(templateInfo2, n, string, string2);
    }

    public static templateInfo[] getTemplateDetails(long[] lArray) throws PlatformMessengerException {
        if (lArray.length == 0) {
            return new templateInfo[0];
        }
        String string = "";
        for (int i = 0; i < lArray.length; ++i) {
            string = string + (i == 0 ? "" : ",") + lArray[i];
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("templateIds", string);
        Map map = dispatcher.syncInvoke(OP_GET_TEMPLATES, hashMap);
        return PlatformMetaSearchMessenger.getTemplatesInfo(map);
    }

    public static templateInfo[] listTopPopularTemplates() throws PlatformMessengerException {
        HashMap hashMap = new HashMap();
        Map map = dispatcher.syncInvoke(OP_LIST_POPULAR_TEMPLATES, hashMap);
        return PlatformMetaSearchMessenger.getTemplatesInfo(map);
    }

    public static templateInfo[] listAllPopularTemplates() throws PlatformMessengerException {
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        hashMap.put("page-num", new Long(1L));
        hashMap.put("items-per-page", new Long(512L));
        Map map = dispatcher.syncInvoke(OP_LIST_POPULAR_TEMPLATES, hashMap);
        return PlatformMetaSearchMessenger.getTemplatesInfo(map);
    }

    public static templateInfo[] listFeaturedTemplates() throws PlatformMessengerException {
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        hashMap.put("page-num", new Long(1L));
        hashMap.put("items-per-page", new Long(512L));
        Map map = dispatcher.syncInvoke(OP_LIST_FEATURED_TEMPLATES, hashMap);
        return PlatformMetaSearchMessenger.getTemplatesInfo(map);
    }

    protected static templateInfo[] getTemplatesInfo(Map map) {
        List list = (List)map.get("templates");
        ArrayList<templateInfo> arrayList = new ArrayList<templateInfo>();
        for (int i = 0; i < list.size(); ++i) {
            Map map2 = (Map)list.get(i);
            templateInfo templateInfo2 = PlatformMetaSearchMessenger.getTemplateInfo(map2);
            if (templateInfo2 == null) continue;
            arrayList.add(templateInfo2);
        }
        templateInfo[] templateInfoArray = new templateInfo[arrayList.size()];
        arrayList.toArray(templateInfoArray);
        return templateInfoArray;
    }

    protected static templateInfo getTemplateInfo(Map map) {
        Long l = (Long)map.get("id");
        Boolean bl = (Boolean)map.get("show");
        Long l2 = (Long)map.get("modified_dt");
        if (bl == null) {
            bl = new Boolean(true);
        }
        if (l != null && bl != null && l2 != null) {
            return new templateInfo(l, l2, bl);
        }
        PlatformMessenger.debug("field missing from template info (" + map + ")");
        return null;
    }

    public static void setTemplatetSelected(long l, String string, boolean bl) throws PlatformMessengerException {
        Map map = PlatformMetaSearchMessenger.getParameter(l);
        map.put("userId", string);
        map.put("selected", new Boolean(bl));
        dispatcher.syncInvoke(OP_TEMPLATE_SELECTED, map);
    }

    protected static Map getParameter(long l) {
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        hashMap.put("templateId", new Long(l));
        return hashMap;
    }

    public static class templateDetails {
        public static final int ENGINE_TYPE_JSON = 1;
        public static final int ENGINE_TYPE_REGEXP = 2;
        private templateInfo info;
        private int type;
        private String name;
        private String value;

        protected templateDetails(templateInfo templateInfo2, int n, String string, String string2) {
            this.info = templateInfo2;
            this.type = n;
            this.name = string;
            this.value = string2;
        }

        public int getType() {
            return this.type;
        }

        public long getId() {
            return this.info.getId();
        }

        public long getModifiedDate() {
            return this.info.getModifiedDate();
        }

        public boolean isVisible() {
            return this.info.isVisible();
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static class templateInfo {
        private long id;
        private long date;
        private boolean visible;

        protected templateInfo(long l, long l2, boolean bl) {
            this.id = l;
            this.date = l2;
            this.visible = bl;
        }

        public long getId() {
            return this.id;
        }

        public long getModifiedDate() {
            return this.date;
        }

        public boolean isVisible() {
            return this.visible;
        }
    }
}

