/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.metasearch;

import com.aelitis.azureus.core.metasearch.Result;
import com.aelitis.azureus.core.metasearch.ResultListener;
import com.aelitis.azureus.core.metasearch.SearchException;
import com.aelitis.azureus.core.metasearch.SearchParameter;
import java.io.File;
import java.io.IOException;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface Engine {
    public static final int AZ_VERSION = 1;
    public static final Object VUZE_FILE_COMPONENT_ENGINE_KEY = new Object();
    public static final int FIELD_NAME = 1;
    public static final int FIELD_DATE = 2;
    public static final int FIELD_SIZE = 3;
    public static final int FIELD_PEERS = 4;
    public static final int FIELD_SEEDS = 5;
    public static final int FIELD_CATEGORY = 6;
    public static final int FIELD_COMMENTS = 7;
    public static final int FIELD_CONTENT_TYPE = 8;
    public static final int FIELD_DISCARD = 9;
    public static final int FIELD_VOTES = 10;
    public static final int FIELD_SUPERSEEDS = 11;
    public static final int FIELD_PRIVATE = 12;
    public static final int FIELD_DRMKEY = 13;
    public static final int FIELD_VOTES_DOWN = 14;
    public static final int FIELD_TORRENTLINK = 102;
    public static final int FIELD_CDPLINK = 103;
    public static final int FIELD_PLAYLINK = 104;
    public static final int FIELD_DOWNLOADBTNLINK = 105;
    public static final int[] FIELD_IDS = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 102, 103, 104, 105, 10, 11, 12, 13, 14};
    public static final String[] FIELD_NAMES = new String[]{"TITLE", "DATE", "SIZE", "PEERS", "SEEDS", "CAT", "COMMENTS", "CONTENT_TYPE", "DISCARD", "TORRENT", "CDP", "PLAY", "DLBTN", "VOTES", "XSEEDS", "PRIVATE", "DRMKEY", "VOTESDOWN"};
    public static final int ENGINE_TYPE_REGEX = 1;
    public static final int ENGINE_TYPE_JSON = 2;
    public static final int ENGINE_TYPE_PLUGIN = 3;
    public static final int ENGINE_TYPE_RSS = 4;
    public static final int ENGINE_SOURCE_UNKNOWN = 0;
    public static final int ENGINE_SOURCE_VUZE = 1;
    public static final int ENGINE_SOURCE_LOCAL = 2;
    public static final int ENGINE_SOURCE_RSS = 3;
    public static final int SEL_STATE_DESELECTED = 0;
    public static final int SEL_STATE_AUTO_SELECTED = 1;
    public static final int SEL_STATE_MANUAL_SELECTED = 2;
    public static final int AUTO_DL_SUPPORTED_UNKNOWN = 0;
    public static final int AUTO_DL_SUPPORTED_YES = 1;
    public static final int AUTO_DL_SUPPORTED_NO = 2;
    public static final String[] ENGINE_SOURCE_STRS = new String[]{"unknown", "vuze", "local", "rss", "unused"};
    public static final String[] SEL_STATE_STRINGS = new String[]{"no", "auto", "manual"};
    public static final String[] ENGINE_TYPE_STRS = new String[]{"unknown", "regexp", "json", "plugin"};
    public static final String SC_SOURCE = "azsrc";
    public static final String SC_AZID = "azid";
    public static final String SC_FORCE_FULL = "force_full";
    public static final String SC_BATCH_PERIOD = "batch_millis";
    public static final String CT_VIDEO = "video";
    public static final String CT_AUDIO = "audio";
    public static final String CT_GAME = "game";

    public int getType();

    public Result[] search(SearchParameter[] var1, Map var2, int var3, int var4, String var5, ResultListener var6) throws SearchException;

    public String getName();

    public String getNameEx();

    public long getId();

    public String getUID();

    public int getVersion();

    public long getLastUpdated();

    public String getIcon();

    public String getDownloadLinkCSS();

    public boolean isActive();

    public boolean isMine();

    public boolean isPublic();

    public void setMine(boolean var1);

    public int getSelectionState();

    public void setSelectionState(int var1);

    public void recordSelectionState();

    public void checkSelectionStateRecorded();

    public int getSource();

    public void setSource(int var1);

    public String getReferer();

    public boolean supportsField(int var1);

    public boolean supportsContext(String var1);

    public boolean isShareable();

    public int getAutoDownloadSupported();

    public int getAZVersion();

    public Map<String, Object> exportToBencodedMap() throws IOException;

    public String exportToJSONString() throws IOException;

    public void exportToVuzeFile(File var1) throws IOException;

    public boolean sameLogicAs(Engine var1);

    public void reset();

    public void delete();

    public String getString();
}

