/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.metasearch;

import com.aelitis.azureus.core.metasearch.Engine;
import com.aelitis.azureus.core.metasearch.utils.MomentsAgoDateFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.json.simple.JSONObject;

public abstract class Result {
    private Engine engine;

    public abstract Date getPublishedDate();

    public abstract String getCategory();

    public abstract void setCategory(String var1);

    public abstract String getContentType();

    public abstract void setContentType(String var1);

    public abstract String getName();

    public abstract long getSize();

    public abstract int getNbPeers();

    public abstract int getNbSeeds();

    public abstract int getNbSuperSeeds();

    public abstract int getComments();

    public abstract int getVotes();

    public abstract int getVotesDown();

    public abstract boolean isPrivate();

    public abstract String getDRMKey();

    public abstract String getDownloadLink();

    public abstract String getDownloadButtonLink();

    public abstract String getCDPLink();

    public abstract String getPlayLink();

    public abstract float getAccuracy();

    public abstract String getSearchQuery();

    public abstract String getUID();

    public abstract String getHash();

    protected Result(Engine engine) {
        this.engine = engine;
    }

    public Engine getEngine() {
        return this.engine;
    }

    public String toString() {
        return this.getName() + " : " + this.getNbSeeds() + " s, " + this.getNbPeers() + "p, ";
    }

    public float getRank() {
        float f;
        int n;
        int n2;
        int n3 = this.getNbSeeds();
        int n4 = this.getNbPeers();
        if (n3 < 0) {
            n3 = 0;
        }
        if (n4 < 0) {
            n4 = 0;
        }
        int n5 = 3 * n3 + n4 + 2;
        int n6 = this.getNbSuperSeeds();
        if (n6 > 0) {
            n5 += 50 * n6;
        }
        if ((n2 = this.getVotes()) > 0) {
            n5 += 10 * n2;
        }
        if ((n = this.getVotesDown()) > 0) {
            n5 -= 200 * n;
        }
        if (n5 < 2) {
            n5 = 2;
        }
        if ((f = (float)(Math.log(n5) / Math.log(10.0)) / 5.0f) > 2.0f) {
            f = 2.0f;
        }
        if (this.isPrivate()) {
            f /= 2.0f;
        }
        String string = this.getSearchQuery();
        String string2 = this.getName();
        if (string != null && string2 != null) {
            string2 = string2.toLowerCase(Locale.ENGLISH);
            String string3 = "";
            ArrayList<String> arrayList = new ArrayList<String>();
            char[] cArray = string.toCharArray();
            for (char c : cArray) {
                if (Character.isLetterOrDigit(c)) {
                    string3 = string3 + String.valueOf(c).toLowerCase(Locale.ENGLISH);
                    continue;
                }
                if (string3.length() <= 0) continue;
                arrayList.add(string3);
                string3 = "";
            }
            if (string3.length() > 0) {
                arrayList.add(string3);
            }
            Object object = arrayList.iterator();
            while (object.hasNext()) {
                String string4 = (String)object.next();
                if (string2.contains(string4)) continue;
                f /= 2.0f;
            }
        }
        if (f > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    public Map toJSONMap() {
        String string;
        String string2;
        long l;
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("d", MomentsAgoDateFormatter.getMomentsAgoString(this.getPublishedDate()));
            jSONObject.put("ts", "" + this.getPublishedDate().getTime());
        }
        catch (Exception exception) {
            jSONObject.put("d", "unknown");
            jSONObject.put("ts", "0");
        }
        jSONObject.put("c", this.getCategory());
        jSONObject.put("n", this.getName());
        int n = this.getNbSuperSeeds();
        int n2 = this.getNbSeeds();
        int n3 = -1;
        if (n > 0) {
            n3 = 10 * n + new Random().nextInt(10);
        }
        if (n2 > 0) {
            if (n3 == -1) {
                n3 = 0;
            }
            n3 += n2;
        }
        jSONObject.put("s", "" + n3);
        if (this.getNbPeers() >= 0) {
            jSONObject.put("p", "" + this.getNbPeers());
        } else {
            jSONObject.put("p", "-1");
        }
        int n4 = this.getComments();
        if (n4 >= 0) {
            jSONObject.put("co", "" + n4);
        }
        if ((l = this.getSize()) >= 0L) {
            String string3 = DisplayFormatters.formatByteCountToKiBEtc(l);
            string3 = DisplayFormatters.trimDigits(string3, 3);
            jSONObject.put("l", string3);
            jSONObject.put("lb", "" + l);
        } else {
            jSONObject.put("l", "-1");
            jSONObject.put("lb", "0");
        }
        jSONObject.put("r", "" + this.getRank());
        jSONObject.put("ct", this.getContentType());
        float f = this.getAccuracy();
        if (f >= 0.0f) {
            if (f > 1.0f) {
                f = 1.0f;
            }
            jSONObject.put("ac", "" + f);
        }
        if (this.getCDPLink().length() > 0) {
            jSONObject.put("cdp", this.getCDPLink());
        }
        if (this.getDownloadLink().length() > 0) {
            jSONObject.put("dl", this.getDownloadLink());
        }
        if (this.getDownloadButtonLink().length() > 0) {
            jSONObject.put("dbl", this.getDownloadButtonLink());
        }
        if (this.getPlayLink().length() > 0) {
            jSONObject.put("pl", this.getPlayLink());
        }
        if (this.getVotes() >= 0) {
            jSONObject.put("v", "" + this.getVotes());
        }
        if (this.getVotesDown() >= 0) {
            jSONObject.put("vd", "" + this.getVotesDown());
        }
        if ((string2 = this.getDRMKey()) != null) {
            jSONObject.put("dk", string2);
        }
        if ((string = this.getUID()) != null) {
            jSONObject.put("u", string);
        }
        jSONObject.put("pr", this.isPrivate() ? "1" : "0");
        String string4 = this.getHash();
        if (string4 != null) {
            jSONObject.put("h", string4);
        }
        return jSONObject;
    }

    public static void adjustRelativeTerms(Map map) {
        long l;
        String string = (String)map.get("ts");
        if (string != null && (l = Long.parseLong(string)) > 0L) {
            map.put("d", MomentsAgoDateFormatter.getMomentsAgoString(new Date(l)));
        }
    }
}

