/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.metasearch.impl;

import com.aelitis.azureus.core.metasearch.impl.DateParser;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DateParserRegex
extends DateParser {
    static boolean DEBUG = false;
    TimeZone timeZone;
    DateFormat userDateFormat;
    boolean auto;
    private static final Pattern hasLettersPattern = Pattern.compile("(?i).*[a-z]");
    private static final Pattern isAgeBasedPattern = Pattern.compile("(?i)(ago)|(min)|(hour)|(day)|(week)|(month)|(year)|([0-9](h|d|w|m|y))");
    private static final Pattern getTimeComponent = Pattern.compile("(?i)([0-9]{2}):([0-9]{2})(:([0-9]{2}))?( ?(a|p)m)?");
    private static final Pattern timeBasedDateWithLettersPattern = Pattern.compile("(?i)([0-9]{1,2})[^ ]{0,2}(?: |-)([a-z]{3,10})\\.?(?: |-)?([0-9]{2,4})?");
    private static final Pattern timeBasedDateWithLettersPatternMonthFirst = Pattern.compile("(?i)([a-z]{3,10})\\.?(?: |-)?([0-9]{1,2})[^ ]{0,2}(?: |-)([0-9]{2,4})?");
    private static final Pattern todayPattern = Pattern.compile("(?i)(t.?day)");
    private static final Pattern yesterdayPattern = Pattern.compile("(?i)(y[a-z\\-]+day)");
    private static final Pattern agoSpacerPattern = Pattern.compile("(?i)([0-9])([a-z])");
    private static final Pattern agoTimeRangePattern = Pattern.compile("(?i)([0-9.]+) ([a-z\\(\\)]+)");
    private static final Pattern numbersOnlyDatePattern = Pattern.compile("([0-9]{2,4})[ \\-\\./]([0-9]{2,4})[ \\-\\./]?([0-9]{2,4})?");
    private static final String[] MONTHS_LIST = new String[]{" january janvier enero januar", " february fevrier f\ufffdvrier febrero februar", " march mars marzo marz marz m\ufffdrz", " april avril abril april ", " may mai mayo mai", " june juin junio juni", " july juillet julio juli", " august aout ao\ufffdt agosto august", " september septembre septiembre september", " october octobre octubre oktober", " november novembre noviembre november", " december decembre d\ufffdcembre diciembre dezember"};

    public DateParserRegex() {
        this("GMT-7", true, null);
    }

    public DateParserRegex(String string, boolean bl, String string2) {
        this.timeZone = TimeZone.getTimeZone(string);
        this.auto = bl;
        if (!bl && string2 != null) {
            this.userDateFormat = new SimpleDateFormat(string2);
            this.userDateFormat.setTimeZone(this.timeZone);
        }
    }

    public Date parseDate(String string) {
        Date date = null;
        if (this.auto) {
            date = this.parseDateInternal(string);
        } else if (this.userDateFormat != null) {
            try {
                date = this.userDateFormat.parse(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (DEBUG && date != null) {
            System.out.println(string + " > " + date.toString());
        }
        return date;
    }

    private Date parseDateInternal(String string) {
        int n;
        int n2;
        String string2;
        if (string == null) {
            return null;
        }
        String string3 = string;
        GregorianCalendar gregorianCalendar = new GregorianCalendar(this.timeZone);
        Matcher matcher = getTimeComponent.matcher(string3);
        if ((string3 = matcher.replaceFirst("").trim()).endsWith(" at")) {
            string3 = string3.substring(0, string3.length() - 3).trim();
        }
        if ((matcher = hasLettersPattern.matcher(string3)).find()) {
            matcher = isAgeBasedPattern.matcher(string3);
            if (matcher.find()) {
                matcher = todayPattern.matcher(string3);
                if (!matcher.find()) {
                    matcher = yesterdayPattern.matcher(string3);
                    if (matcher.find()) {
                        ((Calendar)gregorianCalendar).add(5, -1);
                    } else {
                        string3 = string3.replaceAll("ago", "").trim();
                        matcher = agoSpacerPattern.matcher(string3);
                        string3 = matcher.replaceAll("$1 $2");
                        matcher = agoTimeRangePattern.matcher(string3);
                        boolean bl = false;
                        while (matcher.find()) {
                            string2 = matcher.group(2);
                            if (string2.equals("h")) {
                                bl = true;
                            }
                            String string4 = string2.toLowerCase();
                            float f = Float.parseFloat(matcher.group(1));
                            n2 = (int)f;
                            if (string4.startsWith("sec")) {
                                ((Calendar)gregorianCalendar).add(13, -n2);
                                continue;
                            }
                            if (string4.startsWith("min") || string2.equals("m") && bl) {
                                ((Calendar)gregorianCalendar).add(12, -n2);
                                n = (int)((f - (float)n2) * 60.0f);
                                ((Calendar)gregorianCalendar).add(13, -n);
                                continue;
                            }
                            if (string4.startsWith("h")) {
                                ((Calendar)gregorianCalendar).add(11, -n2);
                                n = (int)((f - (float)n2) * 3600.0f);
                                ((Calendar)gregorianCalendar).add(13, -n);
                                continue;
                            }
                            if (string4.startsWith("d")) {
                                ((Calendar)gregorianCalendar).add(5, -n2);
                                n = (int)((f - (float)n2) * 86400.0f);
                                ((Calendar)gregorianCalendar).add(13, -n);
                                continue;
                            }
                            if (string4.startsWith("w")) {
                                ((Calendar)gregorianCalendar).add(3, -n2);
                                n = (int)((f - (float)n2) * 640800.0f);
                                ((Calendar)gregorianCalendar).add(13, -n);
                                continue;
                            }
                            if (string4.startsWith("m")) {
                                ((Calendar)gregorianCalendar).add(2, -n2);
                                n = (int)((f - (float)n2) * 720.0f);
                                ((Calendar)gregorianCalendar).add(11, -n);
                                continue;
                            }
                            if (!string4.startsWith("y")) continue;
                            ((Calendar)gregorianCalendar).add(1, -n2);
                            n = (int)((f - (float)n2) * 8760.0f);
                            ((Calendar)gregorianCalendar).add(11, -n);
                        }
                    }
                }
            } else {
                matcher = timeBasedDateWithLettersPattern.matcher(string3);
                if (matcher.find()) {
                    int n3;
                    int n4 = Integer.parseInt(matcher.group(1));
                    gregorianCalendar.set(5, n4);
                    string2 = " " + matcher.group(2).toLowerCase();
                    int n5 = -1;
                    for (n3 = 0; n3 < MONTHS_LIST.length; ++n3) {
                        if (MONTHS_LIST[n3].indexOf(string2) == -1) continue;
                        n5 = n3;
                    }
                    if (n5 > -1) {
                        gregorianCalendar.set(2, n5);
                    }
                    int n6 = n3 = matcher.group(3) != null ? 1 : 0;
                    if (n3 != 0) {
                        n2 = Integer.parseInt(matcher.group(3));
                        if (n2 < 100) {
                            n2 += 2000;
                        }
                        gregorianCalendar.set(1, n2);
                    }
                    gregorianCalendar.set(11, 0);
                    gregorianCalendar.set(12, 0);
                    gregorianCalendar.set(13, 0);
                    gregorianCalendar.set(14, 0);
                } else {
                    matcher = timeBasedDateWithLettersPatternMonthFirst.matcher(string3);
                    if (matcher.find()) {
                        int n7;
                        int n8 = Integer.parseInt(matcher.group(2));
                        gregorianCalendar.set(5, n8);
                        string2 = " " + matcher.group(1).toLowerCase();
                        int n9 = -1;
                        for (n7 = 0; n7 < MONTHS_LIST.length; ++n7) {
                            if (MONTHS_LIST[n7].indexOf(string2) == -1) continue;
                            n9 = n7;
                        }
                        if (n9 > -1) {
                            gregorianCalendar.set(2, n9);
                        }
                        int n10 = n7 = matcher.group(3) != null ? 1 : 0;
                        if (n7 != 0) {
                            n2 = Integer.parseInt(matcher.group(3));
                            if (n2 < 100) {
                                n2 += 2000;
                            }
                            gregorianCalendar.set(1, n2);
                        }
                        gregorianCalendar.set(11, 0);
                        gregorianCalendar.set(12, 0);
                        gregorianCalendar.set(13, 0);
                        gregorianCalendar.set(14, 0);
                    } else {
                        System.err.println("Unparseable date : " + string);
                    }
                }
            }
        } else {
            matcher = numbersOnlyDatePattern.matcher(string3);
            if (matcher.find()) {
                try {
                    int n11;
                    String string5 = matcher.group(1);
                    string2 = matcher.group(2);
                    String string6 = matcher.group(3);
                    int n12 = Integer.parseInt(string5);
                    n2 = Integer.parseInt(string2);
                    if (string6 != null) {
                        n = Integer.parseInt(string6);
                        n11 = n12;
                        int n13 = n2;
                        int n14 = n;
                        if (n13 > 12) {
                            n11 = n2;
                            n13 = n12;
                        }
                        if (n14 < 100) {
                            n14 += 2000;
                        }
                        if (string5.length() == 4) {
                            n14 = n12;
                            n11 = n;
                        }
                        gregorianCalendar.set(1, n14);
                        gregorianCalendar.set(2, n13 - 1);
                        gregorianCalendar.set(5, n11);
                    } else {
                        n = n12;
                        n11 = n2;
                        if (n > 12) {
                            n11 = n12;
                            n = n2;
                        }
                        if (n > 12) {
                            System.err.println("Unparseable date : " + string);
                        } else {
                            gregorianCalendar.set(2, n - 1);
                            gregorianCalendar.set(5, n11);
                        }
                    }
                    gregorianCalendar.set(11, 0);
                    gregorianCalendar.set(12, 0);
                    gregorianCalendar.set(13, 0);
                    gregorianCalendar.set(14, 0);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        if ((matcher = getTimeComponent.matcher(string)).find()) {
            try {
                boolean bl;
                int n15 = Integer.parseInt(matcher.group(1));
                int n16 = Integer.parseInt(matcher.group(2));
                gregorianCalendar.set(12, n16);
                boolean bl2 = matcher.group(5) != null;
                boolean bl3 = bl = matcher.group(4) != null;
                if (bl) {
                    n2 = Integer.parseInt(matcher.group(4));
                    gregorianCalendar.set(13, n2);
                }
                if (bl2) {
                    String string7 = matcher.group(5).trim().toLowerCase();
                    if (string7.equals("am")) {
                        gregorianCalendar.set(9, 0);
                    } else {
                        gregorianCalendar.set(9, 1);
                    }
                    gregorianCalendar.set(10, n15);
                } else {
                    gregorianCalendar.set(11, n15);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        int n17 = 0;
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar();
        while (gregorianCalendar.after(gregorianCalendar2) && n17++ < 50) {
            ((Calendar)gregorianCalendar).add(1, -1);
        }
        return gregorianCalendar.getTime();
    }

    public static void main(String[] stringArray) {
        DEBUG = true;
        DateParserRegex dateParserRegex = new DateParserRegex();
        dateParserRegex.parseDate("Today 05:34");
        dateParserRegex.parseDate("Y-Day 21:55");
        dateParserRegex.parseDate("07-25 2006");
        dateParserRegex.parseDate("02-01 02:53");
        dateParserRegex.parseDate("02-01 02:53 am");
        dateParserRegex.parseDate("02-01 02:53 pm");
        dateParserRegex.parseDate("03 Mar 2006");
        dateParserRegex.parseDate("0 minute ago");
        dateParserRegex.parseDate("3 hours ago");
        dateParserRegex.parseDate("2 days ago");
        dateParserRegex.parseDate("10 months ago");
        dateParserRegex.parseDate("45 mins ago");
        dateParserRegex.parseDate("Today");
        dateParserRegex.parseDate("Yesterday");
        dateParserRegex.parseDate("16.9w");
        dateParserRegex.parseDate("22.6h");
        dateParserRegex.parseDate("1.7d");
        dateParserRegex.parseDate("2d 7h");
        dateParserRegex.parseDate("1w");
        dateParserRegex.parseDate("1w 4d");
        dateParserRegex.parseDate("1mon 1w");
        dateParserRegex.parseDate("22.11.");
        dateParserRegex.parseDate("22 Apr 08");
        dateParserRegex.parseDate("3 months");
        dateParserRegex.parseDate("1 day");
        dateParserRegex.parseDate("3 weeks");
        dateParserRegex.parseDate("1 year");
        dateParserRegex.parseDate("4 hours ago");
        dateParserRegex.parseDate("yesterday");
        dateParserRegex.parseDate("2 days ago");
        dateParserRegex.parseDate("1 month ago");
        dateParserRegex.parseDate("2 months ago");
        dateParserRegex.parseDate("06/18");
        dateParserRegex.parseDate("02:10");
        dateParserRegex.parseDate("2005-02-26 20:55:10");
        dateParserRegex.parseDate("2005-02-26 10:55:10 PM");
        dateParserRegex.parseDate("2005-02-26 10:55:10 AM");
        dateParserRegex.parseDate("25-04-08");
        dateParserRegex.parseDate("142 Day(s) ago");
        dateParserRegex.parseDate("6 Minute(s) ago");
        dateParserRegex.parseDate("1 Hour(s) ago");
        dateParserRegex.parseDate("1.4h");
        dateParserRegex.parseDate("3.5d");
        dateParserRegex.parseDate("392w");
        dateParserRegex.parseDate("01st Mar");
        dateParserRegex.parseDate("19th Apr");
        dateParserRegex.parseDate("03rd Apr");
        dateParserRegex.parseDate("2nd Apr");
        dateParserRegex.parseDate("3rd Nov");
        dateParserRegex.parseDate("04-28");
        dateParserRegex.parseDate("2007-07-14");
        dateParserRegex.parseDate("2008.04.28");
        dateParserRegex.parseDate("16/04/08");
        dateParserRegex.parseDate("20-Dec-07");
        dateParserRegex.parseDate("2009-01-12 at 03:36:38");
    }
}

