/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.metasearch.impl;

import com.aelitis.azureus.core.messenger.config.PlatformMetaSearchMessenger;
import com.aelitis.azureus.core.metasearch.Engine;
import com.aelitis.azureus.core.metasearch.Result;
import com.aelitis.azureus.core.metasearch.ResultListener;
import com.aelitis.azureus.core.metasearch.SearchException;
import com.aelitis.azureus.core.metasearch.SearchLoginException;
import com.aelitis.azureus.core.metasearch.SearchParameter;
import com.aelitis.azureus.core.metasearch.impl.FieldRemapper;
import com.aelitis.azureus.core.metasearch.impl.FieldRemapping;
import com.aelitis.azureus.core.metasearch.impl.MetaSearchImpl;
import com.aelitis.azureus.core.metasearch.impl.plugin.PluginEngine;
import com.aelitis.azureus.core.metasearch.impl.web.json.JSONEngine;
import com.aelitis.azureus.core.metasearch.impl.web.regex.RegexEngine;
import com.aelitis.azureus.core.metasearch.impl.web.rss.RSSEngine;
import com.aelitis.azureus.core.vuzefile.VuzeFile;
import com.aelitis.azureus.core.vuzefile.VuzeFileHandler;
import com.aelitis.azureus.util.ConstantsVuze;
import com.aelitis.azureus.util.ImportExportUtils;
import com.aelitis.azureus.util.JSONUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.RandomUtils;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public abstract class EngineImpl
implements Engine {
    private static final int DEFAULT_UPDATE_CHECK_SECS = 86400;
    private static boolean logging_enabled;
    protected static final String LD_COOKIES = "cookies";
    protected static final String LD_ETAG = "etag";
    protected static final String LD_LAST_MODIFIED = "last_mod";
    protected static final String LD_LAST_UPDATE_CHECK = "last_update_check";
    protected static final String LD_UPDATE_CHECK_SECS = "update_check_secs";
    protected static final String LD_CREATED_BY_ME = "mine";
    protected static final String LD_AUTO_DL_SUPPORTED = "auto_dl_supported";
    protected static final String LD_LINK_IS_TORRENT = "link_is_torrent";
    private MetaSearchImpl meta_search;
    private int type;
    private long id;
    private long last_updated;
    private String name;
    private byte[] uid;
    private int version;
    private boolean is_public = true;
    private int az_version;
    private int selection_state = 0;
    private boolean selection_state_recorded = true;
    private int source = 0;
    private List first_level_mapping = new ArrayList();
    private List second_level_mapping = new ArrayList();
    private String update_url;
    private int update_check_default_secs;
    private Map user_data;

    protected static EngineImpl importFromBEncodedMap(MetaSearchImpl metaSearchImpl, Map map) throws IOException {
        int n = ((Long)map.get("type")).intValue();
        if (n == 2) {
            return JSONEngine.importFromBEncodedMap(metaSearchImpl, map);
        }
        if (n == 1) {
            return RegexEngine.importFromBEncodedMap(metaSearchImpl, map);
        }
        if (n == 3) {
            return PluginEngine.importFromBEncodedMap(metaSearchImpl, map);
        }
        if (n == 4) {
            return RSSEngine.importFromBEncodedMap(metaSearchImpl, map);
        }
        throw new IOException("Unknown engine type " + n);
    }

    public static Engine importFromJSONString(MetaSearchImpl metaSearchImpl, int n, long l, long l2, String string, String string2) throws IOException {
        JSONObject jSONObject = (JSONObject)JSONUtils.decodeJSON(string2);
        if (n == 2) {
            return JSONEngine.importFromJSONString(metaSearchImpl, l, l2, string, jSONObject);
        }
        if (n == 1) {
            return RegexEngine.importFromJSONString(metaSearchImpl, l, l2, string, jSONObject);
        }
        if (n == 4) {
            return RSSEngine.importFromJSONString(metaSearchImpl, l, l2, string, jSONObject);
        }
        throw new IOException("Unknown engine type " + n);
    }

    protected EngineImpl(MetaSearchImpl metaSearchImpl, int n, long l, long l2, String string) {
        this.meta_search = metaSearchImpl;
        this.type = n;
        this.id = l;
        this.last_updated = l2;
        this.name = string;
        this.version = 1;
        this.az_version = 1;
        this.allocateUID(this.id);
    }

    protected EngineImpl(MetaSearchImpl metaSearchImpl, Map map) throws IOException {
        this.meta_search = metaSearchImpl;
        this.type = ((Long)map.get("type")).intValue();
        this.id = (Long)map.get("id");
        this.last_updated = ImportExportUtils.importLong(map, "last_updated");
        this.name = ImportExportUtils.importString(map, "name");
        this.selection_state = (int)ImportExportUtils.importLong(map, "selected", 0L);
        this.selection_state_recorded = ImportExportUtils.importBoolean(map, "select_rec", true);
        this.source = (int)ImportExportUtils.importLong(map, "source", 0L);
        this.first_level_mapping = this.importBEncodedMappings(map, "l1_map");
        this.second_level_mapping = this.importBEncodedMappings(map, "l2_map");
        this.version = (int)ImportExportUtils.importLong(map, "version", 1L);
        this.az_version = (int)ImportExportUtils.importLong(map, "az_version", 1L);
        if (this.az_version > 1) {
            throw new IOException(MessageText.getString("metasearch.template.version.bad", new String[]{this.name}));
        }
        this.uid = (byte[])map.get("uid");
        if (this.uid == null) {
            this.allocateUID(this.id);
        }
        this.update_url = ImportExportUtils.importString(map, "update_url");
        this.update_check_default_secs = (int)ImportExportUtils.importLong(map, "update_url_check_secs", 86400L);
    }

    protected void exportToBencodedMap(Map map) throws IOException {
        map.put("type", new Long(this.type));
        map.put("id", new Long(this.id));
        map.put("last_updated", new Long(this.last_updated));
        ImportExportUtils.exportString(map, "name", this.name);
        map.put("selected", new Long(this.selection_state));
        ImportExportUtils.exportBoolean(map, "select_rec", this.selection_state_recorded);
        map.put("source", new Long(this.source));
        this.exportBEncodedMappings(map, "l1_map", this.first_level_mapping);
        this.exportBEncodedMappings(map, "l2_map", this.second_level_mapping);
        map.put("version", new Long(this.version));
        map.put("az_version", new Long(this.az_version));
        map.put("uid", this.uid);
        if (this.update_url != null) {
            ImportExportUtils.exportString(map, "update_url", this.update_url);
        }
        map.put("update_url_check_secs", new Long(this.update_check_default_secs));
    }

    protected EngineImpl(MetaSearchImpl metaSearchImpl, int n, long l, long l2, String string, JSONObject jSONObject) throws IOException {
        this(metaSearchImpl, n, l, l2, string);
        this.first_level_mapping = this.importJSONMappings(jSONObject, "value_map", true);
        this.second_level_mapping = this.importJSONMappings(jSONObject, "ctype_map", false);
        this.version = (int)ImportExportUtils.importLong(jSONObject, "version", 1L);
        this.az_version = (int)ImportExportUtils.importLong(jSONObject, "az_version", 1L);
        if (this.az_version > 1) {
            throw new IOException(MessageText.getString("metasearch.template.version.bad", new String[]{string}));
        }
        String string2 = (String)jSONObject.get("uid");
        if (string2 == null) {
            this.allocateUID(l);
        } else {
            this.uid = Base32.decode(string2);
        }
        this.update_url = ImportExportUtils.importString(jSONObject, "update_url");
        this.update_check_default_secs = (int)ImportExportUtils.importLong(jSONObject, "update_url_check_secs", 86400L);
    }

    protected void exportToJSONObject(JSONObject jSONObject) throws IOException {
        this.exportJSONMappings(jSONObject, "value_map", this.first_level_mapping, true);
        this.exportJSONMappings(jSONObject, "ctype_map", this.second_level_mapping, false);
        jSONObject.put("version", new Long(this.version));
        jSONObject.put("az_version", new Long(this.az_version));
        jSONObject.put("uid", Base32.encode(this.uid));
        if (this.update_url != null) {
            ImportExportUtils.exportJSONString(jSONObject, "update_url", this.update_url);
        }
        jSONObject.put("update_url_check_secs", new Long(this.update_check_default_secs));
    }

    protected List importJSONMappings(JSONObject jSONObject, String string, boolean bl) throws IOException {
        ArrayList<FieldRemapper> arrayList = new ArrayList<FieldRemapper>();
        JSONObject jSONObject2 = (JSONObject)jSONObject.get(string);
        if (jSONObject2 != null) {
            for (Map.Entry entry : jSONObject2.entrySet()) {
                String string2 = (String)entry.getKey();
                List list = (List)entry.getValue();
                int n = this.vuzeFieldToID(string2);
                if (n == -1) {
                    this.log("Unrecognised remapping key '" + string2 + "'");
                    continue;
                }
                int n2 = bl ? n : 8;
                ArrayList<FieldRemapping> arrayList2 = new ArrayList<FieldRemapping>();
                for (int i = 0; i < list.size(); ++i) {
                    JSONObject jSONObject3 = (JSONObject)list.get(i);
                    String string3 = URLDecoder.decode((String)jSONObject3.get(bl ? "from_string" : "cat_string"), "UTF-8");
                    if (string3 == null) {
                        this.log("'from' value missing in " + jSONObject3);
                        continue;
                    }
                    string3 = URLDecoder.decode(string3, "UTF-8");
                    String string4 = URLDecoder.decode((String)jSONObject3.get(bl ? "to_string" : "media_type"), "UTF-8");
                    if (string4 == null) {
                        this.log("'to' value missing in " + jSONObject3);
                        continue;
                    }
                    arrayList2.add(new FieldRemapping(string3, string4));
                }
                FieldRemapping[] fieldRemappingArray = arrayList2.toArray(new FieldRemapping[arrayList2.size()]);
                arrayList.add(new FieldRemapper(n, n2, fieldRemappingArray));
            }
        }
        return arrayList;
    }

    protected void exportJSONMappings(JSONObject jSONObject, String string, List list, boolean bl) {
        JSONObject jSONObject2 = new JSONObject();
        jSONObject.put(string, jSONObject2);
        for (int i = 0; i < list.size(); ++i) {
            FieldRemapper fieldRemapper = (FieldRemapper)list.get(i);
            int n = fieldRemapper.getInField();
            String string2 = this.vuzeIDToField(n);
            JSONArray jSONArray = new JSONArray();
            jSONObject2.put(string2, jSONArray);
            FieldRemapping[] fieldRemappingArray = fieldRemapper.getMappings();
            for (int j = 0; j < fieldRemappingArray.length; ++j) {
                FieldRemapping fieldRemapping = fieldRemappingArray[j];
                String string3 = UrlUtils.encode(fieldRemapping.getMatchString());
                String string4 = fieldRemapping.getReplacement();
                JSONObject jSONObject3 = new JSONObject();
                jSONArray.add(jSONObject3);
                jSONObject3.put(bl ? "from_string" : "cat_string", string3);
                jSONObject3.put(bl ? "to_string" : "media_type", string4);
            }
        }
    }

    protected List importBEncodedMappings(Map map, String string) throws IOException {
        ArrayList<FieldRemapper> arrayList = new ArrayList<FieldRemapper>();
        List list = (List)map.get(string);
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                Map map2 = (Map)list.get(i);
                int n = ((Long)map2.get("from")).intValue();
                int n2 = ((Long)map2.get("to")).intValue();
                List list2 = (List)map2.get("maps");
                FieldRemapping[] fieldRemappingArray = new FieldRemapping[list2.size()];
                for (int j = 0; j < fieldRemappingArray.length; ++j) {
                    Map map3 = (Map)list2.get(j);
                    String string2 = ImportExportUtils.importString(map3, "from");
                    String string3 = ImportExportUtils.importString(map3, "to");
                    fieldRemappingArray[j] = new FieldRemapping(string2, string3);
                }
                arrayList.add(new FieldRemapper(n, n2, fieldRemappingArray));
            }
        }
        return arrayList;
    }

    protected void exportBEncodedMappings(Map map, String string, List list) throws IOException {
        ArrayList arrayList = new ArrayList();
        map.put(string, arrayList);
        for (int i = 0; i < list.size(); ++i) {
            FieldRemapper fieldRemapper = (FieldRemapper)list.get(i);
            HashMap<String, Serializable> hashMap = new HashMap<String, Serializable>();
            arrayList.add(hashMap);
            hashMap.put("from", new Long(fieldRemapper.getInField()));
            hashMap.put("to", new Long(fieldRemapper.getOutField()));
            ArrayList arrayList2 = new ArrayList();
            hashMap.put("maps", arrayList2);
            FieldRemapping[] fieldRemappingArray = fieldRemapper.getMappings();
            for (int j = 0; j < fieldRemappingArray.length; ++j) {
                FieldRemapping fieldRemapping = fieldRemappingArray[j];
                HashMap hashMap2 = new HashMap();
                arrayList2.add(hashMap2);
                ImportExportUtils.exportString(hashMap2, "from", fieldRemapping.getMatchString());
                ImportExportUtils.exportString(hashMap2, "to", fieldRemapping.getReplacement());
            }
        }
    }

    public String exportToJSONString() throws IOException {
        JSONObject jSONObject = new JSONObject();
        this.exportToJSONObject(jSONObject);
        return jSONObject.toString();
    }

    public int getAZVersion() {
        return this.az_version;
    }

    public int getVersion() {
        return this.version;
    }

    protected void setVersion(int n) {
        this.version = n;
    }

    public String getUID() {
        return Base32.encode(this.uid);
    }

    protected void setUID(String string) {
        this.uid = Base32.decode(string);
    }

    protected void allocateUID(long l) {
        this.uid = new byte[10];
        if (l >= 0L && l < Integer.MAX_VALUE) {
            this.uid[0] = (byte)(l >> 24);
            this.uid[1] = (byte)(l >> 16);
            this.uid[2] = (byte)(l >> 8);
            this.uid[3] = (byte)l;
        } else {
            RandomUtils.nextSecureBytes(this.uid);
            this.configDirty();
        }
    }

    public boolean sameLogicAs(Engine engine) {
        try {
            Map<String, Object> map = this.exportToBencodedMap();
            Map<String, Object> map2 = engine.exportToBencodedMap();
            String[] stringArray = new String[]{"type", "id", "last_updated", "selected", "select_rec", "source", "version", "az_version", "uid"};
            for (int i = 0; i < stringArray.length; ++i) {
                map.remove(stringArray[i]);
                map2.remove(stringArray[i]);
            }
            return BEncoder.mapsAreIdentical(map, map2);
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result[] search(SearchParameter[] searchParameterArray, Map hashMap, int n, int n2, String string, final ResultListener resultListener) throws SearchException {
        if (hashMap == null) {
            hashMap = new HashMap();
        }
        try {
            final HashSet hashSet = new HashSet();
            final boolean[] blArray = new boolean[]{false};
            ResultListener resultListener2 = new ResultListener(){

                public void contentReceived(Engine engine, String string) {
                    resultListener.contentReceived(engine, string);
                }

                public void matchFound(Engine engine, String[] stringArray) {
                    resultListener.matchFound(engine, stringArray);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void resultsReceived(Engine engine, Result[] resultArray) {
                    resultListener.resultsReceived(engine, resultArray);
                    Set set = hashSet;
                    synchronized (set) {
                        hashSet.addAll(Arrays.asList(resultArray));
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void resultsComplete(Engine engine) {
                    resultListener.resultsComplete(engine);
                    Set set = hashSet;
                    synchronized (set) {
                        blArray[0] = true;
                    }
                }

                public void engineFailed(Engine engine, Throwable throwable) {
                    resultListener.engineFailed(engine, throwable);
                }

                public void engineRequiresLogin(Engine engine, Throwable throwable) {
                    resultListener.engineRequiresLogin(engine, throwable);
                }
            };
            Result[] resultArray = this.searchAndMap(searchParameterArray, hashMap, n, n2, string, resultListener == null ? null : resultListener2);
            if (resultListener != null) {
                boolean bl;
                ArrayList<Result> arrayList = new ArrayList<Result>();
                HashSet hashSet2 = hashSet;
                synchronized (hashSet2) {
                    for (Result result : resultArray) {
                        if (hashSet.contains(result)) continue;
                        arrayList.add(result);
                    }
                    bl = !blArray[0];
                }
                if (arrayList.size() > 0) {
                    resultListener.resultsReceived(this, arrayList.toArray(new Result[arrayList.size()]));
                }
                if (bl) {
                    resultListener.resultsComplete(this);
                }
            }
            return resultArray;
        }
        catch (Throwable throwable) {
            if (throwable instanceof SearchLoginException) {
                if (resultListener != null) {
                    resultListener.engineRequiresLogin(this, throwable);
                }
                throw (SearchLoginException)throwable;
            }
            if (throwable instanceof SearchException) {
                if (resultListener != null) {
                    resultListener.engineFailed(this, throwable);
                }
                throw (SearchException)throwable;
            }
            if (resultListener != null) {
                resultListener.engineFailed(this, throwable);
            }
            throw new SearchException("Search failed", throwable);
        }
    }

    protected Result[] searchAndMap(SearchParameter[] searchParameterArray, Map map, int n, int n2, String string, final ResultListener resultListener) throws SearchException {
        map.put("azid", ConstantsVuze.AZID);
        if (map.get("azsrc") == null) {
            map.put("azsrc", "search");
        }
        Result[] resultArray = this.searchSupport(searchParameterArray, map, n, n2, string, new ResultListener(){

            public void contentReceived(Engine engine, String string) {
                if (resultListener != null) {
                    resultListener.contentReceived(engine, string);
                }
            }

            public void matchFound(Engine engine, String[] stringArray) {
                if (resultListener != null) {
                    resultListener.matchFound(engine, stringArray);
                }
            }

            public void resultsReceived(Engine engine, Result[] resultArray) {
                if (resultListener != null) {
                    resultListener.resultsReceived(engine, EngineImpl.this.mapResults(resultArray));
                }
            }

            public void resultsComplete(Engine engine) {
                if (resultListener != null) {
                    resultListener.resultsComplete(engine);
                }
            }

            public void engineFailed(Engine engine, Throwable throwable) {
                EngineImpl.this.log("Search failed", throwable);
                if (resultListener != null) {
                    resultListener.engineFailed(engine, throwable);
                }
            }

            public void engineRequiresLogin(Engine engine, Throwable throwable) {
                EngineImpl.this.log("Search requires login", throwable);
                if (resultListener != null) {
                    resultListener.engineRequiresLogin(engine, throwable);
                }
            }
        });
        return this.mapResults(resultArray);
    }

    protected Result[] mapResults(Result[] resultArray) {
        for (int i = 0; i < resultArray.length; ++i) {
            FieldRemapper fieldRemapper;
            int n;
            Result result = resultArray[i];
            for (n = 0; n < this.first_level_mapping.size(); ++n) {
                fieldRemapper = (FieldRemapper)this.first_level_mapping.get(n);
                fieldRemapper.remap(result);
            }
            for (n = 0; n < this.second_level_mapping.size(); ++n) {
                fieldRemapper = (FieldRemapper)this.second_level_mapping.get(n);
                fieldRemapper.remap(result);
            }
        }
        return resultArray;
    }

    protected abstract Result[] searchSupport(SearchParameter[] var1, Map var2, int var3, int var4, String var5, ResultListener var6) throws SearchException;

    public void delete() {
        this.meta_search.removeEngine(this);
    }

    protected int vuzeFieldToID(String string) {
        for (int i = 0; i < FIELD_NAMES.length; ++i) {
            if (!string.equalsIgnoreCase(FIELD_NAMES[i])) continue;
            return FIELD_IDS[i];
        }
        return -1;
    }

    protected String vuzeIDToField(int n) {
        for (int i = 0; i < FIELD_IDS.length; ++i) {
            if (n != FIELD_IDS[i]) continue;
            return FIELD_NAMES[i];
        }
        return null;
    }

    public int getType() {
        return this.type;
    }

    protected void setId(long l) {
        this.id = l;
    }

    public long getId() {
        return this.id;
    }

    public long getLastUpdated() {
        return this.last_updated;
    }

    public String getName() {
        return this.name;
    }

    protected void setName(String string) {
        this.name = string;
    }

    public boolean isActive() {
        return this.getSelectionState() != 0;
    }

    public boolean isPublic() {
        return this.is_public;
    }

    protected void setPublic(boolean bl) {
        this.is_public = bl;
    }

    public int getSelectionState() {
        return this.selection_state;
    }

    public void setSelectionState(int n) {
        if (n != this.selection_state) {
            if (this.getSource() == 1 && (n == 2 || this.selection_state == 2)) {
                this.selection_state_recorded = false;
                this.checkSelectionStateRecorded();
            }
            this.selection_state = n;
            this.configDirty();
        }
    }

    public void recordSelectionState() {
        this.selection_state_recorded = false;
        this.checkSelectionStateRecorded();
    }

    public void checkSelectionStateRecorded() {
        if (!this.selection_state_recorded) {
            try {
                boolean bl = this.selection_state != 0;
                this.log("Marking template id " + this.getId() + " as selected=" + bl);
                PlatformMetaSearchMessenger.setTemplatetSelected(this.getId(), ConstantsVuze.AZID, bl);
                this.selection_state_recorded = true;
            }
            catch (Throwable throwable) {
                this.log("Failed to record selection state", throwable);
            }
        }
    }

    public int getSource() {
        return this.source;
    }

    public void setSource(int n) {
        if (this.source != n) {
            this.source = n;
            this.configDirty();
        }
    }

    public boolean isMine() {
        return this.getLocalBoolean(LD_CREATED_BY_ME, false);
    }

    public void setMine(boolean bl) {
        this.setLocalBoolean(LD_CREATED_BY_ME, bl);
    }

    protected String getUpdateURL() {
        return this.update_url;
    }

    protected void setUpdateURL(String string) {
        this.update_url = string;
    }

    protected int getUpdateCheckSecs() {
        long l = this.getLocalLong(LD_UPDATE_CHECK_SECS, 0L);
        if (l != 0L) {
            return (int)l;
        }
        return this.update_check_default_secs;
    }

    protected void setDefaultUpdateCheckSecs(int n) {
        this.update_check_default_secs = n;
    }

    protected void setLocalUpdateCheckSecs(int n) {
        this.setLocalLong(LD_UPDATE_CHECK_SECS, n);
    }

    protected long getLastUpdateCheck() {
        return this.getLocalLong(LD_LAST_UPDATE_CHECK, 0L);
    }

    protected void setLastUpdateCheck(long l) {
        this.setLocalLong(LD_LAST_UPDATE_CHECK, l);
    }

    public int getAutoDownloadSupported() {
        boolean bl = this.supportsField(102) || this.supportsField(105);
        return bl ? 1 : 2;
    }

    protected void configDirty() {
        if (this.meta_search != null) {
            this.meta_search.configDirty();
        }
    }

    public void exportToVuzeFile(File file) throws IOException {
        VuzeFile vuzeFile = VuzeFileHandler.getSingleton().create();
        vuzeFile.addComponent(1, this.exportToBencodedMap());
        vuzeFile.write(file);
    }

    private String getLocalKey() {
        return "metasearch.engine." + this.id + ".local";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        EngineImpl engineImpl = this;
        synchronized (engineImpl) {
            Map map = COConfigurationManager.getMapParameter(this.getLocalKey(), new HashMap());
            map.remove(LD_COOKIES);
            map.remove(LD_ETAG);
            map.remove(LD_LAST_MODIFIED);
            COConfigurationManager.setParameter(this.getLocalKey(), map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setLocalString(String string, String string2) {
        EngineImpl engineImpl = this;
        synchronized (engineImpl) {
            String string3 = this.getLocalString(string);
            if (string3 != null && string2 != null && string3.equals(string2)) {
                return;
            }
            Map map = COConfigurationManager.getMapParameter(this.getLocalKey(), new HashMap());
            try {
                ImportExportUtils.exportString(map, string, string2);
                COConfigurationManager.setParameter(this.getLocalKey(), map);
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getLocalString(String string) {
        EngineImpl engineImpl = this;
        synchronized (engineImpl) {
            Map map = COConfigurationManager.getMapParameter(this.getLocalKey(), new HashMap());
            try {
                return ImportExportUtils.importString(map, string);
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
                return null;
            }
        }
    }

    protected void setLocalBoolean(String string, boolean bl) {
        this.setLocalLong(string, bl ? 1L : 0L);
    }

    protected boolean getLocalBoolean(String string, boolean bl) {
        return this.getLocalLong(string, bl ? 1L : 0L) == 1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setLocalLong(String string, long l) {
        EngineImpl engineImpl = this;
        synchronized (engineImpl) {
            long l2 = this.getLocalLong(string, 0L);
            if (l2 == l) {
                return;
            }
            Map map = COConfigurationManager.getMapParameter(this.getLocalKey(), new HashMap());
            try {
                map.put(string, new Long(l));
                COConfigurationManager.setParameter(this.getLocalKey(), map);
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getLocalLong(String string, long l) {
        EngineImpl engineImpl = this;
        synchronized (engineImpl) {
            Map map = COConfigurationManager.getMapParameter(this.getLocalKey(), new HashMap());
            try {
                return ImportExportUtils.importLong(map, string, l);
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
                return l;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setUserData(Object object, Object object2) {
        EngineImpl engineImpl = this;
        synchronized (engineImpl) {
            if (this.user_data == null) {
                if (object == null) {
                    return;
                }
                this.user_data = new HashMap(4);
            }
            if (object == null) {
                this.user_data.remove(object);
                if (this.user_data.size() == 0) {
                    this.user_data = null;
                }
            } else {
                this.user_data.put(object, object2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getUserData(Object object) {
        EngineImpl engineImpl = this;
        synchronized (engineImpl) {
            if (this.user_data == null) {
                return null;
            }
            return this.user_data.get(object);
        }
    }

    protected File getDebugFile() {
        if (logging_enabled) {
            return new File(AEDiagnostics.getLogDir(), "MetaSearch_Engine_" + this.getId() + ".txt");
        }
        return null;
    }

    protected synchronized void debugStart() {
        File file = this.getDebugFile();
        if (file != null) {
            file.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void debugLog(String string) {
        File file = this.getDebugFile();
        if (file != null) {
            PrintWriter printWriter = null;
            try {
                printWriter = new PrintWriter(new FileWriter(file, true));
                printWriter.println(string);
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (printWriter != null) {
                    printWriter.close();
                }
                throw throwable;
            }
        }
    }

    protected void log(String string) {
        if (this.meta_search != null) {
            this.meta_search.log("Engine " + this.getId() + ": " + string);
        }
    }

    protected void log(String string, Throwable throwable) {
        if (this.meta_search != null) {
            this.meta_search.log("Engine " + this.getId() + ": " + string, throwable);
        }
    }

    public String getString() {
        return "id=" + this.getId() + ", name=" + this.getName() + ", source=" + ENGINE_SOURCE_STRS[this.getSource()] + ", selected=" + SEL_STATE_STRINGS[this.getSelectionState()];
    }

    public String getString(boolean bl) {
        return this.getString();
    }

    static {
        COConfigurationManager.addAndFireParameterListeners(new String[]{"Logger.Enabled"}, new ParameterListener(){

            public void parameterChanged(String string) {
                logging_enabled = COConfigurationManager.getBooleanParameter("Logger.Enabled");
            }
        });
    }
}

