/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.metasearch.impl.web;

import com.aelitis.azureus.core.metasearch.Engine;
import com.aelitis.azureus.core.metasearch.Result;
import com.aelitis.azureus.core.metasearch.impl.DateParser;
import java.util.Date;
import java.util.StringTokenizer;
import org.apache.commons.lang.Entities;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;

public class WebResult
extends Result {
    private static final String HTML_TAGS = "(\\<(/?[^\\>]+)\\>)";
    private static final String DUPLICATE_SPACES = "\\s{2,}";
    String searchQuery;
    String rootPageURL;
    String basePageURL;
    DateParser dateParser;
    String contentType = "";
    String name;
    String category = "";
    String drmKey = null;
    Date publishedDate;
    long size = -1L;
    int nbPeers = -1;
    int nbSeeds = -1;
    int nbSuperSeeds = -1;
    int comments = -1;
    int votes = -1;
    int votesDown = -1;
    float rank = -1.0f;
    boolean privateTorrent;
    String cdpLink;
    String torrentLink;
    String downloadButtonLink;
    String playLink;
    String uid;
    String hash;

    public WebResult(Engine engine, String string, String string2, DateParser dateParser, String string3) {
        super(engine);
        this.rootPageURL = string;
        this.basePageURL = string2;
        this.dateParser = dateParser;
        this.searchQuery = string3;
    }

    private static final String removeHTMLTags(String string) {
        String string2 = string.replaceAll(HTML_TAGS, " ");
        return string2.replaceAll(DUPLICATE_SPACES, " ").trim();
    }

    public void setName(String string) {
        if (string != null) {
            this.name = string;
        }
    }

    public void setNameFromHTML(String string) {
        if (string != null) {
            string = WebResult.removeHTMLTags(string);
            this.name = Entities.HTML40.unescape(string);
        }
    }

    public void setCommentsFromHTML(String string) {
        if (string != null) {
            string = WebResult.removeHTMLTags(string);
            string = Entities.HTML40.unescape(string);
            string = string.replaceAll(",", "");
            string = string.replaceAll(" ", "");
            try {
                this.comments = Integer.parseInt(string);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void setCategoryFromHTML(String string) {
        if (string != null) {
            string = WebResult.removeHTMLTags(string);
            this.category = Entities.HTML40.unescape(string).trim();
        }
    }

    public void setUID(String string) {
        this.uid = string;
    }

    public String getUID() {
        return this.uid;
    }

    public void setNbPeersFromHTML(String string) {
        if (string != null) {
            string = WebResult.removeHTMLTags(string);
            String string2 = Entities.HTML40.unescape(string);
            string2 = string2.replaceAll(",", "");
            string2 = string2.replaceAll(" ", "");
            try {
                this.nbPeers = Integer.parseInt(string2);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void setNbSeedsFromHTML(String string) {
        if (string != null) {
            string = WebResult.removeHTMLTags(string);
            String string2 = Entities.HTML40.unescape(string);
            string2 = string2.replaceAll(",", "");
            string2 = string2.replaceAll(" ", "");
            try {
                this.nbSeeds = Integer.parseInt(string2);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void setNbSuperSeedsFromHTML(String string) {
        if (string != null) {
            string = WebResult.removeHTMLTags(string);
            String string2 = Entities.HTML40.unescape(string);
            string2 = string2.replaceAll(",", "");
            string2 = string2.replaceAll(" ", "");
            try {
                this.nbSuperSeeds = Integer.parseInt(string2);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void setRankFromHTML(String string) {
        if (string != null) {
            try {
                float f = Float.parseFloat(string.trim());
                if (string.indexOf(".") == -1) {
                    if (f >= 0.0f && f <= 100.0f) {
                        this.rank = f / 100.0f;
                    }
                } else if (f >= 0.0f && f <= 1.0f) {
                    this.rank = f;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public float getRank() {
        if (this.rank != -1.0f) {
            return this.rank;
        }
        return super.getRank();
    }

    public void setPublishedDate(Date date) {
        this.publishedDate = date;
    }

    public void setPublishedDateFromHTML(String string) {
        if (string != null) {
            string = WebResult.removeHTMLTags(string);
            String string2 = Entities.HTML40.unescape(string).replace('\u00a0', ' ');
            this.publishedDate = this.dateParser.parseDate(string2);
        }
    }

    public void setSizeFromHTML(String string) {
        if (string != null) {
            string = WebResult.removeHTMLTags(string);
            String string2 = Entities.HTML40.unescape(string).replace('\u00a0', ' ');
            string2 = string2.replaceAll("<[^>]+>", " ");
            string2 = string2.replaceFirst("(\\d)([a-zA-Z])", "$1 $2");
            try {
                StringTokenizer stringTokenizer = new StringTokenizer(string2, " ");
                double d = Double.parseDouble(stringTokenizer.nextToken());
                String string3 = "b";
                try {
                    string3 = stringTokenizer.nextToken().toLowerCase();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                long l = 1L;
                long l2 = 1024L;
                long l3 = 1024L;
                if ("mb".equals(string3)) {
                    l = l2 * l2;
                } else if ("mib".equals(string3)) {
                    l = l3 * l3;
                } else if ("gb".equals(string3)) {
                    l = l2 * l2 * l2;
                } else if ("gib".equals(string3)) {
                    l = l3 * l3 * l3;
                } else if ("kb".equals(string3)) {
                    l = l2;
                } else if ("kib".equals(string3)) {
                    l = l3;
                }
                this.size = (long)(d * (double)l);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void setVotesFromHTML(String string) {
        if (string != null) {
            string = WebResult.removeHTMLTags(string);
            string = Entities.HTML40.unescape(string);
            string = string.replaceAll(",", "");
            string = string.replaceAll(" ", "");
            try {
                this.votes = Integer.parseInt(string);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void setVotesDownFromHTML(String string) {
        if (string != null) {
            string = WebResult.removeHTMLTags(string);
            string = Entities.HTML40.unescape(string);
            string = string.replaceAll(",", "");
            string = string.replaceAll(" ", "");
            try {
                this.votesDown = Integer.parseInt(string);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void setPrivateFromHTML(String string) {
        if (string != null && !"".equals(string)) {
            this.privateTorrent = true;
        }
    }

    public int getVotes() {
        return this.votes;
    }

    public int getVotesDown() {
        return this.votesDown;
    }

    public void setCDPLink(String string) {
        this.cdpLink = string;
    }

    public void setDownloadButtonLink(String string) {
        this.downloadButtonLink = string;
    }

    public void setTorrentLink(String string) {
        this.torrentLink = string;
    }

    public void setPlayLink(String string) {
        this.playLink = string;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getPlayLink() {
        return this.reConstructLink(this.playLink);
    }

    public void setCategory(String string) {
        this.category = string;
    }

    public void setContentType(String string) {
        this.contentType = string;
    }

    public void setDrmKey(String string) {
        this.drmKey = string;
    }

    public void setHash(String string) {
        try {
            this.hash = string.trim();
            if (this.hash.length() != 32) {
                this.hash = this.hash.length() == 40 ? Base32.encode(ByteFormatter.decodeString(this.hash)) : null;
            }
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
            this.hash = null;
        }
    }

    public String getHash() {
        return this.hash;
    }

    public String getCDPLink() {
        return this.reConstructLink(this.cdpLink);
    }

    public String getCategory() {
        return this.category;
    }

    public String getDownloadLink() {
        return this.reConstructLink(this.torrentLink);
    }

    public String getDownloadButtonLink() {
        if (this.downloadButtonLink != null) {
            return this.reConstructLink(this.downloadButtonLink);
        }
        return this.getDownloadLink();
    }

    private String reConstructLink(String string) {
        if (string != null) {
            String string2 = string.toLowerCase();
            if (string2.startsWith("http://") || string2.startsWith("https://") || string2.startsWith("azplug:") || string2.startsWith("magnet:") || string2.startsWith("dht:")) {
                return string;
            }
            if (string.startsWith("/")) {
                return (this.rootPageURL == null ? "" : this.rootPageURL) + string;
            }
            return (this.basePageURL == null ? "" : this.basePageURL) + string;
        }
        return "";
    }

    public String getName() {
        return this.name;
    }

    public int getNbPeers() {
        return this.nbPeers;
    }

    public int getNbSeeds() {
        return this.nbSeeds;
    }

    public int getNbSuperSeeds() {
        return this.nbSuperSeeds;
    }

    public Date getPublishedDate() {
        return this.publishedDate;
    }

    public long getSize() {
        return this.size;
    }

    public int getComments() {
        return this.comments;
    }

    public String getSearchQuery() {
        return this.searchQuery;
    }

    public boolean isPrivate() {
        return this.privateTorrent;
    }

    public String getDRMKey() {
        return this.drmKey;
    }

    public float getAccuracy() {
        return -1.0f;
    }
}

