/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.metasearch.impl.web.json;

import com.aelitis.azureus.core.metasearch.Engine;
import com.aelitis.azureus.core.metasearch.Result;
import com.aelitis.azureus.core.metasearch.ResultListener;
import com.aelitis.azureus.core.metasearch.SearchException;
import com.aelitis.azureus.core.metasearch.SearchParameter;
import com.aelitis.azureus.core.metasearch.impl.EngineImpl;
import com.aelitis.azureus.core.metasearch.impl.MetaSearchImpl;
import com.aelitis.azureus.core.metasearch.impl.web.FieldMapping;
import com.aelitis.azureus.core.metasearch.impl.web.WebEngine;
import com.aelitis.azureus.core.metasearch.impl.web.WebResult;
import com.aelitis.azureus.util.ImportExportUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public class JSONEngine
extends WebEngine {
    private String resultsEntryPath;

    public static EngineImpl importFromBEncodedMap(MetaSearchImpl metaSearchImpl, Map map) throws IOException {
        return new JSONEngine(metaSearchImpl, map);
    }

    public static Engine importFromJSONString(MetaSearchImpl metaSearchImpl, long l, long l2, String string, JSONObject jSONObject) throws IOException {
        return new JSONEngine(metaSearchImpl, l, l2, string, jSONObject);
    }

    public JSONEngine(MetaSearchImpl metaSearchImpl, long l, long l2, String string, String string2, String string3, boolean bl, String string4, String string5, FieldMapping[] fieldMappingArray, boolean bl2, String string6, String string7, String[] stringArray) {
        super(metaSearchImpl, 2, l, l2, string, string2, string3, bl, string4, fieldMappingArray, bl2, string6, string7, stringArray);
        this.resultsEntryPath = string5;
        this.setSource(2);
        this.setSelectionState(2);
    }

    protected JSONEngine(MetaSearchImpl metaSearchImpl, Map map) throws IOException {
        super(metaSearchImpl, map);
        this.resultsEntryPath = ImportExportUtils.importString(map, "json.path");
    }

    protected JSONEngine(MetaSearchImpl metaSearchImpl, long l, long l2, String string, JSONObject jSONObject) throws IOException {
        super(metaSearchImpl, 2, l, l2, string, jSONObject);
        this.resultsEntryPath = ImportExportUtils.importString(jSONObject, "json_result_key");
    }

    public Map exportToBencodedMap() throws IOException {
        HashMap hashMap = new HashMap();
        ImportExportUtils.exportString(hashMap, "json.path", this.resultsEntryPath);
        super.exportToBencodedMap(hashMap);
        return hashMap;
    }

    protected void exportToJSONObject(JSONObject jSONObject) throws IOException {
        jSONObject.put("json_result_key", this.resultsEntryPath);
        super.exportToJSONObject(jSONObject);
    }

    protected Result[] searchSupport(SearchParameter[] searchParameterArray, Map map, int n, int n2, String string, ResultListener resultListener) throws SearchException {
        this.debugStart();
        WebEngine.pageDetails pageDetails2 = super.getWebPageContent(searchParameterArray, map, string, false);
        String string2 = pageDetails2.getContent();
        if (resultListener != null) {
            resultListener.contentReceived(this, string2);
        }
        String string3 = null;
        for (int i = 0; i < searchParameterArray.length; ++i) {
            if (!searchParameterArray[i].getMatchPattern().equals("s")) continue;
            string3 = searchParameterArray[i].getValue();
        }
        FieldMapping[] fieldMappingArray = this.getMappings();
        try {
            Object object;
            Object object2 = JSONValue.parse(string2);
            JSONArray jSONArray = null;
            if (this.resultsEntryPath != null) {
                JSONArray jSONArray2;
                object = new StringTokenizer(this.resultsEntryPath, ".");
                if (object2 instanceof JSONArray && ((StringTokenizer)object).countTokens() > 0 && (jSONArray2 = (JSONArray)object2).size() == 1) {
                    object2 = jSONArray2.get(0);
                }
                while (((StringTokenizer)object).hasMoreTokens()) {
                    try {
                        object2 = ((JSONObject)object2).get(((StringTokenizer)object).nextToken());
                    }
                    catch (Throwable throwable) {
                        throw new SearchException("Invalid entry path : " + this.resultsEntryPath, throwable);
                    }
                }
            }
            try {
                jSONArray = (JSONArray)object2;
            }
            catch (Throwable throwable) {
                throw new SearchException("Object is not a result array. Check the JSON service and/or the entry path");
            }
            if (jSONArray != null) {
                object = new ArrayList();
                for (int i = 0; i < jSONArray.size(); ++i) {
                    Object object3;
                    Object object4;
                    Object object5;
                    Object e = jSONArray.get(i);
                    if (!(e instanceof JSONObject)) continue;
                    JSONObject jSONObject = (JSONObject)e;
                    if (n2 >= 0 && --n2 < 0) break;
                    if (resultListener != null) {
                        object5 = new TreeMap(jSONObject).entrySet().iterator();
                        String[] stringArray = new String[jSONObject.size()];
                        int n3 = 0;
                        while (object5.hasNext()) {
                            Map.Entry entry = (Map.Entry)object5.next();
                            object4 = entry.getKey();
                            object3 = entry.getValue();
                            if (object4 != null && object3 != null) {
                                stringArray[n3++] = object4.toString() + "=" + UrlUtils.encode(object3.toString());
                                continue;
                            }
                            stringArray[n3++] = "";
                        }
                        resultListener.matchFound(this, stringArray);
                    }
                    object5 = new WebResult(this, this.getRootPage(), this.getBasePage(), this.getDateParser(), string3);
                    block28: for (int j = 0; j < fieldMappingArray.length; ++j) {
                        String string4 = fieldMappingArray[j].getName();
                        if (string4 == null) continue;
                        int n4 = fieldMappingArray[j].getField();
                        object4 = jSONObject.get(string4);
                        if (object4 == null) continue;
                        object3 = object4.toString();
                        switch (n4) {
                            case 1: {
                                ((WebResult)object5).setNameFromHTML((String)object3);
                                continue block28;
                            }
                            case 3: {
                                ((WebResult)object5).setSizeFromHTML((String)object3);
                                continue block28;
                            }
                            case 4: {
                                ((WebResult)object5).setNbPeersFromHTML((String)object3);
                                continue block28;
                            }
                            case 5: {
                                ((WebResult)object5).setNbSeedsFromHTML((String)object3);
                                continue block28;
                            }
                            case 6: {
                                ((WebResult)object5).setCategoryFromHTML((String)object3);
                                continue block28;
                            }
                            case 2: {
                                ((WebResult)object5).setPublishedDateFromHTML((String)object3);
                                continue block28;
                            }
                            case 7: {
                                ((WebResult)object5).setCommentsFromHTML((String)object3);
                                continue block28;
                            }
                            case 103: {
                                ((WebResult)object5).setCDPLink((String)object3);
                                continue block28;
                            }
                            case 102: {
                                ((WebResult)object5).setTorrentLink((String)object3);
                                continue block28;
                            }
                            case 104: {
                                ((WebResult)object5).setPlayLink((String)object3);
                                continue block28;
                            }
                            case 105: {
                                ((WebResult)object5).setDownloadButtonLink((String)object3);
                                continue block28;
                            }
                            case 10: {
                                ((WebResult)object5).setVotesFromHTML((String)object3);
                                continue block28;
                            }
                            case 11: {
                                ((WebResult)object5).setNbSuperSeedsFromHTML((String)object3);
                                continue block28;
                            }
                            case 12: {
                                ((WebResult)object5).setPrivateFromHTML((String)object3);
                                continue block28;
                            }
                            case 13: {
                                ((WebResult)object5).setDrmKey((String)object3);
                                continue block28;
                            }
                            case 14: {
                                ((WebResult)object5).setVotesDownFromHTML((String)object3);
                                continue block28;
                            }
                        }
                    }
                    object.add(object5);
                }
                Result[] resultArray = object.toArray(new Result[object.size()]);
                this.debugLog("success: found " + resultArray.length + " results");
                return resultArray;
            }
            this.debugLog("success: no result array found so no results");
            return new Result[0];
        }
        catch (Throwable throwable) {
            this.debugLog("failed: " + Debug.getNestedExceptionMessageAndStack(throwable));
            if (throwable instanceof SearchException) {
                throw (SearchException)throwable;
            }
            throw new SearchException("JSON matching failed", throwable);
        }
    }

    public String getIcon() {
        String string = this.getRootPage();
        if (string != null) {
            return string + "/favicon.ico";
        }
        return null;
    }
}

