/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.metasearch.impl.web.regex;

import com.aelitis.azureus.core.metasearch.Engine;
import com.aelitis.azureus.core.metasearch.Result;
import com.aelitis.azureus.core.metasearch.ResultListener;
import com.aelitis.azureus.core.metasearch.SearchException;
import com.aelitis.azureus.core.metasearch.SearchLoginException;
import com.aelitis.azureus.core.metasearch.SearchParameter;
import com.aelitis.azureus.core.metasearch.impl.EngineImpl;
import com.aelitis.azureus.core.metasearch.impl.MetaSearchImpl;
import com.aelitis.azureus.core.metasearch.impl.web.FieldMapping;
import com.aelitis.azureus.core.metasearch.impl.web.WebEngine;
import com.aelitis.azureus.core.metasearch.impl.web.WebResult;
import com.aelitis.azureus.util.ImportExportUtils;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.TimeLimitedTask;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.json.simple.JSONObject;

public class RegexEngine
extends WebEngine {
    private String pattern_str;
    private Pattern pattern;

    public static EngineImpl importFromBEncodedMap(MetaSearchImpl metaSearchImpl, Map map) throws IOException {
        return new RegexEngine(metaSearchImpl, map);
    }

    public static Engine importFromJSONString(MetaSearchImpl metaSearchImpl, long l, long l2, String string, JSONObject jSONObject) throws IOException {
        return new RegexEngine(metaSearchImpl, l, l2, string, jSONObject);
    }

    public RegexEngine(MetaSearchImpl metaSearchImpl, long l, long l2, String string, String string2, String string3, String string4, boolean bl, String string5, FieldMapping[] fieldMappingArray, boolean bl2, String string6, String string7, String[] stringArray) {
        super(metaSearchImpl, 1, l, l2, string, string2, string4, bl, string5, fieldMappingArray, bl2, string6, string7, stringArray);
        this.init(string3);
        this.setSource(2);
        this.setSelectionState(2);
    }

    protected RegexEngine(MetaSearchImpl metaSearchImpl, Map map) throws IOException {
        super(metaSearchImpl, map);
        String string = ImportExportUtils.importString(map, "regex.pattern");
        this.init(string);
    }

    protected RegexEngine(MetaSearchImpl metaSearchImpl, long l, long l2, String string, JSONObject jSONObject) throws IOException {
        super(metaSearchImpl, 1, l, l2, string, jSONObject);
        String string2 = ImportExportUtils.importString(jSONObject, "regexp");
        string2 = URLDecoder.decode(string2, "UTF-8");
        this.init(string2);
    }

    public Map exportToBencodedMap() throws IOException {
        HashMap hashMap = new HashMap();
        ImportExportUtils.exportString(hashMap, "regex.pattern", this.pattern_str);
        super.exportToBencodedMap(hashMap);
        return hashMap;
    }

    protected void exportToJSONObject(JSONObject jSONObject) throws IOException {
        jSONObject.put("regexp", UrlUtils.encode(this.pattern_str));
        super.exportToJSONObject(jSONObject);
    }

    protected void init(String string) {
        this.pattern_str = string.trim();
        this.pattern = Pattern.compile(this.pattern_str);
    }

    protected Result[] searchSupport(final SearchParameter[] searchParameterArray, Map map, int n, final int n2, String string, final ResultListener resultListener) throws SearchException {
        this.debugStart();
        final WebEngine.pageDetails pageDetails2 = this.getWebPageContent(searchParameterArray, map, string, false);
        final String string2 = pageDetails2.getContent();
        if (resultListener != null) {
            resultListener.contentReceived(this, string2);
        }
        this.debugLog("pattern: " + this.pattern_str);
        try {
            TimeLimitedTask timeLimitedTask = new TimeLimitedTask("MetaSearch:regexpr", 30000, 4, new TimeLimitedTask.task(){

                public Object run() throws Exception {
                    int n = n2;
                    if (n < 0 || n > 1024) {
                        n = 1024;
                    }
                    String string = null;
                    for (int i = 0; i < searchParameterArray.length; ++i) {
                        if (!searchParameterArray[i].getMatchPattern().equals("s")) continue;
                        string = searchParameterArray[i].getValue();
                    }
                    FieldMapping[] fieldMappingArray = RegexEngine.this.getMappings();
                    try {
                        ArrayList<Object> arrayList = new ArrayList<Object>();
                        Matcher matcher = RegexEngine.this.pattern.matcher(string2);
                        while (matcher.find() && (n < 0 || --n >= 0)) {
                            int n22;
                            Object object;
                            if (resultListener != null) {
                                object = new String[matcher.groupCount()];
                                for (n22 = 0; n22 < ((String[])object).length; ++n22) {
                                    object[n22] = matcher.group(n22 + 1);
                                }
                                resultListener.matchFound(RegexEngine.this, (String[])object);
                            }
                            RegexEngine.this.debugLog("Found match:");
                            object = new WebResult(RegexEngine.this, RegexEngine.this.getRootPage(), RegexEngine.this.getBasePage(), RegexEngine.this.getDateParser(), string);
                            n22 = 0;
                            block25: for (int i = 0; i < fieldMappingArray.length; ++i) {
                                int n3 = -1;
                                try {
                                    n3 = Integer.parseInt(fieldMappingArray[i].getName());
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                if (n3 <= 0 || n3 > matcher.groupCount()) continue;
                                int n4 = fieldMappingArray[i].getField();
                                String string22 = matcher.group(n3);
                                RegexEngine.this.debugLog("    " + n4 + "=" + string22);
                                ++n22;
                                switch (n4) {
                                    case 1: {
                                        ((WebResult)object).setNameFromHTML(string22);
                                        continue block25;
                                    }
                                    case 3: {
                                        ((WebResult)object).setSizeFromHTML(string22);
                                        continue block25;
                                    }
                                    case 4: {
                                        ((WebResult)object).setNbPeersFromHTML(string22);
                                        continue block25;
                                    }
                                    case 5: {
                                        ((WebResult)object).setNbSeedsFromHTML(string22);
                                        continue block25;
                                    }
                                    case 6: {
                                        ((WebResult)object).setCategoryFromHTML(string22);
                                        continue block25;
                                    }
                                    case 2: {
                                        ((WebResult)object).setPublishedDateFromHTML(string22);
                                        continue block25;
                                    }
                                    case 103: {
                                        ((WebResult)object).setCDPLink(string22);
                                        continue block25;
                                    }
                                    case 102: {
                                        ((WebResult)object).setTorrentLink(string22);
                                        continue block25;
                                    }
                                    case 104: {
                                        ((WebResult)object).setPlayLink(string22);
                                        continue block25;
                                    }
                                    case 105: {
                                        ((WebResult)object).setDownloadButtonLink(string22);
                                        continue block25;
                                    }
                                    case 7: {
                                        ((WebResult)object).setCommentsFromHTML(string22);
                                        continue block25;
                                    }
                                    case 10: {
                                        ((WebResult)object).setVotesFromHTML(string22);
                                        continue block25;
                                    }
                                    case 11: {
                                        ((WebResult)object).setNbSuperSeedsFromHTML(string22);
                                        continue block25;
                                    }
                                    case 12: {
                                        ((WebResult)object).setPrivateFromHTML(string22);
                                        continue block25;
                                    }
                                    case 13: {
                                        ((WebResult)object).setDrmKey(string22);
                                        continue block25;
                                    }
                                    case 14: {
                                        ((WebResult)object).setVotesDownFromHTML(string22);
                                        continue block25;
                                    }
                                    default: {
                                        --n22;
                                    }
                                }
                            }
                            if (n22 <= 0) continue;
                            arrayList.add(object);
                        }
                        if (arrayList.size() == 0 && RegexEngine.this.isNeedsAuth() && pageDetails2.getInitialURL().getProtocol().equalsIgnoreCase("http") && pageDetails2.getFinalURL().getProtocol().equalsIgnoreCase("https")) {
                            throw new SearchLoginException("login possibly required");
                        }
                        return arrayList.toArray(new Result[arrayList.size()]);
                    }
                    catch (Throwable throwable) {
                        RegexEngine.this.log("Failed process result", throwable);
                        if (throwable instanceof SearchException) {
                            throw (SearchException)throwable;
                        }
                        throw new SearchException(throwable);
                    }
                }
            });
            Result[] resultArray = (Result[])timeLimitedTask.run();
            this.debugLog("success: found " + resultArray.length + " results");
            return resultArray;
        }
        catch (Throwable throwable) {
            this.debugLog("failed: " + Debug.getNestedExceptionMessageAndStack(throwable));
            if (throwable instanceof SearchException) {
                throw (SearchException)throwable;
            }
            throw new SearchException("Regex matching failed", throwable);
        }
    }
}

