/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.networkmanager.ConnectionEndpoint;
import com.aelitis.azureus.core.networkmanager.LimitedRateGroup;
import com.aelitis.azureus.core.networkmanager.NetworkConnection;
import com.aelitis.azureus.core.networkmanager.NetworkConnectionBase;
import com.aelitis.azureus.core.networkmanager.NetworkConnectionFactory;
import com.aelitis.azureus.core.networkmanager.NetworkManagerStats;
import com.aelitis.azureus.core.networkmanager.Transport;
import com.aelitis.azureus.core.networkmanager.impl.IncomingConnectionManager;
import com.aelitis.azureus.core.networkmanager.impl.RateControlledEntity;
import com.aelitis.azureus.core.networkmanager.impl.ReadController;
import com.aelitis.azureus.core.networkmanager.impl.TransferProcessor;
import com.aelitis.azureus.core.networkmanager.impl.TransportHelper;
import com.aelitis.azureus.core.networkmanager.impl.WriteController;
import com.aelitis.azureus.core.networkmanager.impl.http.HTTPNetworkManager;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TCPNetworkManager;
import com.aelitis.azureus.core.networkmanager.impl.udp.UDPNetworkManager;
import com.aelitis.azureus.core.peermanager.messaging.MessageStreamDecoder;
import com.aelitis.azureus.core.peermanager.messaging.MessageStreamEncoder;
import com.aelitis.azureus.core.peermanager.messaging.MessageStreamFactory;
import com.aelitis.azureus.core.util.FeatureAvailability;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.global.GlobalManagerListener;
import org.gudy.azureus2.core3.util.Debug;

public class NetworkManager {
    public static final int UNLIMITED_RATE = 0x6400000;
    private static final NetworkManager instance = new NetworkManager();
    private static int max_download_rate_bps;
    private static int external_max_download_rate_bps;
    private static int max_upload_rate_bps_normal;
    private static int max_upload_rate_bps_seeding_only;
    private static int max_upload_rate_bps;
    private static boolean lan_rate_enabled;
    private static int max_lan_upload_rate_bps;
    private static int max_lan_download_rate_bps;
    private static boolean seeding_only_mode_allowed;
    private static boolean seeding_only_mode;
    public static boolean REQUIRE_CRYPTO_HANDSHAKE;
    public static boolean INCOMING_HANDSHAKE_FALLBACK_ALLOWED;
    public static boolean OUTGOING_HANDSHAKE_FALLBACK_ALLOWED;
    public static boolean INCOMING_CRYPTO_ALLOWED;
    private static boolean USE_REQUEST_LIMITING;
    private final List<WriteController> write_controllers;
    private final List<ReadController> read_controllers;
    private final TransferProcessor upload_processor;
    private final TransferProcessor download_processor;
    private final TransferProcessor lan_upload_processor;
    private final TransferProcessor lan_download_processor;
    private NetworkManagerStats stats;
    public static final int CRYPTO_OVERRIDE_NONE = 0;
    public static final int CRYPTO_OVERRIDE_REQUIRED = 1;
    public static final int CRYPTO_OVERRIDE_NOT_REQUIRED = 2;

    public static boolean isLANRateEnabled() {
        return lan_rate_enabled;
    }

    private NetworkManager() {
        int n;
        int n2 = COConfigurationManager.getIntParameter("network.control.read.processor.count");
        this.read_controllers = new ArrayList<ReadController>(n2);
        for (n = 0; n < n2; ++n) {
            this.read_controllers.add(new ReadController());
        }
        n = COConfigurationManager.getIntParameter("network.control.write.processor.count");
        this.write_controllers = new ArrayList<WriteController>(n);
        for (int i = 0; i < n; ++i) {
            this.write_controllers.add(new WriteController());
        }
        this.upload_processor = new TransferProcessor(0, new LimitedRateGroup(){

            public String getName() {
                return "global_up";
            }

            public int getRateLimitBytesPerSecond() {
                return max_upload_rate_bps;
            }
        }, this.write_controllers.size() > 1);
        this.download_processor = new TransferProcessor(1, new LimitedRateGroup(){

            public String getName() {
                return "global_down";
            }

            public int getRateLimitBytesPerSecond() {
                return max_download_rate_bps;
            }
        }, this.read_controllers.size() > 1);
        this.lan_upload_processor = new TransferProcessor(0, new LimitedRateGroup(){

            public String getName() {
                return "global_lan_up";
            }

            public int getRateLimitBytesPerSecond() {
                return max_lan_upload_rate_bps;
            }
        }, this.write_controllers.size() > 1);
        this.lan_download_processor = new TransferProcessor(1, new LimitedRateGroup(){

            public String getName() {
                return "global_lan_down";
            }

            public int getRateLimitBytesPerSecond() {
                return max_lan_download_rate_bps;
            }
        }, this.read_controllers.size() > 1);
        this.stats = new NetworkManagerStats();
    }

    public static int getMinMssSize() {
        return Math.min(TCPNetworkManager.getTcpMssSize(), UDPNetworkManager.getUdpMssSize());
    }

    private static void refreshRates() {
        max_upload_rate_bps = NetworkManager.isSeedingOnlyUploadRate() ? max_upload_rate_bps_seeding_only : max_upload_rate_bps_normal;
        if (max_upload_rate_bps < 1024) {
            Debug.out("max_upload_rate_bps < 1024=" + max_upload_rate_bps);
        }
        int n = Math.min(max_upload_rate_bps, Math.min(max_download_rate_bps, Math.min(max_lan_upload_rate_bps, max_lan_download_rate_bps)));
        TCPNetworkManager.refreshRates(n);
        UDPNetworkManager.refreshRates(n);
    }

    public static boolean isSeedingOnlyUploadRate() {
        return seeding_only_mode_allowed && seeding_only_mode;
    }

    public static int getMaxUploadRateBPSNormal() {
        if (max_upload_rate_bps_normal == 0x6400000) {
            return 0;
        }
        return max_upload_rate_bps_normal;
    }

    public static int getMaxUploadRateBPSSeedingOnly() {
        if (max_upload_rate_bps_seeding_only == 0x6400000) {
            return 0;
        }
        return max_upload_rate_bps_seeding_only;
    }

    public static int getMaxDownloadRateBPS() {
        if (max_download_rate_bps == 0x6400000) {
            return 0;
        }
        return external_max_download_rate_bps;
    }

    public static boolean getCryptoRequired(int n) {
        if (n == 0) {
            return REQUIRE_CRYPTO_HANDSHAKE;
        }
        return n == 1;
    }

    public void initialize(AzureusCore azureusCore) {
        HTTPNetworkManager.getSingleton();
        azureusCore.getGlobalManager().addListener(new GlobalManagerListener(){

            public void downloadManagerAdded(DownloadManager downloadManager) {
            }

            public void downloadManagerRemoved(DownloadManager downloadManager) {
            }

            public void destroyInitiated() {
            }

            public void destroyed() {
            }

            public void seedingStatusChanged(boolean bl, boolean bl2) {
                seeding_only_mode = bl;
                NetworkManager.refreshRates();
            }
        });
    }

    public static NetworkManager getSingleton() {
        return instance;
    }

    public NetworkConnection createConnection(ConnectionEndpoint connectionEndpoint, MessageStreamEncoder messageStreamEncoder, MessageStreamDecoder messageStreamDecoder, boolean bl, boolean bl2, byte[][] byArray) {
        return NetworkConnectionFactory.create(connectionEndpoint, messageStreamEncoder, messageStreamDecoder, bl, bl2, byArray);
    }

    public void requestIncomingConnectionRouting(ByteMatcher byteMatcher, final RoutingListener routingListener, final MessageStreamFactory messageStreamFactory) {
        IncomingConnectionManager.getSingleton().registerMatchBytes(byteMatcher, new IncomingConnectionManager.MatchListener(){

            public boolean autoCryptoFallback() {
                return routingListener.autoCryptoFallback();
            }

            public void connectionMatched(Transport transport, Object object) {
                routingListener.connectionRouted(NetworkConnectionFactory.create(transport, messageStreamFactory.createEncoder(), messageStreamFactory.createDecoder()), object);
            }
        });
    }

    public NetworkConnection bindTransport(Transport transport, MessageStreamEncoder messageStreamEncoder, MessageStreamDecoder messageStreamDecoder) {
        return NetworkConnectionFactory.create(transport, messageStreamEncoder, messageStreamDecoder);
    }

    public void cancelIncomingConnectionRouting(ByteMatcher byteMatcher) {
        IncomingConnectionManager.getSingleton().deregisterMatchBytes(byteMatcher);
    }

    public void addWriteEntity(RateControlledEntity rateControlledEntity, int n) {
        if (this.write_controllers.size() == 1 || n < 0) {
            this.write_controllers.get(0).addWriteEntity(rateControlledEntity);
        } else {
            WriteController writeController = this.write_controllers.get(n % (this.write_controllers.size() - 1) + 1);
            writeController.addWriteEntity(rateControlledEntity);
        }
    }

    public void removeWriteEntity(RateControlledEntity rateControlledEntity) {
        if (this.write_controllers.size() == 1) {
            this.write_controllers.get(0).removeWriteEntity(rateControlledEntity);
        } else {
            for (WriteController writeController : this.write_controllers) {
                writeController.removeWriteEntity(rateControlledEntity);
            }
        }
    }

    public void addReadEntity(RateControlledEntity rateControlledEntity, int n) {
        if (this.read_controllers.size() == 1 || n < 0) {
            this.read_controllers.get(0).addReadEntity(rateControlledEntity);
        } else {
            ReadController readController = this.read_controllers.get(n % (this.read_controllers.size() - 1) + 1);
            readController.addReadEntity(rateControlledEntity);
        }
    }

    public void removeReadEntity(RateControlledEntity rateControlledEntity) {
        if (this.read_controllers.size() == 1) {
            this.read_controllers.get(0).removeReadEntity(rateControlledEntity);
        } else {
            for (ReadController readController : this.read_controllers) {
                readController.removeReadEntity(rateControlledEntity);
            }
        }
    }

    public void startTransferProcessing(NetworkConnectionBase networkConnectionBase) {
        if (networkConnectionBase.isLANLocal() && lan_rate_enabled) {
            this.lan_upload_processor.registerPeerConnection(networkConnectionBase, true);
            this.lan_download_processor.registerPeerConnection(networkConnectionBase, false);
        } else {
            this.upload_processor.registerPeerConnection(networkConnectionBase, true);
            this.download_processor.registerPeerConnection(networkConnectionBase, false);
        }
    }

    public void stopTransferProcessing(NetworkConnectionBase networkConnectionBase) {
        if (this.lan_upload_processor.isRegistered(networkConnectionBase)) {
            this.lan_upload_processor.deregisterPeerConnection(networkConnectionBase);
            this.lan_download_processor.deregisterPeerConnection(networkConnectionBase);
        } else {
            this.upload_processor.deregisterPeerConnection(networkConnectionBase);
            this.download_processor.deregisterPeerConnection(networkConnectionBase);
        }
    }

    public void upgradeTransferProcessing(NetworkConnectionBase networkConnectionBase, int n) {
        if (this.lan_upload_processor.isRegistered(networkConnectionBase)) {
            this.lan_upload_processor.upgradePeerConnection(networkConnectionBase, n);
            this.lan_download_processor.upgradePeerConnection(networkConnectionBase, n);
        } else {
            this.upload_processor.upgradePeerConnection(networkConnectionBase, n);
            this.download_processor.upgradePeerConnection(networkConnectionBase, n);
        }
    }

    public void downgradeTransferProcessing(NetworkConnectionBase networkConnectionBase) {
        if (this.lan_upload_processor.isRegistered(networkConnectionBase)) {
            this.lan_upload_processor.downgradePeerConnection(networkConnectionBase);
            this.lan_download_processor.downgradePeerConnection(networkConnectionBase);
        } else {
            this.upload_processor.downgradePeerConnection(networkConnectionBase);
            this.download_processor.downgradePeerConnection(networkConnectionBase);
        }
    }

    public void addRateLimiter(NetworkConnectionBase networkConnectionBase, LimitedRateGroup limitedRateGroup, boolean bl) {
        if (bl) {
            if (this.lan_upload_processor.isRegistered(networkConnectionBase)) {
                this.lan_upload_processor.addRateLimiter(networkConnectionBase, limitedRateGroup);
            } else {
                this.upload_processor.addRateLimiter(networkConnectionBase, limitedRateGroup);
            }
        } else if (this.lan_download_processor.isRegistered(networkConnectionBase)) {
            this.lan_download_processor.addRateLimiter(networkConnectionBase, limitedRateGroup);
        } else {
            this.download_processor.addRateLimiter(networkConnectionBase, limitedRateGroup);
        }
    }

    public void removeRateLimiter(NetworkConnectionBase networkConnectionBase, LimitedRateGroup limitedRateGroup, boolean bl) {
        if (bl) {
            if (this.lan_upload_processor.isRegistered(networkConnectionBase)) {
                this.lan_upload_processor.removeRateLimiter(networkConnectionBase, limitedRateGroup);
            } else {
                this.upload_processor.removeRateLimiter(networkConnectionBase, limitedRateGroup);
            }
        } else if (this.lan_download_processor.isRegistered(networkConnectionBase)) {
            this.lan_download_processor.removeRateLimiter(networkConnectionBase, limitedRateGroup);
        } else {
            this.download_processor.removeRateLimiter(networkConnectionBase, limitedRateGroup);
        }
    }

    public NetworkManagerStats getStats() {
        return this.stats;
    }

    static {
        seeding_only_mode = false;
        COConfigurationManager.addAndFireParameterListeners(new String[]{"network.transport.encrypted.require", "network.transport.encrypted.fallback.incoming", "network.transport.encrypted.fallback.outgoing", "network.transport.encrypted.allow.incoming", "LAN Speed Enabled", "Max Upload Speed KBs", "Max LAN Upload Speed KBs", "Max Upload Speed Seeding KBs", "enable.seedingonly.upload.rate", "Max Download Speed KBs", "Max LAN Download Speed KBs", "network.tcp.mtu.size", "network.udp.mtu.size", "Use Request Limiting"}, new ParameterListener(){

            public void parameterChanged(String string) {
                REQUIRE_CRYPTO_HANDSHAKE = COConfigurationManager.getBooleanParameter("network.transport.encrypted.require");
                INCOMING_HANDSHAKE_FALLBACK_ALLOWED = COConfigurationManager.getBooleanParameter("network.transport.encrypted.fallback.incoming");
                OUTGOING_HANDSHAKE_FALLBACK_ALLOWED = COConfigurationManager.getBooleanParameter("network.transport.encrypted.fallback.outgoing");
                INCOMING_CRYPTO_ALLOWED = COConfigurationManager.getBooleanParameter("network.transport.encrypted.allow.incoming");
                USE_REQUEST_LIMITING = COConfigurationManager.getBooleanParameter("Use Request Limiting");
                max_upload_rate_bps_normal = COConfigurationManager.getIntParameter("Max Upload Speed KBs") * 1024;
                if (max_upload_rate_bps_normal < 1024) {
                    max_upload_rate_bps_normal = 0x6400000;
                }
                if (max_upload_rate_bps_normal > 0x6400000) {
                    max_upload_rate_bps_normal = 0x6400000;
                }
                max_lan_upload_rate_bps = COConfigurationManager.getIntParameter("Max LAN Upload Speed KBs") * 1024;
                if (max_lan_upload_rate_bps < 1024) {
                    max_lan_upload_rate_bps = 0x6400000;
                }
                if (max_lan_upload_rate_bps > 0x6400000) {
                    max_lan_upload_rate_bps = 0x6400000;
                }
                max_upload_rate_bps_seeding_only = COConfigurationManager.getIntParameter("Max Upload Speed Seeding KBs") * 1024;
                if (max_upload_rate_bps_seeding_only < 1024) {
                    max_upload_rate_bps_seeding_only = 0x6400000;
                }
                if (max_upload_rate_bps_seeding_only > 0x6400000) {
                    max_upload_rate_bps_seeding_only = 0x6400000;
                }
                seeding_only_mode_allowed = COConfigurationManager.getBooleanParameter("enable.seedingonly.upload.rate");
                external_max_download_rate_bps = (max_download_rate_bps = COConfigurationManager.getIntParameter("Max Download Speed KBs") * 1024);
                if (max_download_rate_bps < 1024 || max_download_rate_bps > 0x6400000) {
                    max_download_rate_bps = 0x6400000;
                } else if (USE_REQUEST_LIMITING && FeatureAvailability.isRequestLimitingEnabled()) {
                    max_download_rate_bps = (int)((double)max_download_rate_bps + Math.max((double)max_download_rate_bps * 0.1, 5120.0));
                }
                lan_rate_enabled = COConfigurationManager.getBooleanParameter("LAN Speed Enabled");
                max_lan_download_rate_bps = COConfigurationManager.getIntParameter("Max LAN Download Speed KBs") * 1024;
                if (max_lan_download_rate_bps < 1024) {
                    max_lan_download_rate_bps = 0x6400000;
                }
                if (max_lan_download_rate_bps > 0x6400000) {
                    max_lan_download_rate_bps = 0x6400000;
                }
                NetworkManager.refreshRates();
            }
        });
    }

    public static interface RoutingListener {
        public boolean autoCryptoFallback();

        public void connectionRouted(NetworkConnection var1, Object var2);
    }

    public static interface ByteMatcher {
        public int matchThisSizeOrBigger();

        public int maxSize();

        public int minSize();

        public Object matches(TransportHelper var1, ByteBuffer var2, int var3);

        public Object minMatches(TransportHelper var1, ByteBuffer var2, int var3);

        public byte[][] getSharedSecrets();

        public int getSpecificPort();
    }
}

