/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager;

import com.aelitis.azureus.core.networkmanager.impl.tcp.VirtualChannelSelectorImpl;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;

public class VirtualChannelSelector {
    private static final LogIDs LOGID = LogIDs.NWMAN;
    public static final int OP_ACCEPT = 16;
    public static final int OP_CONNECT = 8;
    public static final int OP_READ = 1;
    public static final int OP_WRITE = 4;
    private boolean SAFE_SELECTOR_MODE_ENABLED = COConfigurationManager.getBooleanParameter("network.tcp.enable_safe_selector_mode");
    private static final boolean TEST_SAFE_MODE = false;
    private static final int MAX_CHANNELS_PER_SAFE_SELECTOR = COConfigurationManager.getIntParameter("network.tcp.safe_selector_mode.chunk_size");
    private static final int MAX_SAFEMODE_SELECTORS = 20000 / MAX_CHANNELS_PER_SAFE_SELECTOR;
    private String name;
    private VirtualChannelSelectorImpl selector_impl;
    private volatile boolean destroyed;
    private HashMap<VirtualChannelSelectorImpl, ArrayList<AbstractSelectableChannel>> selectors;
    private HashSet<VirtualChannelSelectorImpl> selectors_keyset_cow;
    private AEMonitor selectors_mon;
    private final int op;
    private final boolean pause;
    private boolean randomise_keys;

    public VirtualChannelSelector(String string, int n, boolean bl) {
        this.name = string;
        this.op = n;
        this.pause = bl;
        if (this.SAFE_SELECTOR_MODE_ENABLED) {
            this.initSafeMode();
        } else {
            this.selector_impl = new VirtualChannelSelectorImpl(this, this.op, this.pause, this.randomise_keys);
            this.selectors = null;
            this.selectors_keyset_cow = null;
            this.selectors_mon = null;
        }
    }

    public String getName() {
        return this.name;
    }

    private void initSafeMode() {
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(LOGID, "***************** SAFE SOCKET SELECTOR MODE ENABLED *****************"));
        }
        this.selector_impl = null;
        this.selectors = new HashMap();
        this.selectors_mon = new AEMonitor("VirtualChannelSelector:FM");
        this.selectors.put(new VirtualChannelSelectorImpl(this, this.op, this.pause, this.randomise_keys), new ArrayList());
        this.selectors_keyset_cow = new HashSet<VirtualChannelSelectorImpl>(this.selectors.keySet());
    }

    public void register(SocketChannel socketChannel, VirtualSelectorListener virtualSelectorListener, Object object) {
        this.registerSupport(socketChannel, virtualSelectorListener, object);
    }

    public void register(ServerSocketChannel serverSocketChannel, VirtualAcceptSelectorListener virtualAcceptSelectorListener, Object object) {
        this.registerSupport(serverSocketChannel, virtualAcceptSelectorListener, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void registerSupport(AbstractSelectableChannel abstractSelectableChannel, VirtualAbstractSelectorListener virtualAbstractSelectorListener, Object object) {
        block10: {
            block9: {
                block8: {
                    if (!this.SAFE_SELECTOR_MODE_ENABLED) {
                        this.selector_impl.register(abstractSelectableChannel, virtualAbstractSelectorListener, object);
                        return;
                    }
                    try {
                        Object object2;
                        this.selectors_mon.enter();
                        for (Map.Entry<VirtualChannelSelectorImpl, ArrayList<AbstractSelectableChannel>> entry : this.selectors.entrySet()) {
                            VirtualChannelSelectorImpl virtualChannelSelectorImpl = entry.getKey();
                            ArrayList<AbstractSelectableChannel> arrayList = entry.getValue();
                            if (arrayList.size() >= MAX_CHANNELS_PER_SAFE_SELECTOR) {
                                Iterator<AbstractSelectableChannel> iterator = arrayList.iterator();
                                while (iterator.hasNext()) {
                                    AbstractSelectableChannel abstractSelectableChannel2 = iterator.next();
                                    if (abstractSelectableChannel2.isOpen()) continue;
                                    Debug.out("Selector '" + this.getName() + "' - removing orphaned safe channel registration");
                                    iterator.remove();
                                }
                            }
                            if (arrayList.size() >= MAX_CHANNELS_PER_SAFE_SELECTOR) continue;
                            virtualChannelSelectorImpl.register(abstractSelectableChannel, virtualAbstractSelectorListener, object);
                            arrayList.add(abstractSelectableChannel);
                            Object var11_11 = null;
                            this.selectors_mon.exit();
                            return;
                        }
                        if (this.selectors.size() >= MAX_SAFEMODE_SELECTORS) {
                            object2 = "Error: MAX_SAFEMODE_SELECTORS reached [" + this.selectors.size() + "], no more socket channels can be registered. Too many peer connections.";
                            Debug.out((String)object2);
                            this.selectFailure(virtualAbstractSelectorListener, abstractSelectableChannel, object, new Throwable((String)object2));
                            break block8;
                        }
                        if (this.destroyed) {
                            object2 = "socket registered after controller destroyed";
                            Debug.out((String)object2);
                            this.selectFailure(virtualAbstractSelectorListener, abstractSelectableChannel, object, new Throwable((String)object2));
                            break block9;
                        }
                        object2 = new VirtualChannelSelectorImpl(this, this.op, this.pause, this.randomise_keys);
                        ArrayList<AbstractSelectableChannel> arrayList = new ArrayList<AbstractSelectableChannel>();
                        this.selectors.put((VirtualChannelSelectorImpl)object2, arrayList);
                        ((VirtualChannelSelectorImpl)object2).register(abstractSelectableChannel, virtualAbstractSelectorListener, object);
                        arrayList.add(abstractSelectableChannel);
                        this.selectors_keyset_cow = new HashSet<VirtualChannelSelectorImpl>(this.selectors.keySet());
                        break block10;
                    }
                    catch (Throwable throwable) {
                        Object var11_15 = null;
                        this.selectors_mon.exit();
                        throw throwable;
                    }
                }
                Object var11_12 = null;
                this.selectors_mon.exit();
                return;
            }
            Object var11_13 = null;
            this.selectors_mon.exit();
            return;
        }
        Object var11_14 = null;
        this.selectors_mon.exit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pauseSelects(AbstractSelectableChannel abstractSelectableChannel) {
        block4: {
            if (this.SAFE_SELECTOR_MODE_ENABLED) {
                try {
                    this.selectors_mon.enter();
                    for (Map.Entry<VirtualChannelSelectorImpl, ArrayList<AbstractSelectableChannel>> entry : this.selectors.entrySet()) {
                        VirtualChannelSelectorImpl virtualChannelSelectorImpl = entry.getKey();
                        ArrayList<AbstractSelectableChannel> arrayList = entry.getValue();
                        if (!arrayList.contains(abstractSelectableChannel)) continue;
                        virtualChannelSelectorImpl.pauseSelects(abstractSelectableChannel);
                        Object var7_6 = null;
                        this.selectors_mon.exit();
                        return;
                    }
                    Debug.out("pauseSelects():: channel not found!");
                }
                catch (Throwable throwable) {
                    Object var7_8 = null;
                    this.selectors_mon.exit();
                    throw throwable;
                }
                Object var7_7 = null;
                this.selectors_mon.exit();
                {
                    break block4;
                }
            }
            this.selector_impl.pauseSelects(abstractSelectableChannel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeSelects(AbstractSelectableChannel abstractSelectableChannel) {
        block4: {
            if (this.SAFE_SELECTOR_MODE_ENABLED) {
                try {
                    this.selectors_mon.enter();
                    for (Map.Entry<VirtualChannelSelectorImpl, ArrayList<AbstractSelectableChannel>> entry : this.selectors.entrySet()) {
                        VirtualChannelSelectorImpl virtualChannelSelectorImpl = entry.getKey();
                        ArrayList<AbstractSelectableChannel> arrayList = entry.getValue();
                        if (!arrayList.contains(abstractSelectableChannel)) continue;
                        virtualChannelSelectorImpl.resumeSelects(abstractSelectableChannel);
                        Object var7_6 = null;
                        this.selectors_mon.exit();
                        return;
                    }
                    Debug.out("resumeSelects():: channel not found!");
                }
                catch (Throwable throwable) {
                    Object var7_8 = null;
                    this.selectors_mon.exit();
                    throw throwable;
                }
                Object var7_7 = null;
                this.selectors_mon.exit();
                {
                    break block4;
                }
            }
            this.selector_impl.resumeSelects(abstractSelectableChannel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(AbstractSelectableChannel abstractSelectableChannel) {
        if (this.SAFE_SELECTOR_MODE_ENABLED) {
            try {
                this.selectors_mon.enter();
                for (Map.Entry<VirtualChannelSelectorImpl, ArrayList<AbstractSelectableChannel>> entry : this.selectors.entrySet()) {
                    VirtualChannelSelectorImpl virtualChannelSelectorImpl = entry.getKey();
                    ArrayList<AbstractSelectableChannel> arrayList = entry.getValue();
                    if (!arrayList.remove(abstractSelectableChannel)) continue;
                    virtualChannelSelectorImpl.cancel(abstractSelectableChannel);
                    Object var7_6 = null;
                    this.selectors_mon.exit();
                    return;
                }
                Object var7_7 = null;
                this.selectors_mon.exit();
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                this.selectors_mon.exit();
                throw throwable;
            }
        } else if (this.selector_impl != null) {
            this.selector_impl.cancel(abstractSelectableChannel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRandomiseKeys(boolean bl) {
        this.randomise_keys = bl;
        if (this.SAFE_SELECTOR_MODE_ENABLED) {
            try {
                this.selectors_mon.enter();
                for (VirtualChannelSelectorImpl virtualChannelSelectorImpl : this.selectors.keySet()) {
                    virtualChannelSelectorImpl.setRandomiseKeys(this.randomise_keys);
                }
                Object var5_4 = null;
                this.selectors_mon.exit();
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.selectors_mon.exit();
                throw throwable;
            }
        } else if (this.selector_impl != null) {
            this.selector_impl.setRandomiseKeys(this.randomise_keys);
        }
    }

    /*
     * Exception decompiling
     */
    public int select(long var1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Missing node tying up JSR block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.tieUpRelations(Op02WithProcessedDataAndRefs.java:2900)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.copyBlock(Op02WithProcessedDataAndRefs.java:2889)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.inlineJSR(Op02WithProcessedDataAndRefs.java:2845)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.processJSRs(Op02WithProcessedDataAndRefs.java:2591)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.processJSR(Op02WithProcessedDataAndRefs.java:2481)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:444)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void destroy() {
        this.destroyed = true;
        if (this.SAFE_SELECTOR_MODE_ENABLED) {
            for (VirtualChannelSelectorImpl virtualChannelSelectorImpl : this.selectors_keyset_cow) {
                virtualChannelSelectorImpl.destroy();
            }
        } else {
            this.selector_impl.destroy();
        }
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    public boolean isSafeSelectionModeEnabled() {
        return this.SAFE_SELECTOR_MODE_ENABLED;
    }

    public void enableSafeSelectionMode() {
        if (!this.SAFE_SELECTOR_MODE_ENABLED) {
            this.SAFE_SELECTOR_MODE_ENABLED = true;
            COConfigurationManager.setParameter("network.tcp.enable_safe_selector_mode", true);
            this.initSafeMode();
        }
    }

    public boolean selectSuccess(VirtualAbstractSelectorListener virtualAbstractSelectorListener, AbstractSelectableChannel abstractSelectableChannel, Object object) {
        if (this.op == 16) {
            return ((VirtualAcceptSelectorListener)virtualAbstractSelectorListener).selectSuccess(this, (ServerSocketChannel)abstractSelectableChannel, object);
        }
        return ((VirtualSelectorListener)virtualAbstractSelectorListener).selectSuccess(this, (SocketChannel)abstractSelectableChannel, object);
    }

    public void selectFailure(VirtualAbstractSelectorListener virtualAbstractSelectorListener, AbstractSelectableChannel abstractSelectableChannel, Object object, Throwable throwable) {
        if (this.op == 16) {
            ((VirtualAcceptSelectorListener)virtualAbstractSelectorListener).selectFailure(this, (ServerSocketChannel)abstractSelectableChannel, object, throwable);
        } else {
            ((VirtualSelectorListener)virtualAbstractSelectorListener).selectFailure(this, (SocketChannel)abstractSelectableChannel, object, throwable);
        }
    }

    public static interface VirtualAcceptSelectorListener
    extends VirtualAbstractSelectorListener {
        public boolean selectSuccess(VirtualChannelSelector var1, ServerSocketChannel var2, Object var3);

        public void selectFailure(VirtualChannelSelector var1, ServerSocketChannel var2, Object var3, Throwable var4);
    }

    public static interface VirtualSelectorListener
    extends VirtualAbstractSelectorListener {
        public boolean selectSuccess(VirtualChannelSelector var1, SocketChannel var2, Object var3);

        public void selectFailure(VirtualChannelSelector var1, SocketChannel var2, Object var3, Throwable var4);
    }

    public static interface VirtualAbstractSelectorListener {
    }
}

