/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager;

import com.aelitis.azureus.core.networkmanager.VirtualServerChannelSelector;
import com.aelitis.azureus.core.networkmanager.impl.tcp.VirtualBlockingServerChannelSelector;
import com.aelitis.azureus.core.networkmanager.impl.tcp.VirtualNonBlockingServerChannelSelector;
import java.net.InetSocketAddress;
import org.gudy.azureus2.core3.config.COConfigurationManager;

public class VirtualServerChannelSelectorFactory {
    public static VirtualServerChannelSelector createBlocking(InetSocketAddress inetSocketAddress, int n, VirtualServerChannelSelector.SelectListener selectListener2) {
        return new VirtualBlockingServerChannelSelector(inetSocketAddress, n, selectListener2);
    }

    public static VirtualServerChannelSelector createNonBlocking(InetSocketAddress inetSocketAddress, int n, VirtualServerChannelSelector.SelectListener selectListener2) {
        return new VirtualNonBlockingServerChannelSelector(inetSocketAddress, n, selectListener2);
    }

    public static VirtualServerChannelSelector createTest(InetSocketAddress inetSocketAddress, int n, VirtualServerChannelSelector.SelectListener selectListener2) {
        int n2 = COConfigurationManager.getIntParameter("TCP.Listen.Port.Range", -1);
        if (n2 == -1) {
            return VirtualServerChannelSelectorFactory.createBlocking(inetSocketAddress, n, selectListener2);
        }
        return new VirtualNonBlockingServerChannelSelector(inetSocketAddress.getAddress(), inetSocketAddress.getPort(), n2, n, selectListener2);
    }
}

