/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.admin.impl;

import com.aelitis.azureus.core.networkmanager.VirtualChannelSelector;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminException;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminHTTPProxy;
import com.aelitis.azureus.core.networkmanager.impl.tcp.ProtocolEndpointTCP;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TCPConnectionManager;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TCPNetworkManager;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TCPTransportHelperFilterFactory;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TCPTransportImpl;
import com.aelitis.azureus.core.versioncheck.VersionCheckClient;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.StringTokenizer;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;

public class NetworkAdminHTTPProxyImpl
implements NetworkAdminHTTPProxy {
    private static final String NL = "\r\n";
    private final String TARGET_HOST = "version.vuze.com";
    private final int TARGET_PORT = 80;
    private String http_host = System.getProperty("http.proxyHost", "").trim();
    private String http_port = System.getProperty("http.proxyPort", "").trim();
    private String https_host = System.getProperty("https.proxyHost", "").trim();
    private String https_port = System.getProperty("https.proxyPort", "").trim();
    private String user = System.getProperty("http.proxyUser", "").trim();
    private String password = System.getProperty("http.proxyPassword", "").trim();
    private String[] non_proxy_hosts;

    protected NetworkAdminHTTPProxyImpl() {
        String string = System.getProperty("http.nonProxyHosts", "").trim();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        this.non_proxy_hosts = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            this.non_proxy_hosts[n++] = stringTokenizer.nextToken();
        }
    }

    public String getName() {
        String string = "";
        if (this.http_host.length() > 0) {
            string = "http=" + this.http_host + ":" + this.http_port;
        }
        if (this.https_host.length() > 0) {
            string = string + (string.length() == 0 ? "" : ", ") + "https=" + this.https_host + ":" + this.https_port;
        }
        return string;
    }

    protected boolean isConfigured() {
        return this.http_host.length() > 0 || this.https_host.length() > 0;
    }

    public String getHTTPHost() {
        return this.http_host;
    }

    public String getHTTPPort() {
        return this.http_port;
    }

    public String getHTTPSHost() {
        return this.https_host;
    }

    public String getHTTPSPort() {
        return this.https_port;
    }

    public String getUser() {
        return this.user;
    }

    public String[] getNonProxyHosts() {
        return this.non_proxy_hosts;
    }

    public String getString() {
        String string = this.getName();
        if (this.user.length() > 0) {
            string = string + " [auth=" + this.user + "]";
        }
        try {
            NetworkAdminHTTPProxy.Details details = this.getDetails();
            string = string + " server=" + details.getServerName();
            string = string + ", response=" + details.getResponse();
            string = string + ", auth=" + details.getAuthenticationType();
        }
        catch (NetworkAdminException networkAdminException) {
            string = string + " failed to query proxy - " + networkAdminException.getLocalizedMessage();
        }
        return string;
    }

    public NetworkAdminHTTPProxy.Details getDetails() throws NetworkAdminException {
        final AESemaphore aESemaphore = new AESemaphore("NetworkAdminSocksProxy:test");
        final int[] nArray = new int[]{0};
        final NetworkAdminException[] networkAdminExceptionArray = new NetworkAdminException[]{null};
        final ProxyDetails[] proxyDetailsArray = new ProxyDetails[]{null};
        try {
            InetSocketAddress inetSocketAddress = new InetSocketAddress(InetAddress.getByName(this.http_host), Integer.parseInt(this.http_port));
            final InetSocketAddress inetSocketAddress2 = new InetSocketAddress("version.vuze.com", 80);
            TCPConnectionManager.ConnectListener connectListener = new TCPConnectionManager.ConnectListener(){

                public void connectAttemptStarted() {
                }

                public void connectSuccess(SocketChannel socketChannel) {
                    final TCPTransportImpl tCPTransportImpl = new TCPTransportImpl(new ProtocolEndpointTCP(inetSocketAddress2), false, false, null);
                    tCPTransportImpl.setFilter(TCPTransportHelperFilterFactory.createTransparentFilter(socketChannel));
                    final long l = SystemTime.getCurrentTime();
                    try {
                        String string = VersionCheckClient.getSingleton().getHTTPGetString(true, false);
                        ByteBuffer byteBuffer = ByteBuffer.wrap(string.getBytes());
                        while (byteBuffer.hasRemaining()) {
                            if (tCPTransportImpl.write(new ByteBuffer[]{byteBuffer}, 0, 1) >= 1L) continue;
                            if (SystemTime.getCurrentTime() - l > 30000L) {
                                String string2 = "proxy handshake message send timed out after 30sec";
                                Debug.out(string2);
                                throw new IOException(string2);
                            }
                            try {
                                Thread.sleep(50L);
                            }
                            catch (Throwable throwable) {
                                throwable.printStackTrace();
                            }
                        }
                        TCPNetworkManager.getSingleton().getReadSelector().register(tCPTransportImpl.getSocketChannel(), new VirtualChannelSelector.VirtualSelectorListener(){
                            private byte[] reply_buffer = new byte[8192];
                            private ByteBuffer reply = ByteBuffer.wrap(this.reply_buffer);

                            public boolean selectSuccess(VirtualChannelSelector virtualChannelSelector, SocketChannel socketChannel, Object object) {
                                try {
                                    if (SystemTime.getCurrentTime() - l > 30000L) {
                                        throw new Exception("Timeout");
                                    }
                                    long l2 = tCPTransportImpl.read(new ByteBuffer[]{this.reply}, 0, 1);
                                    if (l2 <= 0L) {
                                        return false;
                                    }
                                    String string = new String(this.reply_buffer, 0, this.reply.position());
                                    if (string.indexOf("\r\n\r\n") != -1) {
                                        System.out.println(string);
                                        String string2 = "unknown";
                                        String string3 = "none";
                                        String string4 = "unknown";
                                        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
                                        int n = 0;
                                        while (stringTokenizer.hasMoreTokens()) {
                                            int n2;
                                            String string5 = stringTokenizer.nextToken().trim();
                                            if (string5.length() == 0) continue;
                                            if (++n == 1) {
                                                n2 = string5.indexOf(32);
                                                if (n2 == -1) continue;
                                                string4 = string5.substring(n2 + 1).trim();
                                                continue;
                                            }
                                            n2 = string5.indexOf(58);
                                            if (n2 == -1) continue;
                                            String string6 = string5.substring(0, n2).trim().toLowerCase(MessageText.LOCALE_ENGLISH);
                                            String string7 = string5.substring(n2 + 1).trim();
                                            if (string6.equals("server")) {
                                                if (string4.startsWith("200")) continue;
                                                string2 = string7;
                                                continue;
                                            }
                                            if (string6.equals("via")) {
                                                string2 = string7;
                                                int n3 = string2.indexOf(32);
                                                if (n3 == -1) continue;
                                                string2 = string2.substring(n3 + 1).trim();
                                                continue;
                                            }
                                            if (!string6.equals("proxy-authenticate")) continue;
                                            string3 = string7;
                                        }
                                        proxyDetailsArray[0] = new ProxyDetails(string2, string4, string3);
                                        tCPTransportImpl.close("Done");
                                        nArray[0] = 3;
                                        aESemaphore.release();
                                    } else {
                                        TCPNetworkManager.getSingleton().getReadSelector().resumeSelects(tCPTransportImpl.getSocketChannel());
                                    }
                                    return true;
                                }
                                catch (Throwable throwable) {
                                    return false;
                                }
                            }

                            public void selectFailure(VirtualChannelSelector virtualChannelSelector, SocketChannel socketChannel, Object object, Throwable throwable) {
                                nArray[0] = 1;
                                networkAdminExceptionArray[0] = new NetworkAdminException("Proxy error", throwable);
                                tCPTransportImpl.close("Proxy error");
                                aESemaphore.release();
                            }
                        }, null);
                    }
                    catch (Throwable throwable) {
                        nArray[0] = 1;
                        networkAdminExceptionArray[0] = new NetworkAdminException("Proxy connect failed", throwable);
                        aESemaphore.release();
                    }
                }

                public void connectFailure(Throwable throwable) {
                    nArray[0] = 0;
                    networkAdminExceptionArray[0] = new NetworkAdminException("Connect failed", throwable);
                    aESemaphore.release();
                }
            };
            TCPNetworkManager.getSingleton().getConnectDisconnectManager().requestNewConnection(inetSocketAddress, connectListener, 3);
        }
        catch (Throwable throwable) {
            nArray[0] = 0;
            networkAdminExceptionArray[0] = new NetworkAdminException("Connect failed", throwable);
            aESemaphore.release();
        }
        if (!aESemaphore.reserve(10000L)) {
            nArray[0] = 0;
            networkAdminExceptionArray[0] = new NetworkAdminException("Connect timeout");
        }
        if (nArray[0] == 3) {
            return proxyDetailsArray[0];
        }
        throw networkAdminExceptionArray[0];
    }

    protected class ProxyDetails
    implements NetworkAdminHTTPProxy.Details {
        private String name;
        private String response;
        private String auth_type;

        protected ProxyDetails(String string, String string2, String string3) {
            this.name = string;
            this.response = string2;
            this.auth_type = string3;
        }

        public String getServerName() {
            return this.name;
        }

        public String getResponse() {
            return this.response;
        }

        public String getAuthenticationType() {
            return this.auth_type;
        }
    }
}

