/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.admin.impl;

import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminException;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminSocksProxy;
import com.aelitis.azureus.core.networkmanager.impl.tcp.ProtocolEndpointTCP;
import com.aelitis.azureus.core.networkmanager.impl.tcp.ProxyLoginHandler;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TCPConnectionManager;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TCPNetworkManager;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TCPTransportHelperFilterFactory;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TCPTransportImpl;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import org.gudy.azureus2.core3.util.AESemaphore;

public class NetworkAdminSocksProxyImpl
implements NetworkAdminSocksProxy {
    private final String TARGET_HOST = "version.vuze.com";
    private final int TARGET_PORT = 80;
    private String host;
    private String port;
    private String user;
    private String password;

    protected NetworkAdminSocksProxyImpl(String string, String string2, String string3, String string4) {
        this.host = string;
        this.port = string2;
        this.user = string3;
        this.password = string4;
    }

    protected boolean isConfigured() {
        return this.host.length() > 0;
    }

    public String getName() {
        return this.host + ":" + this.port;
    }

    public String getHost() {
        return this.host;
    }

    public String getPort() {
        return this.port;
    }

    public String getUser() {
        return this.user;
    }

    public String[] getVersionsSupported() throws NetworkAdminException {
        NetworkAdminException networkAdminException = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            this.testVersion("V4");
            arrayList.add("4");
        }
        catch (NetworkAdminException networkAdminException2) {
            networkAdminException = networkAdminException2;
        }
        try {
            this.testVersion("V4a");
            arrayList.add("4a");
        }
        catch (NetworkAdminException networkAdminException3) {
            networkAdminException = networkAdminException3;
        }
        try {
            this.testVersion("V5");
            arrayList.add("5");
        }
        catch (NetworkAdminException networkAdminException4) {
            networkAdminException = networkAdminException4;
        }
        if (arrayList.size() > 0) {
            return arrayList.toArray(new String[arrayList.size()]);
        }
        throw networkAdminException;
    }

    public String getString() {
        String string = this.getName();
        if (this.user.length() > 0) {
            string = string + " [auth=" + this.user + "]";
        }
        string = string + ", versions=";
        try {
            String[] stringArray = this.getVersionsSupported();
            for (int i = 0; i < stringArray.length; ++i) {
                string = string + (i == 0 ? "" : ",") + stringArray[i];
            }
        }
        catch (NetworkAdminException networkAdminException) {
            string = string + "unknown (" + networkAdminException.getLocalizedMessage() + ")";
        }
        return string;
    }

    protected void testVersion(final String string) throws NetworkAdminException {
        final AESemaphore aESemaphore = new AESemaphore("NetworkAdminSocksProxy:test");
        final int[] nArray = new int[]{0};
        final NetworkAdminException[] networkAdminExceptionArray = new NetworkAdminException[]{null};
        try {
            InetSocketAddress inetSocketAddress = new InetSocketAddress(InetAddress.getByName(this.host), Integer.parseInt(this.port));
            final InetSocketAddress inetSocketAddress2 = new InetSocketAddress("version.vuze.com", 80);
            TCPConnectionManager.ConnectListener connectListener = new TCPConnectionManager.ConnectListener(){

                public void connectAttemptStarted() {
                }

                public void connectSuccess(SocketChannel socketChannel) {
                    final TCPTransportImpl tCPTransportImpl = new TCPTransportImpl(new ProtocolEndpointTCP(inetSocketAddress2), false, false, null);
                    tCPTransportImpl.setFilter(TCPTransportHelperFilterFactory.createTransparentFilter(socketChannel));
                    new ProxyLoginHandler(tCPTransportImpl, inetSocketAddress2, new ProxyLoginHandler.ProxyListener(){

                        public void connectSuccess() {
                            tCPTransportImpl.close("Done");
                            nArray[0] = 3;
                            aESemaphore.release();
                        }

                        public void connectFailure(Throwable throwable) {
                            tCPTransportImpl.close("Proxy login failed");
                            nArray[0] = 1;
                            networkAdminExceptionArray[0] = new NetworkAdminException("Proxy connect failed", throwable);
                            aESemaphore.release();
                        }
                    }, string, NetworkAdminSocksProxyImpl.this.user, NetworkAdminSocksProxyImpl.this.password);
                }

                public void connectFailure(Throwable throwable) {
                    nArray[0] = 0;
                    networkAdminExceptionArray[0] = new NetworkAdminException("Connect failed", throwable);
                    aESemaphore.release();
                }
            };
            TCPNetworkManager.getSingleton().getConnectDisconnectManager().requestNewConnection(inetSocketAddress, connectListener, 3);
        }
        catch (Throwable throwable) {
            nArray[0] = 0;
            networkAdminExceptionArray[0] = new NetworkAdminException("Connect failed", throwable);
            aESemaphore.release();
        }
        if (!aESemaphore.reserve(10000L)) {
            nArray[0] = 0;
            networkAdminExceptionArray[0] = new NetworkAdminException("Connect timeout");
        }
        if (nArray[0] != 3) {
            throw networkAdminExceptionArray[0];
        }
    }
}

