/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.admin.impl;

import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminSpeedTestScheduledTest;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminSpeedTestScheduledTestListener;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminSpeedTester;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminSpeedTesterListener;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminSpeedTesterResult;
import com.aelitis.azureus.core.networkmanager.admin.impl.NetworkAdminSpeedTesterBTImpl;
import com.aelitis.azureus.core.networkmanager.admin.impl.NetworkAdminSpeedTesterImpl;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.plugins.upnp.UPnPPlugin;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.config.impl.TransferSpeedValidator;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentFactory;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadManagerListener;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.pluginsimpl.local.PluginConfigImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader.ResourceDownloaderFactoryImpl;

public class NetworkAdminSpeedTestScheduledTestImpl
implements NetworkAdminSpeedTestScheduledTest {
    private static final long REQUEST_TEST = 0L;
    private static final long CHALLENGE_REPLY = 1L;
    private static final long TEST_RESULT = 2L;
    private static int ZERO_DOWNLOAD_SETTING = -1;
    private PluginInterface plugin;
    private NetworkAdminSpeedTesterImpl tester;
    private String detectedRouter;
    private SpeedTestDownloadState preTestSettings;
    private byte[] challenge_id;
    private long delay_millis;
    private long max_speed;
    private TOTorrent test_torrent;
    private volatile boolean aborted;
    private CopyOnWriteList listeners = new CopyOnWriteList();

    protected NetworkAdminSpeedTestScheduledTestImpl(PluginInterface pluginInterface, NetworkAdminSpeedTesterImpl networkAdminSpeedTesterImpl) {
        this.plugin = pluginInterface;
        this.tester = networkAdminSpeedTesterImpl;
        PluginInterface pluginInterface2 = this.plugin.getPluginManager().getPluginInterfaceByClass(UPnPPlugin.class);
        if (pluginInterface2 != null) {
            this.detectedRouter = pluginInterface2.getPluginconfig().getPluginStringParameter("plugin.info");
        }
        this.tester.addListener(new NetworkAdminSpeedTesterListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void complete(NetworkAdminSpeedTester networkAdminSpeedTester, NetworkAdminSpeedTesterResult networkAdminSpeedTesterResult) {
                try {
                    NetworkAdminSpeedTestScheduledTestImpl.this.sendResult(networkAdminSpeedTesterResult);
                    Object var4_3 = null;
                    NetworkAdminSpeedTestScheduledTestImpl.this.reportComplete();
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    NetworkAdminSpeedTestScheduledTestImpl.this.reportComplete();
                    throw throwable;
                }
            }

            public void stage(NetworkAdminSpeedTester networkAdminSpeedTester, String string) {
            }
        });
    }

    public NetworkAdminSpeedTester getTester() {
        return this.tester;
    }

    public long getMaxUpBytePerSec() {
        return this.max_speed;
    }

    public long getMaxDownBytePerSec() {
        return this.max_speed;
    }

    public boolean start() {
        if (this.schedule()) {
            new AEThread("NetworkAdminSpeedTestScheduledTest:delay", true){

                public void runSupport() {
                    long l = NetworkAdminSpeedTestScheduledTestImpl.this.delay_millis / 1000L;
                    int n = 0;
                    while ((long)n < l && !NetworkAdminSpeedTestScheduledTestImpl.this.aborted) {
                        String string = MessageText.getString("SpeedTestWizard.abort.message.scheduled.in", new String[]{"" + (l - (long)n)});
                        NetworkAdminSpeedTestScheduledTestImpl.this.reportStage(string);
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            interruptedException.printStackTrace();
                        }
                        ++n;
                    }
                    if (!NetworkAdminSpeedTestScheduledTestImpl.this.aborted) {
                        NetworkAdminSpeedTestScheduledTestImpl.this.setSpeedLimits();
                        if (NetworkAdminSpeedTestScheduledTestImpl.this.tester.getTestType() == 1) {
                            ((NetworkAdminSpeedTesterBTImpl)NetworkAdminSpeedTestScheduledTestImpl.this.tester).start(NetworkAdminSpeedTestScheduledTestImpl.this.test_torrent);
                        } else {
                            String string = MessageText.getString("SpeedTestWizard.abort.message.unsupported.type");
                            NetworkAdminSpeedTestScheduledTestImpl.this.tester.abort(string);
                        }
                    }
                }
            }.start();
            return true;
        }
        return false;
    }

    public void abort() {
        this.abort(MessageText.getString("SpeedTestWizard.abort.message.manual.abort"));
    }

    public void abort(String string) {
        if (!this.aborted) {
            this.aborted = true;
            this.tester.abort(string);
        }
    }

    private boolean schedule() {
        try {
            Object object;
            Object object2;
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("request_type", new Long(0L));
            String string = COConfigurationManager.getStringParameter("ID", "unknown");
            Object object3 = null;
            Object object4 = null;
            String string2 = System.getProperty("azureus.speed.test.challenge.jar.path", null);
            if (string2 != null && ((File)(object2 = new File(string2))).exists() && (object = this.getVersionFromJAR((File)object2)) != null) {
                object3 = object2;
                object4 = object;
                System.out.println("SpeedTest: using explicit challenge jar " + ((File)object3).getAbsolutePath() + ", version " + (String)object4);
            }
            if (object3 == null && !((String)(object2 = System.getProperty("debug.speed.test.challenge", "n"))).equals("n") && ((File)(object = new File("C:\\test\\azureus\\Azureus3.0.1.2.jar"))).exists()) {
                object3 = object;
                object4 = "3.0.1.2";
                System.out.println("SpeedTest: using old spec challenge jar " + ((File)object3).getAbsolutePath() + ", version " + (String)object4);
            }
            if (object3 == null) {
                object3 = FileUtil.getJarFileFromClass(this.getClass());
                if (object3 != null) {
                    object4 = "4.3.0.4";
                } else {
                    object2 = new File(SystemProperties.getAzureusJarPath());
                    if (((File)object2).exists()) {
                        object4 = "4.3.0.4";
                        object3 = object2;
                    }
                }
            }
            if (object3 == null) {
                throw new Exception("Failed to locate an 'Azureus2.jar' to use for the challenge protocol");
            }
            hashMap.put("az-id", string);
            hashMap.put("type", "both");
            hashMap.put("jar_ver", object4);
            if (this.detectedRouter != null) {
                hashMap.put("router", this.detectedRouter);
            }
            object2 = this.sendRequest(hashMap);
            this.challenge_id = (byte[])object2.get("challenge_id");
            if (this.challenge_id == null) {
                throw new IllegalStateException("No challenge returned from speed test scheduling service");
            }
            object = (Long)object2.get("reply_type");
            if (((Long)object).intValue() == 1) {
                object2 = this.handleChallengeFromSpeedTestService((File)object3, (Map)object2);
                object = (Long)object2.get("reply_type");
            }
            if (object == null) {
                throw new IllegalStateException("No challenge response returned from speed test scheduling service");
            }
            if (((Long)object).intValue() == 0) {
                Long l = (Long)object2.get("time");
                Long l2 = (Long)object2.get("limit");
                if (l == null || l2 == null) {
                    throw new IllegalArgumentException("Returned time or limit parameter is null");
                }
                this.delay_millis = l;
                this.max_speed = l2;
                Map map = (Map)object2.get("torrent");
                this.test_torrent = TOTorrentFactory.deserialiseFromMap(map);
                return true;
            }
            throw new IllegalStateException("Unrecognized response from speed test scheduling servcie.");
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
            this.tester.abort(MessageText.getString("SpeedTestWizard.abort.message.scheduling.failed"), throwable);
            return false;
        }
    }

    private String getVersionFromJAR(File file) {
        try {
            ClassLoader classLoader = new ClassLoader(){

                protected synchronized Class loadClass(String string, boolean bl) throws ClassNotFoundException {
                    if (string.equals("org.gudy.azureus2.core3.util.Constants")) {
                        throw new ClassNotFoundException();
                    }
                    return super.loadClass(string, bl);
                }
            };
            URLClassLoader uRLClassLoader = new URLClassLoader(new URL[]{file.toURI().toURL()}, classLoader);
            Class<?> clazz = uRLClassLoader.loadClass("org.gudy.azureus2.core3.util.Constants");
            Field field = clazz.getField("AZUREUS_VERSION");
            return (String)field.get(null);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map handleChallengeFromSpeedTestService(File file, Map map) throws IOException {
        Map map2 = new HashMap();
        RandomAccessFile randomAccessFile = null;
        try {
            Long l = (Long)map.get("size");
            Long l2 = (Long)map.get("offset");
            if (l == null || l2 == null) {
                throw new IllegalStateException("scheduleTestWithSpeedTestService had a null parameter.");
            }
            randomAccessFile = new RandomAccessFile(file, "r");
            byte[] byArray = new byte[l.intValue()];
            randomAccessFile.seek(l2.intValue());
            randomAccessFile.read(byArray);
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("request_type", new Long(1L));
            hashMap.put("challenge_id", this.challenge_id);
            hashMap.put("data", byArray);
            map2 = this.sendRequest(hashMap);
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            try {
                if (randomAccessFile != null) {
                    randomAccessFile.close();
                }
            }
            catch (Throwable throwable2) {
                Debug.printStackTrace(throwable2);
            }
            throw throwable;
        }
        try {
            if (randomAccessFile != null) {
                randomAccessFile.close();
            }
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
        }
        return map2;
    }

    private void sendResult(NetworkAdminSpeedTesterResult networkAdminSpeedTesterResult) {
        try {
            if (this.challenge_id != null) {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("request_type", new Long(2L));
                hashMap.put("challenge_id", this.challenge_id);
                hashMap.put("type", new Long(this.tester.getTestType()));
                hashMap.put("mode", new Long(this.tester.getMode()));
                hashMap.put("crypto", new Long(this.tester.getUseCrypto() ? 1L : 0L));
                if (networkAdminSpeedTesterResult.hadError()) {
                    hashMap.put("result", new Long(0L));
                    hashMap.put("error", networkAdminSpeedTesterResult.getLastError());
                } else {
                    hashMap.put("result", new Long(1L));
                    hashMap.put("maxup", new Long(networkAdminSpeedTesterResult.getUploadSpeed()));
                    hashMap.put("maxdown", new Long(networkAdminSpeedTesterResult.getDownloadSpeed()));
                }
                this.sendRequest(hashMap);
            }
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
        }
    }

    private Map sendRequest(Map map) throws IOException {
        map.put("ver", new Long(1L));
        map.put("locale", MessageText.getCurrentLocale().toString());
        String string = System.getProperty("speedtest.service.ip.address", "speedtest.vuze.com");
        URL uRL = new URL("http://" + string + ":60000/scheduletest?request=" + URLEncoder.encode(new String(BEncoder.encode(map), "ISO-8859-1"), "ISO-8859-1"));
        return this.getBEncodedMapFromRequest(uRL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Map getBEncodedMapFromRequest(URL uRL) throws IOException {
        Map map;
        block14: {
            ResourceDownloader resourceDownloader = ResourceDownloaderFactoryImpl.getSingleton().create(uRL);
            InputStream inputStream = null;
            map = new HashMap();
            inputStream = resourceDownloader.download();
            map = BDecoder.decode(new BufferedInputStream(inputStream));
            Long l = (Long)map.get("result");
            if (l == null) {
                throw new IllegalStateException("No result parameter in the response!! reply=" + map);
            }
            if (l.intValue() == 0) {
                StringBuffer stringBuffer = new StringBuffer("Server failed. ");
                String string = new String((byte[])map.get("error"));
                String string2 = new String((byte[])map.get("error_detail"));
                stringBuffer.append("Error: ").append(string);
                Debug.outNoStack("SpeedCheck server returned an error: " + string + ", details=" + string2);
                throw new IOException(stringBuffer.toString());
            }
            Object var10_11 = null;
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                break block14;
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
            break block14;
            {
                catch (IOException iOException) {
                    throw iOException;
                }
                catch (Throwable throwable) {
                    Debug.out(throwable);
                    Debug.printStackTrace(throwable);
                    Object var10_12 = null;
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        break block14;
                    }
                    catch (Throwable throwable2) {
                        Debug.printStackTrace(throwable2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (Throwable throwable3) {
                    Debug.printStackTrace(throwable3);
                }
                throw throwable;
            }
        }
        return map;
    }

    protected synchronized void resetSpeedLimits() {
        if (this.preTestSettings != null) {
            this.preTestSettings.restoreLimits();
            this.preTestSettings = null;
        }
    }

    protected synchronized void setSpeedLimits() {
        this.resetSpeedLimits();
        this.preTestSettings = new SpeedTestDownloadState();
        this.preTestSettings.saveLimits();
    }

    protected void reportStage(String string) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            try {
                ((NetworkAdminSpeedTestScheduledTestListener)iterator.next()).stage(this, string);
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
    }

    protected void reportComplete() {
        this.resetSpeedLimits();
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            try {
                ((NetworkAdminSpeedTestScheduledTestListener)iterator.next()).complete(this);
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
    }

    public void addListener(NetworkAdminSpeedTestScheduledTestListener networkAdminSpeedTestScheduledTestListener) {
        this.listeners.add(networkAdminSpeedTestScheduledTestListener);
    }

    public void removeListener(NetworkAdminSpeedTestScheduledTestListener networkAdminSpeedTestScheduledTestListener) {
        this.listeners.remove(networkAdminSpeedTestScheduledTestListener);
    }

    class SpeedTestDownloadState
    implements ParameterListener,
    DownloadManagerListener {
        private Map torrentLimits = new HashMap();
        public static final String TORRENT_UPLOAD_LIMIT = "u";
        public static final String TORRENT_DOWNLOAD_LIMIT = "d";
        int maxUploadKbs;
        int maxUploadSeedingKbs;
        int maxDownloadKbs;
        boolean autoSpeedEnabled;
        boolean autoSpeedSeedingEnabled;
        boolean LANSpeedEnabled;

        public void parameterChanged(String string) {
            String string2 = Debug.getCompressedStackTrace();
            NetworkAdminSpeedTestScheduledTestImpl.this.abort("Configuration parameter '" + string + "' changed (new value=" + COConfigurationManager.getParameter(string) + ") during test (" + string2 + ")");
        }

        public void downloadAdded(Download download) {
            if (NetworkAdminSpeedTestScheduledTestImpl.this.test_torrent != null) {
                try {
                    if (Arrays.equals(download.getTorrent().getHash(), NetworkAdminSpeedTestScheduledTestImpl.this.test_torrent.getHash())) {
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                }
            }
            String string = MessageText.getString("SpeedTestWizard.abort.message.download.added", new String[]{download.getName()});
            NetworkAdminSpeedTestScheduledTestImpl.this.abort(string);
        }

        public void downloadRemoved(Download download) {
        }

        public void saveLimits() {
            int n;
            PluginConfigImpl.setEnablePluginCoreConfigChange(false);
            NetworkAdminSpeedTestScheduledTestImpl.this.plugin.getDownloadManager().addListener(this, false);
            Download[] downloadArray = NetworkAdminSpeedTestScheduledTestImpl.this.plugin.getDownloadManager().getDownloads();
            if (downloadArray != null) {
                int n2 = downloadArray.length;
                for (n = 0; n < n2; ++n) {
                    NetworkAdminSpeedTestScheduledTestImpl.this.plugin.getDownloadManager().getStats();
                    int n3 = downloadArray[n].getDownloadRateLimitBytesPerSecond();
                    int n4 = downloadArray[n].getUploadRateLimitBytesPerSecond();
                    this.setDownloadDetails(downloadArray[n], n4, n3);
                    downloadArray[n].setUploadRateLimitBytesPerSecond(ZERO_DOWNLOAD_SETTING);
                    downloadArray[n].setDownloadRateLimitBytesPerSecond(ZERO_DOWNLOAD_SETTING);
                }
            }
            this.saveGlobalLimits();
            COConfigurationManager.setParameter("LAN Speed Enabled", false);
            COConfigurationManager.setParameter("Auto Upload Speed Enabled", false);
            COConfigurationManager.setParameter("Auto Upload Speed Seeding Enabled", false);
            COConfigurationManager.setParameter("Max Upload Speed KBs", NetworkAdminSpeedTestScheduledTestImpl.this.max_speed);
            COConfigurationManager.setParameter("Max Upload Speed Seeding KBs", NetworkAdminSpeedTestScheduledTestImpl.this.max_speed);
            COConfigurationManager.setParameter("Max Download Speed KBs", NetworkAdminSpeedTestScheduledTestImpl.this.max_speed);
            String[] stringArray = TransferSpeedValidator.CONFIG_PARAMS;
            for (n = 0; n < stringArray.length; ++n) {
                COConfigurationManager.addParameterListener(stringArray[n], (ParameterListener)this);
            }
        }

        public void restoreLimits() {
            String[] stringArray = TransferSpeedValidator.CONFIG_PARAMS;
            for (int i = 0; i < stringArray.length; ++i) {
                COConfigurationManager.removeParameterListener(stringArray[i], this);
            }
            NetworkAdminSpeedTestScheduledTestImpl.this.plugin.getDownloadManager().removeListener(this);
            this.restoreGlobalLimits();
            this.restoreIndividualLimits();
            PluginConfigImpl.setEnablePluginCoreConfigChange(true);
        }

        private void saveGlobalLimits() {
            this.maxUploadKbs = COConfigurationManager.getIntParameter("Max Upload Speed KBs");
            this.maxUploadSeedingKbs = COConfigurationManager.getIntParameter("Max Upload Speed Seeding KBs");
            this.maxDownloadKbs = COConfigurationManager.getIntParameter("Max Download Speed KBs");
            this.autoSpeedEnabled = COConfigurationManager.getBooleanParameter("Auto Upload Speed Enabled");
            this.autoSpeedSeedingEnabled = COConfigurationManager.getBooleanParameter("Auto Upload Speed Seeding Enabled");
            this.LANSpeedEnabled = COConfigurationManager.getBooleanParameter("LAN Speed Enabled");
        }

        private void restoreGlobalLimits() {
            COConfigurationManager.setParameter("LAN Speed Enabled", this.LANSpeedEnabled);
            COConfigurationManager.setParameter("Auto Upload Speed Enabled", this.autoSpeedEnabled);
            COConfigurationManager.setParameter("Auto Upload Speed Seeding Enabled", this.autoSpeedSeedingEnabled);
            COConfigurationManager.setParameter("Max Upload Speed KBs", this.maxUploadKbs);
            COConfigurationManager.setParameter("Max Upload Speed Seeding KBs", this.maxUploadSeedingKbs);
            COConfigurationManager.setParameter("Max Download Speed KBs", this.maxDownloadKbs);
        }

        private void restoreIndividualLimits() {
            Download[] downloadArray = this.getAllDownloads();
            if (downloadArray != null) {
                int n = downloadArray.length;
                for (int i = 0; i < n; ++i) {
                    int n2 = this.getDownloadDetails(downloadArray[i], TORRENT_UPLOAD_LIMIT);
                    int n3 = this.getDownloadDetails(downloadArray[i], TORRENT_DOWNLOAD_LIMIT);
                    downloadArray[i].setDownloadRateLimitBytesPerSecond(n3);
                    downloadArray[i].setUploadRateLimitBytesPerSecond(n2);
                }
            }
        }

        private void setDownloadDetails(Download download, int n, int n2) {
            if (download == null) {
                throw new IllegalArgumentException("Download should not be null.");
            }
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
            hashMap.put(TORRENT_UPLOAD_LIMIT, new Integer(n));
            hashMap.put(TORRENT_DOWNLOAD_LIMIT, new Integer(n2));
            this.torrentLimits.put(download, hashMap);
        }

        private int getDownloadDetails(Download download, String string) {
            if (download == null || string == null) {
                throw new IllegalArgumentException("null inputs.");
            }
            if (!string.equals(TORRENT_UPLOAD_LIMIT) && !string.equals(TORRENT_DOWNLOAD_LIMIT)) {
                throw new IllegalArgumentException("invalid param. param=" + string);
            }
            Map map = (Map)this.torrentLimits.get(download);
            Integer n = (Integer)map.get(string);
            return n;
        }

        private Download[] getAllDownloads() {
            Download[] downloadArray = new Download[]{};
            return this.torrentLimits.keySet().toArray(downloadArray);
        }
    }
}

