/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl;

import com.aelitis.azureus.core.networkmanager.IncomingMessageQueue;
import com.aelitis.azureus.core.networkmanager.NetworkConnection;
import com.aelitis.azureus.core.peermanager.messaging.Message;
import com.aelitis.azureus.core.peermanager.messaging.MessageStreamDecoder;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;

public class IncomingMessageQueueImpl
implements IncomingMessageQueue {
    private volatile ArrayList listeners = new ArrayList();
    private final AEMonitor listeners_mon = new AEMonitor("IncomingMessageQueue:listeners");
    private MessageStreamDecoder stream_decoder;
    private final NetworkConnection connection;

    public IncomingMessageQueueImpl(MessageStreamDecoder messageStreamDecoder, NetworkConnection networkConnection) {
        if (messageStreamDecoder == null) {
            throw new NullPointerException("stream_decoder is null");
        }
        this.connection = networkConnection;
        this.stream_decoder = messageStreamDecoder;
    }

    public void setDecoder(MessageStreamDecoder messageStreamDecoder) {
        ByteBuffer byteBuffer = this.stream_decoder.destroy();
        this.connection.getTransport().setAlreadyRead(byteBuffer);
        this.stream_decoder = messageStreamDecoder;
        this.stream_decoder.resumeDecoding();
    }

    public MessageStreamDecoder getDecoder() {
        return this.stream_decoder;
    }

    public int getPercentDoneOfCurrentMessage() {
        return this.stream_decoder.getPercentDoneOfCurrentMessage();
    }

    public int receiveFromTransport(int n) throws IOException {
        int n2;
        Object object;
        int n3;
        int n4;
        if (n < 1) {
            Debug.out("max_bytes < 1: " + n);
            return 0;
        }
        if (this.listeners.isEmpty()) {
            Debug.out("no queue listeners registered!");
            throw new IOException("no queue listeners registered!");
        }
        try {
            n4 = this.stream_decoder.performStreamDecode(this.connection.getTransport(), n);
        }
        catch (RuntimeException runtimeException) {
            Debug.out("Stream decode for " + this.connection.getString() + " failed: " + Debug.getNestedExceptionMessageAndStack(runtimeException));
            throw runtimeException;
        }
        Message[] messageArray = this.stream_decoder.removeDecodedMessages();
        if (messageArray != null) {
            for (n3 = 0; n3 < messageArray.length; ++n3) {
                object = messageArray[n3];
                if (object == null) {
                    System.out.println("received msg == null [messages.length=" + messageArray.length + ", #" + n3 + "]: " + this.connection.getTransport().getDescription());
                    continue;
                }
                ArrayList arrayList = this.listeners;
                boolean bl = false;
                for (int i = 0; i < arrayList.size(); ++i) {
                    IncomingMessageQueue.MessageQueueListener messageQueueListener = (IncomingMessageQueue.MessageQueueListener)arrayList.get(i);
                    bl = bl || messageQueueListener.messageReceived((Message)object);
                }
                if (bl) continue;
                if (arrayList.size() > 0) {
                    System.out.println("no registered listeners [out of " + arrayList.size() + "] handled decoded message [" + object.getDescription() + "]");
                }
                DirectByteBuffer[] directByteBufferArray = object.getData();
                for (int i = 0; i < directByteBufferArray.length; ++i) {
                    directByteBufferArray[i].returnToPool();
                }
            }
        }
        if ((n3 = this.stream_decoder.getProtocolBytesDecoded()) > 0) {
            object = this.listeners;
            for (int i = 0; i < ((ArrayList)object).size(); ++i) {
                IncomingMessageQueue.MessageQueueListener messageQueueListener = (IncomingMessageQueue.MessageQueueListener)((ArrayList)object).get(i);
                messageQueueListener.protocolBytesReceived(n3);
            }
        }
        if ((n2 = this.stream_decoder.getDataBytesDecoded()) > 0) {
            ArrayList arrayList = this.listeners;
            for (int i = 0; i < arrayList.size(); ++i) {
                IncomingMessageQueue.MessageQueueListener messageQueueListener = (IncomingMessageQueue.MessageQueueListener)arrayList.get(i);
                messageQueueListener.dataBytesReceived(n2);
            }
        }
        return n4;
    }

    public void notifyOfExternallyReceivedMessage(Message message) {
        int n;
        ArrayList arrayList = this.listeners;
        boolean bl = false;
        DirectByteBuffer[] directByteBufferArray = message.getData();
        int n2 = 0;
        for (n = 0; n < directByteBufferArray.length; ++n) {
            n2 += directByteBufferArray[n].remaining((byte)5);
        }
        for (n = 0; n < arrayList.size(); ++n) {
            IncomingMessageQueue.MessageQueueListener messageQueueListener = (IncomingMessageQueue.MessageQueueListener)arrayList.get(n);
            boolean bl2 = bl = bl || messageQueueListener.messageReceived(message);
            if (message.getType() == 1) {
                messageQueueListener.dataBytesReceived(n2);
                continue;
            }
            messageQueueListener.protocolBytesReceived(n2);
        }
        if (!bl) {
            if (arrayList.size() > 0) {
                System.out.println("no registered listeners [out of " + arrayList.size() + "] handled decoded message [" + message.getDescription() + "]");
            }
            DirectByteBuffer[] directByteBufferArray2 = message.getData();
            for (int i = 0; i < directByteBufferArray2.length; ++i) {
                directByteBufferArray2[i].returnToPool();
            }
        }
    }

    public void resumeQueueProcessing() {
        this.stream_decoder.resumeDecoding();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerQueueListener(IncomingMessageQueue.MessageQueueListener messageQueueListener) {
        try {
            this.listeners_mon.enter();
            ArrayList<IncomingMessageQueue.MessageQueueListener> arrayList = new ArrayList<IncomingMessageQueue.MessageQueueListener>(this.listeners.size() + 1);
            arrayList.addAll(this.listeners);
            arrayList.add(messageQueueListener);
            this.listeners = arrayList;
            Object var4_3 = null;
            this.listeners_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.listeners_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelQueueListener(IncomingMessageQueue.MessageQueueListener messageQueueListener) {
        try {
            this.listeners_mon.enter();
            ArrayList arrayList = new ArrayList(this.listeners);
            arrayList.remove(messageQueueListener);
            this.listeners = arrayList;
            Object var4_3 = null;
            this.listeners_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.listeners_mon.exit();
            throw throwable;
        }
    }

    public void destroy() {
        this.stream_decoder.destroy();
    }
}

