/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl;

import com.aelitis.azureus.core.networkmanager.EventWaiter;
import com.aelitis.azureus.core.networkmanager.NetworkConnectionBase;
import com.aelitis.azureus.core.networkmanager.impl.RateControlledEntity;
import com.aelitis.azureus.core.networkmanager.impl.RateHandler;
import java.io.IOException;
import java.util.ArrayList;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;

public class MultiPeerDownloader
implements RateControlledEntity {
    private volatile ArrayList connections_cow = new ArrayList();
    private final AEMonitor connections_mon = new AEMonitor("MultiPeerDownloader");
    private final RateHandler main_handler;
    private int next_position = 0;

    public MultiPeerDownloader(RateHandler rateHandler) {
        this.main_handler = rateHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPeerConnection(NetworkConnectionBase networkConnectionBase) {
        try {
            this.connections_mon.enter();
            ArrayList<NetworkConnectionBase> arrayList = new ArrayList<NetworkConnectionBase>(this.connections_cow.size() + 1);
            arrayList.addAll(this.connections_cow);
            arrayList.add(networkConnectionBase);
            this.connections_cow = arrayList;
            Object var4_3 = null;
            this.connections_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.connections_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removePeerConnection(NetworkConnectionBase networkConnectionBase) {
        ArrayList arrayList;
        block3: {
            try {
                this.connections_mon.enter();
                arrayList = new ArrayList(this.connections_cow);
                boolean bl = arrayList.remove(networkConnectionBase);
                if (bl) break block3;
                boolean bl2 = false;
                Object var6_6 = null;
                this.connections_mon.exit();
                return bl2;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                this.connections_mon.exit();
                throw throwable;
            }
        }
        this.connections_cow = arrayList;
        boolean bl = true;
        Object var6_7 = null;
        this.connections_mon.exit();
        return bl;
    }

    public boolean canProcess(EventWaiter eventWaiter) {
        return this.main_handler.getCurrentNumBytesAllowed() >= 1;
    }

    public long getBytesReadyToWrite() {
        return 0L;
    }

    public int getConnectionCount() {
        return this.connections_cow.size();
    }

    public int getReadyConnectionCount(EventWaiter eventWaiter) {
        int n = 0;
        for (NetworkConnectionBase networkConnectionBase : this.connections_cow) {
            if (networkConnectionBase.getTransportBase().isReadyForRead(eventWaiter) != 0L) continue;
            ++n;
        }
        return n;
    }

    public boolean doProcessing(EventWaiter eventWaiter) {
        int n = this.main_handler.getCurrentNumBytesAllowed();
        if (n < 1) {
            return false;
        }
        ArrayList arrayList = this.connections_cow;
        int n2 = 0;
        int n3 = n;
        while (n3 > 0 && n2 < arrayList.size()) {
            this.next_position = this.next_position >= arrayList.size() ? 0 : this.next_position;
            NetworkConnectionBase networkConnectionBase = (NetworkConnectionBase)arrayList.get(this.next_position);
            ++this.next_position;
            ++n2;
            long l = networkConnectionBase.getTransportBase().isReadyForRead(eventWaiter);
            if (l != 0L) continue;
            int n4 = networkConnectionBase.getMssSize();
            int n5 = n3 > n4 ? n4 : n3;
            int n6 = 0;
            try {
                n6 = networkConnectionBase.getIncomingMessageQueue().receiveFromTransport(n5);
            }
            catch (Throwable throwable) {
                if (!(throwable instanceof IOException)) {
                    Debug.printStackTrace(throwable);
                }
                networkConnectionBase.notifyOfException(throwable);
            }
            n3 -= n6;
        }
        int n7 = n - n3;
        if (n7 > 0) {
            this.main_handler.bytesProcessed(n7);
            return true;
        }
        return false;
    }

    public int getPriority() {
        return 1;
    }

    public String getString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("MPD (" + this.connections_cow.size() + "): ");
        int n = 0;
        for (NetworkConnectionBase networkConnectionBase : this.connections_cow) {
            if (n++ > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(networkConnectionBase.getString());
        }
        return stringBuffer.toString();
    }
}

