/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl;

import com.aelitis.azureus.core.networkmanager.EventWaiter;
import com.aelitis.azureus.core.networkmanager.NetworkConnectionBase;
import com.aelitis.azureus.core.networkmanager.impl.RateControlledEntity;
import com.aelitis.azureus.core.networkmanager.impl.RateHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;

public class MultiPeerDownloader2
implements RateControlledEntity {
    private static final int MOVE_TO_IDLE_TIME = 500;
    private static final Object ADD_ACTION = new Object();
    private static final Object REMOVE_ACTION = new Object();
    private volatile ArrayList connections_cow = new ArrayList();
    private final AEMonitor connections_mon = new AEMonitor("MultiPeerDownloader");
    private final RateHandler main_handler;
    private List pending_actions;
    private connectionList active_connections = new connectionList();
    private connectionList idle_connections = new connectionList();
    private long last_idle_check;

    public MultiPeerDownloader2(RateHandler rateHandler) {
        this.main_handler = rateHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPeerConnection(NetworkConnectionBase networkConnectionBase) {
        try {
            this.connections_mon.enter();
            ArrayList<NetworkConnectionBase> arrayList = new ArrayList<NetworkConnectionBase>(this.connections_cow.size() + 1);
            arrayList.addAll(this.connections_cow);
            arrayList.add(networkConnectionBase);
            this.connections_cow = arrayList;
            if (this.pending_actions == null) {
                this.pending_actions = new ArrayList();
            }
            this.pending_actions.add(new Object[]{ADD_ACTION, networkConnectionBase});
            Object var4_3 = null;
            this.connections_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.connections_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removePeerConnection(NetworkConnectionBase networkConnectionBase) {
        ArrayList arrayList;
        block4: {
            try {
                this.connections_mon.enter();
                arrayList = new ArrayList(this.connections_cow);
                boolean bl = arrayList.remove(networkConnectionBase);
                if (bl) break block4;
                boolean bl2 = false;
                Object var6_6 = null;
                this.connections_mon.exit();
                return bl2;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                this.connections_mon.exit();
                throw throwable;
            }
        }
        this.connections_cow = arrayList;
        if (this.pending_actions == null) {
            this.pending_actions = new ArrayList();
        }
        this.pending_actions.add(new Object[]{REMOVE_ACTION, networkConnectionBase});
        boolean bl = true;
        Object var6_7 = null;
        this.connections_mon.exit();
        return bl;
    }

    public boolean canProcess(EventWaiter eventWaiter) {
        return this.main_handler.getCurrentNumBytesAllowed() >= 1;
    }

    public long getBytesReadyToWrite() {
        return 0L;
    }

    public int getConnectionCount() {
        return this.connections_cow.size();
    }

    public int getReadyConnectionCount(EventWaiter eventWaiter) {
        int n = 0;
        for (NetworkConnectionBase networkConnectionBase : this.connections_cow) {
            if (networkConnectionBase.getTransportBase().isReadyForRead(eventWaiter) != 0L) continue;
            ++n;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doProcessing(EventWaiter eventWaiter) {
        int n;
        Object object;
        long l;
        connectionEntry connectionEntry2;
        Object object2;
        int n2 = this.main_handler.getCurrentNumBytesAllowed();
        if (n2 < 1) {
            return false;
        }
        if (this.pending_actions != null) {
            try {
                this.connections_mon.enter();
                for (int i = 0; i < this.pending_actions.size(); ++i) {
                    Object[] objectArray = (Object[])this.pending_actions.get(i);
                    object2 = (NetworkConnectionBase)objectArray[1];
                    if (objectArray[0] == ADD_ACTION) {
                        this.active_connections.add((NetworkConnectionBase)object2);
                        continue;
                    }
                    this.active_connections.remove((NetworkConnectionBase)object2);
                    this.idle_connections.remove((NetworkConnectionBase)object2);
                }
                this.pending_actions = null;
                connectionEntry2 = null;
                this.connections_mon.exit();
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                this.connections_mon.exit();
                throw throwable;
            }
        }
        if ((l = SystemTime.getSteppedMonotonousTime()) - this.last_idle_check > 500L) {
            this.last_idle_check = l;
            object2 = this.idle_connections.head();
            while (object2 != null) {
                object = ((connectionEntry)object2).connection;
                connectionEntry2 = ((connectionEntry)object2).next;
                if (object.getTransportBase().isReadyForRead(eventWaiter) == 0L) {
                    this.idle_connections.remove((connectionEntry)object2);
                    this.active_connections.addToStart((connectionEntry)object2);
                }
                object2 = connectionEntry2;
            }
        }
        int n3 = n2;
        object = this.active_connections.head();
        int n4 = this.active_connections.size();
        for (n = 0; n < n4 && object != null && n3 > 0; ++n) {
            NetworkConnectionBase networkConnectionBase = ((connectionEntry)object).connection;
            connectionEntry connectionEntry3 = ((connectionEntry)object).next;
            long l2 = networkConnectionBase.getTransportBase().isReadyForRead(eventWaiter);
            if (l2 == 0L) {
                int n5 = networkConnectionBase.getMssSize();
                int n6 = n3 > n5 ? n5 : n3;
                int n7 = 0;
                try {
                    n7 = networkConnectionBase.getIncomingMessageQueue().receiveFromTransport(n6);
                }
                catch (Throwable throwable) {
                    if (!(throwable instanceof IOException)) {
                        Debug.printStackTrace(throwable);
                    }
                    networkConnectionBase.notifyOfException(throwable);
                }
                n3 -= n7;
                this.active_connections.moveToEnd((connectionEntry)object);
            } else if (l2 > 500L) {
                this.active_connections.remove((connectionEntry)object);
                this.idle_connections.addToEnd((connectionEntry)object);
            }
            object = connectionEntry3;
        }
        n = n2 - n3;
        if (n > 0) {
            this.main_handler.bytesProcessed(n);
            return true;
        }
        return false;
    }

    public int getPriority() {
        return 1;
    }

    public String getString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("MPD (" + this.connections_cow.size() + "/" + this.active_connections.size() + "/" + this.idle_connections.size() + ": ");
        int n = 0;
        for (NetworkConnectionBase networkConnectionBase : this.connections_cow) {
            if (n++ > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(networkConnectionBase.getString());
        }
        return stringBuffer.toString();
    }

    protected static class connectionEntry {
        private connectionEntry next;
        private connectionEntry prev;
        private NetworkConnectionBase connection;

        protected connectionEntry(NetworkConnectionBase networkConnectionBase) {
            this.connection = networkConnectionBase;
        }
    }

    protected static class connectionList {
        private int size;
        private connectionEntry head;
        private connectionEntry tail;

        protected connectionList() {
        }

        protected connectionEntry add(NetworkConnectionBase networkConnectionBase) {
            connectionEntry connectionEntry2 = new connectionEntry(networkConnectionBase);
            if (this.head == null) {
                this.head = this.tail = connectionEntry2;
            } else {
                this.tail.next = connectionEntry2;
                connectionEntry2.prev = this.tail;
                this.tail = connectionEntry2;
            }
            ++this.size;
            return connectionEntry2;
        }

        protected void addToEnd(connectionEntry connectionEntry2) {
            connectionEntry2.next = null;
            connectionEntry2.prev = this.tail;
            if (this.tail == null) {
                this.head = this.tail = connectionEntry2;
            } else {
                this.tail.next = connectionEntry2;
                this.tail = connectionEntry2;
            }
            ++this.size;
        }

        protected void addToStart(connectionEntry connectionEntry2) {
            connectionEntry2.next = this.head;
            connectionEntry2.prev = null;
            if (this.head == null) {
                this.head = this.tail = connectionEntry2;
            } else {
                this.head.prev = connectionEntry2;
                this.head = connectionEntry2;
            }
            ++this.size;
        }

        protected void moveToEnd(connectionEntry connectionEntry2) {
            if (connectionEntry2 != this.tail) {
                connectionEntry connectionEntry3 = connectionEntry2.prev;
                connectionEntry connectionEntry4 = connectionEntry2.next;
                if (connectionEntry3 == null) {
                    this.head = connectionEntry4;
                } else {
                    connectionEntry3.next = connectionEntry4;
                }
                connectionEntry4.prev = connectionEntry3;
                connectionEntry2.prev = this.tail;
                connectionEntry2.next = null;
                this.tail.next = connectionEntry2;
                this.tail = connectionEntry2;
            }
        }

        protected connectionEntry remove(NetworkConnectionBase networkConnectionBase) {
            connectionEntry connectionEntry2 = this.head;
            while (connectionEntry2 != null) {
                if (connectionEntry2.connection == networkConnectionBase) {
                    this.remove(connectionEntry2);
                    return connectionEntry2;
                }
                connectionEntry2 = connectionEntry2.next;
            }
            return null;
        }

        protected void remove(connectionEntry connectionEntry2) {
            connectionEntry connectionEntry3 = connectionEntry2.prev;
            connectionEntry connectionEntry4 = connectionEntry2.next;
            if (connectionEntry3 == null) {
                this.head = connectionEntry4;
            } else {
                connectionEntry3.next = connectionEntry4;
            }
            if (connectionEntry4 == null) {
                this.tail = connectionEntry3;
            } else {
                connectionEntry4.prev = connectionEntry3;
            }
            --this.size;
        }

        protected int size() {
            return this.size;
        }

        protected connectionEntry head() {
            return this.head;
        }
    }
}

