/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl;

import com.aelitis.azureus.core.networkmanager.NetworkManager;
import com.aelitis.azureus.core.networkmanager.OutgoingMessageQueue;
import com.aelitis.azureus.core.networkmanager.RawMessage;
import com.aelitis.azureus.core.networkmanager.Transport;
import com.aelitis.azureus.core.peermanager.messaging.Message;
import com.aelitis.azureus.core.peermanager.messaging.MessageStreamEncoder;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.TimeFormatter;

public class OutgoingMessageQueueImpl
implements OutgoingMessageQueue {
    private final LinkedList queue = new LinkedList();
    private final AEMonitor queue_mon = new AEMonitor("OutgoingMessageQueue:queue");
    private final ArrayList delayed_notifications = new ArrayList();
    private final AEMonitor delayed_notifications_mon = new AEMonitor("OutgoingMessageQueue:DN");
    private volatile ArrayList listeners = new ArrayList();
    private final AEMonitor listeners_mon = new AEMonitor("OutgoingMessageQueue:L");
    private int total_size = 0;
    private RawMessage urgent_message = null;
    private boolean destroyed = false;
    private MessageStreamEncoder stream_encoder;
    private Transport transport;
    private int percent_complete = -1;
    private static final boolean TRACE_HISTORY = false;
    private static final int MAX_HISTORY_TRACES = 30;
    private final LinkedList prev_sent = new LinkedList();
    private boolean trace;
    private WeakReference rawBufferCache = new WeakReference<Object>(null);
    private WeakReference origPositionsCache = new WeakReference<Object>(null);

    public OutgoingMessageQueueImpl(MessageStreamEncoder messageStreamEncoder) {
        this.stream_encoder = messageStreamEncoder;
    }

    public void setTransport(Transport transport) {
        this.transport = transport;
    }

    public int getMssSize() {
        return this.transport == null ? NetworkManager.getMinMssSize() : this.transport.getMssSize();
    }

    public void setEncoder(MessageStreamEncoder messageStreamEncoder) {
        this.stream_encoder = messageStreamEncoder;
    }

    public MessageStreamEncoder getEncoder() {
        return this.stream_encoder;
    }

    public int getPercentDoneOfCurrentMessage() {
        return this.percent_complete;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        this.destroyed = true;
        try {
            this.queue_mon.enter();
            while (!this.queue.isEmpty()) {
                ((RawMessage)this.queue.remove(0)).destroy();
            }
            Object var2_1 = null;
            this.queue_mon.exit();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.queue_mon.exit();
            throw throwable;
        }
        this.total_size = 0;
        this.prev_sent.clear();
        this.listeners = new ArrayList();
        this.urgent_message = null;
    }

    public int getTotalSize() {
        return this.total_size;
    }

    public boolean hasUrgentMessage() {
        return this.urgent_message != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessage(Message message, boolean bl) {
        boolean bl2 = true;
        ArrayList arrayList = this.listeners;
        for (int i = 0; i < arrayList.size(); ++i) {
            OutgoingMessageQueue.MessageQueueListener messageQueueListener = (OutgoingMessageQueue.MessageQueueListener)arrayList.get(i);
            bl2 = bl2 && messageQueueListener.messageAdded(message);
        }
        if (!bl2) {
            return;
        }
        RawMessage[] rawMessageArray = this.stream_encoder.encodeMessage(message);
        if (this.destroyed) {
            for (int i = 0; i < rawMessageArray.length; ++i) {
                rawMessageArray[i].destroy();
            }
            return;
        }
        for (int i = 0; i < rawMessageArray.length; ++i) {
            Object object;
            Object var12_18;
            RawMessage rawMessage = rawMessageArray[i];
            this.removeMessagesOfType(rawMessage.messagesToRemove(), bl);
            try {
                this.queue_mon.enter();
                int n = 0;
                for (RawMessage rawMessage2 : this.queue) {
                    if (rawMessage.getPriority() > rawMessage2.getPriority() && rawMessage2.getRawData()[0].position((byte)5) == 0) break;
                    ++n;
                }
                if (rawMessage.isNoDelay()) {
                    this.urgent_message = rawMessage;
                }
                this.queue.add(n, rawMessage);
                DirectByteBuffer[] directByteBufferArray = rawMessage.getRawData();
                for (int j = 0; j < directByteBufferArray.length; ++j) {
                    this.total_size += directByteBufferArray[j].remaining((byte)5);
                }
                var12_18 = null;
                this.queue_mon.exit();
            }
            catch (Throwable throwable) {
                var12_18 = null;
                this.queue_mon.exit();
                throw throwable;
            }
            if (bl) {
                Object var14_19;
                object = new NotificationItem(0);
                ((NotificationItem)object).message = rawMessage;
                try {
                    this.delayed_notifications_mon.enter();
                    this.delayed_notifications.add(object);
                    var14_19 = null;
                    this.delayed_notifications_mon.exit();
                    continue;
                }
                catch (Throwable throwable) {
                    var14_19 = null;
                    this.delayed_notifications_mon.exit();
                    throw throwable;
                }
            }
            object = this.listeners;
            for (int j = 0; j < ((ArrayList)object).size(); ++j) {
                OutgoingMessageQueue.MessageQueueListener messageQueueListener = (OutgoingMessageQueue.MessageQueueListener)((ArrayList)object).get(j);
                messageQueueListener.messageQueued(rawMessage.getBaseMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMessagesOfType(Message[] messageArray, boolean bl) {
        Object object;
        int n;
        Object object2;
        if (messageArray == null) {
            return;
        }
        ArrayList<RawMessage> arrayList = null;
        try {
            this.queue_mon.enter();
            object2 = this.queue.iterator();
            block4: while (object2.hasNext()) {
                RawMessage rawMessage = (RawMessage)object2.next();
                for (int i = 0; i < messageArray.length; ++i) {
                    n = messageArray[i].getID().equals(rawMessage.getID());
                    if (n == 0 || rawMessage.getRawData()[0].position((byte)5) != 0) continue;
                    if (rawMessage == this.urgent_message) {
                        this.urgent_message = null;
                    }
                    object = rawMessage.getRawData();
                    for (int j = 0; j < ((DirectByteBuffer[])object).length; ++j) {
                        this.total_size -= ((DirectByteBuffer)object[j]).remaining((byte)5);
                    }
                    if (bl) {
                        Object var11_14;
                        NotificationItem notificationItem = new NotificationItem(1);
                        notificationItem.message = rawMessage;
                        try {
                            this.delayed_notifications_mon.enter();
                            this.delayed_notifications.add(notificationItem);
                            var11_14 = null;
                            this.delayed_notifications_mon.exit();
                        }
                        catch (Throwable throwable) {
                            var11_14 = null;
                            this.delayed_notifications_mon.exit();
                            throw throwable;
                        }
                    } else {
                        if (arrayList == null) {
                            arrayList = new ArrayList<RawMessage>();
                        }
                        arrayList.add(rawMessage);
                    }
                    object2.remove();
                    continue block4;
                }
            }
            Object var13_16 = null;
            this.queue_mon.exit();
        }
        catch (Throwable throwable) {
            Object var13_17 = null;
            this.queue_mon.exit();
            throw throwable;
        }
        if (!bl && arrayList != null) {
            object2 = this.listeners;
            for (int i = 0; i < arrayList.size(); ++i) {
                RawMessage rawMessage = (RawMessage)arrayList.get(i);
                for (n = 0; n < ((ArrayList)object2).size(); ++n) {
                    object = (OutgoingMessageQueue.MessageQueueListener)((ArrayList)object2).get(n);
                    object.messageRemoved(rawMessage.getBaseMessage());
                }
                rawMessage.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeMessage(Message message, boolean bl) {
        Object object;
        Message message2 = null;
        try {
            this.queue_mon.enter();
            for (RawMessage rawMessage : this.queue) {
                if (!message.equals(rawMessage.getBaseMessage())) continue;
                if (rawMessage.getRawData()[0].position((byte)5) != 0) break;
                if (rawMessage == this.urgent_message) {
                    this.urgent_message = null;
                }
                object = rawMessage.getRawData();
                for (int i = 0; i < ((DirectByteBuffer[])object).length; ++i) {
                    this.total_size -= ((DirectByteBuffer)object[i]).remaining((byte)5);
                }
                this.queue.remove(rawMessage);
                message2 = rawMessage;
                break;
            }
            Object var9_9 = null;
            this.queue_mon.exit();
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            this.queue_mon.exit();
            throw throwable;
        }
        if (message2 != null) {
            Object object2;
            if (bl) {
                object2 = new NotificationItem(1);
                ((NotificationItem)object2).message = message2;
                try {
                    this.delayed_notifications_mon.enter();
                    this.delayed_notifications.add(object2);
                    Object var11_12 = null;
                    this.delayed_notifications_mon.exit();
                }
                catch (Throwable throwable) {
                    Object var11_13 = null;
                    this.delayed_notifications_mon.exit();
                    throw throwable;
                }
            } else {
                object2 = this.listeners;
                for (int i = 0; i < ((ArrayList)object2).size(); ++i) {
                    object = (OutgoingMessageQueue.MessageQueueListener)((ArrayList)object2).get(i);
                    object.messageRemoved(message2.getBaseMessage());
                }
                message2.destroy();
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int deliverToTransport(int n, boolean bl) throws IOException {
        Object object;
        int n2;
        if (n < 1) {
            Debug.out("max_bytes < 1: " + n);
            return 0;
        }
        if (this.transport == null) {
            throw new IOException("not ready to deliver data");
        }
        int n3 = 0;
        int n4 = 0;
        ArrayList<RawMessage> arrayList = null;
        try {
            this.queue_mon.enter();
            if (!this.queue.isEmpty()) {
                Object[] objectArray;
                int n5;
                int n6 = 64;
                Object[] objectArray2 = (ByteBuffer[])this.rawBufferCache.get();
                if (objectArray2 == null) {
                    objectArray2 = new ByteBuffer[n6];
                    this.rawBufferCache = new WeakReference<Object[]>(objectArray2);
                } else {
                    Arrays.fill(objectArray2, null);
                }
                int[] nArray = (int[])this.origPositionsCache.get();
                if (nArray == null) {
                    nArray = new int[n6];
                    this.origPositionsCache = new WeakReference<int[]>(nArray);
                } else {
                    Arrays.fill(nArray, 0);
                }
                int n7 = 0;
                n2 = 0;
                object = this.queue.iterator();
                block8: while (object.hasNext()) {
                    DirectByteBuffer[] directByteBufferArray = ((RawMessage)object.next()).getRawData();
                    for (n5 = 0; n5 < directByteBufferArray.length; ++n5) {
                        ByteBuffer byteBuffer = directByteBufferArray[n5].getBuffer((byte)5);
                        objectArray2[n7] = byteBuffer;
                        nArray[n7] = byteBuffer.position();
                        ++n7;
                        if ((n2 += byteBuffer.remaining()) >= n) break block8;
                        if (n7 != n6) continue;
                        int n8 = n6 * 2;
                        objectArray = new ByteBuffer[n8];
                        int[] nArray2 = new int[n8];
                        System.arraycopy(objectArray2, 0, objectArray, 0, n6);
                        System.arraycopy(nArray, 0, nArray2, 0, n6);
                        objectArray2 = objectArray;
                        nArray = nArray2;
                        n6 = n8;
                    }
                }
                object = objectArray2[n7 - 1];
                int n9 = ((Buffer)object).limit();
                if (n2 > n) {
                    ((ByteBuffer)object).limit(n9 - (n2 - n));
                }
                this.transport.write((ByteBuffer[])objectArray2, 0, n7);
                ((ByteBuffer)object).limit(n9);
                n5 = 0;
                boolean bl2 = false;
                block10: while (!this.queue.isEmpty() && !bl2) {
                    RawMessage rawMessage = (RawMessage)this.queue.get(0);
                    objectArray = rawMessage.getRawData();
                    for (int i = 0; i < objectArray.length; ++i) {
                        ByteBuffer byteBuffer = ((DirectByteBuffer)objectArray[i]).getBuffer((byte)5);
                        int n10 = byteBuffer.limit() - byteBuffer.remaining() - nArray[n5];
                        this.total_size -= n10;
                        if (i > 0 && rawMessage.getType() == 1) {
                            n3 += n10;
                        } else {
                            n4 += n10;
                        }
                        if (byteBuffer.hasRemaining()) {
                            bl2 = true;
                            int n11 = 0;
                            int n12 = 0;
                            for (int j = 0; j < objectArray.length; ++j) {
                                ByteBuffer byteBuffer2 = ((DirectByteBuffer)objectArray[j]).getBuffer((byte)5);
                                n11 += byteBuffer2.limit();
                                if (j < i) {
                                    n12 += byteBuffer2.limit();
                                    continue;
                                }
                                if (j != i) continue;
                                n12 += byteBuffer2.position();
                            }
                            this.percent_complete = n12 * 100 / n11;
                            continue block10;
                        }
                        if (i == objectArray.length - 1) {
                            if (rawMessage == this.urgent_message) {
                                this.urgent_message = null;
                            }
                            this.queue.remove(0);
                            this.percent_complete = -1;
                            if (bl) {
                                Object var25_35;
                                NotificationItem notificationItem = new NotificationItem(2);
                                notificationItem.message = rawMessage;
                                try {
                                    this.delayed_notifications_mon.enter();
                                    this.delayed_notifications.add(notificationItem);
                                    var25_35 = null;
                                    this.delayed_notifications_mon.exit();
                                }
                                catch (Throwable throwable) {
                                    var25_35 = null;
                                    this.delayed_notifications_mon.exit();
                                    throw throwable;
                                }
                            } else {
                                if (arrayList == null) {
                                    arrayList = new ArrayList<RawMessage>();
                                }
                                arrayList.add(rawMessage);
                            }
                        }
                        if (++n5 < n7) continue;
                        bl2 = true;
                        continue block10;
                    }
                }
            }
            Object var27_37 = null;
            this.queue_mon.exit();
        }
        catch (Throwable throwable) {
            Object var27_38 = null;
            this.queue_mon.exit();
            throw throwable;
        }
        if (n3 + n4 > 0 || arrayList != null) {
            if (this.trace) {
                TimeFormatter.milliTrace("omq:deliver: " + (n3 + n4) + ", q=" + this.queue.size() + "/" + this.total_size);
            }
            if (bl) {
                if (n3 > 0) {
                    NotificationItem notificationItem = new NotificationItem(3);
                    notificationItem.byte_count = n3;
                    try {
                        this.delayed_notifications_mon.enter();
                        this.delayed_notifications.add(notificationItem);
                        Object var29_40 = null;
                        this.delayed_notifications_mon.exit();
                    }
                    catch (Throwable throwable) {
                        Object var29_41 = null;
                        this.delayed_notifications_mon.exit();
                        throw throwable;
                    }
                }
                if (n4 > 0) {
                    NotificationItem notificationItem = new NotificationItem(4);
                    notificationItem.byte_count = n4;
                    try {
                        this.delayed_notifications_mon.enter();
                        this.delayed_notifications.add(notificationItem);
                        Object var31_43 = null;
                        this.delayed_notifications_mon.exit();
                    }
                    catch (Throwable throwable) {
                        Object var31_44 = null;
                        this.delayed_notifications_mon.exit();
                        throw throwable;
                    }
                }
            } else {
                ArrayList arrayList2 = this.listeners;
                int n13 = arrayList2.size();
                for (int i = 0; i < n13; ++i) {
                    OutgoingMessageQueue.MessageQueueListener messageQueueListener = (OutgoingMessageQueue.MessageQueueListener)arrayList2.get(i);
                    if (n3 > 0) {
                        messageQueueListener.dataBytesSent(n3);
                    }
                    if (n4 > 0) {
                        messageQueueListener.protocolBytesSent(n4);
                    }
                    if (arrayList == null) continue;
                    for (n2 = 0; n2 < arrayList.size(); ++n2) {
                        object = (RawMessage)arrayList.get(n2);
                        messageQueueListener.messageSent(object.getBaseMessage());
                        if (i != n13 - 1) continue;
                        object.destroy();
                    }
                }
            }
        } else if (this.trace) {
            TimeFormatter.milliTrace("omq:deliver: 0, q=" + this.queue.size() + "/" + this.total_size);
        }
        return n3 + n4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        try {
            this.queue_mon.enter();
            if (this.queue.isEmpty()) {
                Object var4_1 = null;
                this.queue_mon.exit();
                return;
            }
            for (int i = 0; i < this.queue.size(); ++i) {
                RawMessage rawMessage = (RawMessage)this.queue.get(i);
                rawMessage.setNoDelay();
                if (i != 0) continue;
                this.urgent_message = rawMessage;
            }
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.queue_mon.exit();
            throw throwable;
        }
        Object var4_2 = null;
        this.queue_mon.exit();
        ArrayList arrayList = this.listeners;
        for (int i = 0; i < arrayList.size(); ++i) {
            OutgoingMessageQueue.MessageQueueListener messageQueueListener = (OutgoingMessageQueue.MessageQueueListener)arrayList.get(i);
            messageQueueListener.flush();
        }
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doListenerNotifications() {
        ArrayList arrayList;
        try {
            this.delayed_notifications_mon.enter();
            if (this.delayed_notifications.size() == 0) {
                Object var3_1 = null;
                this.delayed_notifications_mon.exit();
                return;
            }
            arrayList = new ArrayList(this.delayed_notifications);
            this.delayed_notifications.clear();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.delayed_notifications_mon.exit();
            throw throwable;
        }
        Object var3_2 = null;
        this.delayed_notifications_mon.exit();
        ArrayList arrayList2 = this.listeners;
        block9: for (int i = 0; i < arrayList.size(); ++i) {
            NotificationItem notificationItem = (NotificationItem)arrayList.get(i);
            switch (notificationItem.type) {
                case 0: {
                    OutgoingMessageQueue.MessageQueueListener messageQueueListener;
                    int n;
                    for (n = 0; n < arrayList2.size(); ++n) {
                        messageQueueListener = (OutgoingMessageQueue.MessageQueueListener)arrayList2.get(n);
                        messageQueueListener.messageQueued(notificationItem.message.getBaseMessage());
                    }
                    continue block9;
                }
                case 1: {
                    OutgoingMessageQueue.MessageQueueListener messageQueueListener;
                    int n;
                    for (n = 0; n < arrayList2.size(); ++n) {
                        messageQueueListener = (OutgoingMessageQueue.MessageQueueListener)arrayList2.get(n);
                        messageQueueListener.messageRemoved(notificationItem.message.getBaseMessage());
                    }
                    notificationItem.message.destroy();
                    continue block9;
                }
                case 2: {
                    OutgoingMessageQueue.MessageQueueListener messageQueueListener;
                    int n;
                    for (n = 0; n < arrayList2.size(); ++n) {
                        messageQueueListener = (OutgoingMessageQueue.MessageQueueListener)arrayList2.get(n);
                        messageQueueListener.messageSent(notificationItem.message.getBaseMessage());
                    }
                    notificationItem.message.destroy();
                    continue block9;
                }
                case 4: {
                    OutgoingMessageQueue.MessageQueueListener messageQueueListener;
                    int n;
                    for (n = 0; n < arrayList2.size(); ++n) {
                        messageQueueListener = (OutgoingMessageQueue.MessageQueueListener)arrayList2.get(n);
                        messageQueueListener.protocolBytesSent(notificationItem.byte_count);
                    }
                    continue block9;
                }
                case 3: {
                    OutgoingMessageQueue.MessageQueueListener messageQueueListener;
                    int n;
                    for (n = 0; n < arrayList2.size(); ++n) {
                        messageQueueListener = (OutgoingMessageQueue.MessageQueueListener)arrayList2.get(n);
                        messageQueueListener.dataBytesSent(notificationItem.byte_count);
                    }
                    continue block9;
                }
                default: {
                    Debug.out("NotificationItem.type unknown :" + notificationItem.type);
                }
            }
        }
    }

    public void setTrace(boolean bl) {
        this.trace = bl;
        this.transport.setTrace(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getQueueTrace() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("**** OUTGOING QUEUE TRACE ****\n");
        try {
            this.queue_mon.enter();
            int n = 0;
            for (Object object : this.prev_sent) {
                stringBuffer.append("[#h" + n + "]: ").append(object.getID()).append(" [").append(object.getDescription()).append("]").append("\n");
                ++n;
            }
            int n2 = this.queue.size() - 1;
            for (RawMessage rawMessage : this.queue) {
                int n3 = rawMessage.getRawData()[0].position((byte)5);
                int n4 = rawMessage.getRawData()[0].limit((byte)5);
                stringBuffer.append("[#").append(n2).append(" ").append(n3).append(":").append(n4).append("]: ").append(rawMessage.getID()).append(" [").append(rawMessage.getDescription()).append("]").append("\n");
                --n2;
            }
            Object var9_9 = null;
            this.queue_mon.exit();
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            this.queue_mon.exit();
            throw throwable;
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerQueueListener(OutgoingMessageQueue.MessageQueueListener messageQueueListener) {
        try {
            this.listeners_mon.enter();
            ArrayList<OutgoingMessageQueue.MessageQueueListener> arrayList = new ArrayList<OutgoingMessageQueue.MessageQueueListener>(this.listeners.size() + 1);
            arrayList.addAll(this.listeners);
            arrayList.add(messageQueueListener);
            this.listeners = arrayList;
            Object var4_3 = null;
            this.listeners_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.listeners_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelQueueListener(OutgoingMessageQueue.MessageQueueListener messageQueueListener) {
        try {
            this.listeners_mon.enter();
            ArrayList arrayList = new ArrayList(this.listeners);
            arrayList.remove(messageQueueListener);
            this.listeners = arrayList;
            Object var4_3 = null;
            this.listeners_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.listeners_mon.exit();
            throw throwable;
        }
    }

    public void notifyOfExternallySentMessage(Message message) {
        int n;
        ArrayList arrayList = this.listeners;
        DirectByteBuffer[] directByteBufferArray = message.getData();
        int n2 = 0;
        for (n = 0; n < directByteBufferArray.length; ++n) {
            n2 += directByteBufferArray[n].remaining((byte)5);
        }
        for (n = 0; n < arrayList.size(); ++n) {
            OutgoingMessageQueue.MessageQueueListener messageQueueListener = (OutgoingMessageQueue.MessageQueueListener)arrayList.get(n);
            messageQueueListener.messageSent(message);
            if (message.getType() == 1) {
                messageQueueListener.dataBytesSent(n2);
                continue;
            }
            messageQueueListener.protocolBytesSent(n2);
        }
    }

    private static class NotificationItem {
        private static final int MESSAGE_ADDED = 0;
        private static final int MESSAGE_REMOVED = 1;
        private static final int MESSAGE_SENT = 2;
        private static final int DATA_BYTES_SENT = 3;
        private static final int PROTOCOL_BYTES_SENT = 4;
        private final int type;
        private RawMessage message;
        private int byte_count = 0;

        private NotificationItem(int n) {
            this.type = n;
        }
    }
}

