/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl;

import com.aelitis.azureus.core.networkmanager.EventWaiter;
import com.aelitis.azureus.core.networkmanager.NetworkConnectionBase;
import com.aelitis.azureus.core.networkmanager.impl.RateControlledEntity;
import com.aelitis.azureus.core.networkmanager.impl.RateHandler;
import java.io.IOException;
import org.gudy.azureus2.core3.util.Debug;

public class SinglePeerDownloader
implements RateControlledEntity {
    private final NetworkConnectionBase connection;
    private final RateHandler rate_handler;

    public SinglePeerDownloader(NetworkConnectionBase networkConnectionBase, RateHandler rateHandler) {
        this.connection = networkConnectionBase;
        this.rate_handler = rateHandler;
    }

    public boolean canProcess(EventWaiter eventWaiter) {
        if (this.connection.getTransportBase().isReadyForRead(eventWaiter) != 0L) {
            return false;
        }
        return this.rate_handler.getCurrentNumBytesAllowed() >= 1;
    }

    public boolean doProcessing(EventWaiter eventWaiter) {
        if (this.connection.getTransportBase().isReadyForRead(eventWaiter) != 0L) {
            return false;
        }
        int n = this.rate_handler.getCurrentNumBytesAllowed();
        if (n < 1) {
            return false;
        }
        int n2 = 0;
        try {
            n2 = this.connection.getIncomingMessageQueue().receiveFromTransport(n);
        }
        catch (Throwable throwable) {
            if (!(throwable instanceof IOException)) {
                Debug.printStackTrace(throwable);
            }
            this.connection.notifyOfException(throwable);
            return false;
        }
        if (n2 < 1) {
            return false;
        }
        this.rate_handler.bytesProcessed(n2);
        return true;
    }

    public int getPriority() {
        return 0;
    }

    public long getBytesReadyToWrite() {
        return 0L;
    }

    public int getConnectionCount() {
        return 1;
    }

    public int getReadyConnectionCount(EventWaiter eventWaiter) {
        if (this.connection.getTransportBase().isReadyForRead(eventWaiter) == 0L) {
            return 1;
        }
        return 0;
    }

    public String getString() {
        return "SPD: " + this.connection.getString();
    }
}

